/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.annotation.JsonInclude$Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap$SerializerAndMapResult;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.BeanUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

@JacksonStdImpl
public class MapEntrySerializer
extends ContainerSerializer<Map.Entry<?, ?>>
implements ContextualSerializer {
    public static final Object MARKER_FOR_EMPTY = JsonInclude$Include.NON_EMPTY;
    protected final BeanProperty _property;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _entryType;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;

    public MapEntrySerializer(JavaType javaType, JavaType javaType2, JavaType javaType3, boolean bl2, TypeSerializer typeSerializer, BeanProperty beanProperty) {
        super(javaType);
        this._entryType = javaType;
        this._keyType = javaType2;
        this._valueType = javaType3;
        this._valueTypeIsStatic = bl2;
        this._valueTypeSerializer = typeSerializer;
        this._property = beanProperty;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
        this._suppressableValue = null;
        this._suppressNulls = false;
    }

    @Deprecated
    protected MapEntrySerializer(MapEntrySerializer mapEntrySerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2) {
        this(mapEntrySerializer, beanProperty, typeSerializer, jsonSerializer, jsonSerializer2, mapEntrySerializer._suppressableValue, mapEntrySerializer._suppressNulls);
    }

    protected MapEntrySerializer(MapEntrySerializer mapEntrySerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Object object, boolean bl2) {
        super(Map.class, false);
        this._entryType = mapEntrySerializer._entryType;
        this._keyType = mapEntrySerializer._keyType;
        this._valueType = mapEntrySerializer._valueType;
        this._valueTypeIsStatic = mapEntrySerializer._valueTypeIsStatic;
        this._valueTypeSerializer = mapEntrySerializer._valueTypeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
        this._property = mapEntrySerializer._property;
        this._suppressableValue = object;
        this._suppressNulls = bl2;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        MapEntrySerializer mapEntrySerializer = this;
        return new MapEntrySerializer(mapEntrySerializer, mapEntrySerializer._property, typeSerializer, this._keySerializer, this._valueSerializer, this._suppressableValue, this._suppressNulls);
    }

    public MapEntrySerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Object object, boolean bl2) {
        return new MapEntrySerializer(this, beanProperty, this._valueTypeSerializer, jsonSerializer, jsonSerializer2, object, bl2);
    }

    public MapEntrySerializer withContentInclusion(Object object, boolean bl2) {
        if (this._suppressableValue == object && this._suppressNulls == bl2) {
            return this;
        }
        MapEntrySerializer mapEntrySerializer = this;
        return new MapEntrySerializer(mapEntrySerializer, mapEntrySerializer._property, this._valueTypeSerializer, this._keySerializer, this._valueSerializer, object, bl2);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonInclude$Include jsonInclude$Include;
        Object object;
        JsonSerializer<Object> jsonSerializer = null;
        JsonSerializer<Object> jsonSerializer2 = null;
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)serializerProvider).getAnnotationIntrospector();
        Serializable serializable = beanProperty == null ? null : beanProperty.getMember();
        if (serializable != null && annotationIntrospector != null) {
            object = annotationIntrospector.findKeySerializer((Annotated)((Object)serializable));
            if (object != null) {
                jsonSerializer2 = serializerProvider.serializerInstance((Annotated)((Object)serializable), object);
            }
            if ((object = annotationIntrospector.findContentSerializer((Annotated)((Object)serializable))) != null) {
                jsonSerializer = serializerProvider.serializerInstance((Annotated)((Object)serializable), object);
            }
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._valueSerializer;
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null && this._valueTypeIsStatic && !this._valueType.isJavaLangObject()) {
            jsonSerializer = serializerProvider.findContentValueSerializer(this._valueType, beanProperty);
        }
        if (jsonSerializer2 == null) {
            jsonSerializer2 = this._keySerializer;
        }
        jsonSerializer2 = jsonSerializer2 == null ? serializerProvider.findKeySerializer(this._keyType, beanProperty) : serializerProvider.handleSecondaryContextualization(jsonSerializer2, beanProperty);
        object = this._suppressableValue;
        boolean bl2 = this._suppressNulls;
        if (beanProperty != null && (serializable = beanProperty.findPropertyInclusion(serializerProvider.getConfig(), null)) != null && (jsonInclude$Include = ((JsonInclude$Value)serializable).getContentInclusion()) != JsonInclude$Include.USE_DEFAULTS) {
            switch (jsonInclude$Include) {
                case NON_DEFAULT: {
                    object = BeanUtil.getDefaultValue(this._valueType);
                    bl2 = true;
                    if (object == null || !object.getClass().isArray()) break;
                    object = ArrayBuilders.getArrayComparator(object);
                    break;
                }
                case NON_ABSENT: {
                    bl2 = true;
                    object = this._valueType.isReferenceType() ? MARKER_FOR_EMPTY : null;
                    break;
                }
                case NON_EMPTY: {
                    bl2 = true;
                    object = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    object = serializerProvider.includeFilterInstance(null, ((JsonInclude$Value)serializable).getContentFilter());
                    if (object == null) {
                        bl2 = true;
                        break;
                    }
                    bl2 = serializerProvider.includeFilterSuppressNulls(object);
                    break;
                }
                case NON_NULL: {
                    object = null;
                    bl2 = true;
                    break;
                }
                default: {
                    object = null;
                    bl2 = false;
                }
            }
        }
        return this.withResolved(beanProperty, jsonSerializer2, jsonSerializer, object, bl2);
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean hasSingleElement(Map.Entry<?, ?> entry) {
        return true;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Map.Entry<?, ?> entry) {
        Class<?> clazz;
        if ((entry = entry.getValue()) == null) {
            return this._suppressNulls;
        }
        if (this._suppressableValue == null) {
            return false;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null && (jsonSerializer = this._dynamicValueSerializers.serializerFor(clazz = entry.getClass())) == null) {
            try {
                MapEntrySerializer mapEntrySerializer = this;
                jsonSerializer = mapEntrySerializer._findAndAddDynamic(mapEntrySerializer._dynamicValueSerializers, clazz, serializerProvider);
            }
            catch (JsonMappingException jsonMappingException) {
                return false;
            }
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            return jsonSerializer.isEmpty(serializerProvider, entry);
        }
        return this._suppressableValue.equals(entry);
    }

    @Override
    public void serialize(Map.Entry<?, ?> entry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject(entry);
        this.serializeDynamic(entry, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(Map.Entry<?, ?> entry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        jsonGenerator.assignCurrentValue(entry);
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(entry, JsonToken.START_OBJECT));
        this.serializeDynamic(entry, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected void serializeDynamic(Map.Entry<?, ?> entry, JsonGenerator object, SerializerProvider serializerProvider) throws IOException {
        JsonSerializer<Object> jsonSerializer;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        Object obj = entry.getKey();
        JsonSerializer<Object> jsonSerializer2 = obj == null ? serializerProvider.findNullKeySerializer(this._keyType, this._property) : this._keySerializer;
        Object obj2 = entry.getValue();
        if (obj2 == null) {
            if (this._suppressNulls) {
                return;
            }
            jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
        } else {
            Class<?> clazz;
            jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null && (jsonSerializer = this._dynamicValueSerializers.serializerFor(clazz = obj2.getClass())) == null) {
                if (((ResolvedType)this._valueType).hasGenericTypes()) {
                    MapEntrySerializer mapEntrySerializer = this;
                    jsonSerializer = mapEntrySerializer._findAndAddDynamic(mapEntrySerializer._dynamicValueSerializers, ((DatabindContext)serializerProvider).constructSpecializedType(this._valueType, clazz), serializerProvider);
                } else {
                    MapEntrySerializer mapEntrySerializer = this;
                    jsonSerializer = mapEntrySerializer._findAndAddDynamic(mapEntrySerializer._dynamicValueSerializers, clazz, serializerProvider);
                }
            }
            if (this._suppressableValue != null && (this._suppressableValue == MARKER_FOR_EMPTY ? jsonSerializer.isEmpty(serializerProvider, obj2) : this._suppressableValue.equals(obj2))) {
                return;
            }
        }
        jsonSerializer2.serialize(obj, (JsonGenerator)object, serializerProvider);
        try {
            if (typeSerializer != null) {
                jsonSerializer.serializeWithType(obj2, (JsonGenerator)object, serializerProvider, typeSerializer);
                return;
            }
            jsonSerializer.serialize(obj2, (JsonGenerator)object, serializerProvider);
        }
        catch (Exception exception) {
            object = "" + obj;
            this.wrapAndThrow(serializerProvider, (Throwable)exception, entry, (String)object);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> object, SerializerProvider serializerProvider) throws JsonMappingException {
        object = propertySerializerMap.findAndAddSecondarySerializer((Class<?>)object, serializerProvider, this._property);
        if (propertySerializerMap != ((PropertySerializerMap$SerializerAndMapResult)object).map) {
            this._dynamicValueSerializers = ((PropertySerializerMap$SerializerAndMapResult)object).map;
        }
        return ((PropertySerializerMap$SerializerAndMapResult)object).serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType object, SerializerProvider serializerProvider) throws JsonMappingException {
        object = propertySerializerMap.findAndAddSecondarySerializer((JavaType)object, serializerProvider, this._property);
        if (propertySerializerMap != ((PropertySerializerMap$SerializerAndMapResult)object).map) {
            this._dynamicValueSerializers = ((PropertySerializerMap$SerializerAndMapResult)object).map;
        }
        return ((PropertySerializerMap$SerializerAndMapResult)object).serializer;
    }
}

