/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter$1;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter$FilterExceptFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter$SerializeExceptFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SimpleBeanPropertyFilter
implements BeanPropertyFilter,
PropertyFilter {
    protected SimpleBeanPropertyFilter() {
    }

    public static SimpleBeanPropertyFilter serializeAll() {
        return SimpleBeanPropertyFilter$SerializeExceptFilter.INCLUDE_ALL;
    }

    public static SimpleBeanPropertyFilter filterOutAll() {
        return SimpleBeanPropertyFilter$FilterExceptFilter.EXCLUDE_ALL;
    }

    @Deprecated
    public static SimpleBeanPropertyFilter serializeAll(Set<String> set) {
        return new SimpleBeanPropertyFilter$FilterExceptFilter(set);
    }

    public static SimpleBeanPropertyFilter filterOutAllExcept(Set<String> set) {
        return new SimpleBeanPropertyFilter$FilterExceptFilter(set);
    }

    public static SimpleBeanPropertyFilter filterOutAllExcept(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        return new SimpleBeanPropertyFilter$FilterExceptFilter(hashSet);
    }

    public static SimpleBeanPropertyFilter serializeAllExcept(Set<String> set) {
        return new SimpleBeanPropertyFilter$SerializeExceptFilter(set);
    }

    public static SimpleBeanPropertyFilter serializeAllExcept(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        return new SimpleBeanPropertyFilter$SerializeExceptFilter(hashSet);
    }

    public static PropertyFilter from(BeanPropertyFilter beanPropertyFilter) {
        return new SimpleBeanPropertyFilter$1(beanPropertyFilter);
    }

    protected boolean include(BeanPropertyWriter beanPropertyWriter) {
        return true;
    }

    protected boolean include(PropertyWriter propertyWriter) {
        return true;
    }

    protected boolean includeElement(Object object) {
        return true;
    }

    @Override
    @Deprecated
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, BeanPropertyWriter beanPropertyWriter) throws Exception {
        if (this.include(beanPropertyWriter)) {
            ((PropertyWriter)beanPropertyWriter).serializeAsField(object, jsonGenerator, serializerProvider);
            return;
        }
        if (!jsonGenerator.canOmitFields()) {
            ((PropertyWriter)beanPropertyWriter).serializeAsOmittedField(object, jsonGenerator, serializerProvider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(BeanPropertyWriter beanPropertyWriter, ObjectNode objectNode, SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.include(beanPropertyWriter)) {
            ((PropertyWriter)beanPropertyWriter).depositSchemaProperty(objectNode, serializerProvider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(BeanPropertyWriter beanPropertyWriter, JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.include(beanPropertyWriter)) {
            ((PropertyWriter)beanPropertyWriter).depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
        }
    }

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyWriter propertyWriter) throws Exception {
        if (this.include(propertyWriter)) {
            propertyWriter.serializeAsField(object, jsonGenerator, serializerProvider);
            return;
        }
        if (!jsonGenerator.canOmitFields()) {
            propertyWriter.serializeAsOmittedField(object, jsonGenerator, serializerProvider);
            return;
        }
        if (propertyWriter instanceof AnyGetterWriter) {
            ((AnyGetterWriter)propertyWriter).getAndFilter(object, jsonGenerator, serializerProvider, this);
        }
    }

    @Override
    public void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyWriter propertyWriter) throws Exception {
        if (this.includeElement(object)) {
            propertyWriter.serializeAsElement(object, jsonGenerator, serializerProvider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(PropertyWriter propertyWriter, ObjectNode objectNode, SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.include(propertyWriter)) {
            propertyWriter.depositSchemaProperty(objectNode, serializerProvider);
        }
    }

    @Override
    public void depositSchemaProperty(PropertyWriter propertyWriter, JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.include(propertyWriter)) {
            propertyWriter.depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
        }
    }
}

