/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Shape;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators$PropertyGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.impl.MapEntrySerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class BeanSerializerBase
extends StdSerializer<Object>
implements JsonFormatVisitable,
ContextualSerializer,
ResolvableSerializer {
    protected static final PropertyName NAME_FOR_OBJECT_REF = new PropertyName("#object-ref");
    protected static final BeanPropertyWriter[] NO_PROPS = new BeanPropertyWriter[0];
    protected final JavaType _beanType;
    protected final BeanPropertyWriter[] _props;
    protected final BeanPropertyWriter[] _filteredProps;
    protected final Object _propertyFilterId;
    protected final AnnotatedMember _typeId;
    protected final ObjectIdWriter _objectIdWriter;
    protected final JsonFormat$Shape _serializationShape;

    protected BeanSerializerBase(JavaType serializable, BeanSerializerBuilder beanSerializerBuilder, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super((JavaType)serializable);
        this._beanType = serializable;
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        if (beanSerializerBuilder == null) {
            this._typeId = null;
            this._propertyFilterId = null;
            this._objectIdWriter = null;
            this._serializationShape = null;
            return;
        }
        this._typeId = beanSerializerBuilder.getTypeId();
        this._propertyFilterId = beanSerializerBuilder.getFilterId();
        this._objectIdWriter = beanSerializerBuilder.getObjectIdWriter();
        serializable = beanSerializerBuilder.getBeanDescription().findExpectedFormat();
        this._serializationShape = ((JsonFormat$Value)serializable).getShape();
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super(beanSerializerBase._handledType);
        this._beanType = beanSerializerBase._beanType;
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        this._typeId = beanSerializerBase._typeId;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter) {
        this(beanSerializerBase, objectIdWriter, beanSerializerBase._propertyFilterId);
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter, Object object) {
        super(beanSerializerBase._handledType);
        this._beanType = beanSerializerBase._beanType;
        this._props = beanSerializerBase._props;
        this._filteredProps = beanSerializerBase._filteredProps;
        this._typeId = beanSerializerBase._typeId;
        this._objectIdWriter = objectIdWriter;
        this._propertyFilterId = object;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    @Deprecated
    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, String[] stringArray) {
        this(beanSerializerBase, ArrayBuilders.arrayToSet(stringArray), null);
    }

    @Deprecated
    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, Set<String> set) {
        this(beanSerializerBase, set, null);
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, Set<String> set, Set<String> set2) {
        super(beanSerializerBase._handledType);
        BeanPropertyWriter[] beanPropertyWriterArray;
        this._beanType = beanSerializerBase._beanType;
        BeanPropertyWriter[] beanPropertyWriterArray2 = beanSerializerBase._props;
        BeanPropertyWriter[] beanPropertyWriterArray3 = beanSerializerBase._filteredProps;
        int n2 = beanPropertyWriterArray2.length;
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(n2);
        ArrayList<BeanPropertyWriter> arrayList2 = beanPropertyWriterArray3 == null ? null : new ArrayList<BeanPropertyWriter>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray2[i2];
            if (IgnorePropertiesUtil.shouldIgnore(((PropertyWriter)beanPropertyWriter).getName(), set, set2)) continue;
            arrayList.add(beanPropertyWriter);
            if (beanPropertyWriterArray3 == null) continue;
            arrayList2.add(beanPropertyWriterArray3[i2]);
        }
        ArrayList<BeanPropertyWriter> arrayList3 = arrayList;
        this._props = arrayList3.toArray(new BeanPropertyWriter[arrayList3.size()]);
        if (arrayList2 == null) {
            beanPropertyWriterArray = null;
        } else {
            ArrayList<BeanPropertyWriter> arrayList4 = arrayList2;
            beanPropertyWriterArray = arrayList4.toArray(new BeanPropertyWriter[arrayList4.size()]);
        }
        this._filteredProps = beanPropertyWriterArray;
        this._typeId = beanSerializerBase._typeId;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    public abstract BeanSerializerBase withObjectIdWriter(ObjectIdWriter var1);

    @Deprecated
    protected BeanSerializerBase withIgnorals(Set<String> set) {
        return this.withByNameInclusion(set, null);
    }

    protected abstract BeanSerializerBase withByNameInclusion(Set<String> var1, Set<String> var2);

    @Deprecated
    protected BeanSerializerBase withIgnorals(String[] stringArray) {
        return this.withIgnorals(ArrayBuilders.arrayToSet(stringArray));
    }

    protected abstract BeanSerializerBase asArraySerializer();

    public abstract BeanSerializerBase withFilterId(Object var1);

    protected abstract BeanSerializerBase withProperties(BeanPropertyWriter[] var1, BeanPropertyWriter[] var2);

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase) {
        BeanSerializerBase beanSerializerBase2 = beanSerializerBase;
        this(beanSerializerBase2, beanSerializerBase2._props, beanSerializerBase._filteredProps);
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, NameTransformer nameTransformer) {
        BeanSerializerBase beanSerializerBase2 = beanSerializerBase;
        this(beanSerializerBase2, BeanSerializerBase.rename(beanSerializerBase2._props, nameTransformer), BeanSerializerBase.rename(beanSerializerBase._filteredProps, nameTransformer));
    }

    private static final BeanPropertyWriter[] rename(BeanPropertyWriter[] beanPropertyWriterArray, NameTransformer nameTransformer) {
        if (beanPropertyWriterArray == null || beanPropertyWriterArray.length == 0 || nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return beanPropertyWriterArray;
        }
        int n2 = beanPropertyWriterArray.length;
        BeanPropertyWriter[] beanPropertyWriterArray2 = new BeanPropertyWriter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i2];
            if (beanPropertyWriter == null) continue;
            beanPropertyWriterArray2[i2] = beanPropertyWriter.rename(nameTransformer);
        }
        return beanPropertyWriterArray2;
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        int n2;
        int n3 = this._filteredProps == null ? 0 : this._filteredProps.length;
        int n4 = this._props.length;
        for (n2 = 0; n2 < n4; ++n2) {
            Object object;
            JsonSerializer<Object> jsonSerializer;
            BeanPropertyWriter beanPropertyWriter = this._props[n2];
            if (!beanPropertyWriter.willSuppressNulls() && !beanPropertyWriter.hasNullSerializer() && (jsonSerializer = serializerProvider.findNullValueSerializer(beanPropertyWriter)) != null) {
                beanPropertyWriter.assignNullSerializer(jsonSerializer);
                if (n2 < n3 && (object = this._filteredProps[n2]) != null) {
                    ((BeanPropertyWriter)object).assignNullSerializer(jsonSerializer);
                }
            }
            if (beanPropertyWriter.hasSerializer()) continue;
            jsonSerializer = this.findConvertingSerializer(serializerProvider, beanPropertyWriter);
            if (jsonSerializer == null) {
                object = beanPropertyWriter.getSerializationType();
                if (object == null && !((ResolvedType)(object = beanPropertyWriter.getType())).isFinal()) {
                    if (!((ResolvedType)object).isContainerType() && ((ResolvedType)object).containedTypeCount() <= 0) continue;
                    beanPropertyWriter.setNonTrivialBaseType((JavaType)object);
                    continue;
                }
                jsonSerializer = serializerProvider.findValueSerializer((JavaType)object, (BeanProperty)beanPropertyWriter);
                if (((ResolvedType)object).isContainerType() && (object = (TypeSerializer)((JavaType)object).getContentType().getTypeHandler()) != null && jsonSerializer instanceof ContainerSerializer) {
                    jsonSerializer = ((ContainerSerializer)jsonSerializer).withValueTypeSerializer((TypeSerializer)object);
                }
            }
            if (n2 < n3 && (object = this._filteredProps[n2]) != null) {
                ((BeanPropertyWriter)object).assignSerializer(jsonSerializer);
                continue;
            }
            beanPropertyWriter.assignSerializer(jsonSerializer);
        }
        for (n2 = 0; n2 < this._props.length; ++n2) {
            BeanPropertyWriter beanPropertyWriter = this._props[n2];
            if (!(beanPropertyWriter instanceof AnyGetterWriter)) continue;
            ((AnyGetterWriter)beanPropertyWriter).resolve(serializerProvider);
        }
    }

    protected JsonSerializer<Object> findConvertingSerializer(SerializerProvider serializerProvider, BeanPropertyWriter beanPropertyWriter) throws JsonMappingException {
        Serializable serializable;
        Converter<Object, Object> converter = ((DatabindContext)serializerProvider).getAnnotationIntrospector();
        if (converter != null && (serializable = beanPropertyWriter.getMember()) != null && (converter = ((AnnotationIntrospector)((Object)converter)).findSerializationConverter((Annotated)((Object)serializable))) != null) {
            converter = serializerProvider.converterInstance(beanPropertyWriter.getMember(), converter);
            serializable = converter.getOutputType(((DatabindContext)serializerProvider).getTypeFactory());
            serializerProvider = ((JavaType)serializable).isJavaLangObject() ? null : serializerProvider.findValueSerializer((JavaType)serializable, (BeanProperty)beanPropertyWriter);
            return new StdDelegatingSerializer(converter, (JavaType)serializable, (JsonSerializer<?>)((Object)serializerProvider));
        }
        return null;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        Serializable serializable;
        Object object2;
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)serializerProvider).getAnnotationIntrospector();
        AnnotatedMember annotatedMember = beanProperty == null || annotationIntrospector == null ? null : beanProperty.getMember();
        Object object3 = serializerProvider.getConfig();
        Serializable serializable2 = this.findFormatOverrides(serializerProvider, beanProperty, this._handledType);
        JsonFormat$Shape jsonFormat$Shape = null;
        if (serializable2 != null && serializable2.hasShape() && (jsonFormat$Shape = serializable2.getShape()) != JsonFormat$Shape.ANY && jsonFormat$Shape != this._serializationShape) {
            if (((ResolvedType)this._beanType).isEnumType()) {
                switch (jsonFormat$Shape) {
                    case STRING: 
                    case NUMBER: 
                    case NUMBER_INT: {
                        BeanDescription beanDescription = ((MapperConfig)object3).introspectClassAnnotations(this._beanType);
                        serializable2 = EnumSerializer.construct(((ResolvedType)this._beanType).getRawClass(), serializerProvider.getConfig(), beanDescription, serializable2);
                        return serializerProvider.handlePrimaryContextualization((JsonSerializer<?>)((Object)serializable2), beanProperty);
                    }
                }
            } else if (!(jsonFormat$Shape != JsonFormat$Shape.NATURAL || ((ResolvedType)this._beanType).isMapLikeType() && Map.class.isAssignableFrom(this._handledType) || !Map.Entry.class.isAssignableFrom(this._handledType))) {
                JavaType javaType = this._beanType.findSuperType(Map.Entry.class);
                serializable2 = javaType.containedTypeOrUnknown(0);
                JavaType javaType2 = javaType.containedTypeOrUnknown(1);
                MapEntrySerializer mapEntrySerializer = new MapEntrySerializer(this._beanType, (JavaType)serializable2, javaType2, false, null, beanProperty);
                return serializerProvider.handlePrimaryContextualization(mapEntrySerializer, beanProperty);
            }
        }
        Object object4 = this._objectIdWriter;
        int n2 = 0;
        Set<String> set = null;
        Set<String> set2 = null;
        Object object5 = null;
        if (annotatedMember != null) {
            set = annotationIntrospector.findPropertyIgnoralByName((MapperConfig<?>)object3, annotatedMember).findIgnoredForSerialization();
            set2 = annotationIntrospector.findPropertyInclusionByName((MapperConfig<?>)object3, annotatedMember).getIncluded();
            object3 = annotationIntrospector.findObjectIdInfo(annotatedMember);
            if (object3 == null) {
                if (object4 != null && (object3 = annotationIntrospector.findObjectReferenceInfo(annotatedMember, null)) != null) {
                    object4 = this._objectIdWriter.withAlwaysAsId(((ObjectIdInfo)object3).getAlwaysAsId());
                }
            } else {
                object3 = annotationIntrospector.findObjectReferenceInfo(annotatedMember, (ObjectIdInfo)object3);
                object2 = ((ObjectIdInfo)object3).getGeneratorType();
                serializable = serializerProvider.constructType((Type)object2);
                object = ((DatabindContext)serializerProvider).getTypeFactory().findTypeParameters((JavaType)serializable, ObjectIdGenerator.class)[0];
                if (object2 == ObjectIdGenerators$PropertyGenerator.class) {
                    object4 = ((ObjectIdInfo)object3).getPropertyName().getSimpleName();
                    int n3 = 0;
                    n2 = this._props.length;
                    while (true) {
                        if (n3 == n2) {
                            ((DatabindContext)serializerProvider).reportBadDefinition(this._beanType, String.format("Invalid Object Id definition for %s: cannot find property with name %s", ClassUtil.nameOf(((JsonSerializer)this).handledType()), ClassUtil.name((String)object4)));
                        }
                        if (((String)object4).equals(((PropertyWriter)(serializable = this._props[n3])).getName())) break;
                        ++n3;
                    }
                    object4 = serializable;
                    n2 = n3;
                    object = ((BeanPropertyWriter)object4).getType();
                    object2 = new PropertyBasedObjectIdGenerator((ObjectIdInfo)object3, (BeanPropertyWriter)object4);
                    object4 = ObjectIdWriter.construct((JavaType)object, null, object2, ((ObjectIdInfo)object3).getAlwaysAsId());
                } else {
                    object4 = serializerProvider.objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object3);
                    object4 = ObjectIdWriter.construct((JavaType)object, ((ObjectIdInfo)object3).getPropertyName(), object4, ((ObjectIdInfo)object3).getAlwaysAsId());
                }
            }
            if ((object2 = annotationIntrospector.findFilterId(annotatedMember)) != null && !object2.equals(this._propertyFilterId)) {
                object5 = object2;
            }
        }
        object3 = this;
        if (n2 > 0) {
            object2 = Arrays.copyOf(this._props, this._props.length);
            serializable = object2[n2];
            System.arraycopy(object2, 0, object2, 1, n2);
            object2[0] = serializable;
            if (this._filteredProps == null) {
                object = null;
            } else {
                object = Arrays.copyOf(this._filteredProps, this._filteredProps.length);
                serializable = object[n2];
                System.arraycopy(object, 0, object, 1, n2);
                object[0] = serializable;
            }
            object3 = ((BeanSerializerBase)object3).withProperties((BeanPropertyWriter[])object2, (BeanPropertyWriter[])object);
        }
        if (object4 != null && (object4 = ((ObjectIdWriter)object4).withSerializer((JsonSerializer<?>)(object2 = serializerProvider.findValueSerializer(((ObjectIdWriter)object4).idType, beanProperty)))) != this._objectIdWriter) {
            object3 = ((BeanSerializerBase)object3).withObjectIdWriter((ObjectIdWriter)object4);
        }
        if (set != null && !set.isEmpty() || set2 != null) {
            object3 = ((BeanSerializerBase)object3).withByNameInclusion(set, set2);
        }
        if (object5 != null) {
            object3 = ((BeanSerializerBase)object3).withFilterId(object5);
        }
        if (jsonFormat$Shape == null) {
            jsonFormat$Shape = this._serializationShape;
        }
        if (jsonFormat$Shape == JsonFormat$Shape.ARRAY) {
            return ((BeanSerializerBase)object3).asArraySerializer();
        }
        return object3;
    }

    @Override
    public Iterator<PropertyWriter> properties() {
        return Arrays.asList(this._props).iterator();
    }

    @Override
    public boolean usesObjectId() {
        return this._objectIdWriter != null;
    }

    @Override
    public abstract void serialize(Object var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(object, jsonGenerator, serializerProvider, typeSerializer);
            return;
        }
        WritableTypeId writableTypeId = this._typeIdDef(typeSerializer, object, JsonToken.START_OBJECT);
        typeSerializer.writeTypePrefix(jsonGenerator, writableTypeId);
        jsonGenerator.assignCurrentValue(object);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected final void _serializeWithObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean bl2) throws IOException {
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableObjectId writableObjectId = serializerProvider.findObjectId(object, objectIdWriter.generator);
        if (writableObjectId.writeAsId(jsonGenerator, serializerProvider, objectIdWriter)) {
            return;
        }
        Object object2 = writableObjectId.generateId(object);
        if (objectIdWriter.alwaysAsId) {
            objectIdWriter.serializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        if (bl2) {
            jsonGenerator.writeStartObject(object);
        }
        writableObjectId.writeAsField(jsonGenerator, serializerProvider, objectIdWriter);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (bl2) {
            jsonGenerator.writeEndObject();
        }
    }

    protected final void _serializeWithObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableObjectId writableObjectId = serializerProvider.findObjectId(object, objectIdWriter.generator);
        if (writableObjectId.writeAsId(jsonGenerator, serializerProvider, objectIdWriter)) {
            return;
        }
        Object object2 = writableObjectId.generateId(object);
        if (objectIdWriter.alwaysAsId) {
            objectIdWriter.serializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        this._serializeObjectId(object, jsonGenerator, serializerProvider, typeSerializer, writableObjectId);
    }

    protected void _serializeObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer, WritableObjectId writableObjectId) throws IOException {
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableTypeId writableTypeId = this._typeIdDef(typeSerializer, object, JsonToken.START_OBJECT);
        typeSerializer.writeTypePrefix(jsonGenerator, writableTypeId);
        jsonGenerator.assignCurrentValue(object);
        writableObjectId.writeAsField(jsonGenerator, serializerProvider, objectIdWriter);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected final WritableTypeId _typeIdDef(TypeSerializer typeSerializer, Object object, JsonToken jsonToken) {
        if (this._typeId == null) {
            return typeSerializer.typeId(object, jsonToken);
        }
        Object object2 = this._typeId.getValue(object);
        if (object2 == null) {
            object2 = "";
        }
        return typeSerializer.typeId(object, jsonToken, object2);
    }

    @Deprecated
    protected final String _customTypeId(Object object) {
        if ((object = this._typeId.getValue(object)) == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    protected void serializeFields(Object object, JsonGenerator object2, SerializerProvider serializerProvider) throws IOException {
        int n2;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && ((DatabindContext)serializerProvider).getActiveView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                ((PropertyWriter)beanPropertyWriter).serializeAsField(object, (JsonGenerator)object2, serializerProvider);
            }
            return;
        }
        catch (Exception exception) {
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : ((PropertyWriter)beanPropertyWriterArray[n2]).getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
            return;
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException((Closeable)object2, "Infinite recursion (StackOverflowError)", (Throwable)stackOverflowError);
            object2 = n2 == beanPropertyWriterArray.length ? "[anySetter]" : ((PropertyWriter)beanPropertyWriterArray[n2]).getName();
            ((DatabindException)jsonMappingException).prependPath(object, (String)object2);
            throw jsonMappingException;
        }
    }

    protected void serializeFieldsFiltered(Object object, JsonGenerator object2, SerializerProvider serializerProvider) throws IOException {
        int n2;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && ((DatabindContext)serializerProvider).getActiveView() != null ? this._filteredProps : this._props;
        PropertyFilter propertyFilter = this.findPropertyFilter(serializerProvider, this._propertyFilterId, object);
        if (propertyFilter == null) {
            this.serializeFields(object, (JsonGenerator)object2, serializerProvider);
            return;
        }
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                propertyFilter.serializeAsField(object, (JsonGenerator)object2, serializerProvider, beanPropertyWriter);
            }
            return;
        }
        catch (Exception exception) {
            String string = n2 == beanPropertyWriterArray.length ? "[anySetter]" : ((PropertyWriter)beanPropertyWriterArray[n2]).getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
            return;
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException((Closeable)object2, "Infinite recursion (StackOverflowError)", (Throwable)stackOverflowError);
            object2 = n2 == beanPropertyWriterArray.length ? "[anySetter]" : ((PropertyWriter)beanPropertyWriterArray[n2]).getName();
            ((DatabindException)jsonMappingException).prependPath(object, (String)object2);
            throw jsonMappingException;
        }
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type object) throws JsonMappingException {
        object = this.createSchemaNode("object", true);
        Object object2 = this._handledType.getAnnotation(JsonSerializableSchema.class);
        if (object2 != null && (object2 = object2.id()) != null && !((String)object2).isEmpty()) {
            ((ObjectNode)object).put("id", (String)object2);
        }
        object2 = ((ContainerNode)object).objectNode();
        PropertyFilter propertyFilter = this._propertyFilterId != null ? this.findPropertyFilter(serializerProvider, this._propertyFilterId, null) : null;
        for (int i2 = 0; i2 < this._props.length; ++i2) {
            BeanPropertyWriter beanPropertyWriter = this._props[i2];
            if (propertyFilter == null) {
                ((PropertyWriter)beanPropertyWriter).depositSchemaProperty((ObjectNode)object2, serializerProvider);
                continue;
            }
            propertyFilter.depositSchemaProperty((PropertyWriter)beanPropertyWriter, (ObjectNode)object2, serializerProvider);
        }
        ((ObjectNode)object).set("properties", (JsonNode)object2);
        return object;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper object, JavaType object2) throws JsonMappingException {
        if (object == null) {
            return;
        }
        if ((object2 = object.expectObjectFormat((JavaType)object2)) == null) {
            return;
        }
        SerializerProvider serializerProvider = object.getProvider();
        if (this._propertyFilterId != null) {
            object = this.findPropertyFilter(object.getProvider(), this._propertyFilterId, null);
            int n2 = this._props.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                object.depositSchemaProperty((PropertyWriter)this._props[i2], (JsonObjectFormatVisitor)object2, serializerProvider);
            }
            return;
        }
        object = this._filteredProps == null || serializerProvider == null ? null : ((DatabindContext)serializerProvider).getActiveView();
        for (BeanPropertyWriter beanPropertyWriter : object != null ? this._filteredProps : this._props) {
            if (beanPropertyWriter == null) continue;
            ((PropertyWriter)beanPropertyWriter).depositSchemaProperty((JsonObjectFormatVisitor)object2, serializerProvider);
        }
    }
}

