/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.annotation.JsonInclude$Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap$SerializerAndMapResult;
import com.fasterxml.jackson.databind.ser.std.MapProperty;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil$Checker;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

@JacksonStdImpl
public class MapSerializer
extends ContainerSerializer<Map<?, ?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected static final JavaType UNSPECIFIED_TYPE = TypeFactory.unknownType();
    public static final Object MARKER_FOR_EMPTY = JsonInclude$Include.NON_EMPTY;
    protected final BeanProperty _property;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;
    protected final Set<String> _ignoredEntries;
    protected final Set<String> _includedEntries;
    protected final Object _filterId;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;
    protected final IgnorePropertiesUtil$Checker _inclusionChecker;
    protected final boolean _sortKeys;

    protected MapSerializer(Set<String> set, Set<String> set2, JavaType javaType, JavaType javaType2, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2) {
        super(Map.class, false);
        this._ignoredEntries = set == null || set.isEmpty() ? null : set;
        this._includedEntries = set2;
        this._keyType = javaType;
        this._valueType = javaType2;
        this._valueTypeIsStatic = bl2;
        this._valueTypeSerializer = typeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
        this._property = null;
        this._filterId = null;
        this._sortKeys = false;
        this._suppressableValue = null;
        this._suppressNulls = false;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignoredEntries, this._includedEntries);
    }

    @Deprecated
    protected MapSerializer(Set<String> set, JavaType javaType, JavaType javaType2, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2) {
        this(set, null, javaType, javaType2, bl2, typeSerializer, jsonSerializer, jsonSerializer2);
    }

    protected MapSerializer(MapSerializer mapSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Set<String> set, Set<String> set2) {
        super(Map.class, false);
        this._ignoredEntries = set == null || set.isEmpty() ? null : set;
        this._includedEntries = set2;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = mapSerializer._valueTypeSerializer;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
        this._property = beanProperty;
        this._filterId = mapSerializer._filterId;
        this._sortKeys = mapSerializer._sortKeys;
        this._suppressableValue = mapSerializer._suppressableValue;
        this._suppressNulls = mapSerializer._suppressNulls;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignoredEntries, this._includedEntries);
    }

    @Deprecated
    protected MapSerializer(MapSerializer mapSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Set<String> set) {
        this(mapSerializer, beanProperty, jsonSerializer, jsonSerializer2, set, null);
    }

    protected MapSerializer(MapSerializer mapSerializer, TypeSerializer typeSerializer, Object object, boolean bl2) {
        super(Map.class, false);
        this._ignoredEntries = mapSerializer._ignoredEntries;
        this._includedEntries = mapSerializer._includedEntries;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = typeSerializer;
        this._keySerializer = mapSerializer._keySerializer;
        this._valueSerializer = mapSerializer._valueSerializer;
        this._dynamicValueSerializers = mapSerializer._dynamicValueSerializers;
        this._property = mapSerializer._property;
        this._filterId = mapSerializer._filterId;
        this._sortKeys = mapSerializer._sortKeys;
        this._suppressableValue = object;
        this._suppressNulls = bl2;
        this._inclusionChecker = mapSerializer._inclusionChecker;
    }

    protected MapSerializer(MapSerializer mapSerializer, Object object, boolean bl2) {
        super(Map.class, false);
        this._ignoredEntries = mapSerializer._ignoredEntries;
        this._includedEntries = mapSerializer._includedEntries;
        this._keyType = mapSerializer._keyType;
        this._valueType = mapSerializer._valueType;
        this._valueTypeIsStatic = mapSerializer._valueTypeIsStatic;
        this._valueTypeSerializer = mapSerializer._valueTypeSerializer;
        this._keySerializer = mapSerializer._keySerializer;
        this._valueSerializer = mapSerializer._valueSerializer;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
        this._property = mapSerializer._property;
        this._filterId = object;
        this._sortKeys = bl2;
        this._suppressableValue = mapSerializer._suppressableValue;
        this._suppressNulls = mapSerializer._suppressNulls;
        this._inclusionChecker = mapSerializer._inclusionChecker;
    }

    public MapSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        if (this._valueTypeSerializer == typeSerializer) {
            return this;
        }
        this._ensureOverride("_withValueTypeSerializer");
        return new MapSerializer(this, typeSerializer, this._suppressableValue, this._suppressNulls);
    }

    public MapSerializer withResolved(BeanProperty object, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Set<String> set, Set<String> set2, boolean bl2) {
        this._ensureOverride("withResolved");
        object = new MapSerializer(this, (BeanProperty)object, jsonSerializer, jsonSerializer2, set, set2);
        if (bl2 != ((MapSerializer)object)._sortKeys) {
            object = new MapSerializer((MapSerializer)object, this._filterId, bl2);
        }
        return object;
    }

    public MapSerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, JsonSerializer<?> jsonSerializer2, Set<String> set, boolean bl2) {
        return this.withResolved(beanProperty, jsonSerializer, jsonSerializer2, set, null, bl2);
    }

    public MapSerializer withFilterId(Object object) {
        if (this._filterId == object) {
            return this;
        }
        this._ensureOverride("withFilterId");
        return new MapSerializer(this, object, this._sortKeys);
    }

    public MapSerializer withContentInclusion(Object object, boolean bl2) {
        if (object == this._suppressableValue && bl2 == this._suppressNulls) {
            return this;
        }
        this._ensureOverride("withContentInclusion");
        MapSerializer mapSerializer = this;
        return new MapSerializer(mapSerializer, mapSerializer._valueTypeSerializer, object, bl2);
    }

    public static MapSerializer construct(Set<String> object, Set<String> set, JavaType javaType, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2, Object object2) {
        JavaType javaType2;
        if (javaType == null) {
            javaType2 = javaType = UNSPECIFIED_TYPE;
        } else {
            javaType2 = javaType.getKeyType();
            javaType = ((ResolvedType)javaType).hasRawClass(Properties.class) ? TypeFactory.unknownType() : javaType.getContentType();
        }
        if (!bl2) {
            bl2 = javaType != null && ((ResolvedType)javaType).isFinal();
        } else if (((ResolvedType)javaType).getRawClass() == Object.class) {
            bl2 = false;
        }
        object = new MapSerializer((Set<String>)object, set, javaType2, javaType, bl2, typeSerializer, jsonSerializer, jsonSerializer2);
        if (object2 != null) {
            object = ((MapSerializer)object).withFilterId(object2);
        }
        return object;
    }

    public static MapSerializer construct(Set<String> set, JavaType javaType, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2, Object object) {
        return MapSerializer.construct(set, null, javaType, bl2, typeSerializer, jsonSerializer, jsonSerializer2, object);
    }

    protected void _ensureOverride(String string) {
        ClassUtil.verifyMustOverride(MapSerializer.class, this, string);
    }

    @Deprecated
    protected void _ensureOverride() {
        this._ensureOverride("N/A");
    }

    @Deprecated
    protected MapSerializer(MapSerializer mapSerializer, TypeSerializer typeSerializer, Object object) {
        this(mapSerializer, typeSerializer, object, false);
    }

    @Deprecated
    public MapSerializer withContentInclusion(Object object) {
        MapSerializer mapSerializer = this;
        return new MapSerializer(mapSerializer, mapSerializer._valueTypeSerializer, object, this._suppressNulls);
    }

    @Deprecated
    public static MapSerializer construct(String[] object, JavaType javaType, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2, Object object2) {
        object = ArrayBuilders.arrayToSet(object);
        return MapSerializer.construct(object, javaType, bl2, typeSerializer, jsonSerializer, jsonSerializer2, object2);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonInclude$Include jsonInclude$Include;
        Object object;
        Object object2;
        Set<String> set;
        Serializable serializable;
        Set<String> set2;
        AnnotationIntrospector annotationIntrospector;
        JsonSerializer<Object> jsonSerializer = null;
        JsonSerializer<Object> jsonSerializer2 = null;
        AnnotatedMember annotatedMember = beanProperty == null ? null : beanProperty.getMember();
        if (MapSerializer._neitherNull(annotatedMember, annotationIntrospector = ((DatabindContext)serializerProvider).getAnnotationIntrospector())) {
            set2 = annotationIntrospector.findKeySerializer(annotatedMember);
            if (set2 != null) {
                jsonSerializer2 = serializerProvider.serializerInstance(annotatedMember, set2);
            }
            if ((set2 = annotationIntrospector.findContentSerializer(annotatedMember)) != null) {
                jsonSerializer = serializerProvider.serializerInstance(annotatedMember, set2);
            }
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._valueSerializer;
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null && this._valueTypeIsStatic && !this._valueType.isJavaLangObject()) {
            jsonSerializer = serializerProvider.findContentValueSerializer(this._valueType, beanProperty);
        }
        if (jsonSerializer2 == null) {
            jsonSerializer2 = this._keySerializer;
        }
        jsonSerializer2 = jsonSerializer2 == null ? serializerProvider.findKeySerializer(this._keyType, beanProperty) : serializerProvider.handleSecondaryContextualization(jsonSerializer2, beanProperty);
        set2 = this._ignoredEntries;
        Set<String> set3 = this._includedEntries;
        boolean bl2 = false;
        if (MapSerializer._neitherNull(annotatedMember, annotationIntrospector)) {
            Object object4;
            serializable = serializerProvider.getConfig();
            set = annotationIntrospector.findPropertyIgnoralByName((MapperConfig<?>)serializable, annotatedMember).findIgnoredForSerialization();
            if (MapSerializer._nonEmpty(set)) {
                set2 = set2 == null ? new HashSet<String>() : new HashSet<String>(set2);
                for (String object32 : set) {
                    set2.add(object32);
                }
            }
            if ((object4 = annotationIntrospector.findPropertyInclusionByName((MapperConfig<?>)serializable, annotatedMember).getIncluded()) != null) {
                set3 = set3 == null ? new HashSet<String>() : new HashSet<String>(set3);
                Iterator<String> iterator = object4.iterator();
                while (iterator.hasNext()) {
                    object4 = iterator.next();
                    set3.add((String)object4);
                }
            }
            Boolean bl3 = annotationIntrospector.findSerializationSortAlphabetically(annotatedMember);
            bl2 = Boolean.TRUE.equals(bl3);
        }
        if ((serializable = this.findFormatOverrides(serializerProvider, beanProperty, Map.class)) != null && (set = ((JsonFormat$Value)serializable).getFeature(JsonFormat$Feature.WRITE_SORTED_MAP_ENTRIES)) != null) {
            bl2 = (Boolean)((Object)set);
        }
        set = this.withResolved(beanProperty, jsonSerializer2, jsonSerializer, set2, set3, bl2);
        if (annotatedMember != null && (object2 = annotationIntrospector.findFilterId(annotatedMember)) != null) {
            set = ((MapSerializer)((Object)set)).withFilterId(object2);
        }
        if ((object = this.findIncludeOverrides(serializerProvider, beanProperty, Map.class)) != null && (jsonInclude$Include = ((JsonInclude$Value)object).getContentInclusion()) != JsonInclude$Include.USE_DEFAULTS) {
            boolean bl3;
            switch (jsonInclude$Include) {
                case NON_DEFAULT: {
                    object = BeanUtil.getDefaultValue(this._valueType);
                    bl3 = true;
                    if (object == null || !object.getClass().isArray()) break;
                    object = ArrayBuilders.getArrayComparator(object);
                    break;
                }
                case NON_ABSENT: {
                    bl3 = true;
                    object = this._valueType.isReferenceType() ? MARKER_FOR_EMPTY : null;
                    break;
                }
                case NON_EMPTY: {
                    bl3 = true;
                    object = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    object = serializerProvider.includeFilterInstance(null, ((JsonInclude$Value)object).getContentFilter());
                    if (object == null) {
                        bl3 = true;
                        break;
                    }
                    bl3 = serializerProvider.includeFilterSuppressNulls(object);
                    break;
                }
                case NON_NULL: {
                    object = null;
                    bl3 = true;
                    break;
                }
                default: {
                    object = null;
                    bl3 = false;
                }
            }
            set = ((MapSerializer)((Object)set)).withContentInclusion(object, bl3);
        }
        return set;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Map<?, ?> map) {
        boolean bl2;
        if (map.isEmpty()) {
            return true;
        }
        Object object = this._suppressableValue;
        if (object == null && !this._suppressNulls) {
            return false;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        boolean bl3 = bl2 = MARKER_FOR_EMPTY == object;
        if (jsonSerializer != null) {
            for (Object obj : map.values()) {
                if (!(obj == null ? !this._suppressNulls : (bl2 ? !jsonSerializer.isEmpty(serializerProvider, obj) : object == null || !object.equals(map)))) continue;
                return false;
            }
            return true;
        }
        for (Object obj : map.values()) {
            if (obj == null) {
                if (this._suppressNulls) continue;
                return false;
            }
            try {
                jsonSerializer = this._findSerializer(serializerProvider, obj);
            }
            catch (DatabindException databindException) {
                return false;
            }
            if (!(bl2 ? !jsonSerializer.isEmpty(serializerProvider, obj) : object == null || !object.equals(map))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSingleElement(Map<?, ?> map) {
        return map.size() == 1;
    }

    public JsonSerializer<?> getKeySerializer() {
        return this._keySerializer;
    }

    @Override
    public void serialize(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject(map);
        this.serializeWithoutTypeInfo(map, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        jsonGenerator.assignCurrentValue(map);
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(map, JsonToken.START_OBJECT));
        this.serializeWithoutTypeInfo(map, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    public void serializeWithoutTypeInfo(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (!map.isEmpty()) {
            PropertyFilter propertyFilter;
            if (this._sortKeys || serializerProvider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                map = this._orderEntries(map, jsonGenerator, serializerProvider);
            }
            if (this._filterId != null && (propertyFilter = this.findPropertyFilter(serializerProvider, this._filterId, map)) != null) {
                this.serializeFilteredFields(map, jsonGenerator, serializerProvider, propertyFilter, this._suppressableValue);
                return;
            }
            if (this._suppressableValue != null || this._suppressNulls) {
                this.serializeOptionalFields(map, jsonGenerator, serializerProvider, this._suppressableValue);
                return;
            }
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(map, jsonGenerator, serializerProvider, this._valueSerializer);
                return;
            }
            this.serializeFields(map, jsonGenerator, serializerProvider);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void serializeFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(map, jsonGenerator, serializerProvider, null);
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._keySerializer;
        Object t2 = null;
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                void var7_12;
                Object obj = entry.getValue();
                Object obj2 = entry.getKey();
                t2 = obj2;
                if (obj2 == null) {
                    serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
                } else {
                    if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(t2)) continue;
                    jsonSerializer.serialize(t2, jsonGenerator, serializerProvider);
                }
                if (obj == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                JsonSerializer<Object> jsonSerializer2 = this._valueSerializer;
                if (jsonSerializer2 == null) {
                    JsonSerializer<Object> jsonSerializer3 = this._findSerializer(serializerProvider, obj);
                }
                var7_12.serialize(obj, jsonGenerator, serializerProvider);
            }
            return;
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, map, String.valueOf(t2));
            return;
        }
    }

    public void serializeOptionalFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, Object object) throws IOException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(map, jsonGenerator, serializerProvider, object);
            return;
        }
        boolean bl2 = MARKER_FOR_EMPTY == object;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            JsonSerializer<Object> jsonSerializer;
            JsonSerializer<Object> jsonSerializer2;
            Object obj = entry.getKey();
            if (obj == null) {
                jsonSerializer2 = serializerProvider.findNullKeySerializer(this._keyType, this._property);
            } else {
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(obj)) continue;
                jsonSerializer2 = this._keySerializer;
            }
            entry = entry.getValue();
            if (entry == null) {
                if (this._suppressNulls) continue;
                jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
            } else {
                jsonSerializer = this._valueSerializer;
                if (jsonSerializer == null) {
                    jsonSerializer = this._findSerializer(serializerProvider, entry);
                }
                if (!bl2 ? object != null && object.equals(entry) : jsonSerializer.isEmpty(serializerProvider, entry)) continue;
            }
            try {
                jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
                jsonSerializer.serialize(entry, jsonGenerator, serializerProvider);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, String.valueOf(obj));
            }
        }
    }

    public void serializeFieldsUsing(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException {
        JsonSerializer<Object> jsonSerializer2 = this._keySerializer;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object obj = entry.getKey();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(obj)) continue;
            if (obj == null) {
                serializerProvider.findNullKeySerializer(this._keyType, this._property).serialize(null, jsonGenerator, serializerProvider);
            } else {
                jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
            }
            entry = entry.getValue();
            if (entry == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            try {
                if (typeSerializer == null) {
                    jsonSerializer.serialize(entry, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(entry, jsonGenerator, serializerProvider, typeSerializer);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, String.valueOf(obj));
            }
        }
    }

    public void serializeFilteredFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyFilter propertyFilter, Object object) throws IOException {
        MapProperty mapProperty = new MapProperty(this._valueTypeSerializer, this._property);
        boolean bl2 = MARKER_FOR_EMPTY == object;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            JsonSerializer<Object> jsonSerializer;
            Object obj = entry.getKey();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(obj)) continue;
            JsonSerializer<Object> jsonSerializer2 = obj == null ? serializerProvider.findNullKeySerializer(this._keyType, this._property) : this._keySerializer;
            if ((entry = entry.getValue()) == null) {
                if (this._suppressNulls) continue;
                jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
            } else {
                jsonSerializer = this._valueSerializer;
                if (jsonSerializer == null) {
                    jsonSerializer = this._findSerializer(serializerProvider, entry);
                }
                if (!bl2 ? object != null && object.equals(entry) : jsonSerializer.isEmpty(serializerProvider, entry)) continue;
            }
            mapProperty.reset(obj, entry, jsonSerializer2, jsonSerializer);
            try {
                propertyFilter.serializeAsField(map, jsonGenerator, serializerProvider, mapProperty);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, String.valueOf(obj));
            }
        }
    }

    public void serializeTypedFields(Map<?, ?> map, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, Object object) throws IOException {
        boolean bl2 = MARKER_FOR_EMPTY == object;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            JsonSerializer<Object> jsonSerializer;
            JsonSerializer<Object> jsonSerializer2;
            Object obj = entry.getKey();
            if (obj == null) {
                jsonSerializer2 = serializerProvider.findNullKeySerializer(this._keyType, this._property);
            } else {
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(obj)) continue;
                jsonSerializer2 = this._keySerializer;
            }
            entry = entry.getValue();
            if (entry == null) {
                if (this._suppressNulls) continue;
                jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
            } else {
                jsonSerializer = this._valueSerializer;
                if (jsonSerializer == null) {
                    jsonSerializer = this._findSerializer(serializerProvider, entry);
                }
                if (!bl2 ? object != null && object.equals(entry) : jsonSerializer.isEmpty(serializerProvider, entry)) continue;
            }
            jsonSerializer2.serialize(obj, jsonGenerator, serializerProvider);
            try {
                jsonSerializer.serializeWithType(entry, jsonGenerator, serializerProvider, this._valueTypeSerializer);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, String.valueOf(obj));
            }
        }
    }

    public void serializeFilteredAnyProperties(SerializerProvider serializerProvider, JsonGenerator jsonGenerator, Object object, Map<?, ?> map, PropertyFilter propertyFilter, Object object2) throws IOException {
        MapProperty mapProperty = new MapProperty(this._valueTypeSerializer, this._property);
        boolean bl2 = MARKER_FOR_EMPTY == object2;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            JsonSerializer<Object> jsonSerializer;
            Object obj = entry.getKey();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(obj)) continue;
            JsonSerializer<Object> jsonSerializer2 = obj == null ? serializerProvider.findNullKeySerializer(this._keyType, this._property) : this._keySerializer;
            if ((entry = entry.getValue()) == null) {
                if (this._suppressNulls) continue;
                jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
            } else {
                jsonSerializer = this._valueSerializer;
                if (jsonSerializer == null) {
                    jsonSerializer = this._findSerializer(serializerProvider, entry);
                }
                if (!bl2 ? object2 != null && object2.equals(entry) : jsonSerializer.isEmpty(serializerProvider, entry)) continue;
            }
            mapProperty.reset(obj, entry, jsonSerializer2, jsonSerializer);
            try {
                propertyFilter.serializeAsField(object, jsonGenerator, serializerProvider, mapProperty);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, map, String.valueOf(obj));
            }
        }
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("object", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType object) throws JsonMappingException {
        if ((object = jsonFormatVisitorWrapper.expectMapFormat((JavaType)object)) != null) {
            object.keyFormat(this._keySerializer, this._keyType);
            JsonSerializer<Object> jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                MapSerializer mapSerializer = this;
                jsonSerializer = mapSerializer._findAndAddDynamic(mapSerializer._dynamicValueSerializers, this._valueType, jsonFormatVisitorWrapper.getProvider());
            }
            object.valueFormat(jsonSerializer, this._valueType);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> object, SerializerProvider serializerProvider) throws JsonMappingException {
        object = propertySerializerMap.findAndAddSecondarySerializer((Class<?>)object, serializerProvider, this._property);
        if (propertySerializerMap != ((PropertySerializerMap$SerializerAndMapResult)object).map) {
            this._dynamicValueSerializers = ((PropertySerializerMap$SerializerAndMapResult)object).map;
        }
        return ((PropertySerializerMap$SerializerAndMapResult)object).serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType object, SerializerProvider serializerProvider) throws JsonMappingException {
        object = propertySerializerMap.findAndAddSecondarySerializer((JavaType)object, serializerProvider, this._property);
        if (propertySerializerMap != ((PropertySerializerMap$SerializerAndMapResult)object).map) {
            this._dynamicValueSerializers = ((PropertySerializerMap$SerializerAndMapResult)object).map;
        }
        return ((PropertySerializerMap$SerializerAndMapResult)object).serializer;
    }

    protected Map<?, ?> _orderEntries(Map<?, ?> object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Object object2;
        if (object instanceof SortedMap) {
            return object;
        }
        if (object.isEmpty()) {
            return object;
        }
        Object object32 = object.keySet().iterator().next();
        if (!Comparable.class.isInstance(object32)) {
            if (!serializerProvider.isEnabled(SerializationFeature.FAIL_ON_ORDER_MAP_BY_INCOMPARABLE_KEY)) {
                return object;
            }
            object2 = object32 == null ? Object.class : object32.getClass();
            serializerProvider.reportBadDefinition((Class<?>)object2, String.format("Cannot order Map entries by key of incomparable type %s, consider disabling `SerializationFeature.FAIL_ON_ORDER_MAP_BY_INCOMPARABLE_KEY` to simply skip sorting", ClassUtil.classNameOf(object32)));
        }
        if (this._hasNullKey((Map<?, ?>)((Object)object))) {
            object2 = new TreeMap();
            for (Map.Entry entry : object.entrySet()) {
                Object k2 = entry.getKey();
                if (k2 == null) {
                    this._writeNullKeyedEntry(jsonGenerator, serializerProvider, entry.getValue());
                    continue;
                }
                ((TreeMap)object2).put(k2, entry.getValue());
            }
            return object2;
        }
        return new TreeMap(object);
    }

    protected boolean _hasNullKey(Map<?, ?> map) {
        return map instanceof HashMap && map.containsKey(null);
    }

    protected void _writeNullKeyedEntry(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, Object object) throws IOException {
        JsonSerializer<Object> jsonSerializer;
        JsonSerializer<Object> jsonSerializer2 = serializerProvider.findNullKeySerializer(this._keyType, this._property);
        if (object == null) {
            if (this._suppressNulls) {
                return;
            }
            jsonSerializer = serializerProvider.getDefaultNullValueSerializer();
        } else {
            jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = this._findSerializer(serializerProvider, object);
            }
            if (this._suppressableValue == MARKER_FOR_EMPTY ? jsonSerializer.isEmpty(serializerProvider, object) : this._suppressableValue != null && this._suppressableValue.equals(object)) {
                return;
            }
        }
        try {
            jsonSerializer2.serialize(null, jsonGenerator, serializerProvider);
            jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
            return;
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, "");
            return;
        }
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider serializerProvider, Object clazz) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._dynamicValueSerializers.serializerFor(clazz = clazz.getClass());
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        if (((ResolvedType)this._valueType).hasGenericTypes()) {
            MapSerializer mapSerializer = this;
            return mapSerializer._findAndAddDynamic(mapSerializer._dynamicValueSerializers, ((DatabindContext)serializerProvider).constructSpecializedType(this._valueType, clazz), serializerProvider);
        }
        MapSerializer mapSerializer = this;
        return mapSerializer._findAndAddDynamic(mapSerializer._dynamicValueSerializers, clazz, serializerProvider);
    }
}

