/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;

@JacksonStdImpl
public class SqlDateSerializer
extends DateTimeSerializerBase<Date> {
    public SqlDateSerializer() {
        this(null, null);
    }

    protected SqlDateSerializer(Boolean bl2, DateFormat dateFormat) {
        super(Date.class, bl2, dateFormat);
    }

    public SqlDateSerializer withFormat(Boolean bl2, DateFormat dateFormat) {
        return new SqlDateSerializer(bl2, dateFormat);
    }

    @Override
    protected long _timestamp(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    @Override
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._asTimestamp(serializerProvider)) {
            jsonGenerator.writeNumber(this._timestamp(date));
            return;
        }
        if (this._customFormat == null) {
            jsonGenerator.writeString(date.toString());
            return;
        }
        this._serializeAsString(date, jsonGenerator, serializerProvider);
    }
}

