/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers$TypedPrimitiveArraySerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class StdArraySerializers$FloatArraySerializer
extends StdArraySerializers$TypedPrimitiveArraySerializer<float[]> {
    private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Float.TYPE);

    public StdArraySerializers$FloatArraySerializer() {
        super(float[].class);
    }

    public StdArraySerializers$FloatArraySerializer(StdArraySerializers$FloatArraySerializer stdArraySerializers$FloatArraySerializer, BeanProperty beanProperty, Boolean bl2) {
        super(stdArraySerializers$FloatArraySerializer, beanProperty, bl2);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
        return new StdArraySerializers$FloatArraySerializer(this, beanProperty, bl2);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return null;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, float[] fArray) {
        return fArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(float[] fArray) {
        return fArray.length == 1;
    }

    @Override
    public final void serialize(float[] fArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n2 = fArray.length;
        if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
            this.serializeContents(fArray, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(fArray, n2);
        this.serializeContents(fArray, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(float[] fArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            jsonGenerator.writeNumber(fArray[i2]);
        }
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.NUMBER);
    }
}

