/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBase;
import com.fasterxml.jackson.databind.type.TypeBindings;
import java.lang.reflect.Array;

public final class ArrayType
extends TypeBase {
    private static final long serialVersionUID = 1L;
    protected final JavaType _componentType;
    protected final Object _emptyArray;

    protected ArrayType(JavaType javaType, TypeBindings typeBindings, Object object, Object object2, Object object3, boolean bl2) {
        super(object.getClass(), typeBindings, null, null, javaType.hashCode(), object2, object3, bl2);
        this._componentType = javaType;
        this._emptyArray = object;
    }

    public static ArrayType construct(JavaType javaType, TypeBindings typeBindings) {
        return ArrayType.construct(javaType, typeBindings, null, null);
    }

    public static ArrayType construct(JavaType javaType, TypeBindings typeBindings, Object object, Object object2) {
        Object object3 = Array.newInstance(((ResolvedType)javaType).getRawClass(), 0);
        return new ArrayType(javaType, typeBindings, object3, object, object2, false);
    }

    @Override
    public final JavaType withContentType(JavaType javaType) {
        Object object = Array.newInstance(((ResolvedType)javaType).getRawClass(), 0);
        return new ArrayType(javaType, this._bindings, object, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public final ArrayType withTypeHandler(Object object) {
        if (object == this._typeHandler) {
            return this;
        }
        return new ArrayType(this._componentType, this._bindings, this._emptyArray, this._valueHandler, object, this._asStatic);
    }

    @Override
    public final ArrayType withContentTypeHandler(Object object) {
        if (object == this._componentType.getTypeHandler()) {
            return this;
        }
        return new ArrayType(this._componentType.withTypeHandler(object), this._bindings, this._emptyArray, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public final ArrayType withValueHandler(Object object) {
        if (object == this._valueHandler) {
            return this;
        }
        return new ArrayType(this._componentType, this._bindings, this._emptyArray, object, this._typeHandler, this._asStatic);
    }

    @Override
    public final ArrayType withContentValueHandler(Object object) {
        if (object == this._componentType.getValueHandler()) {
            return this;
        }
        return new ArrayType(this._componentType.withValueHandler(object), this._bindings, this._emptyArray, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public final ArrayType withStaticTyping() {
        if (this._asStatic) {
            return this;
        }
        return new ArrayType(this._componentType.withStaticTyping(), this._bindings, this._emptyArray, this._valueHandler, this._typeHandler, true);
    }

    @Override
    public final JavaType refine(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        return null;
    }

    @Override
    public final boolean isArrayType() {
        return true;
    }

    @Override
    public final boolean isAbstract() {
        return false;
    }

    @Override
    public final boolean isConcrete() {
        return true;
    }

    @Override
    public final boolean hasGenericTypes() {
        return ((ResolvedType)this._componentType).hasGenericTypes();
    }

    @Override
    public final boolean isContainerType() {
        return true;
    }

    @Override
    public final JavaType getContentType() {
        return this._componentType;
    }

    @Override
    public final Object getContentValueHandler() {
        return this._componentType.getValueHandler();
    }

    @Override
    public final Object getContentTypeHandler() {
        return this._componentType.getTypeHandler();
    }

    @Override
    public final boolean hasHandlers() {
        return super.hasHandlers() || this._componentType.hasHandlers();
    }

    @Override
    public final StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        stringBuilder.append('[');
        return this._componentType.getGenericSignature(stringBuilder);
    }

    @Override
    public final StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        stringBuilder.append('[');
        return this._componentType.getErasedSignature(stringBuilder);
    }

    public final Object[] getEmptyArray() {
        return (Object[])this._emptyArray;
    }

    @Override
    public final String toString() {
        return "[array type, component type: " + this._componentType + "]";
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        object = (ArrayType)object;
        return this._componentType.equals(((ArrayType)object)._componentType);
    }
}

