/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class TypeBase
extends JavaType
implements JsonSerializable {
    private static final long serialVersionUID = 1L;
    private static final TypeBindings NO_BINDINGS = TypeBindings.emptyBindings();
    private static final JavaType[] NO_TYPES = new JavaType[0];
    protected final JavaType _superClass;
    protected final JavaType[] _superInterfaces;
    protected final TypeBindings _bindings;
    volatile transient String _canonicalName;

    protected TypeBase(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray, int n2, Object object, Object object2, boolean bl2) {
        super(clazz, n2, object, object2, bl2);
        this._bindings = typeBindings == null ? NO_BINDINGS : typeBindings;
        this._superClass = javaType;
        this._superInterfaces = javaTypeArray;
    }

    protected TypeBase(TypeBase typeBase) {
        super(typeBase);
        this._superClass = typeBase._superClass;
        this._superInterfaces = typeBase._superInterfaces;
        this._bindings = typeBase._bindings;
    }

    @Override
    public String toCanonical() {
        String string = this._canonicalName;
        if (string == null) {
            string = this.buildCanonicalName();
        }
        return string;
    }

    protected String buildCanonicalName() {
        return this._class.getName();
    }

    @Override
    public abstract StringBuilder getGenericSignature(StringBuilder var1);

    @Override
    public abstract StringBuilder getErasedSignature(StringBuilder var1);

    @Override
    public TypeBindings getBindings() {
        return this._bindings;
    }

    @Override
    public int containedTypeCount() {
        return this._bindings.size();
    }

    @Override
    public JavaType containedType(int n2) {
        return this._bindings.getBoundType(n2);
    }

    @Override
    @Deprecated
    public String containedTypeName(int n2) {
        return this._bindings.getBoundName(n2);
    }

    @Override
    public JavaType getSuperClass() {
        return this._superClass;
    }

    @Override
    public List<JavaType> getInterfaces() {
        if (this._superInterfaces == null) {
            return Collections.emptyList();
        }
        switch (this._superInterfaces.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(this._superInterfaces[0]);
            }
        }
        return Arrays.asList(this._superInterfaces);
    }

    @Override
    public final JavaType findSuperType(Class<?> clazz) {
        JavaType javaType;
        if (clazz == this._class) {
            return this;
        }
        if (clazz.isInterface() && this._superInterfaces != null) {
            int n2 = this._superInterfaces.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                JavaType javaType2 = this._superInterfaces[i2].findSuperType(clazz);
                if (javaType2 == null) continue;
                return javaType2;
            }
        }
        if (this._superClass != null && (javaType = this._superClass.findSuperType(clazz)) != null) {
            return javaType;
        }
        return null;
    }

    @Override
    public JavaType[] findTypeParameters(Class<?> type) {
        if ((type = ((JavaType)this).findSuperType((Class<?>)type)) == null) {
            return NO_TYPES;
        }
        return ((JavaType)type).getBindings().typeParameterArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = new WritableTypeId(this, JsonToken.VALUE_STRING);
        typeSerializer.writeTypePrefix(jsonGenerator, writableTypeId);
        this.serialize(jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeString(((ResolvedType)this).toCanonical());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static StringBuilder _classSignature(Class<?> object, StringBuilder stringBuilder, boolean bl2) {
        if (((Class)object).isPrimitive()) {
            if (object == Boolean.TYPE) {
                stringBuilder.append('Z');
                return stringBuilder;
            } else if (object == Byte.TYPE) {
                stringBuilder.append('B');
                return stringBuilder;
            } else if (object == Short.TYPE) {
                stringBuilder.append('S');
                return stringBuilder;
            } else if (object == Character.TYPE) {
                stringBuilder.append('C');
                return stringBuilder;
            } else if (object == Integer.TYPE) {
                stringBuilder.append('I');
                return stringBuilder;
            } else if (object == Long.TYPE) {
                stringBuilder.append('J');
                return stringBuilder;
            } else if (object == Float.TYPE) {
                stringBuilder.append('F');
                return stringBuilder;
            } else if (object == Double.TYPE) {
                stringBuilder.append('D');
                return stringBuilder;
            } else {
                if (object != Void.TYPE) throw new IllegalStateException("Unrecognized primitive type: " + ((Class)object).getName());
                stringBuilder.append('V');
            }
            return stringBuilder;
        } else {
            stringBuilder.append('L');
            object = ((Class)object).getName();
            int n2 = ((String)object).length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = ((String)object).charAt(i2);
                if (c2 == '.') {
                    c2 = '/';
                }
                stringBuilder.append(c2);
            }
            if (!bl2) return stringBuilder;
            stringBuilder.append(';');
        }
        return stringBuilder;
    }

    protected static JavaType _bogusSuperClass(Class<?> clazz) {
        if ((clazz = clazz.getSuperclass()) == null) {
            return null;
        }
        return TypeFactory.unknownType();
    }

    protected boolean _hasNTypeParameters(int n2) {
        TypeVariable<Class<?>>[] typeVariableArray = this._class.getTypeParameters();
        return typeVariableArray.length == n2;
    }
}

