/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;
    protected final boolean _isIgnoreCase;
    protected final boolean _isFromIntValue;

    protected EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_, boolean bl2, boolean bl3) {
        this._enumClass = clazz;
        this._enums = enumArray;
        this._enumsById = hashMap;
        this._defaultValue = enum_;
        this._isIgnoreCase = bl2;
        this._isFromIntValue = bl3;
    }

    public static EnumResolver constructFor(DeserializationConfig serializable, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = ((MapperConfig)serializable).getAnnotationIntrospector();
        boolean bl2 = ((MapperConfig)serializable).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Enum<?>[] enumArray = ((Annotated)annotatedClass).getRawType();
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        String[] stringArray = annotationIntrospector.findEnumValues((MapperConfig<?>)serializable, annotatedClass, enumArray, new String[enumArray.length]);
        String[][] stringArray2 = new String[stringArray.length][];
        annotationIntrospector.findEnumAliases((MapperConfig<?>)serializable, annotatedClass, enumArray, stringArray2);
        serializable = new HashMap();
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String[] stringArray3 = stringArray[i2];
            if (stringArray3 == null) {
                stringArray3 = enum_.name();
            }
            ((HashMap)serializable).put(stringArray3, enum_);
            stringArray3 = stringArray2[i2];
            if (stringArray3 == null) continue;
            for (String string : stringArray3) {
                ((HashMap)serializable).putIfAbsent(string, enum_);
            }
        }
        return new EnumResolver(clazz, enumArray, (HashMap<String, Enum<?>>)serializable, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructFor(DeserializationConfig deserializationConfig, Class<?> enumArray) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        String[] stringArray = annotationIntrospector.findEnumValues(clazz, enumArray, new String[enumArray.length]);
        String[][] stringArray2 = new String[stringArray.length][];
        annotationIntrospector.findEnumAliases(clazz, enumArray, stringArray2);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String[] stringArray3 = stringArray[i2];
            if (stringArray3 == null) {
                stringArray3 = enum_.name();
            }
            hashMap.put((String)stringArray3, enum_);
            stringArray3 = stringArray2[i2];
            if (stringArray3 == null) continue;
            for (String string : stringArray3) {
                hashMap.putIfAbsent(string, enum_);
            }
        }
        return new EnumResolver(clazz, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz), bl2, false);
    }

    public static EnumResolver constructUsingToString(DeserializationConfig serializable, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = ((MapperConfig)serializable).getAnnotationIntrospector();
        boolean bl2 = ((MapperConfig)serializable).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Enum<?>[] enumArray = ((Annotated)annotatedClass).getRawType();
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        String[] stringArray = new String[enumArray.length];
        String[][] stringArray2 = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues((MapperConfig<?>)serializable, annotatedClass, enumArray, stringArray);
            annotationIntrospector.findEnumAliases((MapperConfig<?>)serializable, annotatedClass, enumArray, stringArray2);
        }
        serializable = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            String[] stringArray3 = stringArray[n2];
            if (stringArray3 == null) {
                stringArray3 = enum_.toString();
            }
            ((HashMap)serializable).put(stringArray3, enum_);
            stringArray3 = stringArray2[n2];
            if (stringArray3 == null) continue;
            for (String string : stringArray3) {
                ((HashMap)serializable).putIfAbsent(string, enum_);
            }
        }
        return new EnumResolver(clazz, enumArray, (HashMap<String, Enum<?>>)serializable, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructUsingToString(DeserializationConfig deserializationConfig, Class<?> enumArray) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        HashMap hashMap = new HashMap();
        String[][] stringArray = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumAliases(clazz, enumArray, stringArray);
        }
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap.put(enum_.toString(), enum_);
            String[] stringArray2 = stringArray[n2];
            if (stringArray2 == null) continue;
            for (String string : stringArray2) {
                hashMap.putIfAbsent(string, enum_);
            }
        }
        return new EnumResolver(clazz, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz), bl2, false);
    }

    public static EnumResolver constructUsingIndex(DeserializationConfig deserializationConfig, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Enum<?>[] enumArray = ((Annotated)annotatedClass).getRawType();
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap.put(String.valueOf(n2), enum_);
        }
        return new EnumResolver(clazz, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructUsingIndex(DeserializationConfig deserializationConfig, Class<Enum<?>> enumArray) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap.put(String.valueOf(n2), enum_);
        }
        return new EnumResolver(clazz, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructUsingEnumNamingStrategy(DeserializationConfig deserializationConfig, Class<?> enumArray, EnumNamingStrategy enumNamingStrategy) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        HashMap hashMap = new HashMap();
        String[] stringArray = new String[enumArray.length];
        String[][] stringArray2 = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(clazz, enumArray, stringArray);
            annotationIntrospector.findEnumAliases(clazz, enumArray, stringArray2);
        }
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            String[] stringArray3 = stringArray[n2];
            if (stringArray3 == null) {
                stringArray3 = enumNamingStrategy.convertEnumToExternalName(enum_.name());
            }
            hashMap.put((String)stringArray3, enum_);
            stringArray3 = stringArray2[n2];
            if (stringArray3 == null) continue;
            for (String string : stringArray3) {
                hashMap.putIfAbsent(string, enum_);
            }
        }
        return new EnumResolver(clazz, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz), bl2, false);
    }

    public static EnumResolver constructUsingEnumNamingStrategy(DeserializationConfig serializable, AnnotatedClass annotatedClass, EnumNamingStrategy enumNamingStrategy) {
        AnnotationIntrospector annotationIntrospector = ((MapperConfig)serializable).getAnnotationIntrospector();
        boolean bl2 = ((MapperConfig)serializable).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Enum<?>[] enumArray = ((Annotated)annotatedClass).getRawType();
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        String[] stringArray = new String[enumArray.length];
        String[][] stringArray2 = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues((MapperConfig<?>)serializable, annotatedClass, enumArray, stringArray);
            annotationIntrospector.findEnumAliases((MapperConfig<?>)serializable, annotatedClass, enumArray, stringArray2);
        }
        serializable = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            String[] stringArray3 = stringArray[n2];
            if (stringArray3 == null) {
                stringArray3 = enumNamingStrategy.convertEnumToExternalName(enum_.name());
            }
            ((HashMap)serializable).put(stringArray3, enum_);
            stringArray3 = stringArray2[n2];
            if (stringArray3 == null) continue;
            for (String string : stringArray3) {
                ((HashMap)serializable).putIfAbsent(string, enum_);
            }
        }
        return new EnumResolver(clazz, enumArray, (HashMap<String, Enum<?>>)serializable, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructUsingMethod(DeserializationConfig deserializationConfig, Class<?> enumArray, AnnotatedMember annotatedMember) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            try {
                Object object = annotatedMember.getValue(enum_);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        return new EnumResolver(clazz, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz), bl2, EnumResolver._isIntType(annotatedMember.getRawType()));
    }

    public static EnumResolver constructUsingMethod(DeserializationConfig deserializationConfig, AnnotatedClass annotatedClass, AnnotatedMember annotatedMember) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Enum<?>[] enumArray = ((Annotated)annotatedClass).getRawType();
        Class<Enum<?>> clazz = EnumResolver._enumClass(enumArray);
        enumArray = EnumResolver._enumConstants(enumArray);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            try {
                Object object = annotatedMember.getValue(enum_);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        return new EnumResolver(clazz, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, EnumResolver._isIntType(annotatedMember.getRawType()));
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> clazz) {
        return clazz;
    }

    protected static Enum<?>[] _enumConstants(Class<?> clazz) {
        Enum<?>[] enumArray = EnumResolver._enumClass(clazz).getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        return enumArray;
    }

    protected static Enum<?> _enumDefault(AnnotationIntrospector annotationIntrospector, AnnotatedClass annotatedClass, Enum<?>[] enumArray) {
        if (annotationIntrospector != null) {
            return annotationIntrospector.findDefaultEnumValue(annotatedClass, enumArray);
        }
        return null;
    }

    @Deprecated
    protected static Enum<?> _enumDefault(AnnotationIntrospector annotationIntrospector, Class<?> clazz) {
        if (annotationIntrospector != null) {
            return annotationIntrospector.findDefaultEnumValue(EnumResolver._enumClass(clazz));
        }
        return null;
    }

    protected static boolean _isIntType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        return clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class;
    }

    public Enum<?> findEnum(String string) {
        Enum<?> enum_ = this._enumsById.get(string);
        if (enum_ == null && this._isIgnoreCase) {
            return this._findEnumCaseInsensitive(string);
        }
        return enum_;
    }

    protected Enum<?> _findEnumCaseInsensitive(String string) {
        for (Map.Entry<String, Enum<?>> entry : this._enumsById.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Enum<?> getEnum(int n2) {
        if (n2 < 0 || n2 >= this._enums.length) {
            return null;
        }
        return this._enums[n2];
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public List<Enum<?>> getEnums() {
        ArrayList arrayList = new ArrayList(this._enums.length);
        Enum<?>[] enumArray = this._enums;
        int n2 = this._enums.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            arrayList.add(enum_);
        }
        return arrayList;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }

    public boolean isFromIntValue() {
        return this._isFromIntValue;
    }
}

