/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.FormattingStyle;
import com.google.gson.Gson$1;
import com.google.gson.Gson$2;
import com.google.gson.Gson$3;
import com.google.gson.Gson$4;
import com.google.gson.Gson$5;
import com.google.gson.Gson$FutureTypeAdapter;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonSyntaxException;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.Strictness;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.ArrayTypeAdapter;
import com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.internal.bind.DefaultDateTypeAdapter;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.NumberTypeAdapter;
import com.google.gson.internal.bind.ObjectTypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.sql.SqlTypesSupport;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class Gson {
    public static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    public static final Strictness DEFAULT_STRICTNESS = null;
    public static final FormattingStyle DEFAULT_FORMATTING_STYLE = FormattingStyle.COMPACT;
    public static final boolean DEFAULT_ESCAPE_HTML = true;
    public static final boolean DEFAULT_SERIALIZE_NULLS = false;
    public static final boolean DEFAULT_COMPLEX_MAP_KEYS = false;
    public static final boolean DEFAULT_SPECIALIZE_FLOAT_VALUES = false;
    public static final boolean DEFAULT_USE_JDK_UNSAFE = true;
    public static final String DEFAULT_DATE_PATTERN = null;
    public static final FieldNamingStrategy DEFAULT_FIELD_NAMING_STRATEGY = FieldNamingPolicy.IDENTITY;
    public static final ToNumberStrategy DEFAULT_OBJECT_TO_NUMBER_STRATEGY = ToNumberPolicy.DOUBLE;
    public static final ToNumberStrategy DEFAULT_NUMBER_TO_NUMBER_STRATEGY = ToNumberPolicy.LAZILY_PARSED_NUMBER;
    public static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    public final ThreadLocal<Map<TypeToken<?>, TypeAdapter<?>>> threadLocalAdapterResults = new ThreadLocal();
    public final ConcurrentMap<TypeToken<?>, TypeAdapter<?>> typeTokenCache = new ConcurrentHashMap();
    public final ConstructorConstructor constructorConstructor;
    public final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    public final List<TypeAdapterFactory> factories;
    public final Excluder excluder;
    public final FieldNamingStrategy fieldNamingStrategy;
    public final Map<Type, InstanceCreator<?>> instanceCreators;
    public final boolean serializeNulls;
    public final boolean complexMapKeySerialization;
    public final boolean generateNonExecutableJson;
    public final boolean htmlSafe;
    public final FormattingStyle formattingStyle;
    public final Strictness strictness;
    public final boolean serializeSpecialFloatingPointValues;
    public final boolean useJdkUnsafe;
    public final String datePattern;
    public final int dateStyle;
    public final int timeStyle;
    public final LongSerializationPolicy longSerializationPolicy;
    public final List<TypeAdapterFactory> builderFactories;
    public final List<TypeAdapterFactory> builderHierarchyFactories;
    public final ToNumberStrategy objectToNumberStrategy;
    public final ToNumberStrategy numberToNumberStrategy;
    public final List<ReflectionAccessFilter> reflectionFilters;

    public Gson() {
        this(Excluder.DEFAULT, DEFAULT_FIELD_NAMING_STRATEGY, Collections.emptyMap(), false, false, false, true, DEFAULT_FORMATTING_STYLE, DEFAULT_STRICTNESS, false, true, LongSerializationPolicy.DEFAULT, DEFAULT_DATE_PATTERN, 2, 2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), DEFAULT_OBJECT_TO_NUMBER_STRATEGY, DEFAULT_NUMBER_TO_NUMBER_STRATEGY, Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map<Type, InstanceCreator<?>> object, boolean bl2, boolean bl3, boolean bl4, boolean bl5, FormattingStyle formattingStyle, Strictness strictness, boolean bl6, boolean bl7, LongSerializationPolicy longSerializationPolicy, String string, int n2, int n3, List<TypeAdapterFactory> list, List<TypeAdapterFactory> list2, List<TypeAdapterFactory> list3, ToNumberStrategy toNumberStrategy, ToNumberStrategy toNumberStrategy2, List<ReflectionAccessFilter> list4) {
        this.excluder = excluder;
        this.fieldNamingStrategy = fieldNamingStrategy;
        this.instanceCreators = object;
        this.constructorConstructor = new ConstructorConstructor((Map<Type, InstanceCreator<?>>)object, bl7, list4);
        this.serializeNulls = bl2;
        this.complexMapKeySerialization = bl3;
        this.generateNonExecutableJson = bl4;
        this.htmlSafe = bl5;
        this.formattingStyle = formattingStyle;
        this.strictness = strictness;
        this.serializeSpecialFloatingPointValues = bl6;
        this.useJdkUnsafe = bl7;
        this.longSerializationPolicy = longSerializationPolicy;
        this.datePattern = string;
        this.dateStyle = n2;
        this.timeStyle = n3;
        this.builderFactories = list;
        this.builderHierarchyFactories = list2;
        this.objectToNumberStrategy = toNumberStrategy;
        this.numberToNumberStrategy = toNumberStrategy2;
        this.reflectionFilters = list4;
        object = new ArrayList<TypeAdapterFactory>();
        object.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        object.add(ObjectTypeAdapter.getFactory(toNumberStrategy));
        object.add(excluder);
        object.addAll(list3);
        object.add(TypeAdapters.STRING_FACTORY);
        object.add(TypeAdapters.INTEGER_FACTORY);
        object.add(TypeAdapters.BOOLEAN_FACTORY);
        object.add(TypeAdapters.BYTE_FACTORY);
        object.add(TypeAdapters.SHORT_FACTORY);
        TypeAdapter<Number> typeAdapter = Gson.longAdapter(longSerializationPolicy);
        object.add(TypeAdapters.newFactory(Long.TYPE, Long.class, typeAdapter));
        object.add(TypeAdapters.newFactory(Double.TYPE, Double.class, this.doubleAdapter(bl6)));
        object.add(TypeAdapters.newFactory(Float.TYPE, Float.class, this.floatAdapter(bl6)));
        object.add(NumberTypeAdapter.getFactory(toNumberStrategy2));
        object.add(TypeAdapters.ATOMIC_INTEGER_FACTORY);
        object.add(TypeAdapters.ATOMIC_BOOLEAN_FACTORY);
        object.add(TypeAdapters.newFactory(AtomicLong.class, Gson.atomicLongAdapter(typeAdapter)));
        object.add(TypeAdapters.newFactory(AtomicLongArray.class, Gson.atomicLongArrayAdapter(typeAdapter)));
        object.add(TypeAdapters.ATOMIC_INTEGER_ARRAY_FACTORY);
        object.add(TypeAdapters.CHARACTER_FACTORY);
        object.add(TypeAdapters.STRING_BUILDER_FACTORY);
        object.add(TypeAdapters.STRING_BUFFER_FACTORY);
        object.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        object.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        object.add(TypeAdapters.newFactory(LazilyParsedNumber.class, TypeAdapters.LAZILY_PARSED_NUMBER));
        object.add(TypeAdapters.URL_FACTORY);
        object.add(TypeAdapters.URI_FACTORY);
        object.add(TypeAdapters.UUID_FACTORY);
        object.add(TypeAdapters.CURRENCY_FACTORY);
        object.add(TypeAdapters.LOCALE_FACTORY);
        object.add(TypeAdapters.INET_ADDRESS_FACTORY);
        object.add(TypeAdapters.BIT_SET_FACTORY);
        object.add(DefaultDateTypeAdapter.DEFAULT_STYLE_FACTORY);
        object.add(TypeAdapters.CALENDAR_FACTORY);
        if (SqlTypesSupport.SUPPORTS_SQL_TYPES) {
            object.add(SqlTypesSupport.TIME_FACTORY);
            object.add(SqlTypesSupport.DATE_FACTORY);
            object.add(SqlTypesSupport.TIMESTAMP_FACTORY);
        }
        object.add(ArrayTypeAdapter.FACTORY);
        object.add(TypeAdapters.CLASS_FACTORY);
        object.add(new CollectionTypeAdapterFactory(this.constructorConstructor));
        object.add(new MapTypeAdapterFactory(this.constructorConstructor, bl3));
        this.jsonAdapterFactory = new JsonAdapterAnnotationTypeAdapterFactory(this.constructorConstructor);
        object.add(this.jsonAdapterFactory);
        object.add(TypeAdapters.ENUM_FACTORY);
        object.add(new ReflectiveTypeAdapterFactory(this.constructorConstructor, fieldNamingStrategy, excluder, this.jsonAdapterFactory, list4));
        this.factories = Collections.unmodifiableList(object);
    }

    public GsonBuilder newBuilder() {
        return new GsonBuilder(this);
    }

    @Deprecated
    public Excluder excluder() {
        return this.excluder;
    }

    public FieldNamingStrategy fieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public boolean serializeNulls() {
        return this.serializeNulls;
    }

    public boolean htmlSafe() {
        return this.htmlSafe;
    }

    private TypeAdapter<Number> doubleAdapter(boolean bl2) {
        if (bl2) {
            return TypeAdapters.DOUBLE;
        }
        return new Gson$1(this);
    }

    private TypeAdapter<Number> floatAdapter(boolean bl2) {
        if (bl2) {
            return TypeAdapters.FLOAT;
        }
        return new Gson$2(this);
    }

    static void checkValidFloatingPoint(double d2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(d2 + " is not a valid double value as per JSON specification. To override this behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
        }
    }

    private static TypeAdapter<Number> longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.LONG;
        }
        return new Gson$3();
    }

    private static TypeAdapter<AtomicLong> atomicLongAdapter(TypeAdapter<Number> typeAdapter) {
        return new Gson$4(typeAdapter).nullSafe();
    }

    private static TypeAdapter<AtomicLongArray> atomicLongArrayAdapter(TypeAdapter<Number> typeAdapter) {
        return new Gson$5(typeAdapter).nullSafe();
    }

    /*
     * WARNING - void declaration
     */
    public <T> TypeAdapter<T> getAdapter(TypeToken<T> typeToken) {
        void var4_7;
        Objects.requireNonNull(typeToken, "type must not be null");
        HashMap<TypeToken<T>, TypeAdapter<T>> hashMap = (TypeAdapter)this.typeTokenCache.get(typeToken);
        if (hashMap != null) {
            return hashMap;
        }
        hashMap = this.threadLocalAdapterResults.get();
        boolean bl2 = false;
        if (hashMap == null) {
            hashMap = new HashMap<TypeToken<T>, TypeAdapter<T>>();
            this.threadLocalAdapterResults.set(hashMap);
            bl2 = true;
        } else {
            TypeAdapter typeAdapter2 = (TypeAdapter)hashMap.get(typeToken);
            if (typeAdapter2 != null) {
                return typeAdapter2;
            }
        }
        Object var4_6 = null;
        try {
            Gson$FutureTypeAdapter<T> gson$FutureTypeAdapter = new Gson$FutureTypeAdapter<T>();
            hashMap.put(typeToken, gson$FutureTypeAdapter);
            for (TypeAdapterFactory typeAdapterFactory : this.factories) {
                TypeAdapter<T> typeAdapter = typeAdapterFactory.create(this, typeToken);
                if (typeAdapter == null) continue;
                gson$FutureTypeAdapter.setDelegate(typeAdapter);
                hashMap.put(typeToken, typeAdapter);
                break;
            }
        }
        finally {
            if (bl2) {
                this.threadLocalAdapterResults.remove();
            }
        }
        if (var4_7 == null) {
            throw new IllegalArgumentException("GSON (2.13.2) cannot handle " + typeToken);
        }
        if (bl2) {
            this.typeTokenCache.putAll(hashMap);
        }
        return var4_7;
    }

    public <T> TypeAdapter<T> getAdapter(Class<T> clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory typeAdapterFactory, TypeToken<T> typeToken) {
        Objects.requireNonNull(typeAdapterFactory, "skipPast must not be null");
        Objects.requireNonNull(typeToken, "type must not be null");
        if (this.jsonAdapterFactory.isClassJsonAdapterFactory(typeToken, typeAdapterFactory)) {
            typeAdapterFactory = this.jsonAdapterFactory;
        }
        boolean bl2 = false;
        for (TypeAdapterFactory typeAdapterFactory2 : this.factories) {
            if (!bl2) {
                if (typeAdapterFactory2 != typeAdapterFactory) continue;
                bl2 = true;
                continue;
            }
            TypeAdapter<T> typeAdapter = typeAdapterFactory2.create(this, typeToken);
            if (typeAdapter == null) continue;
            return typeAdapter;
        }
        if (bl2) {
            throw new IllegalArgumentException("GSON cannot serialize or deserialize " + typeToken);
        }
        return this.getAdapter(typeToken);
    }

    public JsonElement toJsonTree(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        Object object2 = object;
        return this.toJsonTree(object2, object2.getClass());
    }

    public JsonElement toJsonTree(Object object, Type type) {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        this.toJson(object, type, jsonTreeWriter);
        return jsonTreeWriter.get();
    }

    public String toJson(Object object) {
        if (object == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        Object object2 = object;
        return this.toJson(object2, object2.getClass());
    }

    public String toJson(Object object, Type type) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toJson(object, type, stringBuilder);
        return stringBuilder.toString();
    }

    public void toJson(Object object, Appendable appendable) throws JsonIOException {
        if (object != null) {
            Object object2 = object;
            this.toJson(object2, object2.getClass(), appendable);
            return;
        }
        this.toJson((JsonElement)JsonNull.INSTANCE, appendable);
    }

    public void toJson(Object object, Type type, Appendable object2) throws JsonIOException {
        try {
            object2 = this.newJsonWriter(Streams.writerForAppendable((Appendable)object2));
            this.toJson(object, type, (JsonWriter)object2);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public void toJson(Object object, Type object2, JsonWriter jsonWriter) throws JsonIOException {
        object2 = this.getAdapter(TypeToken.get((Type)object2));
        Strictness strictness = jsonWriter.getStrictness();
        if (this.strictness != null) {
            jsonWriter.setStrictness(this.strictness);
        } else if (jsonWriter.getStrictness() == Strictness.LEGACY_STRICT) {
            jsonWriter.setStrictness(Strictness.LENIENT);
        }
        boolean bl2 = jsonWriter.isHtmlSafe();
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            ((TypeAdapter)object2).write(jsonWriter, object);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (AssertionError assertionError) {
            throw new AssertionError("AssertionError (GSON 2.13.2): " + ((Throwable)((Object)assertionError)).getMessage(), (Throwable)((Object)assertionError));
        }
        finally {
            jsonWriter.setStrictness(strictness);
            jsonWriter.setHtmlSafe(bl2);
            jsonWriter.setSerializeNulls(bl3);
        }
    }

    public String toJson(JsonElement jsonElement) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toJson(jsonElement, (Appendable)stringBuilder);
        return stringBuilder.toString();
    }

    public void toJson(JsonElement jsonElement, Appendable object) throws JsonIOException {
        try {
            object = this.newJsonWriter(Streams.writerForAppendable((Appendable)object));
            this.toJson(jsonElement, (JsonWriter)object);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public void toJson(JsonElement jsonElement, JsonWriter jsonWriter) throws JsonIOException {
        Strictness strictness = jsonWriter.getStrictness();
        boolean bl2 = jsonWriter.isHtmlSafe();
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        jsonWriter.setSerializeNulls(this.serializeNulls);
        if (this.strictness != null) {
            jsonWriter.setStrictness(this.strictness);
        } else if (jsonWriter.getStrictness() == Strictness.LEGACY_STRICT) {
            jsonWriter.setStrictness(Strictness.LENIENT);
        }
        try {
            Streams.write(jsonElement, jsonWriter);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (AssertionError assertionError) {
            throw new AssertionError("AssertionError (GSON 2.13.2): " + ((Throwable)((Object)assertionError)).getMessage(), (Throwable)((Object)assertionError));
        }
        finally {
            jsonWriter.setStrictness(strictness);
            jsonWriter.setHtmlSafe(bl2);
            jsonWriter.setSerializeNulls(bl3);
        }
    }

    public JsonWriter newJsonWriter(Writer closeable) throws IOException {
        if (this.generateNonExecutableJson) {
            ((Writer)closeable).write(JSON_NON_EXECUTABLE_PREFIX);
        }
        closeable = new JsonWriter((Writer)closeable);
        ((JsonWriter)closeable).setFormattingStyle(this.formattingStyle);
        ((JsonWriter)closeable).setHtmlSafe(this.htmlSafe);
        ((JsonWriter)closeable).setStrictness(this.strictness == null ? Strictness.LEGACY_STRICT : this.strictness);
        ((JsonWriter)closeable).setSerializeNulls(this.serializeNulls);
        return closeable;
    }

    public JsonReader newJsonReader(Reader closeable) {
        closeable = new JsonReader((Reader)closeable);
        ((JsonReader)closeable).setStrictness(this.strictness == null ? Strictness.LEGACY_STRICT : this.strictness);
        return closeable;
    }

    public <T> T fromJson(String string, Class<T> clazz) throws JsonSyntaxException {
        return this.fromJson(string, TypeToken.get(clazz));
    }

    public <T> T fromJson(String string, Type type) throws JsonSyntaxException {
        return (T)this.fromJson(string, TypeToken.get(type));
    }

    public <T> T fromJson(String object, TypeToken<T> typeToken) throws JsonSyntaxException {
        if (object == null) {
            return null;
        }
        object = new StringReader((String)object);
        return this.fromJson((Reader)object, typeToken);
    }

    public <T> T fromJson(Reader reader, Class<T> clazz) throws JsonSyntaxException, JsonIOException {
        return this.fromJson(reader, TypeToken.get(clazz));
    }

    public <T> T fromJson(Reader reader, Type type) throws JsonIOException, JsonSyntaxException {
        return (T)this.fromJson(reader, TypeToken.get(type));
    }

    public <T> T fromJson(Reader closeable, TypeToken<T> typeToken) throws JsonIOException, JsonSyntaxException {
        closeable = this.newJsonReader((Reader)closeable);
        typeToken = this.fromJson((JsonReader)closeable, typeToken);
        Gson.assertFullConsumption(typeToken, (JsonReader)closeable);
        return (T)typeToken;
    }

    public <T> T fromJson(JsonReader jsonReader, Type type) throws JsonIOException, JsonSyntaxException {
        return (T)this.fromJson(jsonReader, TypeToken.get(type));
    }

    public <T> T fromJson(JsonReader jsonReader, TypeToken<T> typeToken) throws JsonIOException, JsonSyntaxException {
        boolean bl2 = true;
        Strictness strictness = jsonReader.getStrictness();
        if (this.strictness != null) {
            jsonReader.setStrictness(this.strictness);
        } else if (jsonReader.getStrictness() == Strictness.LEGACY_STRICT) {
            jsonReader.setStrictness(Strictness.LENIENT);
        }
        try {
            jsonReader.peek();
            bl2 = false;
            TypeAdapter<T> typeAdapter = this.getAdapter(typeToken);
            T t2 = typeAdapter.read(jsonReader);
            Class<T> clazz = Primitives.wrap(typeToken.getRawType());
            if (t2 != null && !clazz.isInstance(t2)) {
                throw new ClassCastException("Type adapter '" + typeAdapter + "' returned wrong type; requested " + typeToken.getRawType() + " but got instance of " + t2.getClass() + "\nVerify that the adapter was registered for the correct type.");
            }
            typeToken = t2;
            return (T)typeToken;
        }
        catch (EOFException eOFException) {
            if (bl2) {
                return null;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonSyntaxException(illegalStateException);
        }
        catch (IOException iOException) {
            throw new JsonSyntaxException(iOException);
        }
        catch (AssertionError assertionError) {
            throw new AssertionError("AssertionError (GSON 2.13.2): " + ((Throwable)((Object)assertionError)).getMessage(), (Throwable)((Object)assertionError));
        }
        finally {
            jsonReader.setStrictness(strictness);
        }
    }

    public <T> T fromJson(JsonElement jsonElement, Class<T> clazz) throws JsonSyntaxException {
        return this.fromJson(jsonElement, TypeToken.get(clazz));
    }

    public <T> T fromJson(JsonElement jsonElement, Type type) throws JsonSyntaxException {
        return (T)this.fromJson(jsonElement, TypeToken.get(type));
    }

    public <T> T fromJson(JsonElement jsonElement, TypeToken<T> typeToken) throws JsonSyntaxException {
        if (jsonElement == null) {
            return null;
        }
        return this.fromJson((JsonReader)new JsonTreeReader(jsonElement), typeToken);
    }

    private static void assertFullConsumption(Object object, JsonReader jsonReader) {
        try {
            if (object != null && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("JSON document was not fully consumed.");
            }
            return;
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public String toString() {
        return "{serializeNulls:" + this.serializeNulls + ",factories:" + this.factories + ",instanceCreators:" + this.constructorConstructor + "}";
    }
}

