/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonParseException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;

final class ToNumberPolicy$3
extends ToNumberPolicy {
    @Override
    public final Number readNumber(JsonReader jsonReader) throws IOException, JsonParseException {
        String string = jsonReader.nextString();
        if (string.indexOf(46) >= 0) {
            return this.parseAsDouble(string, jsonReader);
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return this.parseAsDouble(string, jsonReader);
        }
    }

    private Number parseAsDouble(String string, JsonReader jsonReader) throws IOException {
        try {
            Double d2 = Double.valueOf(string);
            if ((d2.isInfinite() || d2.isNaN()) && !jsonReader.isLenient()) {
                throw new MalformedJsonException("JSON forbids NaN and infinities: " + d2 + "; at path " + jsonReader.getPreviousPath());
            }
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException("Cannot parse " + string + "; at path " + jsonReader.getPreviousPath(), numberFormatException);
        }
    }
}

