/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.TypeAdapter;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;

final class CollectionTypeAdapterFactory$Adapter<E>
extends TypeAdapter<Collection<E>> {
    private final TypeAdapter<E> elementTypeAdapter;
    private final ObjectConstructor<? extends Collection<E>> constructor;

    CollectionTypeAdapterFactory$Adapter(TypeAdapter<E> typeAdapter, ObjectConstructor<? extends Collection<E>> objectConstructor) {
        this.elementTypeAdapter = typeAdapter;
        this.constructor = objectConstructor;
    }

    @Override
    public final Collection<E> read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        Collection<E> collection = this.constructor.construct();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            E e2 = this.elementTypeAdapter.read(jsonReader);
            collection.add(e2);
        }
        jsonReader.endArray();
        return collection;
    }

    @Override
    public final void write(JsonWriter jsonWriter, Collection<E> object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginArray();
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            this.elementTypeAdapter.write(jsonWriter, e2);
        }
        jsonWriter.endArray();
    }
}

