/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory$DummyTypeAdapterFactory;
import com.google.gson.internal.bind.TreeTypeAdapter;
import com.google.gson.reflect.TypeToken;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private static final TypeAdapterFactory TREE_TYPE_CLASS_DUMMY_FACTORY = new JsonAdapterAnnotationTypeAdapterFactory$DummyTypeAdapterFactory(null);
    private static final TypeAdapterFactory TREE_TYPE_FIELD_DUMMY_FACTORY = new JsonAdapterAnnotationTypeAdapterFactory$DummyTypeAdapterFactory(null);
    private final ConstructorConstructor constructorConstructor;
    private final ConcurrentMap<Class<?>, TypeAdapterFactory> adapterFactoryMap;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
        this.adapterFactoryMap = new ConcurrentHashMap();
    }

    private static JsonAdapter getAnnotation(Class<?> clazz) {
        return clazz.getAnnotation(JsonAdapter.class);
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Object object = typeToken.getRawType();
        if ((object = JsonAdapterAnnotationTypeAdapterFactory.getAnnotation(object)) == null) {
            return null;
        }
        JsonAdapterAnnotationTypeAdapterFactory jsonAdapterAnnotationTypeAdapterFactory = this;
        return jsonAdapterAnnotationTypeAdapterFactory.getTypeAdapter(jsonAdapterAnnotationTypeAdapterFactory.constructorConstructor, gson, typeToken, (JsonAdapter)object, true);
    }

    private static Object createAdapter(ConstructorConstructor constructorConstructor, Class<?> clazz) {
        return constructorConstructor.get(TypeToken.get(clazz), true).construct();
    }

    private TypeAdapterFactory putFactoryAndGetCurrent(Class<?> object, TypeAdapterFactory typeAdapterFactory) {
        if ((object = this.adapterFactoryMap.putIfAbsent((Class<?>)object, typeAdapterFactory)) != null) {
            return object;
        }
        return typeAdapterFactory;
    }

    final TypeAdapter<?> getTypeAdapter(ConstructorConstructor treeTypeAdapter, Gson gson, TypeToken<?> typeToken, JsonAdapter jsonAdapter, boolean bl2) {
        treeTypeAdapter = JsonAdapterAnnotationTypeAdapterFactory.createAdapter((ConstructorConstructor)((Object)treeTypeAdapter), jsonAdapter.value());
        boolean bl3 = jsonAdapter.nullSafe();
        if (treeTypeAdapter instanceof TypeAdapter) {
            treeTypeAdapter = treeTypeAdapter;
        } else if (treeTypeAdapter instanceof TypeAdapterFactory) {
            TypeAdapterFactory typeAdapterFactory = (TypeAdapterFactory)((Object)treeTypeAdapter);
            if (bl2) {
                typeAdapterFactory = this.putFactoryAndGetCurrent(typeToken.getRawType(), typeAdapterFactory);
            }
            treeTypeAdapter = typeAdapterFactory.create(gson, typeToken);
        } else if (treeTypeAdapter instanceof JsonSerializer || treeTypeAdapter instanceof JsonDeserializer) {
            JsonSerializer jsonSerializer = treeTypeAdapter instanceof JsonSerializer ? (JsonSerializer)((Object)treeTypeAdapter) : null;
            treeTypeAdapter = treeTypeAdapter instanceof JsonDeserializer ? (JsonDeserializer)((Object)treeTypeAdapter) : null;
            TypeAdapterFactory typeAdapterFactory = bl2 ? TREE_TYPE_CLASS_DUMMY_FACTORY : TREE_TYPE_FIELD_DUMMY_FACTORY;
            treeTypeAdapter = new TreeTypeAdapter(jsonSerializer, (JsonDeserializer<?>)((Object)treeTypeAdapter), gson, typeToken, typeAdapterFactory, bl3);
            bl3 = false;
        } else {
            throw new IllegalArgumentException("Invalid attempt to bind an instance of " + treeTypeAdapter.getClass().getName() + " as a @JsonAdapter for " + typeToken.toString() + ". @JsonAdapter value must be a TypeAdapter, TypeAdapterFactory, JsonSerializer or JsonDeserializer.");
        }
        if (treeTypeAdapter != null && bl3) {
            treeTypeAdapter = treeTypeAdapter.nullSafe();
        }
        return treeTypeAdapter;
    }

    public final boolean isClassJsonAdapterFactory(TypeToken<?> object, TypeAdapterFactory typeAdapterFactory) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(typeAdapterFactory);
        if (typeAdapterFactory == TREE_TYPE_CLASS_DUMMY_FACTORY) {
            return true;
        }
        Object object2 = (TypeAdapterFactory)this.adapterFactoryMap.get(object = ((TypeToken)object).getRawType());
        if (object2 != null) {
            return object2 == typeAdapterFactory;
        }
        object2 = JsonAdapterAnnotationTypeAdapterFactory.getAnnotation(object);
        if (object2 == null) {
            return false;
        }
        if (!TypeAdapterFactory.class.isAssignableFrom((Class<?>)(object2 = object2.value()))) {
            return false;
        }
        object2 = JsonAdapterAnnotationTypeAdapterFactory.createAdapter(this.constructorConstructor, object2);
        return this.putFactoryAndGetCurrent((Class<?>)object, (TypeAdapterFactory)(object2 = (TypeAdapterFactory)object2)) == typeAdapterFactory;
    }
}

