/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;

class JsonElementTypeAdapter
extends TypeAdapter<JsonElement> {
    static final JsonElementTypeAdapter ADAPTER = new JsonElementTypeAdapter();

    private JsonElementTypeAdapter() {
    }

    private JsonElement tryBeginNesting(JsonReader jsonReader, JsonToken jsonToken) throws IOException {
        switch (jsonToken) {
            case BEGIN_ARRAY: {
                jsonReader.beginArray();
                return new JsonArray();
            }
            case BEGIN_OBJECT: {
                jsonReader.beginObject();
                return new JsonObject();
            }
        }
        return null;
    }

    private JsonElement readTerminal(JsonReader object, JsonToken jsonToken) throws IOException {
        switch (jsonToken) {
            case STRING: {
                return new JsonPrimitive(((JsonReader)object).nextString());
            }
            case NUMBER: {
                object = ((JsonReader)object).nextString();
                return new JsonPrimitive(new LazilyParsedNumber((String)object));
            }
            case BOOLEAN: {
                return new JsonPrimitive(((JsonReader)object).nextBoolean());
            }
            case NULL: {
                ((JsonReader)object).nextNull();
                return JsonNull.INSTANCE;
            }
        }
        throw new IllegalStateException("Unexpected token: " + (Object)((Object)jsonToken));
    }

    @Override
    public JsonElement read(JsonReader jsonReader) throws IOException {
        if (jsonReader instanceof JsonTreeReader) {
            return ((JsonTreeReader)jsonReader).nextJsonElement();
        }
        JsonToken jsonToken = jsonReader.peek();
        JsonElement jsonElement = this.tryBeginNesting(jsonReader, jsonToken);
        if (jsonElement == null) {
            return this.readTerminal(jsonReader, jsonToken);
        }
        ArrayDeque<JsonElement> arrayDeque = new ArrayDeque<JsonElement>();
        while (true) {
            if (jsonReader.hasNext()) {
                JsonElement jsonElement2;
                boolean bl2;
                String string = null;
                if (jsonElement instanceof JsonObject) {
                    string = jsonReader.nextName();
                }
                boolean bl3 = bl2 = (jsonElement2 = this.tryBeginNesting(jsonReader, jsonToken = jsonReader.peek())) != null;
                if (jsonElement2 == null) {
                    jsonElement2 = this.readTerminal(jsonReader, jsonToken);
                }
                if (jsonElement instanceof JsonArray) {
                    ((JsonArray)jsonElement).add(jsonElement2);
                } else {
                    ((JsonObject)jsonElement).add(string, jsonElement2);
                }
                if (!bl2) continue;
                arrayDeque.addLast(jsonElement);
                jsonElement = jsonElement2;
                continue;
            }
            if (jsonElement instanceof JsonArray) {
                jsonReader.endArray();
            } else {
                jsonReader.endObject();
            }
            if (arrayDeque.isEmpty()) {
                return jsonElement;
            }
            jsonElement = (JsonElement)arrayDeque.removeLast();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(JsonWriter jsonWriter, JsonElement iterator) throws IOException {
        if (iterator == null || ((JsonElement)((Object)iterator)).isJsonNull()) {
            jsonWriter.nullValue();
            return;
        }
        if (((JsonElement)((Object)iterator)).isJsonPrimitive()) {
            if (((JsonPrimitive)((Object)(iterator = ((JsonElement)((Object)iterator)).getAsJsonPrimitive()))).isNumber()) {
                jsonWriter.value(((JsonElement)((Object)iterator)).getAsNumber());
                return;
            }
            if (((JsonPrimitive)((Object)iterator)).isBoolean()) {
                jsonWriter.value(((JsonElement)((Object)iterator)).getAsBoolean());
                return;
            }
            jsonWriter.value(((JsonElement)((Object)iterator)).getAsString());
            return;
        }
        if (((JsonElement)((Object)iterator)).isJsonArray()) {
            jsonWriter.beginArray();
            iterator = ((JsonElement)((Object)iterator)).getAsJsonArray().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    jsonWriter.endArray();
                    return;
                }
                JsonElement jsonElement = iterator.next();
                this.write(jsonWriter, jsonElement);
            }
        }
        if (!((JsonElement)((Object)iterator)).isJsonObject()) throw new IllegalArgumentException("Couldn't write " + iterator.getClass());
        jsonWriter.beginObject();
        iterator = ((JsonElement)((Object)iterator)).getAsJsonObject().entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                jsonWriter.endObject();
                return;
            }
            Map.Entry entry = (Map.Entry)iterator.next();
            jsonWriter.name((String)entry.getKey());
            this.write(jsonWriter, (JsonElement)entry.getValue());
        }
    }
}

