/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.ReflectionAccessFilter$FilterResult;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.GsonTypes;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.ReflectionAccessFilterHelper;
import com.google.gson.internal.TroubleshootingGuide;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$1;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$2;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$BoundField;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$FieldReflectionAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$FieldsData;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$RecordAdapter;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    private final List<ReflectionAccessFilter> reflectionFilters;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterAnnotationTypeAdapterFactory, List<ReflectionAccessFilter> list) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
        this.jsonAdapterFactory = jsonAdapterAnnotationTypeAdapterFactory;
        this.reflectionFilters = list;
    }

    private boolean includeField(Field field, boolean bl2) {
        return !this.excluder.excludeField(field, bl2);
    }

    private List<String> getFieldNames(Field list) {
        String string;
        Object object = ((Field)((Object)list)).getAnnotation(SerializedName.class);
        if (object == null) {
            string = this.fieldNamingPolicy.translateName((Field)((Object)list));
            list = this.fieldNamingPolicy.alternateNames((Field)((Object)list));
        } else {
            string = object.value();
            list = Arrays.asList(object.alternate());
        }
        if (list.isEmpty()) {
            return Collections.singletonList(string);
        }
        object = new ArrayList<String>(list.size() + 1);
        object.add(string);
        object.addAll(list);
        return object;
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        boolean bl2;
        Class<T> clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (ReflectionHelper.isAnonymousOrNonStaticLocal(clazz)) {
            return new ReflectiveTypeAdapterFactory$1(this);
        }
        ReflectionAccessFilter$FilterResult reflectionAccessFilter$FilterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, clazz);
        if (reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_ALL) {
            throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + clazz + ". Register a TypeAdapter for this type or adjust the access filter.");
        }
        boolean bl3 = bl2 = reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_INACCESSIBLE;
        if (ReflectionHelper.isRecord(clazz)) {
            ReflectiveTypeAdapterFactory$RecordAdapter<T> reflectiveTypeAdapterFactory$RecordAdapter = new ReflectiveTypeAdapterFactory$RecordAdapter<T>(clazz, this.getBoundFields(gson, typeToken, clazz, bl2, true), bl2);
            return reflectiveTypeAdapterFactory$RecordAdapter;
        }
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken, true);
        return new ReflectiveTypeAdapterFactory$FieldReflectionAdapter<T>(objectConstructor, this.getBoundFields(gson, typeToken, clazz, bl2, false));
    }

    private static <M extends AccessibleObject> void checkAccessible(Object object, M m2) {
        M m3 = m2;
        if (!ReflectionAccessFilterHelper.canAccess(m3, Modifier.isStatic(((Member)((Object)m3)).getModifiers()) ? null : object)) {
            object = ReflectionHelper.getAccessibleObjectDescription(m2, true);
            throw new JsonIOException((String)object + " is not accessible and ReflectionAccessFilter does not permit making it accessible. Register a TypeAdapter for the declaring type, adjust the access filter or increase the visibility of the element and its declaring type.");
        }
    }

    private ReflectiveTypeAdapterFactory$BoundField createBoundField(Gson typeAdapterRuntimeTypeWrapper, Field field, Method method, String string, TypeToken<?> typeToken, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = Primitives.isPrimitive(typeToken.getRawType());
        int n2 = field.getModifiers();
        n2 = Modifier.isStatic(n2) && Modifier.isFinal(n2) ? 1 : 0;
        JsonAdapter jsonAdapter = field.getAnnotation(JsonAdapter.class);
        TypeAdapterRuntimeTypeWrapper typeAdapterRuntimeTypeWrapper2 = null;
        if (jsonAdapter != null) {
            typeAdapterRuntimeTypeWrapper2 = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, (Gson)((Object)typeAdapterRuntimeTypeWrapper), typeToken, jsonAdapter, false);
        }
        boolean bl6 = bl4 = typeAdapterRuntimeTypeWrapper2 != null;
        if (typeAdapterRuntimeTypeWrapper2 == null) {
            typeAdapterRuntimeTypeWrapper2 = ((Gson)((Object)typeAdapterRuntimeTypeWrapper)).getAdapter(typeToken);
        }
        typeAdapterRuntimeTypeWrapper = bl2 ? (bl4 ? typeAdapterRuntimeTypeWrapper2 : new TypeAdapterRuntimeTypeWrapper((Gson)((Object)typeAdapterRuntimeTypeWrapper), typeAdapterRuntimeTypeWrapper2, typeToken.getType())) : typeAdapterRuntimeTypeWrapper2;
        return new ReflectiveTypeAdapterFactory$2(this, string, field, bl3, method, typeAdapterRuntimeTypeWrapper, typeAdapterRuntimeTypeWrapper2, bl5, n2 != 0);
    }

    private static IllegalArgumentException createDuplicateFieldException(Class<?> clazz, String string, Field field, Field field2) {
        throw new IllegalArgumentException("Class " + clazz.getName() + " declares multiple JSON fields named '" + string + "'; conflict is caused by fields " + ReflectionHelper.fieldToString(field) + " and " + ReflectionHelper.fieldToString(field2) + "\nSee " + TroubleshootingGuide.createUrl("duplicate-fields"));
    }

    private ReflectiveTypeAdapterFactory$FieldsData getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz, boolean bl2, boolean bl3) {
        if (clazz.isInterface()) {
            return ReflectiveTypeAdapterFactory$FieldsData.EMPTY;
        }
        LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField> linkedHashMap = new LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField>();
        LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
        Class<?> clazz2 = clazz;
        while (clazz != Object.class) {
            Object object;
            Field[] fieldArray = clazz.getDeclaredFields();
            if (clazz != clazz2 && fieldArray.length > 0) {
                object = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, clazz);
                if (object == ReflectionAccessFilter$FilterResult.BLOCK_ALL) {
                    throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + clazz + " (supertype of " + clazz2 + "). Register a TypeAdapter for this type or adjust the access filter.");
                }
                bl2 = object == ReflectionAccessFilter$FilterResult.BLOCK_INACCESSIBLE;
            }
            object = fieldArray;
            int n2 = fieldArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField;
                Object object2;
                Field field = object[i2];
                boolean bl4 = this.includeField(field, true);
                boolean bl5 = this.includeField(field, false);
                if (!bl4 && !bl5) continue;
                Object object3 = null;
                if (bl3) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        bl5 = false;
                    } else {
                        object3 = ReflectionHelper.getAccessor(clazz, field);
                        if (!bl2) {
                            ReflectionHelper.makeAccessible((AccessibleObject)object3);
                        }
                        if (((Method)object3).getAnnotation(SerializedName.class) != null && field.getAnnotation(SerializedName.class) == null) {
                            object2 = ReflectionHelper.getAccessibleObjectDescription((AccessibleObject)object3, false);
                            throw new JsonIOException("@SerializedName on " + (String)object2 + " is not supported");
                        }
                    }
                }
                if (!bl2 && object3 == null) {
                    ReflectionHelper.makeAccessible(field);
                }
                object2 = GsonTypes.resolve(typeToken.getType(), clazz, field.getGenericType());
                Object object4 = this.getFieldNames(field);
                String string = object4.get(0);
                object3 = this.createBoundField(gson, field, (Method)object3, string, TypeToken.get((Type)object2), bl4, bl2);
                if (bl5) {
                    Iterator<String> iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        object4 = linkedHashMap.put((String)object2, (ReflectiveTypeAdapterFactory$BoundField)object3);
                        if (object4 == null) continue;
                        throw ReflectiveTypeAdapterFactory.createDuplicateFieldException(clazz2, (String)object2, ((ReflectiveTypeAdapterFactory$BoundField)object4).field, field);
                    }
                }
                if (!bl4 || (reflectiveTypeAdapterFactory$BoundField = (ReflectiveTypeAdapterFactory$BoundField)linkedHashMap2.put(string, object3)) == null) continue;
                throw ReflectiveTypeAdapterFactory.createDuplicateFieldException(clazz2, string, reflectiveTypeAdapterFactory$BoundField.field, field);
            }
            Class<?> clazz3 = clazz;
            typeToken = TypeToken.get(GsonTypes.resolve(typeToken.getType(), clazz3, clazz3.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return new ReflectiveTypeAdapterFactory$FieldsData(linkedHashMap, new ArrayList<ReflectiveTypeAdapterFactory$BoundField>(linkedHashMap2.values()));
    }

    static /* synthetic */ void access$000(Object object, AccessibleObject accessibleObject) {
        ReflectiveTypeAdapterFactory.checkAccessible(object, accessibleObject);
    }
}

