/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.NumberLimits;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

class TypeAdapters$16
extends TypeAdapter<BigDecimal> {
    TypeAdapters$16() {
    }

    @Override
    public BigDecimal read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        try {
            return NumberLimits.parseBigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException("Failed parsing '" + string + "' as BigDecimal; at path " + jsonReader.getPreviousPath(), numberFormatException);
        }
    }

    @Override
    public void write(JsonWriter jsonWriter, BigDecimal bigDecimal) throws IOException {
        jsonWriter.value(bigDecimal);
    }
}

