/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.BitSet;

class TypeAdapters$2
extends TypeAdapter<BitSet> {
    TypeAdapters$2() {
    }

    @Override
    public BitSet read(JsonReader jsonReader) throws IOException {
        BitSet bitSet = new BitSet();
        jsonReader.beginArray();
        int n2 = 0;
        JsonToken jsonToken = jsonReader.peek();
        while (jsonToken != JsonToken.END_ARRAY) {
            int n3;
            switch (jsonToken) {
                case NUMBER: 
                case STRING: {
                    n3 = jsonReader.nextInt();
                    if (n3 == 0) {
                        n3 = 0;
                        break;
                    }
                    if (n3 == 1) {
                        n3 = 1;
                        break;
                    }
                    throw new JsonSyntaxException("Invalid bitset value " + n3 + ", expected 0 or 1; at path " + jsonReader.getPreviousPath());
                }
                case BOOLEAN: {
                    n3 = jsonReader.nextBoolean();
                    break;
                }
                default: {
                    throw new JsonSyntaxException("Invalid bitset value type: " + (Object)((Object)jsonToken) + "; at path " + jsonReader.getPath());
                }
            }
            if (n3 != 0) {
                bitSet.set(n2);
            }
            ++n2;
            jsonToken = jsonReader.peek();
        }
        jsonReader.endArray();
        return bitSet;
    }

    @Override
    public void write(JsonWriter jsonWriter, BitSet bitSet) throws IOException {
        jsonWriter.beginArray();
        int n2 = bitSet.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = bitSet.get(i2) ? 1 : 0;
            jsonWriter.value(n3);
        }
        jsonWriter.endArray();
    }
}

