/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import com.sun.activation.registries.LineTokenizer;
import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MimeTypeEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MimeTypeFile {
    private String fname = null;
    private Hashtable type_hash = new Hashtable();

    public MimeTypeFile(String object) throws IOException {
        this.fname = object;
        object = new File(this.fname);
        object = new FileReader((File)object);
        try {
            this.parse(new BufferedReader((Reader)object));
        }
        catch (Throwable throwable) {
            try {
                ((InputStreamReader)object).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStreamReader)object).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public MimeTypeFile(InputStream inputStream) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(inputStream, "iso-8859-1")));
    }

    public MimeTypeFile() {
    }

    public MimeTypeEntry getMimeTypeEntry(String string) {
        return (MimeTypeEntry)this.type_hash.get(string);
    }

    public String getMIMETypeString(String object) {
        if ((object = this.getMimeTypeEntry((String)object)) != null) {
            return ((MimeTypeEntry)object).getMIMEType();
        }
        return null;
    }

    public void appendToRegistry(String string) {
        try {
            this.parse(new BufferedReader(new StringReader(string)));
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void parse(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            string2 = string2 == null ? string : string2 + string;
            int n2 = string2.length();
            if (string2.length() > 0 && string2.charAt(n2 - 1) == '\\') {
                string2 = string2.substring(0, n2 - 1);
                continue;
            }
            this.parseEntry(string2);
            string2 = null;
        }
        if (string2 != null) {
            this.parseEntry(string2);
        }
    }

    private void parseEntry(String string) {
        String string2 = null;
        if ((string = string.trim()).length() == 0) {
            return;
        }
        if (string.charAt(0) == '#') {
            return;
        }
        if (string.indexOf(61) > 0) {
            LineTokenizer lineTokenizer = new LineTokenizer(string);
            while (lineTokenizer.hasMoreTokens()) {
                String string3 = lineTokenizer.nextToken();
                Object object = null;
                if (lineTokenizer.hasMoreTokens() && lineTokenizer.nextToken().equals("=") && lineTokenizer.hasMoreTokens()) {
                    object = lineTokenizer.nextToken();
                }
                if (object == null) {
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("Bad .mime.types entry: " + string);
                    }
                    return;
                }
                if (string3.equals("type")) {
                    string2 = object;
                    continue;
                }
                if (!string3.equals("exts")) continue;
                object = new StringTokenizer((String)object, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string3 = ((StringTokenizer)object).nextToken();
                    MimeTypeEntry mimeTypeEntry = new MimeTypeEntry(string2, string3);
                    this.type_hash.put(string3, mimeTypeEntry);
                    if (!LogSupport.isLoggable()) continue;
                    LogSupport.log("Added: " + mimeTypeEntry.toString());
                }
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        if (n2 == 0) {
            return;
        }
        string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            MimeTypeEntry mimeTypeEntry = new MimeTypeEntry(string2, string4);
            this.type_hash.put(string4, mimeTypeEntry);
            if (!LogSupport.isLoggable()) continue;
            LogSupport.log("Added: " + mimeTypeEntry.toString());
        }
    }
}

