/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.DelayedCallback;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.delegate.ClipboardDelegate;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Clipboard {
    public static final String TEXT_TYPE = "text/plain";
    public static final String HTML_TYPE = "text/html";
    public static final String RTF_TYPE = "text/rtf";
    public static final String URI_TYPE = "text/uri-list";
    public static final String FILE_LIST_TYPE = "application/x-java-file-list";
    public static final String RAW_IMAGE_TYPE = "application/x-java-rawimage";
    public static final String DRAG_IMAGE = "application/x-java-drag-image";
    public static final String DRAG_IMAGE_OFFSET = "application/x-java-drag-image-offset";
    public static final String IE_URL_SHORTCUT_FILENAME = "text/ie-shortcut-filename";
    public static final int ACTION_NONE = 0;
    public static final int ACTION_COPY = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_REFERENCE = 0x40000000;
    public static final int ACTION_COPY_OR_MOVE = 3;
    public static final int ACTION_ANY = 0x4FFFFFFF;
    public static final String DND = "DND";
    public static final String SYSTEM = "SYSTEM";
    public static final String SELECTION = "SELECTION";
    private static final Map<String, Clipboard> clipboards = new HashMap<String, Clipboard>();
    private static final ClipboardDelegate delegate = PlatformFactory.getPlatformFactory().createClipboardDelegate();
    private final HashSet<ClipboardAssistance> assistants = new HashSet();
    private final String name;
    private final Object localDataProtector = new Object();
    private HashMap<String, Object> localSharedData;
    private ClipboardAssistance dataSource;
    protected int supportedActions = 1;

    protected Clipboard(String string) {
        Application.checkEventThread();
        this.name = string;
    }

    public void add(ClipboardAssistance clipboardAssistance) {
        Application.checkEventThread();
        HashSet<ClipboardAssistance> hashSet = this.assistants;
        synchronized (hashSet) {
            this.assistants.add(clipboardAssistance);
            return;
        }
    }

    public void remove(ClipboardAssistance clipboardAssistance) {
        boolean bl2;
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            if (clipboardAssistance == this.dataSource) {
                this.dataSource = null;
            }
        }
        Object object2 = this.assistants;
        synchronized (object2) {
            this.assistants.remove(clipboardAssistance);
            bl2 = this.assistants.isEmpty();
        }
        if (bl2) {
            object2 = clipboards;
            synchronized (object2) {
                clipboards.remove(this.name);
            }
            this.close();
        }
    }

    protected void setSharedData(ClipboardAssistance clipboardAssistance, HashMap<String, Object> hashMap, int n2) {
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            this.localSharedData = (HashMap)hashMap.clone();
            this.supportedActions = n2;
            this.dataSource = clipboardAssistance;
            return;
        }
    }

    public void flush(ClipboardAssistance clipboardAssistance, HashMap<String, Object> hashMap, int n2) {
        Application.checkEventThread();
        this.setSharedData(clipboardAssistance, hashMap, n2);
        this.contentChanged();
    }

    public int getSupportedSourceActions() {
        Application.checkEventThread();
        return this.supportedActions;
    }

    public void setTargetAction(int n2) {
        Application.checkEventThread();
        this.actionPerformed(n2);
    }

    public void contentChanged() {
        Object object;
        Application.checkEventThread();
        Object object2 = this.assistants;
        synchronized (object2) {
            object = (HashSet)this.assistants.clone();
        }
        object2 = ((HashSet)object).iterator();
        while (object2.hasNext()) {
            object = (ClipboardAssistance)object2.next();
            ((ClipboardAssistance)object).contentChanged();
        }
    }

    public void actionPerformed(int n2) {
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            if (this.dataSource != null) {
                this.dataSource.actionPerformed(n2);
            }
            return;
        }
    }

    public Object getData(String object) {
        Application.checkEventThread();
        Object object2 = this.localDataProtector;
        synchronized (object2) {
            if (this.localSharedData == null) {
                return null;
            }
            Object object3 = (object = this.localSharedData.get(object)) instanceof DelayedCallback ? ((DelayedCallback)object).providedData() : object;
            return object3;
        }
    }

    public String[] getMimeTypes() {
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            if (this.localSharedData == null) {
                return null;
            }
            Object object2 = this.localSharedData.keySet();
            String[] stringArray = new String[object2.size()];
            int n2 = 0;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                stringArray[n2++] = string;
            }
            return stringArray;
        }
    }

    protected static Clipboard get(String string) {
        Application.checkEventThread();
        Map<String, Clipboard> map = clipboards;
        synchronized (map) {
            if (!clipboards.keySet().contains(string)) {
                Clipboard clipboard = delegate.createClipboard(string);
                if (clipboard == null) {
                    clipboard = new Clipboard(string);
                }
                clipboards.put(string, clipboard);
            }
            return clipboards.get(string);
        }
    }

    public Pixels getPixelsForRawImage(byte[] object) {
        Application.checkEventThread();
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object, 0, 8);
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        object = ByteBuffer.wrap((byte[])object, 8, ((byte[])object).length - 8);
        return Application.GetApplication().createPixels(n2, n3, ((ByteBuffer)object).slice());
    }

    public String toString() {
        return "Clipboard: " + this.name + "@" + this.hashCode();
    }

    protected void close() {
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            this.dataSource = null;
            return;
        }
    }

    public String getName() {
        Application.checkEventThread();
        return this.name;
    }

    public static String getActionString(int n2) {
        Application.checkEventThread();
        StringBuilder stringBuilder = new StringBuilder("");
        int[] nArray = new int[]{1, 2, 0x40000000};
        String[] stringArray = new String[]{"copy", "move", "link"};
        for (int i2 = 0; i2 < 3; ++i2) {
            if ((nArray[i2] & n2) <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }
}

