/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Menu$EventHandler;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.delegate.MenuDelegate;
import com.sun.glass.ui.delegate.MenuItemDelegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Menu {
    private final MenuDelegate delegate;
    private String title;
    private boolean enabled;
    private final List<Object> items = new ArrayList<Object>();
    private Menu$EventHandler eventHandler;

    public final Menu$EventHandler getEventHandler() {
        Application.checkEventThread();
        return this.eventHandler;
    }

    public final void setEventHandler(Menu$EventHandler menu$EventHandler) {
        Application.checkEventThread();
        this.eventHandler = menu$EventHandler;
    }

    protected Menu(String string) {
        this(string, true);
    }

    protected Menu(String string, boolean bl2) {
        Application.checkEventThread();
        this.title = string;
        this.enabled = bl2;
        this.delegate = PlatformFactory.getPlatformFactory().createMenuDelegate(this);
        if (!this.delegate.createMenu(string, bl2)) {
            throw new RuntimeException("Menu creation error.");
        }
    }

    public final String getTitle() {
        Application.checkEventThread();
        return this.title;
    }

    public final void setTitle(String string) {
        Application.checkEventThread();
        if (this.delegate.setTitle(string)) {
            this.title = string;
        }
    }

    public final boolean isEnabled() {
        Application.checkEventThread();
        return this.enabled;
    }

    public final void setEnabled(boolean bl2) {
        Application.checkEventThread();
        if (this.delegate.setEnabled(bl2)) {
            this.enabled = bl2;
        }
    }

    public final boolean setPixels(Pixels pixels) {
        Application.checkEventThread();
        return this.delegate.setPixels(pixels);
    }

    public final List<Object> getItems() {
        Application.checkEventThread();
        return Collections.unmodifiableList(this.items);
    }

    public final void add(Menu menu) {
        Application.checkEventThread();
        this.insert(menu, this.items.size());
    }

    public final void add(MenuItem menuItem) {
        Application.checkEventThread();
        this.insert(menuItem, this.items.size());
    }

    public final void insert(Menu menu, int n2) throws IndexOutOfBoundsException {
        Application.checkEventThread();
        if (menu == null) {
            throw new IllegalArgumentException();
        }
        List<Object> list = this.items;
        synchronized (list) {
            if (n2 < 0 || n2 > this.items.size()) {
                throw new IndexOutOfBoundsException();
            }
            MenuDelegate menuDelegate = menu.getDelegate();
            if (this.delegate.insert(menuDelegate, n2)) {
                this.items.add(n2, menu);
            }
            return;
        }
    }

    public final void insert(MenuItem menuItem, int n2) throws IndexOutOfBoundsException {
        Application.checkEventThread();
        List<Object> list = this.items;
        synchronized (list) {
            MenuItemDelegate menuItemDelegate;
            if (n2 < 0 || n2 > this.items.size()) {
                throw new IndexOutOfBoundsException();
            }
            MenuItemDelegate menuItemDelegate2 = menuItemDelegate = menuItem != null ? menuItem.getDelegate() : null;
            if (this.delegate.insert(menuItemDelegate, n2)) {
                this.items.add(n2, menuItem);
            }
            return;
        }
    }

    public final void remove(int n2) throws IndexOutOfBoundsException {
        Application.checkEventThread();
        List<Object> list = this.items;
        synchronized (list) {
            Object object = this.items.get(n2);
            boolean bl2 = object == MenuItem.Separator ? this.delegate.remove((MenuItemDelegate)null, n2) : (object instanceof MenuItem ? this.delegate.remove(((MenuItem)object).getDelegate(), n2) : this.delegate.remove(((Menu)object).getDelegate(), n2));
            if (bl2) {
                this.items.remove(n2);
            }
            return;
        }
    }

    final MenuDelegate getDelegate() {
        return this.delegate;
    }

    protected final void notifyMenuOpening() {
        if (this.eventHandler != null) {
            this.eventHandler.handleMenuOpening(this, System.nanoTime());
        }
    }

    protected final void notifyMenuClosed() {
        if (this.eventHandler != null) {
            this.eventHandler.handleMenuClosed(this, System.nanoTime());
        }
    }
}

