/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public abstract class Pixels {
    protected final int width;
    protected final int height;
    protected final int bytesPerComponent;
    protected final ByteBuffer bytes;
    protected final IntBuffer ints;
    private final float scalex;
    private final float scaley;

    public static int getNativeFormat() {
        Application.checkEventThread();
        return Application.GetApplication().staticPixels_getNativeFormat();
    }

    protected Pixels(int n2, int n3, ByteBuffer byteBuffer) {
        this(n2, n3, byteBuffer, 1.0f, 1.0f);
    }

    protected Pixels(int n2, int n3, ByteBuffer byteBuffer, float f2, float f3) {
        this.width = n2;
        this.height = n3;
        this.bytesPerComponent = 1;
        this.bytes = byteBuffer.slice();
        if (this.width <= 0 || this.height <= 0 || this.width > 0x1FFFFFFF / this.height) {
            throw new IllegalArgumentException("Invalid width*height");
        }
        if (this.width * this.height << 2 > this.bytes.capacity()) {
            throw new IllegalArgumentException("Too small byte buffer size " + this.width + "x" + this.height + " [" + (this.width * this.height << 2) + "] > " + this.bytes.capacity());
        }
        this.ints = null;
        this.scalex = f2;
        this.scaley = f3;
    }

    protected Pixels(int n2, int n3, IntBuffer intBuffer) {
        this(n2, n3, intBuffer, 1.0f, 1.0f);
    }

    protected Pixels(int n2, int n3, IntBuffer intBuffer, float f2, float f3) {
        this.width = n2;
        this.height = n3;
        this.bytesPerComponent = 4;
        this.ints = intBuffer.slice();
        if (this.width <= 0 || this.height <= 0 || this.width > 0x1FFFFFFF / this.height) {
            throw new IllegalArgumentException("Invalid width*height");
        }
        if (this.width * this.height > this.ints.capacity()) {
            throw new IllegalArgumentException("Too small int buffer size " + this.width + "x" + this.height + " [" + this.width * this.height + "] > " + this.ints.capacity());
        }
        this.bytes = null;
        this.scalex = f2;
        this.scaley = f3;
    }

    public final float getScaleX() {
        Application.checkEventThread();
        return this.scalex;
    }

    public final float getScaleY() {
        Application.checkEventThread();
        return this.scaley;
    }

    public final float getScaleXUnsafe() {
        return this.scalex;
    }

    public final float getScaleYUnsafe() {
        return this.scaley;
    }

    public final int getWidth() {
        Application.checkEventThread();
        return this.width;
    }

    public final int getWidthUnsafe() {
        return this.width;
    }

    public final int getHeight() {
        Application.checkEventThread();
        return this.height;
    }

    public final int getHeightUnsafe() {
        return this.height;
    }

    public final int getBytesPerComponent() {
        Application.checkEventThread();
        return this.bytesPerComponent;
    }

    public final Buffer getPixels() {
        if (this.bytes != null) {
            this.bytes.rewind();
            return this.bytes;
        }
        if (this.ints != null) {
            this.ints.rewind();
            return this.ints;
        }
        throw new RuntimeException("Unexpected Pixels state.");
    }

    public final Buffer getBuffer() {
        if (this.bytes != null) {
            return this.bytes;
        }
        if (this.ints != null) {
            return this.ints;
        }
        throw new RuntimeException("Unexpected Pixels state.");
    }

    public final ByteBuffer asByteBuffer() {
        Application.checkEventThread();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.getWidth() * this.getHeight() << 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.rewind();
        this.asByteBuffer(byteBuffer);
        return byteBuffer;
    }

    public final void asByteBuffer(ByteBuffer byteBuffer) {
        Application.checkEventThread();
        if (!byteBuffer.isDirect()) {
            throw new RuntimeException("Expected direct buffer.");
        }
        if (byteBuffer.remaining() < this.getWidth() * this.getHeight() << 2) {
            throw new RuntimeException("Too small buffer.");
        }
        this._fillDirectByteBuffer(byteBuffer);
        byteBuffer.rewind();
    }

    private void attachData(long l2) {
        int[] nArray;
        if (this.ints != null) {
            nArray = !this.ints.isDirect() ? this.ints.array() : null;
            this._attachInt(l2, this.width, this.height, this.ints, nArray, nArray != null ? this.ints.arrayOffset() : 0);
        }
        if (this.bytes != null) {
            nArray = !this.bytes.isDirect() ? this.bytes.array() : null;
            this._attachByte(l2, this.width, this.height, this.bytes, (byte[])nArray, nArray != null ? this.bytes.arrayOffset() : 0);
        }
    }

    protected abstract void _fillDirectByteBuffer(ByteBuffer var1);

    protected abstract void _attachInt(long var1, int var3, int var4, IntBuffer var5, int[] var6, int var7);

    protected abstract void _attachByte(long var1, int var3, int var4, ByteBuffer var5, byte[] var6, int var7);

    public final boolean equals(Object object) {
        Application.checkEventThread();
        boolean bl2 = object != null && this.getClass().equals(object.getClass());
        if (bl2) {
            object = (Pixels)object;
            bl2 = this.getWidth() == ((Pixels)object).getWidth() && this.getHeight() == ((Pixels)object).getHeight();
            if (bl2) {
                ByteBuffer byteBuffer = this.asByteBuffer();
                bl2 = byteBuffer.compareTo((ByteBuffer)(object = ((Pixels)object).asByteBuffer())) == 0;
            }
        }
        return bl2;
    }

    public final int hashCode() {
        Application.checkEventThread();
        int n2 = this.getWidth();
        n2 = n2 * 31 + this.getHeight();
        n2 = n2 * 17 + this.asByteBuffer().hashCode();
        return n2;
    }
}

