/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.mac.MacAccessible$1;
import com.sun.glass.ui.mac.MacAccessible$MacAction;
import com.sun.glass.ui.mac.MacAccessible$MacAttribute;
import com.sun.glass.ui.mac.MacAccessible$MacNotification;
import com.sun.glass.ui.mac.MacAccessible$MacOrientation;
import com.sun.glass.ui.mac.MacAccessible$MacRole;
import com.sun.glass.ui.mac.MacAccessible$MacSubrole;
import com.sun.glass.ui.mac.MacAccessible$MacText;
import com.sun.glass.ui.mac.MacApplication;
import com.sun.glass.ui.mac.MacVariant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyCombination$ModifierValue;
import javafx.scene.text.Font;

final class MacAccessible
extends Accessible {
    private static final List<MacAccessible$MacAttribute> BASE_ATTRIBUTES;
    private static final List<MacAccessible$MacAttribute> TEXT_ATTRIBUTES;
    private static final List<MacAccessible$MacAttribute> TEXT_PARAMETRIZED_ATTRIBUTES;
    private long peer;
    private static final int kAXMenuItemModifierNone = 0;
    private static final int kAXMenuItemModifierShift = 1;
    private static final int kAXMenuItemModifierOption = 2;
    private static final int kAXMenuItemModifierControl = 4;
    private static final int kAXMenuItemModifierNoCommand = 8;
    private Boolean inMenu;
    private Boolean inSlider;
    private Boolean ignoreInnerText;

    private static native void _initIDs();

    private static native boolean _initEnum(String var0);

    private native long _createAccessiblePeer(String var1);

    private native void _destroyAccessiblePeer(long var1);

    private native void _invalidateParent(long var1);

    private static native String getString(long var0);

    private static native boolean isEqualToString(long var0, long var2);

    private static native long NSAccessibilityUnignoredAncestor(long var0);

    private static native long[] NSAccessibilityUnignoredChildren(long[] var0);

    private static native void NSAccessibilityPostNotification(long var0, long var2);

    private static native String NSAccessibilityActionDescription(long var0);

    private static native String NSAccessibilityRoleDescription(long var0, long var2);

    private static native MacVariant idToMacVariant(long var0, int var2);

    private static native MacAccessible GlassAccessibleToMacAccessible(long var0);

    MacAccessible() {
    }

    @Override
    public final void dispose() {
        Application.checkEventThread();
        if (this.peer != 0L) {
            if (this.getView() == null) {
                MacAccessible.NSAccessibilityPostNotification(this.peer, MacAccessible$MacNotification.NSAccessibilityUIElementDestroyedNotification.ptr);
            }
            MacAccessible macAccessible = this;
            macAccessible._destroyAccessiblePeer(macAccessible.peer);
            this.peer = 0L;
        }
        super.dispose();
    }

    @Override
    public final void sendNotification(AccessibleAttribute object) {
        Application.checkEventThread();
        if (this.isDisposed()) {
            return;
        }
        MacAccessible$MacNotification macAccessible$MacNotification = null;
        switch (MacAccessible$1.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
                if (object == AccessibleRole.TABLE_VIEW || object == AccessibleRole.TREE_TABLE_VIEW) {
                    macAccessible$MacNotification = MacAccessible$MacNotification.NSAccessibilitySelectedCellsChangedNotification;
                    break;
                }
                if (object == AccessibleRole.LIST_VIEW || object == AccessibleRole.TREE_VIEW) {
                    macAccessible$MacNotification = MacAccessible$MacNotification.NSAccessibilitySelectedRowsChangedNotification;
                    break;
                }
                Node node = (Node)this.getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0]);
                long l2 = this.getNativeAccessible(node);
                if (l2 == 0L) break;
                MacAccessible.NSAccessibilityPostNotification(l2, MacAccessible$MacNotification.NSAccessibilityFocusedUIElementChangedNotification.ptr);
                break;
            }
            case 2: {
                Accessible accessible;
                Scene scene;
                object = (Node)this.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                View view = this.getView();
                if (object == null && view == null && (scene = (Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0])) != null && (accessible = this.getAccessible(scene)) != null) {
                    object = (Node)accessible.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                }
                long l3 = 0L;
                if (object != null) {
                    Node node = (Node)this.getAccessible((Node)object).getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0]);
                    l3 = node != null ? this.getNativeAccessible(node) : this.getNativeAccessible((Node)object);
                } else {
                    if (view == null) {
                        MacAccessible macAccessible = this;
                        view = macAccessible.getRootView((Scene)macAccessible.getAttribute(AccessibleAttribute.SCENE, new Object[0]));
                    }
                    if (view != null) {
                        l3 = view.getNativeView();
                    }
                }
                if (l3 != 0L) {
                    MacAccessible.NSAccessibilityPostNotification(l3, MacAccessible$MacNotification.NSAccessibilityFocusedUIElementChangedNotification.ptr);
                }
                return;
            }
            case 3: {
                return;
            }
            case 4: 
            case 5: {
                macAccessible$MacNotification = MacAccessible$MacNotification.NSAccessibilitySelectedTextChangedNotification;
                break;
            }
            case 6: {
                AccessibleRole accessibleRole;
                MacAccessible macAccessible;
                boolean bl2 = Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.EXPANDED, new Object[0]));
                macAccessible$MacNotification = bl2 ? MacAccessible$MacNotification.NSAccessibilityRowExpandedNotification : MacAccessible$MacNotification.NSAccessibilityRowCollapsedNotification;
                AccessibleRole accessibleRole2 = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
                if (accessibleRole2 != AccessibleRole.TREE_ITEM && accessibleRole2 != AccessibleRole.CHECK_BOX_TREE_ITEM && accessibleRole2 != AccessibleRole.TREE_TABLE_ROW || (macAccessible = (MacAccessible)this.getContainerAccessible(accessibleRole = accessibleRole2 == AccessibleRole.TREE_ITEM || accessibleRole2 == AccessibleRole.CHECK_BOX_TREE_ITEM ? AccessibleRole.TREE_VIEW : AccessibleRole.TREE_TABLE_VIEW)) == null) break;
                MacAccessible.NSAccessibilityPostNotification(macAccessible.getNativeAccessible(), MacAccessible$MacNotification.NSAccessibilityRowCountChangedNotification.ptr);
                break;
            }
            case 7: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) != AccessibleRole.CONTEXT_MENU) break;
                Boolean bl3 = (Boolean)this.getAttribute(AccessibleAttribute.VISIBLE, new Object[0]);
                if (Boolean.TRUE.equals(bl3)) {
                    macAccessible$MacNotification = MacAccessible$MacNotification.AXMenuOpened;
                    break;
                }
                macAccessible$MacNotification = MacAccessible$MacNotification.AXMenuClosed;
                Node node = (Node)this.getAttribute(AccessibleAttribute.PARENT_MENU, new Object[0]);
                MacAccessible macAccessible = (MacAccessible)this.getAccessible(node);
                if (macAccessible == null || (object = (MacAccessible)macAccessible.getContainerAccessible(AccessibleRole.CONTEXT_MENU)) == null) break;
                long l4 = ((MacAccessible)object).getNativeAccessible();
                MacAccessible.NSAccessibilityPostNotification(l4, MacAccessible$MacNotification.AXMenuClosed.ptr);
                MacAccessible.NSAccessibilityPostNotification(l4, MacAccessible$MacNotification.AXMenuOpened.ptr);
                break;
            }
            case 8: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.SPINNER) {
                    macAccessible$MacNotification = MacAccessible$MacNotification.NSAccessibilityTitleChangedNotification;
                    break;
                }
                macAccessible$MacNotification = MacAccessible$MacNotification.NSAccessibilityValueChangedNotification;
                break;
            }
            case 9: {
                if (this.peer != 0L) {
                    MacAccessible macAccessible = this;
                    macAccessible._invalidateParent(macAccessible.peer);
                }
                this.ignoreInnerText = null;
                break;
            }
            default: {
                macAccessible$MacNotification = MacAccessible$MacNotification.NSAccessibilityValueChangedNotification;
            }
        }
        if (macAccessible$MacNotification != null) {
            View view = this.getView();
            long l5 = view != null ? view.getNativeView() : this.getNativeAccessible();
            MacAccessible.NSAccessibilityPostNotification(l5, macAccessible$MacNotification.ptr);
        }
    }

    @Override
    protected final long getNativeAccessible() {
        Application.checkEventThread();
        if (this.peer == 0L) {
            AccessibleRole accessibleRole = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
            if (accessibleRole == null) {
                accessibleRole = AccessibleRole.NODE;
            }
            this.peer = this._createAccessiblePeer(accessibleRole.toString());
            if (this.peer == 0L) {
                throw new RuntimeException("could not create platform accessible");
            }
        }
        return this.peer;
    }

    private View getRootView(Scene object) {
        Application.checkEventThread();
        if (object == null) {
            return null;
        }
        if ((object = this.getAccessible((Scene)object)) == null || ((Accessible)object).isDisposed()) {
            return null;
        }
        if ((object = ((Accessible)object).getView()) == null || ((View)object).isClosed()) {
            return null;
        }
        return object;
    }

    private long[] getUnignoredChildren(ObservableList<Node> object) {
        Application.checkEventThread();
        if (object == null) {
            return new long[0];
        }
        long[] lArray = object.stream().filter(Node::isVisible).mapToLong(node -> this.getNativeAccessible((Node)node)).filter(l2 -> l2 != 0L).toArray();
        object = lArray;
        return MacAccessible.NSAccessibilityUnignoredChildren(lArray);
    }

    private boolean isInMenu() {
        if (this.inMenu == null) {
            this.inMenu = this.getContainerAccessible(AccessibleRole.CONTEXT_MENU) != null || this.getContainerAccessible(AccessibleRole.MENU_BAR) != null;
        }
        return this.inMenu;
    }

    private boolean isMenuElement(AccessibleRole accessibleRole) {
        if (accessibleRole == null) {
            return false;
        }
        switch (accessibleRole) {
            case MENU_BAR: 
            case CONTEXT_MENU: 
            case MENU_ITEM: 
            case RADIO_MENU_ITEM: 
            case CHECK_MENU_ITEM: 
            case MENU: {
                return true;
            }
        }
        return false;
    }

    private boolean isInSlider() {
        if (this.inSlider == null) {
            this.inSlider = this.getContainerAccessible(AccessibleRole.SLIDER) != null;
        }
        return this.inSlider;
    }

    private boolean ignoreInnerText() {
        if (this.ignoreInnerText != null) {
            return this.ignoreInnerText;
        }
        Object object = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        this.ignoreInnerText = Boolean.FALSE;
        if (object == AccessibleRole.TEXT) {
            object = (Node)this.getAttribute(AccessibleAttribute.PARENT, new Object[0]);
            if (object == null) {
                return this.ignoreInnerText;
            }
            if ((object = (AccessibleRole)((Object)this.getAccessible((Node)object).getAttribute(AccessibleAttribute.ROLE, new Object[0]))) == null) {
                return this.ignoreInnerText;
            }
            switch (MacAccessible$1.$SwitchMap$javafx$scene$AccessibleRole[((Enum)object).ordinal()]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    this.ignoreInnerText = Boolean.TRUE;
                }
            }
        }
        return this.ignoreInnerText;
    }

    private int getMenuItemCmdGlyph(KeyCode keyCode) {
        switch (keyCode) {
            case ENTER: {
                return 4;
            }
            case SHIFT: {
                return 5;
            }
            case CONTROL: {
                return 6;
            }
            case META: {
                return 7;
            }
            case SPACE: {
                return 9;
            }
            case COMMAND: {
                return 17;
            }
            case ESCAPE: {
                return 27;
            }
            case CLEAR: {
                return 28;
            }
            case PAGE_UP: {
                return 98;
            }
            case CAPS: {
                return 99;
            }
            case LEFT: 
            case KP_LEFT: {
                return 100;
            }
            case RIGHT: 
            case KP_RIGHT: {
                return 101;
            }
            case HELP: {
                return 103;
            }
            case UP: 
            case KP_UP: {
                return 104;
            }
            case DOWN: 
            case KP_DOWN: {
                return 106;
            }
            case PAGE_DOWN: {
                return 107;
            }
            case CONTEXT_MENU: {
                return 109;
            }
            case POWER: {
                return 110;
            }
            case F1: {
                return 111;
            }
            case F2: {
                return 112;
            }
            case F3: {
                return 113;
            }
            case F4: {
                return 114;
            }
            case F5: {
                return 115;
            }
            case F6: {
                return 116;
            }
            case F7: {
                return 117;
            }
            case F8: {
                return 118;
            }
            case F9: {
                return 119;
            }
            case F10: {
                return 120;
            }
            case F11: {
                return 121;
            }
            case F12: {
                return 122;
            }
            case F13: {
                return 135;
            }
            case F14: {
                return 136;
            }
            case F15: {
                return 137;
            }
        }
        return 0;
    }

    private boolean isCmdCharBased(KeyCode keyCode) {
        return keyCode.isLetterKey() || keyCode.isDigitKey() && !keyCode.isKeypadKey();
    }

    private MacAccessible$MacRole getRole(AccessibleRole accessibleRole) {
        if (accessibleRole == AccessibleRole.COMBO_BOX) {
            if (Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.EDITABLE, new Object[0]))) {
                return MacAccessible$MacRole.NSAccessibilityComboBoxRole;
            }
            return MacAccessible$MacRole.NSAccessibilityPopUpButtonRole;
        }
        return MacAccessible$MacRole.getRole(accessibleRole);
    }

    private Bounds flipBounds(Bounds bounds) {
        Screen screen = Screen.getMainScreen();
        float f2 = screen.getHeight();
        return new BoundingBox(bounds.getMinX(), (double)f2 - bounds.getMinY() - bounds.getHeight(), bounds.getWidth(), bounds.getHeight());
    }

    private long[] accessibilityAttributeNames() {
        Application.checkEventThread();
        if (this.getView() != null) {
            return null;
        }
        AccessibleRole accessibleRole = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (accessibleRole != null) {
            ArrayList<MacAccessible$MacAttribute> arrayList = new ArrayList<MacAccessible$MacAttribute>(BASE_ATTRIBUTES);
            Enum enum_ = this.getRole(accessibleRole);
            if (enum_ != null && ((MacAccessible$MacRole)enum_).macAttributes != null) {
                arrayList.addAll(((MacAccessible$MacRole)enum_).macAttributes);
            }
            if ((enum_ = MacAccessible$MacSubrole.getRole(accessibleRole)) != null && ((MacAccessible$MacSubrole)enum_).macAttributes != null) {
                arrayList.addAll(((MacAccessible$MacSubrole)enum_).macAttributes);
            }
            switch (accessibleRole) {
                case LIST_VIEW: 
                case TREE_VIEW: {
                    arrayList.remove((Object)MacAccessible$MacAttribute.NSAccessibilitySelectedCellsAttribute);
                    break;
                }
                case MENU_BAR: 
                case CONTEXT_MENU: 
                case MENU_ITEM: 
                case RADIO_MENU_ITEM: 
                case CHECK_MENU_ITEM: 
                case MENU: {
                    arrayList.remove((Object)MacAccessible$MacAttribute.NSAccessibilityWindowAttribute);
                    arrayList.remove((Object)MacAccessible$MacAttribute.NSAccessibilityTopLevelUIElementAttribute);
                    break;
                }
                case COMBO_BOX: 
                case TEXT: 
                case TEXT_FIELD: 
                case TEXT_AREA: 
                case PASSWORD_FIELD: {
                    arrayList.addAll(TEXT_ATTRIBUTES);
                }
            }
            return arrayList.stream().mapToLong(macAccessible$MacAttribute -> macAccessible$MacAttribute.ptr).toArray();
        }
        return null;
    }

    private int accessibilityArrayAttributeCount(long l2) {
        Application.checkEventThread();
        Object object = MacAccessible$MacAttribute.getAttribute(l2);
        if (object == null) {
            return -1;
        }
        switch (object) {
            case NSAccessibilityRowsAttribute: {
                object = this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.LIST_VIEW ? AccessibleAttribute.ITEM_COUNT : AccessibleAttribute.ROW_COUNT;
                object = (Integer)this.getAttribute((AccessibleAttribute)((Object)object), new Object[0]);
                if (object != null) {
                    return (Integer)object;
                }
                return 0;
            }
            case NSAccessibilityColumnsAttribute: {
                object = (Integer)this.getAttribute(AccessibleAttribute.COLUMN_COUNT, new Object[0]);
                if (object != null) {
                    return (Integer)object;
                }
                return 1;
            }
            case NSAccessibilityChildrenAttribute: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.MENU) {
                    object = (ObservableList)this.getAttribute(AccessibleAttribute.CHILDREN, new Object[0]);
                    if (object == null) {
                        return 0;
                    }
                    long[] lArray = this.getUnignoredChildren((ObservableList<Node>)object);
                    object = lArray;
                    int n2 = lArray.length;
                    if (this.getAttribute(AccessibleAttribute.SUBMENU, new Object[0]) != null) {
                        ++n2;
                    }
                    return n2;
                }
                return -1;
            }
            case NSAccessibilityDisclosedRowsAttribute: {
                object = (Integer)this.getAttribute(AccessibleAttribute.TREE_ITEM_COUNT, new Object[0]);
                if (object != null) {
                    return (Integer)object;
                }
                return 0;
            }
        }
        return -1;
    }

    private long[] accessibilityArrayAttributeValues(long l2, int n2, int n3) {
        Application.checkEventThread();
        Object object = MacAccessible$MacAttribute.getAttribute(l2);
        if (object == null) {
            return null;
        }
        Object object2 = null;
        switch (object) {
            case NSAccessibilityColumnsAttribute: {
                object2 = AccessibleAttribute.COLUMN_AT_INDEX;
                break;
            }
            case NSAccessibilityRowsAttribute: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.LIST_VIEW) {
                    object2 = AccessibleAttribute.ITEM_AT_INDEX;
                    break;
                }
                object2 = AccessibleAttribute.ROW_AT_INDEX;
                break;
            }
            case NSAccessibilityDisclosedRowsAttribute: {
                object2 = AccessibleAttribute.TREE_ITEM_AT_INDEX;
                break;
            }
            case NSAccessibilityChildrenAttribute: {
                Object object3;
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) != AccessibleRole.MENU) break;
                object = new long[n3];
                int n4 = 0;
                if (n2 == 0 && (object3 = (Node)this.getAttribute(AccessibleAttribute.SUBMENU, new Object[0])) != null) {
                    ++n4;
                    object[0] = (MacAccessible$MacAttribute)this.getNativeAccessible((Node)object3);
                }
                if (n4 < n3) {
                    object3 = (ObservableList)this.getAttribute(AccessibleAttribute.CHILDREN, new Object[0]);
                    if (object3 == null) {
                        return null;
                    }
                    object2 = this.getUnignoredChildren((ObservableList<Node>)object3);
                    --n2;
                    while (n4 < n3 && n2 < ((AccessibleAttribute)object2).length) {
                        object[n4++] = object2[n2++];
                    }
                }
                if (n4 < n3) {
                    object = Arrays.copyOf((long[])object, n4);
                }
                return object;
            }
        }
        if (object2 != null) {
            Node node;
            int n5;
            object = new long[n3];
            for (n5 = 0; n5 < n3 && (node = (Node)this.getAttribute((AccessibleAttribute)((Object)object2), new Object[]{n2 + n5})) != null; ++n5) {
                object[n5] = (MacAccessible$MacAttribute)this.getNativeAccessible(node);
            }
            if (n5 == n3) {
                return MacAccessible.NSAccessibilityUnignoredChildren((long[])object);
            }
        }
        return null;
    }

    private boolean accessibilityIsAttributeSettable(long l2) {
        Application.checkEventThread();
        Object object = MacAccessible$MacAttribute.getAttribute(l2);
        if (object == null) {
            return false;
        }
        switch (MacAccessible$1.$SwitchMap$com$sun$glass$ui$mac$MacAccessible$MacAttribute[((Enum)object).ordinal()]) {
            case 5: {
                object = (Integer)this.getAttribute(AccessibleAttribute.TREE_ITEM_COUNT, new Object[0]);
                return object != null && (Integer)object > 0;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
            case 10: 
            case 11: {
                object = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
                if (object != AccessibleRole.TEXT_FIELD && object != AccessibleRole.TEXT_AREA || !Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.EDITABLE, new Object[0]))) break;
                return true;
            }
        }
        return false;
    }

    private MacVariant accessibilityAttributeValue(long l2) {
        Object object;
        Object object2;
        Application.checkEventThread();
        Object object3 = MacAccessible$MacAttribute.getAttribute(l2);
        if (object3 == null) {
            return null;
        }
        Function<Object, MacVariant> function = ((MacAccessible$MacAttribute)((Object)object3)).map;
        Object object4 = ((MacAccessible$MacAttribute)((Object)object3)).jfxAttr;
        AccessibleRole accessibleRole = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (accessibleRole == null) {
            return null;
        }
        if (object4 == null) {
            block0 : switch (MacAccessible$1.$SwitchMap$com$sun$glass$ui$mac$MacAccessible$MacAttribute[((Enum)object3).ordinal()]) {
                case 10: {
                    switch (accessibleRole) {
                        case TAB_PANE: 
                        case PAGINATION: {
                            object4 = AccessibleAttribute.FOCUS_ITEM;
                            function = MacVariant::createNSObject;
                            break block0;
                        }
                        case RADIO_BUTTON: 
                        case TAB_ITEM: 
                        case PAGE_ITEM: {
                            object4 = AccessibleAttribute.SELECTED;
                            function = MacVariant::createNSNumberForBoolean;
                            break block0;
                        }
                        case SCROLL_BAR: 
                        case SLIDER: 
                        case PROGRESS_INDICATOR: 
                        case THUMB: {
                            object4 = AccessibleAttribute.VALUE;
                            function = MacVariant::createNSNumberForDouble;
                            break block0;
                        }
                        case COMBO_BOX: 
                        case TEXT: 
                        case TEXT_FIELD: 
                        case TEXT_AREA: {
                            object4 = AccessibleAttribute.TEXT;
                            function = MacVariant::createNSString;
                            break block0;
                        }
                        case TOGGLE_BUTTON: 
                        case CHECK_BOX: {
                            object4 = AccessibleAttribute.SELECTED;
                            function = MacVariant::createNSNumberForInt;
                            break block0;
                        }
                        case DATE_PICKER: {
                            object4 = AccessibleAttribute.DATE;
                            function = MacVariant::createNSDate;
                            break block0;
                        }
                        case TITLED_PANE: {
                            object4 = AccessibleAttribute.EXPANDED;
                            function = MacVariant::createNSNumberForInt;
                            break block0;
                        }
                    }
                    return null;
                }
                case 12: {
                    Object object5;
                    Object object6;
                    object4 = null;
                    if (accessibleRole == AccessibleRole.CONTEXT_MENU && (object6 = this.getAccessible((Scene)(object5 = (Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0])))) != null) {
                        object4 = (Node)((Accessible)object6).getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                    }
                    if (accessibleRole == AccessibleRole.MENU_BAR) {
                        object4 = (Node)this.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                    }
                    if (object4 != null && this.isMenuElement((AccessibleRole)((Object)(object5 = (AccessibleRole)((Object)this.getAccessible((Node)object4).getAttribute(AccessibleAttribute.ROLE, new Object[0])))))) {
                        object6 = new long[]{this.getNativeAccessible((Node)object4)};
                        return ((MacAccessible$MacAttribute)((Object)object3)).map.apply(object6);
                    }
                    return null;
                }
                case 13: {
                    if (this.getAttribute(AccessibleAttribute.DATE, new Object[0]) == null) {
                        return null;
                    }
                    return ((MacAccessible$MacAttribute)((Object)object3)).map.apply(224);
                }
            }
        }
        if (object4 == null) {
            return null;
        }
        if ((object4 = this.getAttribute((AccessibleAttribute)((Object)object4), new Object[0])) == null) {
            block14 : switch (MacAccessible$1.$SwitchMap$com$sun$glass$ui$mac$MacAccessible$MacAttribute[((Enum)object3).ordinal()]) {
                case 14: {
                    break;
                }
                case 15: {
                    object4 = 1;
                    break;
                }
                case 16: {
                    if (accessibleRole == AccessibleRole.TABLE_COLUMN && (object4 = this.getAttribute(AccessibleAttribute.INDEX, new Object[0])) != null) break;
                    return null;
                }
                case 17: {
                    return ((MacAccessible$MacAttribute)((Object)object3)).map.apply(8);
                }
                case 18: {
                    switch (accessibleRole) {
                        case TITLED_PANE: {
                            object4 = "title pane";
                            break block14;
                        }
                        case SPLIT_MENU_BUTTON: {
                            object4 = "split button";
                            break block14;
                        }
                        case PAGE_ITEM: {
                            object4 = "page";
                            break block14;
                        }
                        case TAB_ITEM: {
                            object4 = "tab";
                            break block14;
                        }
                        case LIST_VIEW: {
                            object4 = "list";
                            break block14;
                        }
                        case DIALOG: {
                            object4 = "dialog";
                            break block14;
                        }
                    }
                    object2 = this.getRole(accessibleRole);
                    object = (Object)MacAccessible$MacSubrole.getRole(accessibleRole);
                    object4 = MacAccessible.NSAccessibilityRoleDescription(((MacAccessible$MacRole)((Object)object2)).ptr, object != null ? ((MacAccessible$MacSubrole)((Object)object)).ptr : 0L);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        block29 : switch (MacAccessible$1.$SwitchMap$com$sun$glass$ui$mac$MacAccessible$MacAttribute[((Enum)object3).ordinal()]) {
            case 19: 
            case 20: {
                if (this.isMenuElement(accessibleRole)) {
                    return null;
                }
                object2 = (Scene)object4;
                View view = this.getRootView((Scene)object2);
                object = view;
                if (view == null || ((View)object).getWindow() == null) {
                    return null;
                }
                object4 = ((View)object).getWindow().getNativeWindow();
                break;
            }
            case 21: {
                object2 = MacAccessible$MacSubrole.getRole((AccessibleRole)((Object)object4));
                object4 = object2 != null ? ((MacAccessible$MacSubrole)((Object)object2)).ptr : 0L;
                break;
            }
            case 22: {
                object2 = this.getRole(accessibleRole);
                object4 = object2 != null ? ((MacAccessible$MacRole)((Object)object2)).ptr : 0L;
                break;
            }
            case 23: {
                object4 = Boolean.FALSE.equals(object4);
                break;
            }
            case 24: {
                object2 = (Integer)object4;
                object = new long[((Integer)object2).intValue()];
                for (int i2 = 0; i2 < (Integer)object2; ++i2) {
                    object4 = (Node)this.getAttribute(AccessibleAttribute.ITEM_AT_INDEX, i2);
                    object[i2] = this.getNativeAccessible((Node)object4);
                }
                object4 = MacAccessible.NSAccessibilityUnignoredChildren((long[])object);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 25: {
                object2 = (ObservableList)object4;
                object4 = this.getUnignoredChildren((ObservableList<Node>)object2);
                break;
            }
            case 14: {
                if (this.getView() != null) {
                    if (this.getView().getWindow() == null) {
                        return null;
                    }
                    object4 = this.getView().getWindow().getNativeWindow();
                } else if (object4 != null) {
                    if (accessibleRole == AccessibleRole.CONTEXT_MENU && (object2 = (Node)this.getAttribute(AccessibleAttribute.PARENT_MENU, new Object[0])) != null && this.getAccessible((Node)object2).getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.MENU) {
                        object4 = object2;
                    }
                    object4 = this.getNativeAccessible((Node)object4);
                } else {
                    MacAccessible macAccessible = this;
                    object2 = macAccessible.getRootView((Scene)macAccessible.getAttribute(AccessibleAttribute.SCENE, new Object[0]));
                    if (object2 == null) {
                        return null;
                    }
                    object4 = ((View)object2).getNativeView();
                }
                object4 = MacAccessible.NSAccessibilityUnignoredAncestor((Long)object4);
                break;
            }
            case 10: {
                switch (accessibleRole) {
                    case TAB_PANE: 
                    case PAGINATION: {
                        object4 = this.getNativeAccessible((Node)object4);
                        break block29;
                    }
                    case TOGGLE_BUTTON: 
                    case CHECK_BOX: {
                        if (Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.INDETERMINATE, new Object[0]))) {
                            object4 = 2;
                            break block29;
                        }
                        object4 = Boolean.TRUE.equals(object4) ? 1 : 0;
                        break block29;
                    }
                    case TITLED_PANE: {
                        object4 = Boolean.TRUE.equals(object4) ? 1 : 0;
                        break block29;
                    }
                }
                break;
            }
            case 26: {
                object4 = this.flipBounds((Bounds)object4);
                break;
            }
            case 27: {
                if (!Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.INDETERMINATE, new Object[0]))) break;
                return null;
            }
            case 28: {
                switch (accessibleRole) {
                    case COMBO_BOX: 
                    case TEXT: 
                    case TEXT_FIELD: 
                    case TEXT_AREA: {
                        return null;
                    }
                }
                break;
            }
            case 29: {
                object2 = (KeyCombination)object4;
                object4 = null;
                if (object2 instanceof KeyCharacterCombination) {
                    object4 = ((KeyCharacterCombination)object2).getCharacter();
                }
                if (object2 instanceof KeyCodeCombination && this.isCmdCharBased((KeyCode)((Object)(object = ((KeyCodeCombination)object2).getCode())))) {
                    object4 = ((KeyCode)((Object)object)).getName();
                }
                if (object4 != null) break;
                return null;
            }
            case 30: {
                object2 = (KeyCombination)object4;
                object4 = null;
                if (object2 instanceof KeyCodeCombination && !this.isCmdCharBased((KeyCode)((Object)(object = (Object)((Object)((KeyCodeCombination)object2).getCode()))))) {
                    int n2 = ((KeyCode)((Object)object)).getCode();
                    object4 = MacApplication._getMacKey(n2);
                }
                if (object4 != null) break;
                return null;
            }
            case 31: {
                object2 = (KeyCombination)object4;
                object4 = null;
                if (object2 instanceof KeyCodeCombination && !this.isCmdCharBased((KeyCode)((Object)(object = (Object)((Object)((KeyCodeCombination)object2).getCode()))))) {
                    object4 = this.getMenuItemCmdGlyph((KeyCode)((Object)object));
                }
                if (object4 != null) break;
                return null;
            }
            case 17: {
                object2 = (KeyCombination)object4;
                int n3 = 8;
                if (object2 != null) {
                    if (((KeyCombination)object2).getShortcut() == KeyCombination$ModifierValue.DOWN) {
                        n3 = 0;
                    }
                    if (((KeyCombination)object2).getAlt() == KeyCombination$ModifierValue.DOWN) {
                        n3 |= 2;
                    }
                    if (((KeyCombination)object2).getControl() == KeyCombination$ModifierValue.DOWN) {
                        n3 |= 4;
                    }
                    if (((KeyCombination)object2).getShift() == KeyCombination$ModifierValue.DOWN) {
                        n3 |= 1;
                    }
                }
                object4 = n3;
                break;
            }
            case 32: {
                if (Boolean.TRUE.equals(object4)) {
                    object4 = "\u2713";
                    break;
                }
                return null;
            }
            case 33: {
                object2 = (String)object4;
                object4 = ((String)object2).length();
                break;
            }
            case 34: {
                int n4 = (Integer)object4;
                int n5 = -1;
                if (n4 != -1) {
                    object4 = this.getAttribute(AccessibleAttribute.SELECTION_END, new Object[0]);
                    if (object4 == null) {
                        return null;
                    }
                    n5 = (Integer)object4;
                }
                if (n4 < 0 || n5 < 0 || n4 > n5) {
                    return null;
                }
                object3 = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                if (object3 == null) {
                    return null;
                }
                if (n5 > ((String)object3).length()) {
                    return null;
                }
                object4 = ((String)object3).substring(n4, n5);
                break;
            }
            case 11: {
                int n6 = (Integer)object4;
                int n7 = -1;
                if (n6 != -1) {
                    object4 = this.getAttribute(AccessibleAttribute.SELECTION_END, new Object[0]);
                    if (object4 == null) {
                        return null;
                    }
                    n7 = (Integer)object4;
                }
                if (n6 < 0 || n7 < 0 || n6 > n7) {
                    return null;
                }
                object3 = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                if (object3 == null) {
                    return null;
                }
                if (n7 > ((String)object3).length()) {
                    return null;
                }
                object4 = new int[]{n6, n7 - n6};
                break;
            }
            case 35: {
                if (accessibleRole == AccessibleRole.TEXT_AREA) {
                    object2 = (Integer)this.getAttribute(AccessibleAttribute.LINE_FOR_OFFSET, object4);
                    object4 = object2 != null ? (Integer)object2 : 0;
                    break;
                }
                object4 = 0;
                break;
            }
            case 36: {
                object2 = (String)object4;
                object4 = new int[]{0, ((String)object2).length()};
                break;
            }
            case 37: {
                if (object4 == null) break;
                object4 = new long[]{this.getNativeAccessible((Node)object4)};
                break;
            }
            case 16: 
            case 38: {
                object2 = (Integer)object4;
                object4 = new int[]{(Integer)object2, 1};
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                object4 = this.getNativeAccessible((Node)object4);
                break;
            }
            case 45: {
                object2 = (Orientation)((Object)object4);
                switch (MacAccessible$1.$SwitchMap$javafx$geometry$Orientation[((Enum)object2).ordinal()]) {
                    case 1: {
                        object4 = MacAccessible$MacOrientation.NSAccessibilityHorizontalOrientationValue.ptr;
                        break block29;
                    }
                    case 2: {
                        object4 = MacAccessible$MacOrientation.NSAccessibilityVerticalOrientationValue.ptr;
                        break block29;
                    }
                }
                return null;
            }
            case 5: {
                if (object4 != Boolean.TRUE || !Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.LEAF, new Object[0]))) break;
                object4 = Boolean.FALSE;
            }
        }
        if (object4 != null) {
            return function.apply(object4);
        }
        return null;
    }

    private void accessibilitySetValue(long l2, long l3) {
        Application.checkEventThread();
        MacAccessible$MacAttribute macAccessible$MacAttribute = MacAccessible$MacAttribute.getAttribute(l3);
        if (macAccessible$MacAttribute != null) {
            switch (macAccessible$MacAttribute) {
                case NSAccessibilityFocusedAttribute: {
                    MacVariant macVariant = MacAccessible.idToMacVariant(l2, 9);
                    if (macVariant == null || macVariant.int1 == 0) break;
                    this.executeAction(AccessibleAction.REQUEST_FOCUS, new Object[0]);
                    return;
                }
                case NSAccessibilityDisclosingAttribute: {
                    MacVariant macVariant = MacAccessible.idToMacVariant(l2, 9);
                    if (macVariant == null) break;
                    if (macVariant.int1 != 0) {
                        this.executeAction(AccessibleAction.EXPAND, new Object[0]);
                        return;
                    }
                    this.executeAction(AccessibleAction.COLLAPSE, new Object[0]);
                    return;
                }
                case NSAccessibilityExpandedAttribute: {
                    if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) != AccessibleRole.COMBO_BOX) break;
                    this.executeAction(AccessibleAction.EXPAND, new Object[0]);
                    return;
                }
                case NSAccessibilitySelectedCellsAttribute: {
                    Object object = MacAccessible.idToMacVariant(l2, 1);
                    if (object == null || ((MacVariant)object).longArray == null || ((MacVariant)object).longArray.length <= 0) break;
                    long[] lArray = ((MacVariant)object).longArray;
                    object = FXCollections.observableArrayList();
                    for (long l4 : lArray) {
                        Object object2 = MacAccessible.GlassAccessibleToMacAccessible(l4);
                        if (object2 == null) continue;
                        Integer n2 = (Integer)((Accessible)object2).getAttribute(AccessibleAttribute.ROW_INDEX, new Object[0]);
                        object2 = (Integer)((Accessible)object2).getAttribute(AccessibleAttribute.COLUMN_INDEX, new Object[0]);
                        if (n2 == null || object2 == null || (object2 = (Node)this.getAttribute(AccessibleAttribute.CELL_AT_ROW_COLUMN, n2, object2)) == null) continue;
                        object.add(object2);
                    }
                    this.executeAction(AccessibleAction.SET_SELECTED_ITEMS, object);
                    return;
                }
                case NSAccessibilitySelectedRowsAttribute: {
                    Object object = MacAccessible.idToMacVariant(l2, 1);
                    if (object == null || ((MacVariant)object).longArray == null || ((MacVariant)object).longArray.length <= 0) break;
                    long[] lArray = ((MacVariant)object).longArray;
                    object = FXCollections.observableArrayList();
                    for (long l5 : lArray) {
                        Integer n3;
                        Object object3 = MacAccessible.GlassAccessibleToMacAccessible(l5);
                        if (object3 == null || (n3 = (Integer)((Accessible)object3).getAttribute(AccessibleAttribute.INDEX, new Object[0])) == null || (object3 = (Node)this.getAttribute(AccessibleAttribute.ROW_AT_INDEX, n3)) == null) continue;
                        object.add(object3);
                    }
                    this.executeAction(AccessibleAction.SET_SELECTED_ITEMS, object);
                    return;
                }
                case NSAccessibilitySelectedTextRangeAttribute: {
                    MacVariant macVariant = MacAccessible.idToMacVariant(l2, 18);
                    if (macVariant == null) break;
                    int n4 = macVariant.int1;
                    int n5 = macVariant.int1 + macVariant.int2;
                    this.executeAction(AccessibleAction.SET_TEXT_SELECTION, n4, n5);
                }
            }
        }
    }

    private long accessibilityIndexOfChild(long l2) {
        return -1L;
    }

    private long[] accessibilityParameterizedAttributeNames() {
        Application.checkEventThread();
        if (this.getView() != null) {
            return null;
        }
        AccessibleRole accessibleRole = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (accessibleRole != null) {
            ArrayList<MacAccessible$MacAttribute> arrayList = new ArrayList<MacAccessible$MacAttribute>();
            MacAccessible$MacRole macAccessible$MacRole = this.getRole(accessibleRole);
            if (macAccessible$MacRole != null && macAccessible$MacRole.macParameterizedAttributes != null) {
                arrayList.addAll(macAccessible$MacRole.macParameterizedAttributes);
            }
            switch (accessibleRole) {
                case LIST_VIEW: 
                case TREE_VIEW: {
                    arrayList.remove((Object)MacAccessible$MacAttribute.NSAccessibilityCellForColumnAndRowParameterizedAttribute);
                    break;
                }
                case COMBO_BOX: 
                case TEXT: 
                case TEXT_FIELD: 
                case TEXT_AREA: 
                case PASSWORD_FIELD: {
                    arrayList.addAll(TEXT_PARAMETRIZED_ATTRIBUTES);
                }
            }
            return arrayList.stream().mapToLong(macAccessible$MacAttribute -> macAccessible$MacAttribute.ptr).toArray();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private MacVariant accessibilityAttributeValueForParameter(long l2, long l3) {
        Object object;
        MacVariant macVariant;
        MacAccessible$MacAttribute macAccessible$MacAttribute;
        block23: {
            Application.checkEventThread();
            macAccessible$MacAttribute = MacAccessible$MacAttribute.getAttribute(l2);
            if (macAccessible$MacAttribute == null) return null;
            if (macAccessible$MacAttribute.inputType == 0) return null;
            if (macAccessible$MacAttribute.jfxAttr == null) {
                return null;
            }
            macVariant = MacAccessible.idToMacVariant(l3, macAccessible$MacAttribute.inputType);
            if (macVariant == null) {
                return null;
            }
            object = macVariant.getValue();
            switch (macAccessible$MacAttribute) {
                case NSAccessibilityCellForColumnAndRowParameterizedAttribute: {
                    int[] nArray = (int[])object;
                    object = this.getAttribute(macAccessible$MacAttribute.jfxAttr, nArray[1], nArray[0]);
                    break block23;
                }
                case NSAccessibilityLineForIndexParameterizedAttribute: {
                    if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.TEXT_AREA) break;
                    object = 0;
                    break block23;
                }
                case NSAccessibilityRangeForLineParameterizedAttribute: {
                    if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.TEXT_AREA) {
                        Integer n2 = (Integer)this.getAttribute(AccessibleAttribute.LINE_START, object);
                        object = (Integer)this.getAttribute(AccessibleAttribute.LINE_END, object);
                        if (n2 == null) return null;
                        if (object == null) return null;
                        object = new int[]{n2, (Integer)object - n2};
                        break block23;
                    } else {
                        String string = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                        object = new int[]{0, string != null ? string.length() : 0};
                    }
                    break block23;
                }
                case NSAccessibilityBoundsForRangeParameterizedAttribute: {
                    int[] nArray = (int[])object;
                    object = (Bounds[])this.getAttribute(macAccessible$MacAttribute.jfxAttr, nArray[0], nArray[0] + nArray[1] - 1);
                    double d2 = Double.POSITIVE_INFINITY;
                    double d3 = Double.POSITIVE_INFINITY;
                    double d4 = Double.NEGATIVE_INFINITY;
                    double d5 = Double.NEGATIVE_INFINITY;
                    if (object != null) {
                        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                            Object object2 = object[i2];
                            if (object2 == null) continue;
                            if (((Bounds)object2).getMinX() < d2) {
                                d2 = ((Bounds)object2).getMinX();
                            }
                            if (((Bounds)object2).getMinY() < d3) {
                                d3 = ((Bounds)object2).getMinY();
                            }
                            if (((Bounds)object2).getMaxX() > d4) {
                                d4 = ((Bounds)object2).getMaxX();
                            }
                            if (!(((Bounds)object2).getMaxY() > d5)) continue;
                            d5 = ((Bounds)object2).getMaxY();
                        }
                    }
                    object = this.flipBounds(new BoundingBox(d2, d3, d4 - d2, d5 - d3));
                    break block23;
                }
                case NSAccessibilityRangeForPositionParameterizedAttribute: {
                    float[] fArray = (float[])object;
                    object = (Integer)this.getAttribute(macAccessible$MacAttribute.jfxAttr, new Point2D(fArray[0], fArray[1]));
                    if (object == null) return null;
                    object = new int[]{(Integer)object, 1};
                    break block23;
                }
            }
            object = this.getAttribute(macAccessible$MacAttribute.jfxAttr, object);
        }
        if (object == null) {
            return null;
        }
        switch (macAccessible$MacAttribute) {
            case NSAccessibilityAttributedStringForRangeParameterizedAttribute: {
                MacVariant macVariant2;
                String string = (String)object;
                string = string.substring(macVariant.int1, macVariant.int1 + macVariant.int2);
                object = new ArrayList();
                Font font = (Font)this.getAttribute(AccessibleAttribute.FONT, new Object[0]);
                if (font != null) {
                    macVariant2 = new MacVariant();
                    new MacVariant().type = 8;
                    macVariant2.longArray = new long[]{MacAccessible$MacText.NSAccessibilityFontNameKey.ptr, MacAccessible$MacText.NSAccessibilityFontFamilyKey.ptr, MacAccessible$MacText.NSAccessibilityVisibleNameKey.ptr, MacAccessible$MacText.NSAccessibilityFontSizeKey.ptr};
                    macVariant2.variantArray = new MacVariant[]{MacVariant.createNSString(font.getName()), MacVariant.createNSString(font.getFamily()), MacVariant.createNSString(font.getName()), MacVariant.createNSNumberForDouble(font.getSize())};
                    macVariant2.key = MacAccessible$MacText.NSAccessibilityFontTextAttribute.ptr;
                    macVariant2.location = 0;
                    macVariant2.length = string.length();
                    object.add(macVariant2);
                }
                macVariant2 = macAccessible$MacAttribute.map.apply(string);
                macAccessible$MacAttribute.map.apply(string).variantArray = object.toArray(new MacVariant[0]);
                return macVariant2;
            }
            case NSAccessibilityStringForRangeParameterizedAttribute: {
                String string = (String)object;
                object = string.substring(macVariant.int1, macVariant.int1 + macVariant.int2);
                return macAccessible$MacAttribute.map.apply(object);
            }
            case NSAccessibilityCellForColumnAndRowParameterizedAttribute: {
                object = this.getNativeAccessible((Node)object);
                return macAccessible$MacAttribute.map.apply(object);
            }
        }
        return macAccessible$MacAttribute.map.apply(object);
    }

    private long[] accessibilityActionNames() {
        Application.checkEventThread();
        if (this.getView() != null) {
            return null;
        }
        AccessibleRole accessibleRole = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        ArrayList<MacAccessible$MacAction> arrayList = new ArrayList<MacAccessible$MacAction>();
        if (accessibleRole != null) {
            MacAccessible$MacRole macAccessible$MacRole = this.getRole(accessibleRole);
            if (macAccessible$MacRole != null && macAccessible$MacRole.macActions != null) {
                arrayList.addAll(macAccessible$MacRole.macActions);
            }
            if (accessibleRole != AccessibleRole.NODE && accessibleRole != AccessibleRole.PARENT) {
                arrayList.add(MacAccessible$MacAction.NSAccessibilityShowMenuAction);
            }
        }
        return arrayList.stream().mapToLong(macAccessible$MacAction -> macAccessible$MacAction.ptr).toArray();
    }

    private String accessibilityActionDescription(long l2) {
        return MacAccessible.NSAccessibilityActionDescription(l2);
    }

    private void accessibilityPerformAction(long l2) {
        AccessibleRole accessibleRole;
        MacAccessible$MacAction macAccessible$MacAction = MacAccessible$MacAction.getAction(l2);
        boolean bl2 = false;
        if (macAccessible$MacAction == MacAccessible$MacAction.NSAccessibilityPressAction && ((accessibleRole = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]))) == AccessibleRole.TITLED_PANE || accessibleRole == AccessibleRole.COMBO_BOX)) {
            bl2 = true;
        }
        if (macAccessible$MacAction == MacAccessible$MacAction.NSAccessibilityShowMenuAction && this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.SPLIT_MENU_BUTTON) {
            bl2 = true;
        }
        if (bl2) {
            if (Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.EXPANDED, new Object[0]))) {
                this.executeAction(AccessibleAction.COLLAPSE, new Object[0]);
                return;
            }
            this.executeAction(AccessibleAction.EXPAND, new Object[0]);
            return;
        }
        if (macAccessible$MacAction != null && macAccessible$MacAction.jfxAction != null) {
            this.executeAction(macAccessible$MacAction.jfxAction, new Object[0]);
        }
    }

    private long accessibilityFocusedUIElement() {
        Application.checkEventThread();
        Node node = (Node)this.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
        if (node == null) {
            return 0L;
        }
        Node node2 = (Node)this.getAccessible(node).getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0]);
        if (node2 != null) {
            return this.getNativeAccessible(node2);
        }
        return this.getNativeAccessible(node);
    }

    private boolean accessibilityIsIgnored() {
        Application.checkEventThread();
        if (this.isIgnored()) {
            return true;
        }
        if (this.isInSlider()) {
            return true;
        }
        if (this.isInMenu()) {
            AccessibleRole accessibleRole = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
            return !this.isMenuElement(accessibleRole);
        }
        return this.ignoreInnerText();
    }

    private long accessibilityHitTest(float f2, float f3) {
        Application.checkEventThread();
        Object object = this.getView();
        if (object == null || ((View)object).getWindow() == null) {
            return 0L;
        }
        object = ((View)object).getWindow().getScreen();
        f3 = (float)((Screen)object).getHeight() - f3;
        Node node = (Node)this.getAttribute(AccessibleAttribute.NODE_AT_POINT, new Point2D(f2, f3));
        return MacAccessible.NSAccessibilityUnignoredAncestor(this.getNativeAccessible(node));
    }

    static {
        MacAccessible._initIDs();
        if (!MacAccessible._initEnum("MacAttribute")) {
            System.err.println("Fail linking MacAttribute");
        }
        if (!MacAccessible._initEnum("MacAction")) {
            System.err.println("Fail linking MacAction");
        }
        if (!MacAccessible._initEnum("MacRole")) {
            System.err.println("Fail linking MacRole");
        }
        if (!MacAccessible._initEnum("MacSubrole")) {
            System.err.println("Fail linking MacSubrole");
        }
        if (!MacAccessible._initEnum("MacNotification")) {
            System.err.println("Fail linking MacNotification");
        }
        if (!MacAccessible._initEnum("MacOrientation")) {
            System.err.println("Fail linking MacOrientation");
        }
        if (!MacAccessible._initEnum("MacText")) {
            System.err.println("Fail linking MacText");
        }
        BASE_ATTRIBUTES = List.of(MacAccessible$MacAttribute.NSAccessibilityRoleAttribute, MacAccessible$MacAttribute.NSAccessibilityRoleDescriptionAttribute, MacAccessible$MacAttribute.NSAccessibilityHelpAttribute, MacAccessible$MacAttribute.NSAccessibilityFocusedAttribute, MacAccessible$MacAttribute.NSAccessibilityParentAttribute, MacAccessible$MacAttribute.NSAccessibilityChildrenAttribute, MacAccessible$MacAttribute.NSAccessibilityPositionAttribute, MacAccessible$MacAttribute.NSAccessibilitySizeAttribute, MacAccessible$MacAttribute.NSAccessibilityWindowAttribute, MacAccessible$MacAttribute.NSAccessibilityTopLevelUIElementAttribute, MacAccessible$MacAttribute.NSAccessibilityTitleUIElementAttribute);
        TEXT_ATTRIBUTES = List.of(MacAccessible$MacAttribute.NSAccessibilityEnabledAttribute, MacAccessible$MacAttribute.NSAccessibilityValueAttribute, MacAccessible$MacAttribute.NSAccessibilityNumberOfCharactersAttribute, MacAccessible$MacAttribute.NSAccessibilitySelectedTextAttribute, MacAccessible$MacAttribute.NSAccessibilitySelectedTextRangeAttribute, MacAccessible$MacAttribute.NSAccessibilityInsertionPointLineNumberAttribute, MacAccessible$MacAttribute.NSAccessibilityVisibleCharacterRangeAttribute);
        TEXT_PARAMETRIZED_ATTRIBUTES = List.of(MacAccessible$MacAttribute.NSAccessibilityLineForIndexParameterizedAttribute, MacAccessible$MacAttribute.NSAccessibilityRangeForLineParameterizedAttribute, MacAccessible$MacAttribute.NSAccessibilityAttributedStringForRangeParameterizedAttribute, MacAccessible$MacAttribute.NSAccessibilityStringForRangeParameterizedAttribute);
    }
}

