/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.Pixels;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;

final class MacRobot
extends GlassRobot {
    private long ptr;

    MacRobot() {
    }

    private native long _init();

    @Override
    public final void create() {
        Application.checkEventThread();
        this.ptr = this._init();
    }

    private native void _destroy(long var1);

    @Override
    public final void destroy() {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return;
        }
        MacRobot macRobot = this;
        macRobot._destroy(macRobot.ptr);
    }

    protected final native void _keyPress(int var1);

    @Override
    public final void keyPress(KeyCode keyCode) {
        Application.checkEventThread();
        this._keyPress(keyCode.getCode());
    }

    protected final native void _keyRelease(int var1);

    @Override
    public final void keyRelease(KeyCode keyCode) {
        Application.checkEventThread();
        this._keyRelease(keyCode.getCode());
    }

    private native void _mouseMove(long var1, float var3, float var4);

    @Override
    public final void mouseMove(double d2, double d3) {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return;
        }
        MacRobot macRobot = this;
        macRobot._mouseMove(macRobot.ptr, (float)d2, (float)d3);
    }

    private native void _mousePress(long var1, int var3);

    @Override
    public final void mousePress(MouseButton ... mouseButtonArray) {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return;
        }
        MacRobot macRobot = this;
        macRobot._mousePress(macRobot.ptr, GlassRobot.convertToRobotMouseButton(mouseButtonArray));
    }

    private native void _mouseRelease(long var1, int var3);

    @Override
    public final void mouseRelease(MouseButton ... mouseButtonArray) {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return;
        }
        MacRobot macRobot = this;
        macRobot._mouseRelease(macRobot.ptr, GlassRobot.convertToRobotMouseButton(mouseButtonArray));
    }

    protected final native void _mouseWheel(int var1);

    @Override
    public final void mouseWheel(int n2) {
        Application.checkEventThread();
        this._mouseWheel(n2);
    }

    private native float _getMouseX(long var1);

    @Override
    public final double getMouseX() {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return 0.0;
        }
        MacRobot macRobot = this;
        return macRobot._getMouseX(macRobot.ptr);
    }

    private native float _getMouseY(long var1);

    @Override
    public final double getMouseY() {
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return 0.0;
        }
        MacRobot macRobot = this;
        return macRobot._getMouseY(macRobot.ptr);
    }

    protected final native int _getPixelColor(double var1, double var3);

    @Override
    public final Color getPixelColor(double d2, double d3) {
        Application.checkEventThread();
        return GlassRobot.convertFromIntArgb(this._getPixelColor(d2, d3));
    }

    protected final native Pixels _getScreenCapture(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public final WritableImage getScreenCapture(WritableImage writableImage, double d2, double d3, double d4, double d5, boolean bl2) {
        Application.checkEventThread();
        int n2 = (int)d4;
        int n3 = (int)d5;
        if (n2 <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
        if (n2 >= Integer.MAX_VALUE / n3) {
            throw new IllegalArgumentException("invalid capture size");
        }
        Pixels pixels = this._getScreenCapture((int)d2, (int)d3, n2, n3, bl2);
        return MacRobot.convertFromPixels(writableImage, pixels);
    }
}

