/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.SystemClipboard;
import com.sun.glass.ui.mac.MacPasteboard;
import com.sun.glass.ui.mac.MacSystemClipboard$FormatEncoder;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class MacSystemClipboard
extends SystemClipboard {
    static final String FILE_SCHEME = "file";
    private static final String BAD_URI_MSG = "bad URI in com.sun.glass.ui.mac.MacSystemClipboard for file: ";
    private static final String BAD_URL_MSG = "bad URL in com.sun.glass.ui.mac.MacSystemClipboard for file: ";
    static final boolean SUPPORT_10_5_API = true;
    static final boolean SUPPORT_10_5_API_FORCE = false;
    static final boolean SUPPORT_10_6_API = false;
    long seed = 0L;
    final MacPasteboard pasteboard;

    public MacSystemClipboard(String string) {
        super(string);
        switch (string) {
            case "DND": {
                this.pasteboard = new MacPasteboard(2);
                return;
            }
            case "SYSTEM": {
                this.pasteboard = new MacPasteboard(1);
                return;
            }
        }
        this.pasteboard = new MacPasteboard(string);
    }

    @Override
    protected boolean isOwner() {
        return this.seed == this.pasteboard.getSeed();
    }

    @Override
    protected int supportedSourceActionsFromSystem() {
        return this.pasteboard.getAllowedOperation();
    }

    @Override
    protected void pushTargetActionToSystem(int n2) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void pushToSystem(HashMap<String, Object> hashMap, int n2) {
        HashMap<String, byte[]> hashMap2 = null;
        HashMap[] hashMapArray = null;
        block19: for (String[] stringArray : hashMap.keySet()) {
            List<HashMap<String, Object>> list = hashMap.get(stringArray);
            if (list == null) continue;
            switch (stringArray) {
                case "text/uri-list": {
                    Object object = this.putToItemList(((String)((Object)list)).split("\n"), true);
                    if (object.isEmpty()) continue block19;
                    hashMapArray = new HashMap[object.size()];
                    object.toArray(hashMapArray);
                    continue block19;
                }
                case "application/x-java-rawimage": 
                case "application/x-java-drag-image": {
                    Object object = null;
                    if (list instanceof Pixels) {
                        object = (Pixels)((Object)list);
                    } else if (list instanceof ByteBuffer) {
                        try {
                            list = (ByteBuffer)((Object)list);
                            ((ByteBuffer)((Object)list)).rewind();
                            object = Application.GetApplication().createPixels(((ByteBuffer)((Object)list)).getInt(), ((ByteBuffer)((Object)list)).getInt(), ((ByteBuffer)((Object)list)).slice());
                        }
                        catch (Exception exception) {}
                    } else if (list instanceof IntBuffer) {
                        try {
                            list = (IntBuffer)((Object)list);
                            ((IntBuffer)((Object)list)).rewind();
                            object = Application.GetApplication().createPixels(((IntBuffer)((Object)list)).get(), ((IntBuffer)((Object)list)).get(), ((IntBuffer)((Object)list)).slice());
                        }
                        catch (Exception exception) {}
                    } else {
                        throw new RuntimeException(list.getClass().getName() + " cannot be converted to Pixels");
                    }
                    if (object == null) continue block19;
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap();
                    }
                    hashMap2.put(MacSystemClipboard$FormatEncoder.mimeToUtf((String)stringArray), (byte[])object);
                    continue block19;
                }
                case "text/plain": 
                case "text/html": 
                case "text/rtf": {
                    Object object;
                    if (list instanceof String) {
                        object = (String)((Object)list);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap2.put(MacSystemClipboard$FormatEncoder.mimeToUtf((String)stringArray), (byte[])object);
                        continue block19;
                    }
                    System.err.println("DelayedCallback not implemented yet: RT-14593");
                    Thread.dumpStack();
                    continue block19;
                }
                case "application/x-java-file-list": {
                    void var6_8;
                    Object object = (String[])list;
                    if (hashMap.get("text/uri-list") == null) {
                        list = this.putToItemList((String[])object, true);
                        if (list.isEmpty()) continue block19;
                        hashMapArray = new HashMap[list.size()];
                        list.toArray(hashMapArray);
                        continue block19;
                    }
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap();
                    }
                    list = null;
                    boolean i2 = false;
                    while (var6_8 < ((String[])object).length) {
                        String string = object[var6_8];
                        string = FileSystems.getDefault().getPath(string, new String[0]).toUri().toASCIIString();
                        if (list == null) {
                            list = new StringBuilder();
                        }
                        ((StringBuilder)((Object)list)).append(string);
                        if (var6_8 < ((String[])object).length - 1) {
                            ((StringBuilder)((Object)list)).append("\n");
                        }
                        ++var6_8;
                    }
                    if (list == null || hashMap2.get("public.utf8-plain-text") != null) continue block19;
                    hashMap2.remove("public.utf8-plain-text");
                    hashMap2.put("public.utf8-plain-text", (byte[])((StringBuilder)((Object)list)).toString());
                    continue block19;
                }
            }
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, byte[]>();
            }
            hashMap2.put(MacSystemClipboard$FormatEncoder.mimeToUtf((String)stringArray), this.serialize(list));
        }
        if (hashMap2 != null) {
            if (hashMapArray == null || hashMapArray.length == 0) {
                HashMap[] hashMapArray2 = new HashMap[1];
                hashMapArray = hashMapArray2;
                hashMapArray2[0] = hashMap2;
            } else {
                hashMapArray[0].putAll(hashMap2);
            }
        }
        if (hashMapArray != null) {
            this.seed = this.pasteboard.putItems(hashMapArray, n2);
        }
    }

    @Override
    protected Object popFromSystem(String object) {
        String[][] stringArray = this.pasteboard.getUTFs();
        if (stringArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = object;
        int n2 = -1;
        switch (((String)((Object)arrayList)).hashCode()) {
            case 1678854698: {
                if (!((String)((Object)arrayList)).equals("application/x-java-rawimage")) break;
                n2 = 0;
                break;
            }
            case 817335912: {
                if (!((String)((Object)arrayList)).equals("text/plain")) break;
                n2 = 1;
                break;
            }
            case -1082243251: {
                if (!((String)((Object)arrayList)).equals("text/html")) break;
                n2 = 2;
                break;
            }
            case -1004732798: {
                if (!((String)((Object)arrayList)).equals("text/rtf")) break;
                n2 = 3;
                break;
            }
            case -1882575103: {
                if (!((String)((Object)arrayList)).equals("text/uri-list")) break;
                n2 = 4;
                break;
            }
            case 431188280: {
                if (!((String)((Object)arrayList)).equals("application/x-java-file-list")) break;
                n2 = 5;
            }
        }
        switch (n2) {
            case 0: {
                arrayList = new ArrayList();
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    byte[] byArray = this.pasteboard.getItemAsRawImage(n2);
                    if (byArray == null) continue;
                    object = this.getPixelsForRawImage(byArray);
                    arrayList.add(object);
                    break;
                }
                return this.getObjectFromList(arrayList);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                arrayList = new ArrayList<Object>();
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    String string = this.pasteboard.getItemStringForUTF(n2, MacSystemClipboard$FormatEncoder.mimeToUtf((String)object));
                    if (string == null) continue;
                    arrayList.add(string);
                    break;
                }
                return this.getObjectFromList(arrayList);
            }
            case 5: {
                arrayList = new ArrayList();
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    String string = this.pasteboard.getItemStringForUTF(n2, "public.file-url");
                    if (string == null) continue;
                    arrayList.add(MacSystemClipboard._convertFileReferencePath(string));
                }
                String[] stringArray2 = null;
                if (arrayList.size() > 0) {
                    stringArray2 = new String[arrayList.size()];
                    arrayList.toArray(stringArray2);
                }
                return stringArray2;
            }
        }
        arrayList = new ArrayList();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            byte[] byArray = this.pasteboard.getItemBytesForUTF(n2, MacSystemClipboard$FormatEncoder.mimeToUtf((String)object));
            if (byArray == null) continue;
            object = ByteBuffer.wrap(byArray);
            arrayList.add(object);
            break;
        }
        return this.getObjectFromList(arrayList);
    }

    private Object getObjectFromList(List<?> list) {
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    protected String[] mimesFromSystem() {
        String[][] stringArray = this.pasteboard.getUTFs();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (String[] stringArray2 : stringArray) {
                if (stringArray2 == null) continue;
                int n2 = stringArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = stringArray2[i2];
                    if ((string = MacSystemClipboard$FormatEncoder.utfToMime(string)) == null || arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray((T[])stringArray);
        return stringArray;
    }

    @Override
    public String toString() {
        return "Mac OS X " + this.pasteboard.getName() + " Clipboard";
    }

    private URI createUri(String string, String string2) {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println(string2 + string);
            Thread.dumpStack();
        }
        return uRI;
    }

    private HashMap<String, Object> getItemFromURIString(String hashMap) {
        String string;
        String string2 = null;
        if (((String)((Object)hashMap)).indexOf(58) == -1) {
            string = "public.file-url";
            string2 = FileSystems.getDefault().getPath((String)((Object)hashMap), new String[0]).toUri().toASCIIString();
        } else {
            string = "public.url";
            if ((hashMap = this.createUri((String)((Object)hashMap), BAD_URI_MSG)) != null) {
                string2 = ((URI)((Object)hashMap)).toASCIIString();
            }
        }
        if (string2 != null) {
            hashMap = new HashMap<String, Object>();
            hashMap.put(string, string2);
            return hashMap;
        }
        return null;
    }

    private List<HashMap<String, Object>> putToItemList(String[] stringArray, boolean bl2) {
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        for (String string : stringArray) {
            HashMap<String, Object> hashMap;
            if (bl2 && string.startsWith("#") || (hashMap = this.getItemFromURIString(string)) == null) continue;
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private static native String _convertFileReferencePath(String var0);

    private byte[] serialize(Object object) {
        if (object instanceof String) {
            object = (String)object;
            return ((String)object).getBytes();
        }
        if (object instanceof ByteBuffer) {
            object = (ByteBuffer)object;
            return ((ByteBuffer)object).array();
        }
        throw new RuntimeException("can not handle " + String.valueOf(object));
    }
}

