/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.LauncherImpl$1;
import com.sun.javafx.application.ModuleAccess;
import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.application.PlatformImpl$FinishListener;
import com.sun.javafx.stage.StageHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javafx.application.Application;
import javafx.application.Preloader;
import javafx.application.Preloader$ErrorNotification;
import javafx.application.Preloader$PreloaderNotification;
import javafx.application.Preloader$ProgressNotification;
import javafx.application.Preloader$StateChangeNotification;
import javafx.application.Preloader$StateChangeNotification$Type;
import javafx.stage.Stage;

public class LauncherImpl {
    public static final String LAUNCH_MODE_CLASS = "LM_CLASS";
    public static final String LAUNCH_MODE_JAR = "LM_JAR";
    public static final String LAUNCH_MODE_MODULE = "LM_MODULE";
    private static final boolean trace = false;
    private static final boolean verbose = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.verbose"));
    private static final String MF_MAIN_CLASS = "Main-Class";
    private static final String MF_JAVAFX_MAIN = "JavaFX-Application-Class";
    private static final String MF_JAVAFX_PRELOADER = "JavaFX-Preloader-Class";
    private static final String MF_JAVAFX_CLASS_PATH = "JavaFX-Class-Path";
    private static final String MF_JAVAFX_ARGUMENT_PREFIX = "JavaFX-Argument-";
    private static final String MF_JAVAFX_PARAMETER_NAME_PREFIX = "JavaFX-Parameter-Name-";
    private static final String MF_JAVAFX_PARAMETER_VALUE_PREFIX = "JavaFX-Parameter-Value-";
    private static final boolean simulateSlowProgress = false;
    private static AtomicBoolean launchCalled = new AtomicBoolean(false);
    private static final AtomicBoolean toolkitStarted = new AtomicBoolean(false);
    private static volatile RuntimeException launchException = null;
    private static Preloader currentPreloader = null;
    private static Class<? extends Preloader> savedPreloaderClass = null;
    private static ClassLoader savedMainCcl = null;
    private static volatile boolean error = false;
    private static volatile Throwable pConstructorError = null;
    private static volatile Throwable pInitError = null;
    private static volatile Throwable pStartError = null;
    private static volatile Throwable pStopError = null;
    private static volatile Throwable constructorError = null;
    private static volatile Throwable initError = null;
    private static volatile Throwable startError = null;
    private static volatile Throwable stopError = null;

    public static void launchApplication(Class<? extends Application> clazz, String[] stringArray) {
        String string;
        Class<Preloader> clazz2 = savedPreloaderClass;
        if (clazz2 == null && (string = AccessController.doPrivileged(() -> System.getProperty("javafx.preloader"))) != null) {
            try {
                clazz2 = Class.forName(string, false, clazz.getClassLoader());
            }
            catch (Exception exception) {
                System.err.printf("Could not load preloader class '" + string + "', continuing without preloader.", new Object[0]);
                exception.printStackTrace();
            }
        }
        LauncherImpl.launchApplication(clazz, clazz2, stringArray);
    }

    public static void launchApplication(Class<? extends Application> object, Class<? extends Preloader> clazz, String[] stringArray) {
        if (com.sun.glass.ui.Application.isEventThread()) {
            throw new IllegalStateException("Application launch must not be called on the JavaFX Application Thread");
        }
        if (launchCalled.getAndSet(true)) {
            throw new IllegalStateException("Application launch must not be called more than once");
        }
        if (!Application.class.isAssignableFrom((Class<?>)object)) {
            throw new IllegalArgumentException("Error: " + ((Class)object).getName() + " is not a subclass of javafx.application.Application");
        }
        if (clazz != null && !Preloader.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Error: " + clazz.getName() + " is not a subclass of javafx.application.Preloader");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        object = new Thread(() -> {
            try {
                LauncherImpl.launchApplication1(object, clazz, stringArray);
                return;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                launchException = runtimeException;
                return;
            }
            catch (Exception exception) {
                launchException = new RuntimeException("Application launch exception", exception);
                return;
            }
            catch (Error error) {
                launchException = new RuntimeException("Application launch error", error);
                return;
            }
            finally {
                countDownLatch.countDown();
            }
        });
        ((Thread)object).setName("JavaFX-Launcher");
        ((Thread)object).start();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Unexpected exception: ", interruptedException);
        }
        if (launchException != null) {
            throw launchException;
        }
    }

    public static void launchApplication(String optional, String object, String[] stringArray) {
        Object object2;
        if (verbose) {
            System.err.println("JavaFX launchApplication method: launchMode=" + (String)object);
        }
        String string = null;
        String string2 = null;
        String[] stringArray2 = stringArray;
        ClassLoader classLoader = null;
        ModuleAccess moduleAccess = null;
        if (((String)object).equals(LAUNCH_MODE_JAR)) {
            object = LauncherImpl.getJarAttributes((String)((Object)optional));
            if (object == null) {
                LauncherImpl.abort(null, "Can't get manifest attributes from jar", new Object[0]);
            }
            if ((object2 = ((Attributes)object).getValue(MF_JAVAFX_CLASS_PATH)) != null && ((String)object2).trim().length() != 0) {
                if (verbose) {
                    System.err.println("WARNING: Application jar uses deprecated JavaFX-Class-Path attribute. Please use Class-Path instead.");
                }
                classLoader = LauncherImpl.setupJavaFXClassLoader(new File((String)((Object)optional)), (String)object2);
            }
            if (stringArray.length == 0) {
                stringArray2 = LauncherImpl.getAppArguments((Attributes)object);
            }
            if ((string = ((Attributes)object).getValue(MF_JAVAFX_MAIN)) == null && (string = ((Attributes)object).getValue(MF_MAIN_CLASS)) == null) {
                LauncherImpl.abort(null, "JavaFX jar manifest requires a valid JavaFX-Appliation-Class or Main-Class entry", new Object[0]);
            }
            string = string.trim();
            string2 = ((Attributes)object).getValue(MF_JAVAFX_PRELOADER);
            if (string2 != null) {
                string2 = string2.trim();
            }
        } else if (((String)object).equals(LAUNCH_MODE_CLASS)) {
            string = optional;
        } else if (((String)object).equals(LAUNCH_MODE_MODULE)) {
            int n2 = ((String)((Object)optional)).indexOf(47);
            if (n2 == -1) {
                object2 = optional;
                string = null;
            } else {
                object2 = ((String)((Object)optional)).substring(0, n2);
                string = ((String)((Object)optional)).substring(n2 + 1);
            }
            moduleAccess = ModuleAccess.load((String)object2);
            if (string == null) {
                optional = moduleAccess.getDescriptor().mainClass();
                if (!optional.isPresent()) {
                    LauncherImpl.abort(null, "Module %1$s does not have a MainClass attribute, use -m <module>/<main-class>", object2);
                }
                string = (String)optional.get();
            }
        } else {
            LauncherImpl.abort(new IllegalArgumentException("The launchMode argument must be one of LM_CLASS, LM_JAR or LM_MODULE"), "Invalid launch mode: %1$s", object);
        }
        if (string2 == null) {
            string2 = System.getProperty("javafx.preloader");
        }
        if (string == null) {
            LauncherImpl.abort(null, "No main JavaFX class to launch", new Object[0]);
        }
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(LauncherImpl.class.getName());
                object2 = clazz.getMethod("launchApplicationWithArgs", ModuleAccess.class, String.class, String.class, new String[0].getClass());
                Thread.currentThread().setContextClassLoader(classLoader);
                ((Method)object2).invoke(null, null, string, string2, stringArray2);
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                LauncherImpl.abort(exception, "Exception while launching application", new Object[0]);
                return;
            }
        }
        LauncherImpl.launchApplicationWithArgs(moduleAccess, string, string2, stringArray2);
    }

    private static Class<?> loadClass(ModuleAccess moduleAccess, String string) {
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (moduleAccess != null) {
            clazz = moduleAccess.classForName(string);
        } else {
            try {
                clazz = Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
        }
        if (clazz == null && PlatformUtil.isMac() && Normalizer.isNormalized(string, Normalizer.Form.NFD)) {
            string = Normalizer.normalize(string, Normalizer.Form.NFC);
            if (moduleAccess != null) {
                clazz = moduleAccess.classForName(string);
            } else {
                try {
                    clazz = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
            }
        }
        return clazz;
    }

    public static void launchApplicationWithArgs(ModuleAccess object, String object2, String object3, String[] stringArray) {
        Class<Application> clazz;
        try {
            LauncherImpl.startToolkit();
        }
        catch (InterruptedException interruptedException) {
            clazz = interruptedException;
            LauncherImpl.abort(interruptedException, "Toolkit initialization error", object2);
        }
        clazz = new AtomicReference();
        AtomicReference atomicReference = new AtomicReference();
        PlatformImpl.runAndWait(() -> LauncherImpl.lambda$launchApplicationWithArgs$3((ModuleAccess)object, (String)object2, (AtomicReference)((Object)clazz), (String)object3, atomicReference));
        object = (Class)atomicReference.get();
        object2 = (Class)((AtomicReference)((Object)clazz)).get();
        savedPreloaderClass = object;
        try {
            clazz = ((Class)object2).getMethod("main", new String[0].getClass());
            if (verbose) {
                System.err.println("Calling main(String[]) method");
            }
            savedMainCcl = Thread.currentThread().getContextClassLoader();
            ((Method)((Object)clazz)).invoke(null, new Object[]{stringArray});
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            clazz = reflectiveOperationException;
            object3 = reflectiveOperationException;
            savedPreloaderClass = null;
            if (verbose) {
                System.err.println("WARNING: Cannot access application main method: " + String.valueOf(clazz));
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            clazz = invocationTargetException;
            invocationTargetException.printStackTrace();
            LauncherImpl.abort(null, "Exception running application %1$s", ((Class)object2).getName());
            return;
        }
        if (!Application.class.isAssignableFrom((Class<?>)object2)) {
            LauncherImpl.abort((Throwable)object3, "JavaFX application class %1$s does not extend javafx.application.Application", ((Class)object2).getName());
        }
        clazz = ((Class)object2).asSubclass(Application.class);
        if (verbose) {
            System.err.println("Launching application directly");
        }
        LauncherImpl.launchApplication(clazz, (Class<? extends Preloader>)object, stringArray);
    }

    private static URL fileToURL(File file) throws IOException {
        return file.getCanonicalFile().toURI().toURL();
    }

    private static ClassLoader setupJavaFXClassLoader(File file, String string) {
        try {
            Object object;
            file = file.getParentFile();
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (string != null) {
                while (string.length() > 0) {
                    String string2;
                    int n2 = string.indexOf(" ");
                    if (n2 < 0) {
                        string2 = string;
                        object = file == null ? new File(string2) : new File(file, string2);
                        if (((File)object).exists()) {
                            arrayList.add(LauncherImpl.fileToURL((File)object));
                            break;
                        }
                        if (!verbose) break;
                        System.err.println("Class Path entry \"" + string2 + "\" does not exist, ignoring");
                        break;
                    }
                    if (n2 > 0) {
                        string2 = string.substring(0, n2);
                        object = file == null ? new File(string2) : new File(file, string2);
                        if (((File)object).exists()) {
                            arrayList.add(LauncherImpl.fileToURL((File)object));
                        } else if (verbose) {
                            System.err.println("Class Path entry \"" + string2 + "\" does not exist, ignoring");
                        }
                    }
                    string = string.substring(n2 + 1);
                }
            }
            if (!arrayList.isEmpty()) {
                ArrayList<URL> arrayList2 = new ArrayList<URL>();
                string = System.getProperty("java.class.path");
                if (string != null) {
                    while (string.length() > 0) {
                        int n3 = string.indexOf(File.pathSeparatorChar);
                        if (n3 < 0) {
                            object = string;
                            arrayList2.add(LauncherImpl.fileToURL(new File((String)object)));
                            break;
                        }
                        if (n3 > 0) {
                            object = string.substring(0, n3);
                            arrayList2.add(LauncherImpl.fileToURL(new File((String)object)));
                        }
                        string = string.substring(n3 + 1);
                    }
                }
                arrayList2.addAll(arrayList);
                URL[] uRLArray = arrayList2.toArray(new URL[0]);
                if (verbose) {
                    System.err.println("===== URL list");
                    for (int i2 = 0; i2 < uRLArray.length; ++i2) {
                        System.err.println(String.valueOf(uRLArray[i2]));
                    }
                    System.err.println("=====");
                }
                return new URLClassLoader(uRLArray, ClassLoader.getPlatformClassLoader());
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static String decodeBase64(String string) {
        return new String(Base64.getDecoder().decode(string));
    }

    private static String[] getAppArguments(Attributes attributes) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n2 = 1;
        String string = MF_JAVAFX_ARGUMENT_PREFIX;
        while (attributes.getValue(string + n2) != null) {
            linkedList.add(LauncherImpl.decodeBase64(attributes.getValue(string + n2)));
            ++n2;
        }
        string = MF_JAVAFX_PARAMETER_NAME_PREFIX;
        String string2 = MF_JAVAFX_PARAMETER_VALUE_PREFIX;
        n2 = 1;
        while (attributes.getValue(string + n2) != null) {
            String string3 = LauncherImpl.decodeBase64(attributes.getValue(string + n2));
            String string4 = null;
            if (attributes.getValue(string2 + n2) != null) {
                string4 = LauncherImpl.decodeBase64(attributes.getValue(string2 + n2));
            }
            linkedList.add("--" + string3 + "=" + (string4 != null ? string4 : ""));
            ++n2;
        }
        return linkedList.toArray(new String[0]);
    }

    private static void abort(Throwable object, String string, Object ... objectArray) {
        object = String.format(string, objectArray);
        if (object != null) {
            System.err.println((String)object);
        }
        System.exit(1);
    }

    /*
     * Loose catch block
     */
    private static Attributes getJarAttributes(String string) {
        ZipFile zipFile = null;
        zipFile = new JarFile(string);
        Cloneable cloneable = ((JarFile)zipFile).getManifest();
        if (cloneable == null) {
            LauncherImpl.abort(null, "No manifest in jar file %1$s", string);
        }
        cloneable = cloneable.getMainAttributes();
        try {
            zipFile.close();
        }
        catch (IOException iOException) {}
        return cloneable;
        catch (IOException iOException) {
            try {
                IOException iOException2 = iOException;
                LauncherImpl.abort(iOException, "Error launching jar file %1%s", string);
            }
            catch (Throwable throwable) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException3) {}
                throw throwable;
            }
            try {
                zipFile.close();
            }
            catch (IOException iOException4) {}
        }
        return null;
    }

    private static void startToolkit() throws InterruptedException {
        if (toolkitStarted.getAndSet(true)) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        PlatformImpl.startup(() -> countDownLatch.countDown());
        countDownLatch.await();
    }

    private static void launchApplication1(Class<? extends Application> clazz, Class<? extends Preloader> object, String[] object2) throws Exception {
        Object object3;
        LauncherImpl.startToolkit();
        if (savedMainCcl != null && (object3 = Thread.currentThread().getContextClassLoader()) != null && object3 != savedMainCcl) {
            PlatformImpl.runLater(() -> LauncherImpl.lambda$launchApplication1$5((ClassLoader)object3));
        }
        object3 = new AtomicBoolean(false);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
        new AtomicBoolean(false);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object4 = new CountDownLatch(1);
        object4 = new LauncherImpl$1(atomicBoolean, countDownLatch, (AtomicBoolean)object3, (CountDownLatch)object4, atomicBoolean2);
        PlatformImpl.addListener((PlatformImpl$FinishListener)object4);
        try {
            AtomicReference atomicReference = new AtomicReference();
            if (object != null) {
                PlatformImpl.runAndWait(() -> LauncherImpl.lambda$launchApplication1$6(object, atomicReference, (String[])object2));
            }
            if ((currentPreloader = (Preloader)atomicReference.get()) != null && !error && !atomicBoolean2.get()) {
                try {
                    currentPreloader.init();
                }
                catch (Throwable throwable) {
                    System.err.println("Exception in Preloader init method");
                    pInitError = throwable;
                    error = true;
                }
            }
            if (currentPreloader != null && !error && !atomicBoolean2.get()) {
                PlatformImpl.runAndWait(() -> LauncherImpl.lambda$launchApplication1$7((AtomicBoolean)object3));
                if (!error && !atomicBoolean2.get()) {
                    LauncherImpl.notifyProgress(currentPreloader, 0.0);
                }
            }
            object = new AtomicReference();
            if (!error && !atomicBoolean2.get()) {
                if (currentPreloader != null) {
                    LauncherImpl.notifyProgress(currentPreloader, 1.0);
                    LauncherImpl.notifyStateChange(currentPreloader, Preloader$StateChangeNotification$Type.BEFORE_LOAD, null);
                }
                PlatformImpl.runAndWait(() -> LauncherImpl.lambda$launchApplication1$8(clazz, (AtomicReference)object, (String[])object2));
            }
            object = (Application)((AtomicReference)object).get();
            if (!error && !atomicBoolean2.get()) {
                if (currentPreloader != null) {
                    LauncherImpl.notifyStateChange(currentPreloader, Preloader$StateChangeNotification$Type.BEFORE_INIT, (Application)object);
                }
                try {
                    ((Application)object).init();
                }
                catch (Throwable throwable) {
                    System.err.println("Exception in Application init method");
                    initError = throwable;
                    error = true;
                }
            }
            if (!error && !atomicBoolean2.get()) {
                if (currentPreloader != null) {
                    LauncherImpl.notifyStateChange(currentPreloader, Preloader$StateChangeNotification$Type.BEFORE_START, (Application)object);
                }
                PlatformImpl.runAndWait(() -> LauncherImpl.lambda$launchApplication1$9(atomicBoolean, (Application)object));
            }
            if (!error) {
                countDownLatch.await();
            }
            if (atomicBoolean.get()) {
                PlatformImpl.runAndWait(() -> LauncherImpl.lambda$launchApplication1$10((Application)object));
            }
            if (error) {
                if (pConstructorError != null) {
                    throw new RuntimeException("Unable to construct Preloader instance: " + String.valueOf(clazz), pConstructorError);
                }
                if (pInitError != null) {
                    throw new RuntimeException("Exception in Preloader init method", pInitError);
                }
                if (pStartError != null) {
                    throw new RuntimeException("Exception in Preloader start method", pStartError);
                }
                if (pStopError != null) {
                    throw new RuntimeException("Exception in Preloader stop method", pStopError);
                }
                if (constructorError != null) {
                    object2 = "Unable to construct Application instance: " + String.valueOf(clazz);
                    if (!LauncherImpl.notifyError((String)object2, constructorError)) {
                        throw new RuntimeException((String)object2, constructorError);
                    }
                } else if (initError != null) {
                    object2 = "Exception in Application init method";
                    if (!LauncherImpl.notifyError("Exception in Application init method", initError)) {
                        throw new RuntimeException((String)object2, initError);
                    }
                } else if (startError != null) {
                    object2 = "Exception in Application start method";
                    if (!LauncherImpl.notifyError("Exception in Application start method", startError)) {
                        throw new RuntimeException((String)object2, startError);
                    }
                } else if (stopError != null) {
                    object2 = "Exception in Application stop method";
                    if (!LauncherImpl.notifyError("Exception in Application stop method", stopError)) {
                        throw new RuntimeException((String)object2, stopError);
                    }
                }
            }
            return;
        }
        finally {
            PlatformImpl.removeListener((PlatformImpl$FinishListener)object4);
            PlatformImpl.tkExit();
        }
    }

    private static void notifyStateChange(Preloader preloader, Preloader$StateChangeNotification$Type preloader$StateChangeNotification$Type, Application application) {
        PlatformImpl.runAndWait(() -> preloader.handleStateChangeNotification(new Preloader$StateChangeNotification(preloader$StateChangeNotification$Type, application)));
    }

    private static void notifyProgress(Preloader preloader, double d2) {
        PlatformImpl.runAndWait(() -> preloader.handleProgressNotification(new Preloader$ProgressNotification(d2)));
    }

    private static boolean notifyError(String string, Throwable throwable) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        PlatformImpl.runAndWait(() -> {
            if (currentPreloader != null) {
                try {
                    string = new Preloader$ErrorNotification(null, string, throwable);
                    boolean bl2 = currentPreloader.handleErrorNotification((Preloader$ErrorNotification)((Object)string));
                    atomicBoolean.set(bl2);
                    return;
                }
                catch (Throwable throwable2) {
                    string = throwable2;
                    throwable2.printStackTrace();
                }
            }
        });
        return atomicBoolean.get();
    }

    private static void notifyCurrentPreloader(Preloader$PreloaderNotification preloader$PreloaderNotification) {
        PlatformImpl.runAndWait(() -> {
            if (currentPreloader != null) {
                currentPreloader.handleApplicationNotification(preloader$PreloaderNotification);
            }
        });
    }

    public static void notifyPreloader(Application application, Preloader$PreloaderNotification preloader$PreloaderNotification) {
        if (launchCalled.get()) {
            LauncherImpl.notifyCurrentPreloader(preloader$PreloaderNotification);
            return;
        }
    }

    private LauncherImpl() {
        throw new InternalError();
    }

    private static /* synthetic */ void lambda$launchApplication1$10(Application application) {
        try {
            application.stop();
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Exception in Application stop method");
            stopError = throwable;
            error = true;
            return;
        }
    }

    private static /* synthetic */ void lambda$launchApplication1$9(AtomicBoolean object, Application application) {
        try {
            ((AtomicBoolean)object).set(true);
            object = new Stage();
            StageHelper.setPrimary((Stage)object, true);
            application.start((Stage)object);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Exception in Application start method");
            startError = throwable;
            error = true;
            return;
        }
    }

    private static /* synthetic */ void lambda$launchApplication1$8(Class clazz, AtomicReference atomicReference, String[] stringArray) {
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            atomicReference.set((Application)constructor.newInstance(new Object[0]));
            ParametersImpl.registerParameters((Application)atomicReference.get(), new ParametersImpl(stringArray));
            PlatformImpl.setApplicationName(clazz);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Exception in Application constructor");
            constructorError = throwable;
            error = true;
            return;
        }
    }

    private static /* synthetic */ void lambda$launchApplication1$7(AtomicBoolean object) {
        try {
            ((AtomicBoolean)object).set(true);
            object = new Stage();
            StageHelper.setPrimary((Stage)object, true);
            currentPreloader.start((Stage)object);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Exception in Preloader start method");
            pStartError = throwable;
            error = true;
            return;
        }
    }

    private static /* synthetic */ void lambda$launchApplication1$6(Class genericDeclaration, AtomicReference atomicReference, String[] stringArray) {
        try {
            genericDeclaration = ((Class)genericDeclaration).getConstructor(new Class[0]);
            atomicReference.set((Preloader)((Constructor)genericDeclaration).newInstance(new Object[0]));
            ParametersImpl.registerParameters((Application)atomicReference.get(), new ParametersImpl(stringArray));
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Exception in Preloader constructor");
            pConstructorError = throwable;
            error = true;
            return;
        }
    }

    private static /* synthetic */ void lambda$launchApplication1$5(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private static /* synthetic */ void lambda$launchApplicationWithArgs$3(ModuleAccess moduleAccess, String string, AtomicReference atomicReference, String string2, AtomicReference atomicReference2) {
        Class<?> clazz = LauncherImpl.loadClass(moduleAccess, string);
        if (clazz == null) {
            if (moduleAccess != null) {
                LauncherImpl.abort(null, "Missing JavaFX application class %1$s in module %2$s", string, moduleAccess.getName());
            } else {
                LauncherImpl.abort(null, "Missing JavaFX application class %1$s", string);
            }
        }
        atomicReference.set(clazz);
        if (string2 != null) {
            clazz = LauncherImpl.loadClass(null, string2);
            if (clazz == null) {
                LauncherImpl.abort(null, "Missing JavaFX preloader class %1$s", string2);
            }
            if (!Preloader.class.isAssignableFrom(clazz)) {
                LauncherImpl.abort(null, "JavaFX preloader class %1$s does not extend javafx.application.Preloader", clazz.getName());
            }
            atomicReference2.set(clazz.asSubclass(Preloader.class));
        }
    }
}

