/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ElementObserver$ElementsMapElement;
import java.util.IdentityHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableListBase;
import javafx.util.Callback;

final class ElementObserver<E> {
    private Callback<E, Observable[]> extractor;
    private final Callback<E, InvalidationListener> listenerGenerator;
    private final ObservableListBase<E> list;
    private IdentityHashMap<E, ElementObserver$ElementsMapElement> elementsMap = new IdentityHashMap();

    ElementObserver(Callback<E, Observable[]> callback, Callback<E, InvalidationListener> callback2, ObservableListBase<E> observableListBase) {
        this.extractor = callback;
        this.listenerGenerator = callback2;
        this.list = observableListBase;
    }

    final void attachListener(E e2) {
        if (this.elementsMap != null && e2 != null) {
            if (this.elementsMap.containsKey(e2)) {
                this.elementsMap.get(e2).increment();
                return;
            }
            InvalidationListener invalidationListener = this.listenerGenerator.call(e2);
            for (Observable observable : this.extractor.call(e2)) {
                observable.addListener(invalidationListener);
            }
            this.elementsMap.put(e2, new ElementObserver$ElementsMapElement(invalidationListener));
        }
    }

    final void detachListener(E e2) {
        if (this.elementsMap != null && e2 != null) {
            ElementObserver$ElementsMapElement elementObserver$ElementsMapElement = this.elementsMap.get(e2);
            for (Observable observable : this.extractor.call(e2)) {
                observable.removeListener(elementObserver$ElementsMapElement.getListener());
            }
            if (elementObserver$ElementsMapElement.decrement() == 0) {
                this.elementsMap.remove(e2);
            }
        }
    }
}

