/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.collections.SetListenerHelper;
import com.sun.javafx.css.BitSet$1;
import com.sun.javafx.css.BitSet$Change;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

abstract class BitSet<T>
extends AbstractSet<T>
implements ObservableSet<T> {
    private static final long[] EMPTY_SET = new long[0];
    private long[] bits = EMPTY_SET;
    private SetListenerHelper<T> listenerHelper;

    protected BitSet() {
    }

    @Override
    public int size() {
        int n2 = 0;
        if (this.bits.length > 0) {
            for (int i2 = 0; i2 < this.bits.length; ++i2) {
                long l2 = this.bits[i2];
                if (l2 == 0L) continue;
                n2 += Long.bitCount(l2);
            }
        }
        return n2;
    }

    @Override
    public boolean isEmpty() {
        if (this.bits.length > 0) {
            for (int i2 = 0; i2 < this.bits.length; ++i2) {
                long l2 = this.bits[i2];
                if (l2 == 0L) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new BitSet$1(this);
    }

    @Override
    public boolean add(T t2) {
        if (t2 == null) {
            return false;
        }
        int n2 = this.getIndex(t2) / 64;
        long l2 = 1L << this.getIndex(t2) % 64;
        if (n2 >= this.bits.length) {
            long[] lArray = new long[n2 + 1];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            this.bits = lArray;
        }
        long l3 = this.bits[n2];
        this.bits[n2] = l3 | l2;
        if ((n2 = this.bits[n2] != l3 ? 1 : 0) != 0 && SetListenerHelper.hasListeners(this.listenerHelper)) {
            this.notifyObservers(t2, false);
        }
        return n2 != 0;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        object = this.cast(object);
        int n2 = this.getIndex(object) / 64;
        long l2 = 1L << this.getIndex(object) % 64;
        if (n2 >= this.bits.length) {
            return false;
        }
        long l3 = this.bits[n2];
        this.bits[n2] = l3 & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (n2 = this.bits[n2] != l3) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                this.notifyObservers(object, true);
            }
            boolean bl2 = true;
            for (int i2 = 0; i2 < this.bits.length && bl2; bl2 &= this.bits[i2] == 0L, ++i2) {
            }
            if (bl2) {
                this.bits = EMPTY_SET;
            }
        }
        return n2;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        object = this.cast(object);
        int n2 = this.getIndex(object) / 64;
        long l2 = 1L << this.getIndex(object) % 64;
        return n2 < this.bits.length && (this.bits[n2] & l2) == l2;
    }

    @Override
    public boolean containsAll(Collection<?> object) {
        if (this.getClass() != object.getClass()) {
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                if (this.contains(e2)) continue;
                return false;
            }
            return true;
        }
        object = (BitSet)object;
        if (this.bits.length == 0 && ((BitSet)object).bits.length == 0) {
            return true;
        }
        if (this.bits.length < ((BitSet)object).bits.length) {
            return false;
        }
        int n2 = ((BitSet)object).bits.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((this.bits[i2] & ((BitSet)object).bits[i2]) == ((BitSet)object).bits[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> object) {
        int n2;
        if (this.getClass() != object.getClass()) {
            boolean bl2 = false;
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                bl2 |= this.add((T)e2);
            }
            return bl2;
        }
        boolean bl3 = false;
        object = (BitSet)object;
        long[] lArray = this.bits;
        int n3 = lArray.length;
        object = ((BitSet)object).bits;
        int n4 = ((Object)object).length;
        n3 = n3 < n4 ? n4 : n3;
        long[] lArray2 = n3 > 0 ? new long[n3] : EMPTY_SET;
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 < lArray.length && n2 < ((Object)object).length) {
                lArray2[n2] = lArray[n2] | object[n2];
                bl3 |= lArray2[n2] != lArray[n2];
                continue;
            }
            if (n2 < lArray.length) {
                lArray2[n2] = lArray[n2];
                continue;
            }
            lArray2[n2] = (long)object[n2];
            bl3 = true;
        }
        if (bl3) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                for (n2 = 0; n2 < n3; ++n2) {
                    Object object2;
                    if (n2 < lArray.length && n2 < ((Object)object).length) {
                        object2 = (lArray[n2] ^ 0xFFFFFFFFFFFFFFFFL) & object[n2];
                    } else {
                        if (n2 < lArray.length) continue;
                        object2 = object[n2];
                    }
                    for (int i2 = 0; i2 < 64; ++i2) {
                        long l2 = 1L << i2;
                        if ((l2 & object2) != l2) continue;
                        T t2 = this.getT((n2 << 6) + i2);
                        this.notifyObservers(t2, false);
                    }
                }
            }
            this.bits = lArray2;
        }
        return bl3;
    }

    @Override
    public boolean retainAll(Collection<?> object) {
        int n2;
        if (this.getClass() != object.getClass()) {
            boolean bl2 = false;
            Iterator<T> iterator = this.iterator();
            while (iterator.hasNext()) {
                T t2 = iterator.next();
                if (object.contains(t2)) continue;
                iterator.remove();
                bl2 = true;
            }
            return bl2;
        }
        BitSet bitSet = (BitSet)object;
        long[] lArray = this.bits;
        int n3 = lArray.length;
        object = bitSet.bits;
        int n4 = ((Object)object).length;
        n4 = n3 < n4 ? n3 : n4;
        long[] lArray2 = n4 > 0 ? new long[n4] : EMPTY_SET;
        n3 = 0 | (lArray.length > n4 ? 1 : 0);
        boolean bl3 = true;
        for (n2 = 0; n2 < n4; ++n2) {
            lArray2[n2] = lArray[n2] & object[n2];
            n3 |= lArray2[n2] != lArray[n2] ? 1 : 0;
            bl3 &= lArray2[n2] == 0L;
        }
        if (n3 != 0) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                for (n2 = 0; n2 < lArray.length; ++n2) {
                    long l2 = n2 < ((Object)object).length ? lArray[n2] & (object[n2] ^ 0xFFFFFFFFFFFFFFFFL) : lArray[n2];
                    for (n4 = 0; n4 < 64; ++n4) {
                        long l3 = 1L << n4;
                        if ((l3 & l2) != l3) continue;
                        T t3 = this.getT((n2 << 6) + n4);
                        this.notifyObservers(t3, true);
                    }
                }
            }
            this.bits = !bl3 ? lArray2 : EMPTY_SET;
        }
        return n3 != 0;
    }

    @Override
    public boolean removeAll(Collection<?> object) {
        int n2;
        if (this.getClass() != object.getClass()) {
            boolean bl2 = false;
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                bl2 |= this.remove(e2);
            }
            return bl2;
        }
        boolean bl3 = false;
        object = (BitSet)object;
        long[] lArray = this.bits;
        int n3 = lArray.length;
        object = ((BitSet)object).bits;
        int n4 = ((Object)object).length;
        n3 = n3 < n4 ? n3 : n4;
        long[] lArray2 = n3 > 0 ? new long[n3] : EMPTY_SET;
        boolean bl4 = true;
        for (n2 = 0; n2 < n3; ++n2) {
            lArray2[n2] = lArray[n2] & (object[n2] ^ 0xFFFFFFFFFFFFFFFFL);
            bl3 |= lArray2[n2] != lArray[n2];
            bl4 &= lArray2[n2] == 0L;
        }
        if (bl3) {
            if (SetListenerHelper.hasListeners(this.listenerHelper)) {
                for (n2 = 0; n2 < n3; ++n2) {
                    long l2 = lArray[n2] & object[n2];
                    for (int i2 = 0; i2 < 64; ++i2) {
                        long l3 = 1L << i2;
                        if ((l3 & l2) != l3) continue;
                        T t2 = this.getT((n2 << 6) + i2);
                        this.notifyObservers(t2, true);
                    }
                }
            }
            this.bits = !bl4 ? lArray2 : EMPTY_SET;
        }
        return bl3;
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            long l2 = this.bits[i2];
            for (int i3 = 0; i3 < 64; ++i3) {
                long l3 = 1L << i3;
                if ((l3 & l2) != l3) continue;
                T t2 = this.getT((i2 << 6) + i3);
                this.notifyObservers(t2, true);
            }
        }
        this.bits = EMPTY_SET;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (this.getClass() == object.getClass()) {
            return this.equalsBitSet((BitSet)object);
        }
        return super.equals(object);
    }

    private boolean equalsBitSet(BitSet<?> bitSet) {
        int n2;
        int n3 = this.bits != null ? this.bits.length : 0;
        int n4 = n2 = bitSet.bits != null ? bitSet.bits.length : 0;
        if (n3 != n2) {
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            long l2 = this.bits[n2];
            long l3 = bitSet.bits[n2];
            if (l2 == l3) continue;
            return false;
        }
        return true;
    }

    protected abstract T getT(int var1);

    protected abstract int getIndex(T var1);

    protected abstract T cast(Object var1);

    protected long[] getBits() {
        return this.bits;
    }

    @Override
    public void addListener(SetChangeListener<? super T> setChangeListener) {
        if (setChangeListener != null) {
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, setChangeListener);
        }
    }

    @Override
    public void removeListener(SetChangeListener<? super T> setChangeListener) {
        if (setChangeListener != null) {
            this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, setChangeListener);
        }
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        if (invalidationListener != null) {
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, invalidationListener);
        }
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        if (invalidationListener != null) {
            this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, invalidationListener);
        }
    }

    private void notifyObservers(T object, boolean bl2) {
        if (object != null && SetListenerHelper.hasListeners(this.listenerHelper)) {
            object = new BitSet$Change(this, object, bl2);
            SetListenerHelper.fireValueChangedEvent(this.listenerHelper, object);
        }
    }
}

