/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.BitSet;
import com.sun.javafx.css.PseudoClassImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.css.PseudoClass;

public final class PseudoClassState
extends BitSet<PseudoClass> {
    static final Map<String, Integer> pseudoClassMap = new HashMap<String, Integer>(64);
    static final List<PseudoClass> pseudoClasses = new ArrayList<PseudoClass>();

    public PseudoClassState() {
    }

    PseudoClassState(List<String> list) {
        int n2 = list != null ? list.size() : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            PseudoClass pseudoClass = PseudoClassState.getPseudoClass(list.get(i2));
            this.add(pseudoClass);
        }
    }

    @Override
    public final Object[] toArray() {
        PseudoClassState pseudoClassState = this;
        return pseudoClassState.toArray(new PseudoClass[pseudoClassState.size()]);
    }

    @Override
    public final <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size()) {
            objectArray = new PseudoClass[this.size()];
        }
        int n2 = 0;
        while (n2 < this.getBits().length) {
            long l2 = this.getBits()[n2];
            for (int i2 = 0; i2 < 64; ++i2) {
                long l3 = 1L << i2;
                if ((l2 & l3) != l3) continue;
                int n3 = (n2 << 6) + i2;
                PseudoClass pseudoClass = PseudoClassState.getPseudoClass(n3);
                objectArray[n2++] = pseudoClass;
            }
        }
        return objectArray;
    }

    @Override
    public final String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((PseudoClass)iterator.next()).getPseudoClassName());
        }
        return ((Object)arrayList).toString();
    }

    @Override
    protected final PseudoClass cast(Object object) {
        if (object == null) {
            throw new NullPointerException("null arg");
        }
        object = (PseudoClass)object;
        return object;
    }

    @Override
    protected final PseudoClass getT(int n2) {
        return PseudoClassState.getPseudoClass(n2);
    }

    @Override
    protected final int getIndex(PseudoClass object) {
        if (object instanceof PseudoClassImpl) {
            return ((PseudoClassImpl)object).getIndex();
        }
        Integer n2 = pseudoClassMap.get(object = ((PseudoClass)object).getPseudoClassName());
        if (n2 == null) {
            n2 = pseudoClasses.size();
            pseudoClasses.add(new PseudoClassImpl((String)object, n2));
            pseudoClassMap.put((String)object, n2);
        }
        return n2;
    }

    public static PseudoClass getPseudoClass(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("pseudoClass cannot be null or empty String");
        }
        PseudoClass pseudoClass = null;
        Integer n2 = pseudoClassMap.get(string);
        int n3 = n2 != null ? n2 : -1;
        int n4 = pseudoClasses.size();
        assert (n3 < n4);
        if (n3 != -1 && n3 < n4) {
            pseudoClass = pseudoClasses.get(n3);
        }
        if (pseudoClass == null) {
            pseudoClass = new PseudoClassImpl(string, n4);
            pseudoClasses.add(pseudoClass);
            pseudoClassMap.put(string, n4);
        }
        return pseudoClass;
    }

    static PseudoClass getPseudoClass(int n2) {
        if (n2 >= 0 && n2 < pseudoClasses.size()) {
            return pseudoClasses.get(n2);
        }
        return null;
    }
}

