/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.util.DataURI;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.scene.image.Image;

final class StyleManager$ImageCache {
    private Map<String, SoftReference<Image>> imageCache = new HashMap<String, SoftReference<Image>>();

    private StyleManager$ImageCache() {
    }

    final Image getCachedImage(String string) {
        Object object = StyleManager.styleLock;
        synchronized (object) {
            Image image;
            block11: {
                image = null;
                if (this.imageCache.containsKey(string)) {
                    image = this.imageCache.get(string).get();
                }
                if (image == null) {
                    try {
                        image = new Image(string);
                        if (image.isError()) {
                            PlatformLogger platformLogger = StyleManager.getLogger();
                            if (platformLogger != null && platformLogger.isLoggable(PlatformLogger$Level.WARNING)) {
                                DataURI dataURI = DataURI.tryParse(string);
                                if (dataURI != null) {
                                    platformLogger.warning("Error loading image: " + String.valueOf(dataURI));
                                } else {
                                    platformLogger.warning("Error loading image: " + string);
                                }
                            }
                            image = null;
                        }
                        this.imageCache.put(string, new SoftReference<Image>(image));
                    }
                    catch (IllegalArgumentException | NullPointerException runtimeException) {
                        PlatformLogger platformLogger = StyleManager.getLogger();
                        if (platformLogger == null || !platformLogger.isLoggable(PlatformLogger$Level.WARNING)) break block11;
                        platformLogger.warning(runtimeException.getLocalizedMessage());
                    }
                }
            }
            return image;
        }
    }

    final void cleanUpImageCache(String string) {
        Object object = StyleManager.styleLock;
        synchronized (object) {
            if (string == null || this.imageCache.isEmpty()) {
                return;
            }
            if ((string = string.trim()).isEmpty()) {
                return;
            }
            int n2 = string.lastIndexOf(47);
            string = n2 > 0 ? string.substring(0, n2) : string;
            int n3 = string.length();
            String[] stringArray = new String[this.imageCache.size()];
            int n4 = 0;
            Set<Map.Entry<String, SoftReference<Image>>> set = this.imageCache.entrySet();
            for (Map.Entry<String, SoftReference<Image>> entry : set) {
                String string2 = entry.getKey();
                if (entry.getValue().get() == null) {
                    stringArray[n4++] = string2;
                    continue;
                }
                int n5 = string2.lastIndexOf(47);
                String string3 = n5 > 0 ? string2.substring(0, n5) : string2;
                int n6 = string3.length();
                boolean bl2 = n6 > n3 ? string3.startsWith(string) : string.startsWith(string3);
                if (!bl2) continue;
                stringArray[n4++] = string2;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                this.imageCache.remove(stringArray[i2]);
            }
            return;
        }
    }
}

