/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.FontFaceImpl;
import com.sun.javafx.css.FontFaceImpl$FontFaceSrc;
import com.sun.javafx.css.FontFaceImpl$FontFaceSrcType;
import com.sun.javafx.css.StyleCache;
import com.sun.javafx.css.StyleCache$Key;
import com.sun.javafx.css.StyleClassSet;
import com.sun.javafx.css.StyleManager$Cache;
import com.sun.javafx.css.StyleManager$CacheContainer;
import com.sun.javafx.css.StyleManager$ImageCache;
import com.sun.javafx.css.StyleManager$InstanceHolder;
import com.sun.javafx.css.StyleManager$Key;
import com.sun.javafx.css.StyleManager$StylesheetContainer;
import com.sun.javafx.css.StyleMap;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.util.DataURI;
import com.sun.javafx.util.Logging;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.css.CssParser;
import javafx.css.CssParser$ParseError;
import javafx.css.FontFace;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.Stylesheet;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.stage.Window;

public final class StyleManager {
    private static final Object styleLock = new Object();
    private static PlatformLogger LOGGER;
    public static final Map<Parent, StyleManager$CacheContainer> cacheContainerMap;
    public final List<StyleManager$StylesheetContainer> userAgentStylesheetContainers = new ArrayList<StyleManager$StylesheetContainer>();
    public final List<StyleManager$StylesheetContainer> platformUserAgentStylesheetContainers = new ArrayList<StyleManager$StylesheetContainer>();
    public boolean hasDefaultUserAgentStylesheet = false;
    public final Map<String, StyleManager$StylesheetContainer> stylesheetContainerMap = new HashMap<String, StyleManager$StylesheetContainer>();
    private final StyleManager$ImageCache imageCache = new StyleManager$ImageCache();
    private static final String skinPrefix = "com/sun/javafx/scene/control/skin/";
    private static final String skinUtilsClassName = "com.sun.javafx.scene.control.skin.Utils";
    private StyleManager$Key key = null;
    private final WeakHashMap<Region, String> weakRegionUserAgentStylesheetMap = new WeakHashMap();
    private static ObservableList<CssParser$ParseError> errors;
    private static List<String> cacheMapKey;

    private static PlatformLogger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logging.getCSSLogger();
        }
        return LOGGER;
    }

    public static StyleManager getInstance() {
        return StyleManager$InstanceHolder.INSTANCE;
    }

    private StyleManager() {
    }

    final StyleManager$CacheContainer getCacheContainer(Styleable object, SubScene object2) {
        if (object == null && object2 == null) {
            return null;
        }
        Parent parent = null;
        if (object2 != null) {
            parent = ((SubScene)object2).getRoot();
        } else if (object instanceof Node) {
            object2 = ((Node)(object = (Node)object)).getScene();
            if (object2 != null) {
                parent = ((Scene)object2).getRoot();
            }
        } else if (object instanceof Window && (object = ((Window)object).getScene()) != null) {
            parent = ((Scene)object).getRoot();
        }
        if (parent == null) {
            return null;
        }
        object = styleLock;
        synchronized (object) {
            object2 = cacheContainerMap.get(parent);
            if (object2 == null) {
                object2 = new StyleManager$CacheContainer();
                cacheContainerMap.put(parent, (StyleManager$CacheContainer)object2);
            }
            return object2;
        }
    }

    public final StyleCache getSharedCache(Styleable map, SubScene object, StyleCache$Key styleCache$Key) {
        if ((map = this.getCacheContainer((Styleable)((Object)map), (SubScene)object)) == null) {
            return null;
        }
        if ((map = ((StyleManager$CacheContainer)((Object)map)).getStyleCache()) == null) {
            return null;
        }
        object = map.get(styleCache$Key);
        if (object == null) {
            object = new StyleCache();
            map.put(new StyleCache$Key(styleCache$Key), (StyleCache)object);
        }
        return object;
    }

    public final StyleMap getStyleMap(Styleable object, SubScene subScene, int n2) {
        if (n2 == -1) {
            return StyleMap.EMPTY_MAP;
        }
        if ((object = this.getCacheContainer((Styleable)object, subScene)) == null) {
            return StyleMap.EMPTY_MAP;
        }
        return ((StyleManager$CacheContainer)object).getStyleMap(n2);
    }

    public final void forget(Scene scene) {
        if (scene == null) {
            return;
        }
        this.forget(scene.getRoot());
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            Object object3;
            if (scene.getUserAgentStylesheet() != null && !((String)(object3 = scene.getUserAgentStylesheet().trim())).isEmpty()) {
                for (int i2 = this.userAgentStylesheetContainers.size() - 1; i2 >= 0; --i2) {
                    object2 = this.userAgentStylesheetContainers.get(i2);
                    if (!((String)object3).equals(((StyleManager$StylesheetContainer)object2).fname)) continue;
                    ((StyleManager$StylesheetContainer)object2).parentUsers.remove(scene.getRoot());
                    if (((StyleManager$StylesheetContainer)object2).parentUsers.list.size() != 0) continue;
                    this.userAgentStylesheetContainers.remove(i2);
                }
            }
            Object object4 = this.stylesheetContainerMap.entrySet();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object3 = object2.next();
                object3 = object3.getValue();
                object4 = ((StyleManager$StylesheetContainer)object3).parentUsers.list.iterator();
                while (object4.hasNext()) {
                    Reference reference = (Reference)object4.next();
                    Parent parent = (Parent)reference.get();
                    if (parent != null && parent.getScene() != scene && parent.getScene() != null) continue;
                    reference.clear();
                    object4.remove();
                }
                if (!((StyleManager$StylesheetContainer)object3).parentUsers.list.isEmpty()) continue;
                object2.remove();
            }
            return;
        }
    }

    public final void stylesheetsChanged(Scene scene, ListChangeListener$Change<String> listChangeListener$Change) {
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            Iterator<String> iterator = cacheContainerMap.entrySet();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                object2 = (Parent)entry.getKey();
                StyleManager$CacheContainer object3 = (StyleManager$CacheContainer)entry.getValue();
                if (((Node)object2).getScene() != scene) continue;
                object3.clearCache();
            }
            listChangeListener$Change.reset();
            while (listChangeListener$Change.next()) {
                if (!listChangeListener$Change.wasRemoved()) continue;
                for (String string : listChangeListener$Change.getRemoved()) {
                    this.stylesheetRemoved(scene, string);
                    object2 = this.stylesheetContainerMap.get(string);
                    if (object2 == null) continue;
                    ((StyleManager$StylesheetContainer)object2).invalidateChecksum();
                }
            }
            return;
        }
    }

    private void stylesheetRemoved(Scene scene, String string) {
        this.stylesheetRemoved(scene.getRoot(), string);
    }

    public final void forget(Parent parent) {
        if (parent == null) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            Iterator<Map.Entry<String, StyleManager$StylesheetContainer>> iterator = cacheContainerMap.remove(parent);
            if (iterator != null) {
                ((StyleManager$CacheContainer)((Object)iterator)).clearCache();
            }
            if ((iterator = parent.getStylesheets()) != null && !iterator.isEmpty()) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    object2 = (String)((Object)iterator.next());
                    this.stylesheetRemoved(parent, (String)object2);
                }
            }
            iterator = this.stylesheetContainerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object2 = object2.getValue();
                ((StyleManager$StylesheetContainer)object2).parentUsers.remove(parent);
                if (!((StyleManager$StylesheetContainer)object2).parentUsers.list.isEmpty()) continue;
                iterator.remove();
                if (((StyleManager$StylesheetContainer)object2).selectorPartitioning != null) {
                    ((StyleManager$StylesheetContainer)object2).selectorPartitioning.reset();
                }
                object2 = ((StyleManager$StylesheetContainer)object2).fname;
                this.imageCache.cleanUpImageCache((String)object2);
            }
            return;
        }
    }

    public final void stylesheetsChanged(Parent parent, ListChangeListener$Change<String> listChangeListener$Change) {
        Object object = styleLock;
        synchronized (object) {
            listChangeListener$Change.reset();
            while (listChangeListener$Change.next()) {
                if (!listChangeListener$Change.wasRemoved()) continue;
                for (String string : listChangeListener$Change.getRemoved()) {
                    this.stylesheetRemoved(parent, string);
                    StyleManager$StylesheetContainer object2 = this.stylesheetContainerMap.get(string);
                    if (object2 == null) continue;
                    object2.invalidateChecksum();
                }
            }
            return;
        }
    }

    private void stylesheetRemoved(Parent parent, String object) {
        Object object2 = styleLock;
        synchronized (object2) {
            object = this.stylesheetContainerMap.get(object);
            if (object == null) {
                return;
            }
            ((StyleManager$StylesheetContainer)object).parentUsers.remove(parent);
            if (((StyleManager$StylesheetContainer)object).parentUsers.list.isEmpty()) {
                this.removeStylesheetContainer((StyleManager$StylesheetContainer)object);
            }
            return;
        }
    }

    public final void forget(SubScene iterator) {
        if (iterator == null) {
            return;
        }
        Parent parent = ((SubScene)((Object)iterator)).getRoot();
        if (parent == null) {
            return;
        }
        this.forget(parent);
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            Object object3;
            Reference reference;
            if (((SubScene)((Object)iterator)).getUserAgentStylesheet() != null && !((String)((Object)(reference = ((SubScene)((Object)iterator)).getUserAgentStylesheet().trim()))).isEmpty()) {
                object3 = this.userAgentStylesheetContainers.iterator();
                while (object3.hasNext()) {
                    object2 = (StyleManager$StylesheetContainer)object3.next();
                    if (!((String)((Object)reference)).equals(((StyleManager$StylesheetContainer)object2).fname)) continue;
                    ((StyleManager$StylesheetContainer)object2).parentUsers.remove(((SubScene)((Object)iterator)).getRoot());
                    if (((StyleManager$StylesheetContainer)object2).parentUsers.list.size() != 0) continue;
                    object3.remove();
                }
            }
            object3 = new ArrayList<StyleManager$StylesheetContainer>(this.stylesheetContainerMap.values());
            object2 = object3.iterator();
            while (object2.hasNext()) {
                iterator = (StyleManager$StylesheetContainer)object2.next();
                iterator = ((StyleManager$StylesheetContainer)((Object)iterator)).parentUsers.list.iterator();
                block5: while (iterator.hasNext()) {
                    reference = iterator.next();
                    object3 = (Parent)reference.get();
                    if (object3 == null) continue;
                    for (Object object4 = object3; object4 != null; object4 = ((Node)object4).getParent()) {
                        if (parent != ((Node)object4).getParent()) continue;
                        reference.clear();
                        iterator.remove();
                        this.forget((Parent)object3);
                        continue block5;
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeStylesheetContainer(StyleManager$StylesheetContainer styleManager$StylesheetContainer) {
        if (styleManager$StylesheetContainer == null) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            void var5_12;
            Object object2;
            Object object3;
            String string = styleManager$StylesheetContainer.fname;
            this.stylesheetContainerMap.remove(string);
            if (styleManager$StylesheetContainer.selectorPartitioning != null) {
                styleManager$StylesheetContainer.selectorPartitioning.reset();
            }
            for (Map.Entry<Parent, StyleManager$CacheContainer> i2 : cacheContainerMap.entrySet()) {
                object3 = i2.getValue();
                if (object3 == null || ((StyleManager$CacheContainer)object3).cacheMap == null || ((StyleManager$CacheContainer)object3).cacheMap.isEmpty()) continue;
                object2 = new ArrayList();
                for (Map<StyleManager$Key, StyleManager$Cache> map : ((StyleManager$CacheContainer)object3).cacheMap.entrySet()) {
                    if (!((map = map.getKey()) != null ? map.contains(string) : string == null)) continue;
                    object2.add(map);
                }
                if (object2.isEmpty()) continue;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Map<StyleManager$Key, StyleManager$Cache> map;
                    map = (List)iterator.next();
                    if ((map = ((StyleManager$CacheContainer)object3).cacheMap.remove(map)) == null) continue;
                    map.clear();
                }
            }
            this.imageCache.cleanUpImageCache(string);
            List list = styleManager$StylesheetContainer.parentUsers.list;
            int n2 = list.size() - 1;
            while (var5_12 >= 0) {
                object3 = (Reference)list.remove((int)var5_12);
                object2 = (Parent)((Reference)object3).get();
                ((Reference)object3).clear();
                if (object2 != null && ((Node)object2).getScene() != null) {
                    NodeHelper.reapplyCSS((Node)object2);
                }
                --var5_12;
            }
            return;
        }
    }

    public final Image getCachedImage(String string) {
        return this.imageCache.getCachedImage(string);
    }

    private static URL getURL(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        try {
            Object object = new URI(string.trim());
            if (!((URI)object).isAbsolute()) {
                if (string.startsWith(skinPrefix) && (string.endsWith(".css") || string.endsWith(".bss"))) {
                    try {
                        ClassLoader classLoader = StyleManager.class.getClassLoader();
                        object = Class.forName(skinUtilsClassName, true, classLoader);
                        object = ((Class)object).getMethod("getResource", String.class);
                        return (URL)((Method)object).invoke(null, string.substring(34));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
                        reflectiveOperationException.printStackTrace();
                        return null;
                    }
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                object = ((String)(object = ((URI)object).getPath())).startsWith("/") ? classLoader.getResource(((String)object).substring(1)) : classLoader.getResource((String)object);
                return object;
            }
            return ((URI)object).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] calculateCheckSum(String object) {
        block15: {
            if (object == null || ((String)object).isEmpty()) {
                return new byte[0];
            }
            try {
                object = StyleManager.getURL((String)object);
                if (object == null || !"file".equals(((URL)object).getProtocol())) break block15;
                object = ((URL)object).openStream();
                try {
                    byte[] byArray;
                    try (DigestInputStream digestInputStream = new DigestInputStream((InputStream)object, MessageDigest.getInstance("MD5"));){
                        digestInputStream.getMessageDigest().reset();
                        byte[] byArray2 = new byte[4096];
                        while (digestInputStream.read(byArray2) != -1) {
                        }
                        byArray = digestInputStream.getMessageDigest().digest();
                    }
                    return byArray;
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (IOException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException exception) {}
        }
        return new byte[0];
    }

    public static Stylesheet loadStylesheet(String string) {
        try {
            return StyleManager.loadStylesheetUnPrivileged(string);
        }
        catch (AccessControlException accessControlException) {
            System.err.println("WARNING: security exception trying to load: " + string);
            if (string.length() < 7 && string.indexOf("!/") < string.length() - 7) {
                return null;
            }
            try {
                Object object = new URI(string);
                if ("jar".equals(((URI)object).getScheme())) {
                    Object object2 = AccessController.doPrivileged(() -> StyleManager.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    object2 = ((URI)object2).getSchemeSpecificPart();
                    object = ((URI)object).getSchemeSpecificPart();
                    if (((String)object2).equals(object = ((String)object).substring(((String)object).indexOf(47), ((String)object).indexOf("!/")))) {
                        String string2 = string;
                        object = string2.substring(string2.indexOf("!/") + 2);
                        if (string.endsWith(".css") || string.endsWith(".bss")) {
                            Object object3 = new FilePermission((String)object2, "read");
                            PermissionCollection permissionCollection = ((FilePermission)object3).newPermissionCollection();
                            permissionCollection.add((Permission)object3);
                            object3 = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissionCollection)});
                            try {
                                object2 = AccessController.doPrivileged(() -> StyleManager.lambda$loadStylesheet$1((String)object2), (AccessControlContext)object3);
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                return null;
                            }
                            if (object2 != null && (object = ((JarFile)object2).getJarEntry((String)object)) != null) {
                                return AccessController.doPrivileged(() -> StyleManager.loadStylesheetUnPrivileged(string), (AccessControlContext)object3);
                            }
                        }
                    }
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Stylesheet loadStylesheetUnPrivileged(String string) {
        Object object = styleLock;
        synchronized (object) {
            block41: {
                Boolean object22 = AccessController.doPrivileged(() -> {
                    String string2 = System.getProperty("binary.css");
                    return !string.endsWith(".bss") && string2 != null ? !Boolean.valueOf(string2).booleanValue() : false;
                });
                try {
                    Object object2;
                    Object object3 = object22 != false ? ".css" : ".bss";
                    Stylesheet stylesheet = null;
                    if (!string.endsWith(".css") && !string.endsWith(".bss")) {
                        object3 = StyleManager.getURL(string);
                    } else {
                        void var2_5;
                        Boolean bl3;
                        object2 = string.substring(0, string.length() - 4);
                        object3 = StyleManager.getURL((String)object2 + (String)object3);
                        if (object3 == null && (bl3 = Boolean.valueOf(object22 == false)).booleanValue()) {
                            object3 = StyleManager.getURL((String)object2 + ".css");
                        }
                        if (object3 != null && !var2_5.booleanValue()) {
                            try {
                                stylesheet = Stylesheet.loadBinary((URL)object3);
                            }
                            catch (IOException iOException) {}
                            if (stylesheet == null) {
                                object3 = StyleManager.getURL(string);
                            }
                        }
                    }
                    if (stylesheet == null) {
                        object2 = null;
                        if (object3 != null) {
                            stylesheet = new CssParser().parse((URL)object3);
                        } else {
                            object2 = DataURI.tryParse(string);
                        }
                        if (object2 != null) {
                            boolean bl2;
                            boolean string2 = "text".equalsIgnoreCase(((DataURI)object2).getMimeType()) && ("css".equalsIgnoreCase(((DataURI)object2).getMimeSubtype()) || "plain".equalsIgnoreCase(((DataURI)object2).getMimeSubtype()));
                            boolean bl3 = bl2 = "application".equalsIgnoreCase(((DataURI)object2).getMimeType()) && "octet-stream".equalsIgnoreCase(((DataURI)object2).getMimeSubtype());
                            if (string2) {
                                Charset charset;
                                String string3 = ((DataURI)object2).getParameters().get("charset");
                                try {
                                    charset = string3 != null ? Charset.forName(string3) : Charset.defaultCharset();
                                }
                                catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                                    String string4 = String.format("Unsupported charset \"%s\" in stylesheet URI \"%s\"", string3, object2);
                                    if (errors != null) {
                                        errors.add(new CssParser$ParseError(string4));
                                    }
                                    if (StyleManager.getLogger().isLoggable(PlatformLogger$Level.WARNING)) {
                                        StyleManager.getLogger().warning(string4);
                                    }
                                    return null;
                                }
                                String string5 = new String(((DataURI)object2).getData(), charset);
                                stylesheet = new CssParser().parse(string5);
                            } else if (bl2) {
                                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((DataURI)object2).getData());){
                                    stylesheet = Stylesheet.loadBinary(byteArrayInputStream);
                                }
                            } else {
                                String string6 = String.format("Unexpected MIME type \"%s/%s\" in stylesheet URI \"%s\"", ((DataURI)object2).getMimeType(), ((DataURI)object2).getMimeSubtype(), object2);
                                if (errors != null) {
                                    errors.add(new CssParser$ParseError(string6));
                                }
                                if (StyleManager.getLogger().isLoggable(PlatformLogger$Level.WARNING)) {
                                    StyleManager.getLogger().warning(string6);
                                }
                                return null;
                            }
                        }
                    }
                    if (stylesheet == null) {
                        if (errors != null) {
                            object2 = new CssParser$ParseError("Resource \"" + string + "\" not found.");
                            errors.add((CssParser$ParseError)object2);
                        }
                        if (StyleManager.getLogger().isLoggable(PlatformLogger$Level.WARNING)) {
                            StyleManager.getLogger().warning(String.format("Resource \"%s\" not found.", string));
                        }
                    }
                    if (stylesheet != null) {
                        block15: for (FontFace fontFace : stylesheet.getFontFaces()) {
                            if (!(fontFace instanceof FontFaceImpl)) continue;
                            object3 = ((FontFaceImpl)fontFace).getSources().iterator();
                            while (object3.hasNext()) {
                                FontFaceImpl$FontFaceSrc fontFaceImpl$FontFaceSrc = object3.next();
                                if (fontFaceImpl$FontFaceSrc.getType() != FontFaceImpl$FontFaceSrcType.URL) continue;
                                object3 = Font.loadFont(fontFaceImpl$FontFaceSrc.getSrc(), 10.0);
                                if (object3 != null) continue block15;
                                StyleManager.getLogger().info("Could not load @font-face font [" + fontFaceImpl$FontFaceSrc.getSrc() + "]");
                                continue block15;
                            }
                        }
                    }
                    return stylesheet;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (errors != null) {
                        CssParser$ParseError cssParser$ParseError = new CssParser$ParseError("Stylesheet \"" + string + "\" not found.");
                        errors.add(cssParser$ParseError);
                    }
                    if (StyleManager.getLogger().isLoggable(PlatformLogger$Level.INFO)) {
                        StyleManager.getLogger().info("Could not find stylesheet: " + string);
                    }
                }
                catch (IOException iOException) {
                    String string7;
                    DataURI dataURI = DataURI.tryParse(string);
                    String string8 = string7 = dataURI != null ? dataURI.toString() : string;
                    if (errors != null) {
                        errors.add(new CssParser$ParseError("Could not load stylesheet: " + string7));
                    }
                    if (!StyleManager.getLogger().isLoggable(PlatformLogger$Level.INFO)) break block41;
                    StyleManager.getLogger().info("Could not load stylesheet: " + string7);
                }
            }
            return null;
        }
    }

    public final void setUserAgentStylesheets(List<String> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            String string;
            int n2;
            int n3;
            boolean bl2;
            if (list.size() == this.platformUserAgentStylesheetContainers.size()) {
                bl2 = true;
                n3 = list.size();
                for (n2 = 0; n2 < n3 && bl2 && (string = (string = list.get(n2)) != null ? string.trim() : null) != null && !string.isEmpty(); ++n2) {
                    StyleManager$StylesheetContainer styleManager$StylesheetContainer = this.platformUserAgentStylesheetContainers.get(n2);
                    bl2 = string.equals(styleManager$StylesheetContainer.fname);
                    if (!bl2) continue;
                    Object object2 = styleManager$StylesheetContainer.stylesheet.getUrl();
                    byte[] byArray = StyleManager.calculateCheckSum((String)object2);
                    object2 = byArray;
                    bl2 = Arrays.equals(byArray, styleManager$StylesheetContainer.checksum);
                }
                if (bl2) {
                    return;
                }
            }
            bl2 = false;
            n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string = list.get(n2);
                string = string != null ? string.trim() : null;
                if (string == null || string.isEmpty()) continue;
                if (!bl2) {
                    this.platformUserAgentStylesheetContainers.clear();
                    bl2 = true;
                }
                if (n2 == 0) {
                    this._setDefaultUserAgentStylesheet(string);
                    continue;
                }
                this._addUserAgentStylesheet(string);
            }
            if (bl2) {
                this.userAgentStylesheetsChanged();
            }
            return;
        }
    }

    public final void addUserAgentStylesheet(String string) {
        this.addUserAgentStylesheet(null, string);
    }

    public final void addUserAgentStylesheet(Scene object, String object2) {
        object = object2 != null ? ((String)object2).trim() : null;
        if (object == null || ((String)object).isEmpty()) {
            return;
        }
        object2 = styleLock;
        synchronized (object2) {
            if (this._addUserAgentStylesheet((String)object)) {
                this.userAgentStylesheetsChanged();
            }
            return;
        }
    }

    private boolean _addUserAgentStylesheet(String string) {
        Object object = styleLock;
        synchronized (object) {
            int n2 = this.platformUserAgentStylesheetContainers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                StyleManager$StylesheetContainer styleManager$StylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!string.equals(styleManager$StylesheetContainer.fname)) continue;
                return false;
            }
            Stylesheet stylesheet = StyleManager.loadStylesheet(string);
            if (stylesheet == null) {
                return false;
            }
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.platformUserAgentStylesheetContainers.add(new StyleManager$StylesheetContainer(string, stylesheet));
            return true;
        }
    }

    public final void addUserAgentStylesheet(Scene object, Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException("null arg ua_stylesheet");
        }
        object = stylesheet.getUrl();
        object = object != null ? ((String)object).trim() : "";
        Object object2 = styleLock;
        synchronized (object2) {
            int n2 = this.platformUserAgentStylesheetContainers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                StyleManager$StylesheetContainer styleManager$StylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!((String)object).equals(styleManager$StylesheetContainer.fname)) continue;
                return;
            }
            this.platformUserAgentStylesheetContainers.add(new StyleManager$StylesheetContainer((String)object, stylesheet));
            if (stylesheet != null) {
                stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            }
            this.userAgentStylesheetsChanged();
            return;
        }
    }

    public final void setDefaultUserAgentStylesheet(String string) {
        this.setDefaultUserAgentStylesheet(null, string);
    }

    public final void setDefaultUserAgentStylesheet(Scene object, String object2) {
        object = object2 != null ? ((String)object2).trim() : null;
        if (object == null || ((String)object).isEmpty()) {
            return;
        }
        object2 = styleLock;
        synchronized (object2) {
            if (this._setDefaultUserAgentStylesheet((String)object)) {
                this.userAgentStylesheetsChanged();
            }
            return;
        }
    }

    private boolean _setDefaultUserAgentStylesheet(String string) {
        Object object = styleLock;
        synchronized (object) {
            int n2 = this.platformUserAgentStylesheetContainers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                StyleManager$StylesheetContainer styleManager$StylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!string.equals(styleManager$StylesheetContainer.fname)) continue;
                if (i2 > 0) {
                    this.platformUserAgentStylesheetContainers.remove(i2);
                    if (this.hasDefaultUserAgentStylesheet) {
                        this.platformUserAgentStylesheetContainers.set(0, styleManager$StylesheetContainer);
                    } else {
                        this.platformUserAgentStylesheetContainers.add(0, styleManager$StylesheetContainer);
                    }
                }
                return i2 > 0;
            }
            Stylesheet stylesheet = StyleManager.loadStylesheet(string);
            if (stylesheet == null) {
                return false;
            }
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            StyleManager$StylesheetContainer styleManager$StylesheetContainer = new StyleManager$StylesheetContainer(string, stylesheet);
            if (this.platformUserAgentStylesheetContainers.size() == 0) {
                this.platformUserAgentStylesheetContainers.add(styleManager$StylesheetContainer);
            } else if (this.hasDefaultUserAgentStylesheet) {
                this.platformUserAgentStylesheetContainers.set(0, styleManager$StylesheetContainer);
            } else {
                this.platformUserAgentStylesheetContainers.add(0, styleManager$StylesheetContainer);
            }
            this.hasDefaultUserAgentStylesheet = true;
            return true;
        }
    }

    public final void removeUserAgentStylesheet(String string) {
        if ((string = string != null ? string.trim() : null) == null || string.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            boolean bl2 = false;
            for (int i2 = this.platformUserAgentStylesheetContainers.size() - 1; i2 >= 0; --i2) {
                if (string.equals(Application.getUserAgentStylesheet())) continue;
                StyleManager$StylesheetContainer styleManager$StylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!string.equals(styleManager$StylesheetContainer.fname)) continue;
                this.platformUserAgentStylesheetContainers.remove(i2);
                bl2 = true;
            }
            if (bl2) {
                this.userAgentStylesheetsChanged();
            }
            return;
        }
    }

    public final void setDefaultUserAgentStylesheet(Stylesheet stylesheet) {
        if (stylesheet == null) {
            return;
        }
        String string = stylesheet.getUrl();
        string = string != null ? string.trim() : "";
        Object object = styleLock;
        synchronized (object) {
            int n2 = this.platformUserAgentStylesheetContainers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                StyleManager$StylesheetContainer styleManager$StylesheetContainer = this.platformUserAgentStylesheetContainers.get(i2);
                if (!string.equals(styleManager$StylesheetContainer.fname)) continue;
                if (i2 > 0) {
                    this.platformUserAgentStylesheetContainers.remove(i2);
                    if (this.hasDefaultUserAgentStylesheet) {
                        this.platformUserAgentStylesheetContainers.set(0, styleManager$StylesheetContainer);
                    } else {
                        this.platformUserAgentStylesheetContainers.add(0, styleManager$StylesheetContainer);
                    }
                }
                return;
            }
            StyleManager$StylesheetContainer styleManager$StylesheetContainer = new StyleManager$StylesheetContainer(string, stylesheet);
            if (this.platformUserAgentStylesheetContainers.size() == 0) {
                this.platformUserAgentStylesheetContainers.add(styleManager$StylesheetContainer);
            } else if (this.hasDefaultUserAgentStylesheet) {
                this.platformUserAgentStylesheetContainers.set(0, styleManager$StylesheetContainer);
            } else {
                this.platformUserAgentStylesheetContainers.add(0, styleManager$StylesheetContainer);
            }
            this.hasDefaultUserAgentStylesheet = true;
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.userAgentStylesheetsChanged();
            return;
        }
    }

    private void userAgentStylesheetsChanged() {
        ArrayList<Parent> arrayList = new ArrayList<Parent>();
        Iterator iterator = styleLock;
        synchronized (iterator) {
            for (StyleManager$CacheContainer object : cacheContainerMap.values()) {
                object.clearCache();
            }
            StyleConverter.clearCache();
            for (Parent parent : cacheContainerMap.keySet()) {
                if (parent == null) continue;
                arrayList.add(parent);
            }
        }
        for (Object object : arrayList) {
            NodeHelper.reapplyCSS((Node)object);
        }
    }

    private List<StyleManager$StylesheetContainer> processStylesheets(List<String> list, Parent parent) {
        Object object = styleLock;
        synchronized (object) {
            ArrayList<StyleManager$StylesheetContainer> arrayList = new ArrayList<StyleManager$StylesheetContainer>();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2;
                Object object3;
                String string = list.get(i2);
                if (this.stylesheetContainerMap.containsKey(string)) {
                    object3 = this.stylesheetContainerMap.get(string);
                    if (!arrayList.contains(object3)) {
                        if (((StyleManager$StylesheetContainer)object3).checksumInvalid) {
                            byte[] byArray = StyleManager.calculateCheckSum(string);
                            object2 = byArray;
                            if (!Arrays.equals(byArray, ((StyleManager$StylesheetContainer)object3).checksum)) {
                                this.removeStylesheetContainer((StyleManager$StylesheetContainer)object3);
                                object3 = StyleManager.loadStylesheet(string);
                                object3 = new StyleManager$StylesheetContainer(string, (Stylesheet)object3, (byte[])object2);
                                this.stylesheetContainerMap.put(string, (StyleManager$StylesheetContainer)object3);
                            } else {
                                ((StyleManager$StylesheetContainer)object3).checksumInvalid = false;
                            }
                        }
                        arrayList.add((StyleManager$StylesheetContainer)object3);
                    }
                    ((StyleManager$StylesheetContainer)object3).parentUsers.add(parent);
                    continue;
                }
                object2 = StyleManager.loadStylesheet(string);
                object3 = new StyleManager$StylesheetContainer(string, (Stylesheet)object2);
                ((StyleManager$StylesheetContainer)object3).parentUsers.add(parent);
                this.stylesheetContainerMap.put(string, (StyleManager$StylesheetContainer)object3);
                arrayList.add((StyleManager$StylesheetContainer)object3);
            }
            return arrayList;
        }
    }

    private List<StyleManager$StylesheetContainer> gatherParentStylesheets(Parent parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        List<String> list = ParentHelper.getAllParentStylesheets(parent);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = styleLock;
        synchronized (object) {
            return this.processStylesheets(list, parent);
        }
    }

    private List<StyleManager$StylesheetContainer> gatherSceneStylesheets(Scene scene) {
        if (scene == null) {
            return Collections.emptyList();
        }
        ObservableList<String> observableList = scene.getStylesheets();
        if (observableList == null || observableList.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = styleLock;
        synchronized (object) {
            return this.processStylesheets(observableList, scene.getRoot());
        }
    }

    public final StyleMap findMatchingStyles(Node node, SubScene subScene, Set<PseudoClass>[] setArray) {
        Scene scene = node.getScene();
        if (scene == null) {
            return StyleMap.EMPTY_MAP;
        }
        StyleManager$CacheContainer styleManager$CacheContainer = this.getCacheContainer(node, subScene);
        if (styleManager$CacheContainer == null) {
            assert (false) : node.toString();
            return StyleMap.EMPTY_MAP;
        }
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            boolean bl2;
            Node node2;
            Object object3 = node instanceof Parent ? (Parent)node : node.getParent();
            object3 = this.gatherParentStylesheets((Parent)object3);
            boolean bl3 = !object3.isEmpty();
            List<StyleManager$StylesheetContainer> list = this.gatherSceneStylesheets(scene);
            boolean bl4 = !list.isEmpty();
            String string = node.getStyle();
            boolean bl5 = string != null && !string.trim().isEmpty();
            String string2 = scene.getUserAgentStylesheet();
            int n2 = string2 != null && !string2.trim().isEmpty() ? 1 : 0;
            String string3 = subScene != null ? subScene.getUserAgentStylesheet() : null;
            boolean bl6 = string3 != null && !string3.trim().isEmpty();
            String string4 = null;
            for (node2 = node; !(node2 == null || node2 instanceof Region && (string4 = this.weakRegionUserAgentStylesheetMap.computeIfAbsent((Region)node2, Region::getUserAgentStylesheet)) != null); node2 = node2.getParent()) {
            }
            boolean bl7 = bl2 = string4 != null && !string4.trim().isEmpty();
            if (!(bl5 || bl3 || bl4 || n2 != 0 || bl6 || bl2 || !this.platformUserAgentStylesheetContainers.isEmpty())) {
                return StyleMap.EMPTY_MAP;
            }
            String string5 = node.getTypeSelector();
            String string6 = node.getId();
            Object object4 = node.getStyleClass();
            if (this.key == null) {
                this.key = new StyleManager$Key();
            }
            this.key.className = string5;
            this.key.id = string6;
            int n3 = object4.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                object2 = (String)object4.get(i2);
                if (object2 == null || ((String)object2).isEmpty()) continue;
                this.key.styleClasses.add(StyleClassSet.getStyleClass((String)object2));
            }
            Map<StyleManager$Key, StyleManager$Cache> map = styleManager$CacheContainer.getCacheMap((List<StyleManager$StylesheetContainer>)object3, string4);
            Object object5 = map.get(this.key);
            if (object5 != null) {
                this.key.styleClasses.clear();
            } else {
                object2 = new ArrayList();
                if (bl6 || n2 != 0) {
                    String string7 = bl6 ? subScene.getUserAgentStylesheet().trim() : scene.getUserAgentStylesheet().trim();
                    object4 = null;
                    int n4 = this.userAgentStylesheetContainers.size();
                    for (int i3 = 0; i3 < n4; ++i3) {
                        object4 = this.userAgentStylesheetContainers.get(i3);
                        if (string7.equals(((StyleManager$StylesheetContainer)object4).fname)) break;
                        object4 = null;
                    }
                    if (object4 == null) {
                        Stylesheet stylesheet = StyleManager.loadStylesheet(string7);
                        if (stylesheet != null) {
                            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
                        }
                        object4 = new StyleManager$StylesheetContainer(string7, stylesheet);
                        this.userAgentStylesheetContainers.add((StyleManager$StylesheetContainer)object4);
                    }
                    if (((StyleManager$StylesheetContainer)object4).selectorPartitioning != null) {
                        Parent parent = bl6 ? subScene.getRoot() : scene.getRoot();
                        ((StyleManager$StylesheetContainer)object4).parentUsers.add(parent);
                        List<Selector> list2 = ((StyleManager$StylesheetContainer)object4).selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list2);
                    }
                } else if (!this.platformUserAgentStylesheetContainers.isEmpty()) {
                    int n5 = this.platformUserAgentStylesheetContainers.size();
                    for (n2 = 0; n2 < n5; ++n2) {
                        object5 = this.platformUserAgentStylesheetContainers.get(n2);
                        if (object5 == null || ((StyleManager$StylesheetContainer)object5).selectorPartitioning == null) continue;
                        List<Selector> list3 = ((StyleManager$StylesheetContainer)object5).selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list3);
                    }
                }
                if (bl2) {
                    StyleManager$StylesheetContainer styleManager$StylesheetContainer = null;
                    int n6 = this.userAgentStylesheetContainers.size();
                    for (int i4 = 0; i4 < n6; ++i4) {
                        styleManager$StylesheetContainer = this.userAgentStylesheetContainers.get(i4);
                        if (string4.equals(styleManager$StylesheetContainer.fname)) break;
                        styleManager$StylesheetContainer = null;
                    }
                    if (styleManager$StylesheetContainer == null) {
                        Stylesheet stylesheet = StyleManager.loadStylesheet(string4);
                        if (stylesheet != null) {
                            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
                        }
                        styleManager$StylesheetContainer = new StyleManager$StylesheetContainer(string4, stylesheet);
                        this.userAgentStylesheetContainers.add(styleManager$StylesheetContainer);
                    }
                    if (styleManager$StylesheetContainer.selectorPartitioning != null) {
                        styleManager$StylesheetContainer.parentUsers.add((Parent)node2);
                        List<Selector> list4 = styleManager$StylesheetContainer.selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list4);
                    }
                }
                if (!list.isEmpty()) {
                    int n7 = list.size();
                    for (int i5 = 0; i5 < n7; ++i5) {
                        StyleManager$StylesheetContainer styleManager$StylesheetContainer = list.get(i5);
                        if (styleManager$StylesheetContainer == null || styleManager$StylesheetContainer.selectorPartitioning == null) continue;
                        List<Selector> list5 = styleManager$StylesheetContainer.selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list5);
                    }
                }
                if (bl3) {
                    int n8 = object3 == null ? 0 : object3.size();
                    for (int i6 = 0; i6 < n8; ++i6) {
                        StyleManager$StylesheetContainer styleManager$StylesheetContainer = (StyleManager$StylesheetContainer)object3.get(i6);
                        if (styleManager$StylesheetContainer.selectorPartitioning == null) continue;
                        List<Selector> list6 = styleManager$StylesheetContainer.selectorPartitioning.match(string6, string5, this.key.styleClasses);
                        object2.addAll(list6);
                    }
                }
                object5 = new StyleManager$Cache((List<Selector>)object2);
                map.put(this.key, (StyleManager$Cache)object5);
                this.key = null;
            }
            object2 = ((StyleManager$Cache)object5).getStyleMap(styleManager$CacheContainer, node, setArray, bl5);
            return object2;
        }
    }

    public static ObservableList<CssParser$ParseError> errorsProperty() {
        if (errors == null) {
            errors = FXCollections.observableArrayList();
        }
        return errors;
    }

    public static ObservableList<CssParser$ParseError> getErrors() {
        return errors;
    }

    private static /* synthetic */ JarFile lambda$loadStylesheet$1(String string) throws Exception {
        return new JarFile(string);
    }

    static {
        cacheContainerMap = new WeakHashMap<Parent, StyleManager$CacheContainer>();
        errors = null;
    }
}

