/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.embed.swing.newimpl;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.swing.FXDnD;
import com.sun.javafx.embed.swing.SwingCursors;
import com.sun.javafx.embed.swing.SwingNodeHelper;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.stage.WindowHelper;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.lang.ref.WeakReference;
import javafx.embed.swing.SwingNode;
import javafx.scene.Scene;
import javax.swing.JComponent;
import jdk.swing.interop.DragSourceContextWrapper;
import jdk.swing.interop.LightweightContentWrapper;

class SwingNodeInteropN$SwingNodeContent
extends LightweightContentWrapper {
    private JComponent comp;
    private volatile FXDnD dnd;
    private WeakReference<SwingNode> swingNodeRef;

    SwingNodeInteropN$SwingNodeContent(JComponent jComponent, SwingNode swingNode) {
        this.comp = jComponent;
        this.swingNodeRef = new WeakReference<SwingNode>(swingNode);
    }

    @Override
    public JComponent getComponent() {
        return this.comp;
    }

    @Override
    public void paintLock() {
        SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
        if (swingNode != null) {
            SwingNodeHelper.getPaintLock(swingNode).lock();
        }
    }

    @Override
    public void paintUnlock() {
        SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
        if (swingNode != null) {
            SwingNodeHelper.getPaintLock(swingNode).unlock();
        }
    }

    @Override
    public void imageBufferReset(int[] nArray, int n2, int n3, int n4, int n5, int n6) {
        this.imageBufferReset(nArray, n2, n3, n4, n5, n6, 1);
    }

    public void imageBufferReset(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
        if (swingNode != null) {
            SwingNodeHelper.setImageBuffer(swingNode, nArray, n2, n3, n4, n5, n6, n7, n7);
        }
    }

    @Override
    public void imageBufferReset(int[] nArray, int n2, int n3, int n4, int n5, int n6, double d2, double d3) {
        SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
        if (swingNode != null) {
            SwingNodeHelper.setImageBuffer(swingNode, nArray, n2, n3, n4, n5, n6, d2, d3);
        }
    }

    @Override
    public void imageReshaped(int n2, int n3, int n4, int n5) {
        SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
        if (swingNode != null) {
            SwingNodeHelper.setImageBounds(swingNode, n2, n3, n4, n5);
        }
    }

    @Override
    public void imageUpdated(int n2, int n3, int n4, int n5) {
        SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
        if (swingNode != null) {
            SwingNodeHelper.repaintDirtyRegion(swingNode, n2, n3, n4, n5);
        }
    }

    @Override
    public void focusGrabbed() {
        SwingNodeHelper.runOnFxThread(() -> {
            Scene scene;
            if (PlatformUtil.isLinux()) {
                return;
            }
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null && (scene = swingNode.getScene()) != null && scene.getWindow() != null && WindowHelper.getPeer(scene.getWindow()) != null) {
                WindowHelper.getPeer(scene.getWindow()).grabFocus();
                SwingNodeHelper.setGrabbed(swingNode, true);
            }
        });
    }

    @Override
    public void focusUngrabbed() {
        SwingNodeHelper.runOnFxThread(() -> {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.getScene();
                SwingNodeHelper.ungrabFocus(swingNode, false);
            }
        });
    }

    @Override
    public void preferredSizeChanged(int n2, int n3) {
        SwingNodeHelper.runOnFxThread(() -> {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                SwingNodeHelper.setSwingPrefWidth(swingNode, n2);
                SwingNodeHelper.setSwingPrefHeight(swingNode, n3);
                NodeHelper.notifyLayoutBoundsChanged(swingNode);
            }
        });
    }

    @Override
    public void maximumSizeChanged(int n2, int n3) {
        SwingNodeHelper.runOnFxThread(() -> {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                SwingNodeHelper.setSwingMaxWidth(swingNode, n2);
                SwingNodeHelper.setSwingMaxHeight(swingNode, n3);
                NodeHelper.notifyLayoutBoundsChanged(swingNode);
            }
        });
    }

    @Override
    public void minimumSizeChanged(int n2, int n3) {
        SwingNodeHelper.runOnFxThread(() -> {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                SwingNodeHelper.setSwingMinWidth(swingNode, n2);
                SwingNodeHelper.setSwingMinHeight(swingNode, n3);
                NodeHelper.notifyLayoutBoundsChanged(swingNode);
            }
        });
    }

    public void setCursor(Cursor cursor) {
        SwingNodeHelper.runOnFxThread(() -> {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.setCursor(SwingCursors.embedCursorToCursor(cursor));
            }
        });
    }

    private void initDnD() {
        SwingNodeInteropN$SwingNodeContent swingNodeInteropN$SwingNodeContent = this;
        synchronized (swingNodeInteropN$SwingNodeContent) {
            SwingNode swingNode;
            if (this.dnd == null && (swingNode = (SwingNode)this.swingNodeRef.get()) != null) {
                this.dnd = new FXDnD(swingNode);
            }
            return;
        }
    }

    @Override
    public synchronized <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n2, DragGestureListener dragGestureListener) {
        this.initDnD();
        return this.dnd.createDragGestureRecognizer(clazz, dragSource, component, n2, dragGestureListener);
    }

    @Override
    public DragSourceContextWrapper createDragSourceContext(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        this.initDnD();
        return (DragSourceContextWrapper)this.dnd.createDragSourceContext(dragGestureEvent);
    }

    @Override
    public void addDropTarget(DropTarget dropTarget) {
        this.initDnD();
        this.dnd.addDropTarget(dropTarget);
    }

    @Override
    public void removeDropTarget(DropTarget dropTarget) {
        this.initDnD();
        this.dnd.removeDropTarget(dropTarget);
    }
}

