/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.event;

import com.sun.javafx.event.BasicEventDispatcher;
import com.sun.javafx.event.CompositeEventHandler;
import java.util.HashMap;
import java.util.Map;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;

public class EventHandlerManager
extends BasicEventDispatcher {
    private final Map<EventType<? extends Event>, CompositeEventHandler<? extends Event>> eventHandlerMap;
    private final Object eventSource;

    public EventHandlerManager(Object object) {
        this.eventSource = object;
        this.eventHandlerMap = new HashMap<EventType<? extends Event>, CompositeEventHandler<? extends Event>>();
    }

    public final <T extends Event> void addEventHandler(EventType<T> object, EventHandler<? super T> eventHandler) {
        EventHandlerManager.validateEventType(object);
        EventHandlerManager.validateEventHandler(eventHandler);
        object = this.createGetCompositeEventHandler((EventType<T>)object);
        ((CompositeEventHandler)object).addEventHandler(eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> object, EventHandler<? super T> eventHandler) {
        EventHandlerManager.validateEventType(object);
        EventHandlerManager.validateEventHandler(eventHandler);
        object = this.eventHandlerMap.get(object);
        if (object != null) {
            ((CompositeEventHandler)object).removeEventHandler(eventHandler);
        }
    }

    public final <T extends Event> void addEventFilter(EventType<T> object, EventHandler<? super T> eventHandler) {
        EventHandlerManager.validateEventType(object);
        EventHandlerManager.validateEventFilter(eventHandler);
        object = this.createGetCompositeEventHandler((EventType<T>)object);
        ((CompositeEventHandler)object).addEventFilter(eventHandler);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> object, EventHandler<? super T> eventHandler) {
        EventHandlerManager.validateEventType(object);
        EventHandlerManager.validateEventFilter(eventHandler);
        object = this.eventHandlerMap.get(object);
        if (object != null) {
            ((CompositeEventHandler)object).removeEventFilter(eventHandler);
        }
    }

    public final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        EventHandlerManager.validateEventType(eventType);
        CompositeEventHandler<Event> compositeEventHandler = this.eventHandlerMap.get(eventType);
        if (compositeEventHandler == null) {
            if (eventHandler == null) {
                return;
            }
            compositeEventHandler = new CompositeEventHandler();
            this.eventHandlerMap.put(eventType, compositeEventHandler);
        }
        compositeEventHandler.setEventHandler(eventHandler);
    }

    public final <T extends Event> EventHandler<? super T> getEventHandler(EventType<T> object) {
        if ((object = this.eventHandlerMap.get(object)) != null) {
            return ((CompositeEventHandler)object).getEventHandler();
        }
        return null;
    }

    @Override
    public final Event dispatchCapturingEvent(Event event) {
        EventType<? extends Event> eventType = event.getEventType();
        do {
            event = this.dispatchCapturingEvent(eventType, event);
        } while ((eventType = eventType.getSuperType()) != null);
        return event;
    }

    @Override
    public final Event dispatchBubblingEvent(Event event) {
        EventType<? extends Event> eventType = event.getEventType();
        do {
            event = this.dispatchBubblingEvent(eventType, event);
        } while ((eventType = eventType.getSuperType()) != null);
        return event;
    }

    private <T extends Event> CompositeEventHandler<T> createGetCompositeEventHandler(EventType<T> eventType) {
        CompositeEventHandler<Event> compositeEventHandler = this.eventHandlerMap.get(eventType);
        if (compositeEventHandler == null) {
            compositeEventHandler = new CompositeEventHandler();
            this.eventHandlerMap.put(eventType, compositeEventHandler);
        }
        return compositeEventHandler;
    }

    protected Object getEventSource() {
        return this.eventSource;
    }

    private Event dispatchCapturingEvent(EventType<? extends Event> object, Event event) {
        if ((object = this.eventHandlerMap.get(object)) != null && ((CompositeEventHandler)object).hasFilter()) {
            event = EventHandlerManager.fixEventSource(event, this.eventSource);
            ((CompositeEventHandler)object).dispatchCapturingEvent(event);
        }
        return event;
    }

    private Event dispatchBubblingEvent(EventType<? extends Event> object, Event event) {
        if ((object = this.eventHandlerMap.get(object)) != null && ((CompositeEventHandler)object).hasHandler()) {
            event = EventHandlerManager.fixEventSource(event, this.eventSource);
            ((CompositeEventHandler)object).dispatchBubblingEvent(event);
        }
        return event;
    }

    private static Event fixEventSource(Event event, Object object) {
        if (event.getSource() != object) {
            return event.copyFor(object, event.getTarget());
        }
        return event;
    }

    private static void validateEventType(EventType<?> eventType) {
        if (eventType == null) {
            throw new NullPointerException("Event type must not be null");
        }
    }

    private static void validateEventHandler(EventHandler<?> eventHandler) {
        if (eventHandler == null) {
            throw new NullPointerException("Event handler must not be null");
        }
    }

    private static void validateEventFilter(EventHandler<?> eventHandler) {
        if (eventHandler == null) {
            throw new NullPointerException("Event filter must not be null");
        }
    }
}

