/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.CompositeGlyphMapper;
import com.sun.javafx.font.CompositeStrike;
import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FontFallbackInfo;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.transform.BaseTransform;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FallbackResource
implements CompositeFontResource {
    FontResource primaryResource;
    private String[] linkedFontFiles;
    private String[] linkedFontNames;
    private FontResource[] fallbacks;
    private FontResource[] nativeFallbacks;
    private boolean isBold;
    private boolean isItalic;
    private int aaMode;
    private CompositeGlyphMapper mapper;
    Map<FontStrikeDesc, WeakReference<FontStrike>> strikeMap = new ConcurrentHashMap<FontStrikeDesc, WeakReference<FontStrike>>();
    static FallbackResource[] greyFallBackResource = new FallbackResource[4];
    static FallbackResource[] lcdFallBackResource = new FallbackResource[4];

    @Override
    public Map<FontStrikeDesc, WeakReference<FontStrike>> getStrikeMap() {
        return this.strikeMap;
    }

    FallbackResource(FontResource fontResource) {
        this.primaryResource = fontResource;
        this.aaMode = this.primaryResource.getDefaultAAMode();
        this.isBold = this.primaryResource.isBold();
        this.isItalic = this.primaryResource.isItalic();
    }

    static FallbackResource getFallbackResource(FontResource fontResource) {
        return new FallbackResource(fontResource);
    }

    FallbackResource(boolean bl2, boolean bl3, int n2) {
        this.isBold = bl2;
        this.isItalic = bl3;
        this.aaMode = n2;
    }

    static FallbackResource getFallbackResource(boolean bl2, boolean bl3, int n2) {
        FallbackResource fallbackResource;
        int n3;
        FallbackResource[] fallbackResourceArray = n2 == 0 ? greyFallBackResource : lcdFallBackResource;
        int n4 = n3 = bl2 ? 1 : 0;
        if (bl3) {
            n3 += 2;
        }
        if ((fallbackResource = fallbackResourceArray[n3]) == null) {
            fallbackResourceArray[n3] = fallbackResource = new FallbackResource(bl2, bl3, n2);
        }
        return fallbackResource;
    }

    @Override
    public int getDefaultAAMode() {
        return this.aaMode;
    }

    private String throwException() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getFullName() {
        return this.throwException();
    }

    @Override
    public String getPSName() {
        return this.throwException();
    }

    @Override
    public String getFamilyName() {
        return this.throwException();
    }

    @Override
    public String getStyleName() {
        return this.throwException();
    }

    @Override
    public String getLocaleFullName() {
        return this.throwException();
    }

    @Override
    public String getLocaleFamilyName() {
        return this.throwException();
    }

    @Override
    public String getLocaleStyleName() {
        return this.throwException();
    }

    @Override
    public boolean isBold() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean isItalic() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getFeatures() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getFileName() {
        return this.throwException();
    }

    @Override
    public Object getPeer() {
        return null;
    }

    @Override
    public void setPeer(Object object) {
        this.throwException();
    }

    @Override
    public boolean isEmbeddedFont() {
        return false;
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    private int getSlotForFontNoCreate(String string) {
        Object object;
        int n2;
        this.getLinkedFonts();
        int n3 = 0;
        Object[] objectArray = this.linkedFontNames;
        int n4 = this.linkedFontNames.length;
        for (n2 = 0; n2 < n4; ++n2) {
            object = objectArray[n2];
            if (string.equalsIgnoreCase((String)object)) {
                return n3;
            }
            ++n3;
        }
        if (this.nativeFallbacks != null) {
            objectArray = this.nativeFallbacks;
            n4 = this.nativeFallbacks.length;
            for (n2 = 0; n2 < n4; ++n2) {
                object = objectArray[n2];
                if (string.equalsIgnoreCase(object.getFullName())) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    @Override
    public int getSlotForFont(String string) {
        int n2 = this.getSlotForFontNoCreate(string);
        if (n2 >= 0) {
            return n2;
        }
        PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
        FontResource fontResource = prismFontFactory.getFontResource(string, null, false);
        if (fontResource == null) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\t Font name not supported \"" + string + "\".");
            }
            return -1;
        }
        int n3 = this.getSlotForFontNoCreate(fontResource.getFullName());
        if (n3 >= 0) {
            return n3;
        }
        return this.addNativeFallback(fontResource);
    }

    private int addNativeFallback(FontResource fontResource) {
        FontResource[] fontResourceArray;
        int n2 = this.getNumSlots();
        if (n2 >= 126) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\tToo many font fallbacks!");
            }
            return -1;
        }
        if (this.nativeFallbacks == null) {
            fontResourceArray = new FontResource[1];
        } else {
            fontResourceArray = new FontResource[this.nativeFallbacks.length + 1];
            System.arraycopy(this.nativeFallbacks, 0, fontResourceArray, 0, this.nativeFallbacks.length);
        }
        fontResourceArray[fontResourceArray.length - 1] = fontResource;
        this.nativeFallbacks = fontResourceArray;
        return n2 + 1;
    }

    @Override
    public int addSlotFont(FontResource fontResource) {
        int n2 = this.getSlotForFont(fontResource.getFullName());
        if (n2 >= 0) {
            return n2;
        }
        return this.addNativeFallback(fontResource);
    }

    private void getLinkedFonts() {
        if (this.fallbacks == null) {
            Object object = PrismFontFactory.getFontFactory();
            object = ((PrismFontFactory)object).getFallbacks(this.primaryResource);
            this.linkedFontNames = ((FontFallbackInfo)object).getFontNames();
            this.linkedFontFiles = ((FontFallbackInfo)object).getFontFiles();
            this.fallbacks = ((FontFallbackInfo)object).getFonts();
        }
    }

    @Override
    public int getNumSlots() {
        this.getLinkedFonts();
        int n2 = this.fallbacks.length;
        if (this.nativeFallbacks != null) {
            n2 += this.nativeFallbacks.length;
        }
        return n2;
    }

    @Override
    public float[] getGlyphBoundingBox(int n2, float f2, float[] fArray) {
        int n3 = n2 >>> 24;
        FontResource fontResource = this.getSlotResource(n3);
        return fontResource.getGlyphBoundingBox(n2 &= 0xFFFFFF, f2, fArray);
    }

    @Override
    public float getAdvance(int n2, float f2) {
        int n3 = n2 >>> 24;
        FontResource fontResource = this.getSlotResource(n3);
        return fontResource.getAdvance(n2 &= 0xFFFFFF, f2);
    }

    @Override
    public synchronized FontResource getSlotResource(int n2) {
        this.getLinkedFonts();
        if (n2 >= this.fallbacks.length) {
            if (this.nativeFallbacks == null || (n2 -= this.fallbacks.length) >= this.nativeFallbacks.length) {
                return null;
            }
            return this.nativeFallbacks[n2];
        }
        if (this.fallbacks[n2] == null) {
            String string = this.linkedFontFiles[n2];
            String string2 = this.linkedFontNames[n2];
            this.fallbacks[n2] = PrismFontFactory.getFontFactory().getFontResource(string2, string, false);
        }
        return this.fallbacks[n2];
    }

    @Override
    public FontStrike getStrike(float f2, BaseTransform baseTransform) {
        return this.getStrike(f2, baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float f2, BaseTransform baseTransform, int n2) {
        FontStrikeDesc fontStrikeDesc = new FontStrikeDesc(f2, baseTransform, n2);
        WeakReference<CompositeStrike> weakReference = this.strikeMap.get(fontStrikeDesc);
        CompositeStrike compositeStrike = null;
        if (weakReference != null) {
            compositeStrike = (CompositeStrike)weakReference.get();
        }
        if (compositeStrike == null) {
            compositeStrike = new CompositeStrike(this, f2, baseTransform, n2, fontStrikeDesc);
            if (compositeStrike.disposer != null) {
                CompositeStrike compositeStrike2 = compositeStrike;
                weakReference = Disposer.addRecord(compositeStrike2, compositeStrike2.disposer);
            } else {
                weakReference = new WeakReference<CompositeStrike>(compositeStrike);
            }
            this.strikeMap.put(fontStrikeDesc, weakReference);
        }
        return compositeStrike;
    }

    public String toString() {
        int n2 = this.getNumSlots();
        Object object = "Fallback resource:\n";
        for (int i2 = 0; i2 < n2; ++i2) {
            object = this.getSlotResource(i2) == null ? (String)object + "Slot " + i2 + "=null\n" : (String)object + "Slot " + i2 + "=" + this.getSlotResource(i2).getFullName() + "\n";
        }
        object = (String)object + "\n";
        return object;
    }
}

