/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConfigManager;
import com.sun.javafx.font.FontConfigManager$FcCompFont;
import com.sun.javafx.font.FontConfigManager$FontConfigFont;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

class FontConfigManager$EmbeddedFontSupport {
    private static String fontDirProp = null;
    private static String fontDir;
    private static boolean fontDirFromJRE;
    static String[] jreFontsProperties;

    private FontConfigManager$EmbeddedFontSupport() {
    }

    private static void initEmbeddedFonts() {
        fontDirProp = System.getProperty("prism.fontdir");
        if (fontDirProp != null) {
            fontDir = fontDirProp;
            return;
        }
        try {
            Object object = System.getProperty("java.home");
            if (object == null) {
                return;
            }
            if (((File)(object = new File((String)object, "lib/fonts"))).exists()) {
                fontDirFromJRE = true;
                fontDir = ((File)object).getPath();
            }
            if (FontConfigManager.debugFonts) {
                System.err.println("Fallback fontDir is " + String.valueOf(object) + " exists = " + ((File)object).exists());
            }
            return;
        }
        catch (Exception exception) {
            if (FontConfigManager.debugFonts) {
                exception.printStackTrace();
            }
            fontDir = "/";
            return;
        }
    }

    private static String getStyleStr(int n2) {
        switch (n2) {
            case 0: {
                return "regular";
            }
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "regular";
    }

    private static boolean exists(File file) {
        return AccessController.doPrivileged(() -> file.exists());
    }

    static void initLogicalFonts(FontConfigManager$FcCompFont[] fontConfigManager$FcCompFontArray) {
        Object object;
        Properties properties;
        block11: {
            properties = new Properties();
            try {
                File file = new File(fontDir, "logicalfonts.properties");
                if (file.exists()) {
                    object = new FileInputStream(file);
                    properties.load((InputStream)object);
                    ((FileInputStream)object).close();
                } else if (fontDirFromJRE) {
                    for (int i2 = 0; i2 < jreFontsProperties.length; i2 += 2) {
                        properties.setProperty(jreFontsProperties[i2], jreFontsProperties[i2 + 1]);
                    }
                    if (FontConfigManager.debugFonts) {
                        System.err.println("Using fallback implied logicalfonts.properties");
                    }
                }
            }
            catch (IOException iOException) {
                if (!FontConfigManager.debugFonts) break block11;
                System.err.println(iOException);
                return;
            }
        }
        for (int i3 = 0; i3 < fontConfigManager$FcCompFontArray.length; ++i3) {
            object = fontConfigManager$FcCompFontArray[i3].fcFamily;
            Object object2 = FontConfigManager$EmbeddedFontSupport.getStyleStr(fontConfigManager$FcCompFontArray[i3].style);
            object = (String)object + "." + (String)object2 + ".";
            object2 = new ArrayList();
            int n2 = 0;
            while (true) {
                Object object3 = properties.getProperty((String)object + n2 + ".file");
                String string = properties.getProperty((String)object + n2 + ".font");
                ++n2;
                if (object3 == null) break;
                if (!FontConfigManager$EmbeddedFontSupport.exists((File)(object3 = new File(fontDir, (String)object3)))) {
                    if (!FontConfigManager.debugFonts) continue;
                    System.out.println("Failed to find logical font file " + String.valueOf(object3));
                    continue;
                }
                FontConfigManager$FontConfigFont fontConfigManager$FontConfigFont = new FontConfigManager$FontConfigFont();
                new FontConfigManager$FontConfigFont().fontFile = ((File)object3).getPath();
                fontConfigManager$FontConfigFont.fullName = string;
                fontConfigManager$FontConfigFont.familyName = null;
                fontConfigManager$FontConfigFont.styleStr = null;
                if (fontConfigManager$FcCompFontArray[i3].firstFont == null) {
                    fontConfigManager$FcCompFontArray[i3].firstFont = fontConfigManager$FontConfigFont;
                }
                ((ArrayList)object2).add(fontConfigManager$FontConfigFont);
            }
            if (((ArrayList)object2).size() <= 0) continue;
            fontConfigManager$FcCompFontArray[i3].allFonts = new FontConfigManager$FontConfigFont[((ArrayList)object2).size()];
            ((ArrayList)object2).toArray(fontConfigManager$FcCompFontArray[i3].allFonts);
        }
    }

    static void populateMaps(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale cloneable) {
        cloneable = new Properties();
        AccessController.doPrivileged(() -> FontConfigManager$EmbeddedFontSupport.lambda$populateMaps$2((Properties)cloneable));
        if (!((Properties)cloneable).isEmpty()) {
            int n2 = Integer.MAX_VALUE;
            try {
                n2 = Integer.parseInt(((Properties)cloneable).getProperty("maxFont", ""));
            }
            catch (NumberFormatException numberFormatException) {}
            if (n2 <= 0) {
                n2 = Integer.MAX_VALUE;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                ArrayList<String> arrayList = ((Properties)cloneable).getProperty("family." + i2);
                String string = ((Properties)cloneable).getProperty("font." + i2);
                Object object = ((Properties)cloneable).getProperty("file." + i2);
                if (object == null) break;
                if (!FontConfigManager$EmbeddedFontSupport.exists((File)(object = new File(fontDir, (String)object))) || arrayList == null || string == null) continue;
                String string2 = string.toLowerCase(Locale.ENGLISH);
                String string3 = ((String)((Object)arrayList)).toLowerCase(Locale.ENGLISH);
                hashMap.put(string2, ((File)object).getPath());
                hashMap2.put(string2, (String)((Object)arrayList));
                arrayList = hashMap3.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(4);
                    hashMap3.put(string3, arrayList);
                }
                arrayList.add(string);
            }
        }
    }

    private static /* synthetic */ Void lambda$populateMaps$2(Properties properties) {
        block2: {
            try {
                Object object = fontDir + "/allfonts.properties";
                object = new FileInputStream((String)object);
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (IOException iOException) {
                properties.clear();
                if (!FontConfigManager.debugFonts) break block2;
                System.err.println(iOException);
                System.err.println("Fall back to opening the files");
            }
        }
        return null;
    }

    static {
        fontDirFromJRE = false;
        AccessController.doPrivileged(() -> {
            FontConfigManager$EmbeddedFontSupport.initEmbeddedFonts();
            return null;
        });
        jreFontsProperties = new String[]{"sans.regular.0.font", "Lucida Sans Regular", "sans.regular.0.file", "LucidaSansRegular.ttf", "sans.bold.0.font", "Lucida Sans Bold", "sans.bold.0.file", "LucidaSansDemiBold.ttf", "monospace.regular.0.font", "Lucida Typewriter Regular", "monospace.regular.0.file", "LucidaTypewriterRegular.ttf", "monospace.bold.0.font", "Lucida Typewriter Bold", "monospace.bold.0.file", "LucidaTypewriterBold.ttf", "serif.regular.0.font", "Lucida Bright", "serif.regular.0.file", "LucidaBrightRegular.ttf", "serif.bold.0.font", "Lucida Bright Demibold", "serif.bold.0.file", "LucidaBrightDemiBold.ttf", "serif.italic.0.font", "Lucida Bright Italic", "serif.italic.0.file", "LucidaBrightItalic.ttf", "serif.bolditalic.0.font", "Lucida Bright Demibold Italic", "serif.bolditalic.0.file", "LucidaBrightDemiItalic.ttf"};
    }
}

