/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConfigManager$EmbeddedFontSupport;
import com.sun.javafx.font.FontConfigManager$FcCompFont;
import com.sun.javafx.font.FontConfigManager$FontConfigFont;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class FontConfigManager {
    static boolean debugFonts = false;
    static boolean useFontConfig = true;
    static boolean fontConfigFailed = false;
    static boolean useEmbeddedFontSupport = false;
    private static final String[] fontConfigNames;
    private static FontConfigManager$FcCompFont[] fontConfigFonts;
    private static String defaultFontFile;

    private FontConfigManager() {
    }

    private static String[] getFontConfigNames() {
        return fontConfigNames;
    }

    private static String getFCLocaleStr() {
        Object object = Locale.getDefault();
        Object object2 = ((Locale)object).getLanguage();
        if (!((String)(object = ((Locale)object).getCountry())).equals("")) {
            object2 = (String)object2 + "-" + (String)object;
        }
        return object2;
    }

    private static native boolean getFontConfig(String var0, FontConfigManager$FcCompFont[] var1, boolean var2);

    private static synchronized void initFontConfigLogFonts() {
        int n2;
        int n3;
        if (fontConfigFonts != null || fontConfigFailed) {
            return;
        }
        long l2 = 0L;
        if (debugFonts) {
            l2 = System.nanoTime();
        }
        String[] stringArray = FontConfigManager.getFontConfigNames();
        Object object = new FontConfigManager$FcCompFont[stringArray.length];
        for (n3 = 0; n3 < ((FontConfigManager$FcCompFont[])object).length; ++n3) {
            object[n3] = new FontConfigManager$FcCompFont();
            object[n3].fcName = stringArray[n3];
            int n4 = object[n3].fcName.indexOf(58);
            object[n3].fcFamily = object[n3].fcName.substring(0, n4);
            object[n3].style = n3 % 4;
        }
        n3 = 0;
        if (useFontConfig) {
            n3 = FontConfigManager.getFontConfig(FontConfigManager.getFCLocaleStr(), object, true) ? 1 : 0;
        } else if (debugFonts) {
            System.err.println("Not using FontConfig");
        }
        if (useEmbeddedFontSupport || n3 == 0) {
            FontConfigManager$EmbeddedFontSupport.initLogicalFonts(object);
        }
        FontConfigManager$FontConfigFont fontConfigManager$FontConfigFont = null;
        for (n2 = 0; n2 < ((FontConfigManager$FcCompFont[])object).length; ++n2) {
            FontConfigManager$FcCompFont fontConfigManager$FcCompFont = object[n2];
            if (fontConfigManager$FcCompFont.firstFont == null) {
                if (debugFonts) {
                    System.err.println("Fontconfig returned no font for " + object[n2].fcName);
                }
                fontConfigFailed = true;
                continue;
            }
            if (fontConfigManager$FontConfigFont != null) continue;
            fontConfigManager$FontConfigFont = fontConfigManager$FcCompFont.firstFont;
            defaultFontFile = fontConfigManager$FontConfigFont.fontFile;
        }
        if (fontConfigManager$FontConfigFont == null) {
            fontConfigFailed = true;
            System.err.println("Error: JavaFX detected no fonts! Please refer to release notes for proper font configuration");
            return;
        }
        if (fontConfigFailed) {
            for (n2 = 0; n2 < ((FontConfigManager$FcCompFont[])object).length; ++n2) {
                if (object[n2].firstFont != null) continue;
                object[n2].firstFont = fontConfigManager$FontConfigFont;
            }
        }
        fontConfigFonts = object;
        if (debugFonts) {
            long l3 = System.nanoTime();
            System.err.println("Time spent accessing fontconfig=" + (l3 - l2) / 1000000L + "ms.");
            for (int i2 = 0; i2 < fontConfigFonts.length; ++i2) {
                FontConfigManager$FcCompFont fontConfigManager$FcCompFont = fontConfigFonts[i2];
                System.err.println("FC font " + fontConfigManager$FcCompFont.fcName + " maps to " + fontConfigManager$FcCompFont.firstFont.fullName + " in file " + fontConfigManager$FcCompFont.firstFont.fontFile);
                if (fontConfigManager$FcCompFont.allFonts == null) continue;
                for (int i3 = 0; i3 < fontConfigManager$FcCompFont.allFonts.length; ++i3) {
                    object = fontConfigManager$FcCompFont.allFonts[i3];
                    System.err.println(" " + i3 + ") Family=" + object.familyName + ", Style=" + object.styleStr + ", Fullname=" + object.fullName + ", File=" + object.fontFile);
                }
            }
        }
    }

    private static native boolean populateMapsNative(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    public static void populateMaps(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
        boolean bl2 = false;
        if (useFontConfig && !fontConfigFailed) {
            bl2 = FontConfigManager.populateMapsNative(hashMap, hashMap2, hashMap3, locale);
        }
        if (fontConfigFailed || useEmbeddedFontSupport || !bl2) {
            FontConfigManager$EmbeddedFontSupport.populateMaps(hashMap, hashMap2, hashMap3, locale);
        }
    }

    private static String mapFxToFcLogicalFamilyName(String string) {
        if (string.equals("serif")) {
            return "serif";
        }
        if (string.equals("monospaced")) {
            return "monospace";
        }
        return "sans";
    }

    public static FontConfigManager$FcCompFont getFontConfigFont(String string, boolean n2, boolean bl2) {
        FontConfigManager.initFontConfigLogFonts();
        if (fontConfigFonts == null) {
            return null;
        }
        string = FontConfigManager.mapFxToFcLogicalFamilyName(string.toLowerCase());
        int n3 = n2 = n2 != 0 ? 1 : 0;
        if (bl2) {
            n2 += 2;
        }
        FontConfigManager$FcCompFont fontConfigManager$FcCompFont = null;
        for (int i2 = 0; i2 < fontConfigFonts.length; ++i2) {
            if (!string.equals(FontConfigManager.fontConfigFonts[i2].fcFamily) || n2 != FontConfigManager.fontConfigFonts[i2].style) continue;
            fontConfigManager$FcCompFont = fontConfigFonts[i2];
            break;
        }
        if (fontConfigManager$FcCompFont == null) {
            fontConfigManager$FcCompFont = fontConfigFonts[0];
        }
        if (debugFonts) {
            System.err.println("FC name=" + string + " style=" + n2 + " uses " + fontConfigManager$FcCompFont.firstFont.fullName + " in file: " + fontConfigManager$FcCompFont.firstFont.fontFile);
        }
        return fontConfigManager$FcCompFont;
    }

    public static String getDefaultFontPath() {
        if (fontConfigFonts == null && !fontConfigFailed) {
            FontConfigManager.getFontConfigFont("System", false, false);
        }
        return defaultFontFile;
    }

    public static ArrayList<String> getFileNames(FontConfigManager$FcCompFont fontConfigManager$FcCompFont, boolean n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fontConfigManager$FcCompFont.allFonts != null) {
            n2 = n2 != 0 ? 1 : 0;
            for (n2 = n2; n2 < fontConfigManager$FcCompFont.allFonts.length; ++n2) {
                arrayList.add(fontConfigManager$FcCompFont.allFonts[n2].fontFile);
            }
        }
        return arrayList;
    }

    public static ArrayList<String> getFontNames(FontConfigManager$FcCompFont fontConfigManager$FcCompFont, boolean n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fontConfigManager$FcCompFont.allFonts != null) {
            n2 = n2 != 0 ? 1 : 0;
            for (n2 = n2; n2 < fontConfigManager$FcCompFont.allFonts.length; ++n2) {
                arrayList.add(fontConfigManager$FcCompFont.allFonts[n2].fullName);
            }
        }
        return arrayList;
    }

    static {
        AccessController.doPrivileged(() -> {
            String string = System.getProperty("prism.debugfonts", "");
            debugFonts = "true".equals(string);
            string = System.getProperty("prism.useFontConfig", "true");
            useFontConfig = "true".equals(string);
            string = System.getProperty("prism.embeddedfonts", "");
            useEmbeddedFontSupport = "true".equals(string);
            return null;
        });
        fontConfigNames = new String[]{"sans:regular:roman", "sans:bold:roman", "sans:regular:italic", "sans:bold:italic", "serif:regular:roman", "serif:bold:roman", "serif:regular:italic", "serif:bold:italic", "monospace:regular:roman", "monospace:bold:roman", "monospace:regular:italic", "monospace:bold:italic"};
    }
}

