/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConstants;
import com.sun.javafx.font.FontFileReader$Buffer;
import com.sun.javafx.font.PrismFontFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;

class FontFileReader
implements FontConstants {
    String filename;
    long filesize;
    RandomAccessFile raFile;
    private static final int READBUFFERSIZE = 1024;
    private byte[] readBuffer;
    private int readBufferLen;
    private int readBufferStart;

    public FontFileReader(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public synchronized boolean openFile() throws PrivilegedActionException {
        if (this.raFile != null) {
            return false;
        }
        this.raFile = AccessController.doPrivileged(() -> {
            try {
                return new RandomAccessFile(this.filename, "r");
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        });
        if (this.raFile != null) {
            try {
                this.filesize = this.raFile.length();
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public synchronized void closeFile() throws IOException {
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
            this.readBuffer = null;
        }
    }

    public synchronized long getLength() {
        return this.filesize;
    }

    public synchronized void reset() throws IOException {
        if (this.raFile != null) {
            this.raFile.seek(0L);
        }
    }

    private synchronized int readFromFile(byte[] byArray, long l2, int n2) {
        try {
            this.raFile.seek(l2);
            int n3 = this.raFile.read(byArray, 0, n2);
            return n3;
        }
        catch (IOException iOException) {
            if (PrismFontFactory.debugFonts) {
                iOException.printStackTrace();
            }
            return 0;
        }
    }

    public synchronized FontFileReader$Buffer readBlock(int n2, int n3) {
        if (this.readBuffer == null) {
            this.readBuffer = new byte[1024];
            this.readBufferLen = 0;
        }
        if (n3 <= 1024) {
            if (this.readBufferStart <= n2 && this.readBufferStart + this.readBufferLen >= n2 + n3) {
                return new FontFileReader$Buffer(this.readBuffer, n2 - this.readBufferStart);
            }
            this.readBufferStart = n2;
            this.readBufferLen = (long)(n2 + 1024) > this.filesize ? (int)this.filesize - n2 : 1024;
            FontFileReader fontFileReader = this;
            fontFileReader.readFromFile(fontFileReader.readBuffer, this.readBufferStart, this.readBufferLen);
            return new FontFileReader$Buffer(this.readBuffer, 0);
        }
        byte[] byArray = new byte[n3];
        this.readFromFile(byArray, n2, n3);
        return new FontFileReader$Buffer(byArray, 0);
    }
}

