/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.CompositeGlyphMapper;
import com.sun.javafx.font.CompositeStrike;
import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FontConfigManager;
import com.sun.javafx.font.FontConfigManager$FcCompFont;
import com.sun.javafx.font.FontFallbackInfo;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.transform.BaseTransform;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogicalFont
implements CompositeFontResource {
    public static final String SYSTEM = "System";
    public static final String SERIF = "Serif";
    public static final String SANS_SERIF = "SansSerif";
    public static final String MONOSPACED = "Monospaced";
    public static final String STYLE_REGULAR = "Regular";
    public static final String STYLE_BOLD = "Bold";
    public static final String STYLE_ITALIC = "Italic";
    public static final String STYLE_BOLD_ITALIC = "Bold Italic";
    private static final Map<String, String> CANONICAL_FAMILY_MAP = Map.of("system", "System", "serif", "Serif", "sansserif", "SansSerif", "sans-serif", "SansSerif", "dialog", "SansSerif", "default", "SansSerif", "monospaced", "Monospaced", "monospace", "Monospaced", "dialoginput", "Monospaced");
    static LogicalFont[] logicalFonts = new LogicalFont[16];
    boolean isBold;
    boolean isItalic;
    private String fullName;
    private String familyName;
    private String styleName;
    private String physicalFamily;
    private String physicalFullName;
    private String physicalFileName;
    private FontResource slot0FontResource;
    private volatile String[] linkedFontNames;
    private volatile String[] linkedFontFiles;
    private volatile FontResource[] fallbacks;
    private volatile FontResource[] nativeFallbacks;
    CompositeGlyphMapper mapper;
    Map<FontStrikeDesc, WeakReference<FontStrike>> strikeMap = new ConcurrentHashMap<FontStrikeDesc, WeakReference<FontStrike>>();
    private static final int SANS_SERIF_INDEX = 0;
    private static final int SERIF_INDEX = 1;
    private static final int MONOSPACED_INDEX = 2;
    private static final int SYSTEM_INDEX = 3;
    static String[][] logFamilies = null;
    private int hash;

    static boolean isLogicalFont(String string) {
        int n2 = string.indexOf(32);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return CANONICAL_FAMILY_MAP.get(string) != null;
    }

    private static String getCanonicalFamilyName(String string) {
        if (string == null) {
            return SANS_SERIF;
        }
        string = string.toLowerCase();
        return CANONICAL_FAMILY_MAP.get(string);
    }

    static PGFont getLogicalFont(String string, boolean bl2, boolean bl3, float f2) {
        LogicalFont logicalFont;
        if ((string = LogicalFont.getCanonicalFamilyName(string)) == null) {
            return null;
        }
        int n2 = string.equals(SANS_SERIF) ? 0 : (string.equals(SERIF) ? 4 : (string.equals(MONOSPACED) ? 8 : 12));
        if (bl2) {
            ++n2;
        }
        if (bl3) {
            n2 += 2;
        }
        if ((logicalFont = logicalFonts[n2]) == null) {
            LogicalFont.logicalFonts[n2] = logicalFont = new LogicalFont(string, bl2, bl3);
        }
        LogicalFont logicalFont2 = logicalFont;
        return new PrismFont(logicalFont2, logicalFont2.getFullName(), f2);
    }

    static PGFont getLogicalFont(String string, float f2) {
        int n2 = string.indexOf(32);
        if (n2 == -1 || n2 == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(0, n2);
        if ((string2 = LogicalFont.getCanonicalFamilyName(string2)) == null) {
            return null;
        }
        string = string.substring(n2 + 1).toLowerCase();
        n2 = 0;
        boolean bl2 = false;
        if (!string.equals("regular")) {
            if (string.equals("bold")) {
                n2 = 1;
            } else if (string.equals("italic")) {
                bl2 = true;
            } else if (string.equals("bold italic")) {
                n2 = 1;
                bl2 = true;
            } else {
                return null;
            }
        }
        return LogicalFont.getLogicalFont(string2, n2 != 0, bl2, f2);
    }

    private LogicalFont(String object, boolean bl2, boolean bl3) {
        this.familyName = object;
        this.isBold = bl2;
        this.isItalic = bl3;
        this.styleName = !bl2 && !bl3 ? STYLE_REGULAR : (bl2 && !bl3 ? STYLE_BOLD : (!bl2 && bl3 ? STYLE_ITALIC : STYLE_BOLD_ITALIC));
        this.fullName = this.familyName + " " + this.styleName;
        if (PrismFontFactory.isLinux) {
            object = FontConfigManager.getFontConfigFont((String)object, bl2, bl3);
            this.physicalFullName = ((FontConfigManager$FcCompFont)object).firstFont.fullName;
            this.physicalFileName = ((FontConfigManager$FcCompFont)object).firstFont.fontFile;
            return;
        }
        this.physicalFamily = PrismFontFactory.getSystemFont(this.familyName);
    }

    private FontResource getSlot0Resource() {
        if (this.slot0FontResource == null) {
            PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
            this.slot0FontResource = this.physicalFamily != null ? prismFontFactory.getFontResource(this.physicalFamily, this.isBold, this.isItalic, false) : prismFontFactory.getFontResource(this.physicalFullName, this.physicalFileName, false);
            if (this.slot0FontResource == null) {
                this.slot0FontResource = prismFontFactory.getDefaultFontResource(false);
            }
        }
        return this.slot0FontResource;
    }

    private void getLinkedFonts() {
        if (this.fallbacks == null) {
            Object object = PrismFontFactory.getFontFactory();
            object = ((PrismFontFactory)object).getFallbacks(this.getSlot0Resource());
            this.linkedFontNames = ((FontFallbackInfo)object).getFontNames();
            this.linkedFontFiles = ((FontFallbackInfo)object).getFontFiles();
            this.fallbacks = ((FontFallbackInfo)object).getFonts();
        }
    }

    @Override
    public int getNumSlots() {
        this.getLinkedFonts();
        int n2 = this.fallbacks.length;
        if (this.nativeFallbacks != null) {
            n2 += this.nativeFallbacks.length;
        }
        return n2 + 1;
    }

    private int getSlotForFontNoCreate(String string) {
        Object object;
        int n2;
        if (string.equals(this.getSlot0Resource().getFullName())) {
            return 0;
        }
        this.getLinkedFonts();
        int n3 = 1;
        Object[] objectArray = this.linkedFontNames;
        int n4 = this.linkedFontNames.length;
        for (n2 = 0; n2 < n4; ++n2) {
            object = objectArray[n2];
            if (string.equalsIgnoreCase((String)object)) {
                return n3;
            }
            ++n3;
        }
        if (this.nativeFallbacks != null) {
            objectArray = this.nativeFallbacks;
            n4 = this.nativeFallbacks.length;
            for (n2 = 0; n2 < n4; ++n2) {
                object = objectArray[n2];
                if (string.equalsIgnoreCase(object.getFullName())) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    @Override
    public int getSlotForFont(String string) {
        int n2 = this.getSlotForFontNoCreate(string);
        if (n2 >= 0) {
            return n2;
        }
        PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
        FontResource fontResource = prismFontFactory.getFontResource(string, null, false);
        if (fontResource == null) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\t Font name not supported \"" + string + "\".");
            }
            return -1;
        }
        int n3 = this.getSlotForFontNoCreate(fontResource.getFullName());
        if (n3 >= 0) {
            return n3;
        }
        return this.addNativeFallback(fontResource);
    }

    private int addNativeFallback(FontResource fontResource) {
        FontResource[] fontResourceArray;
        int n2 = this.getNumSlots();
        if (n2 >= 126) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\tToo many font fallbacks!");
            }
            return -1;
        }
        if (this.nativeFallbacks == null) {
            fontResourceArray = new FontResource[1];
        } else {
            fontResourceArray = new FontResource[this.nativeFallbacks.length + 1];
            System.arraycopy(this.nativeFallbacks, 0, fontResourceArray, 0, this.nativeFallbacks.length);
        }
        fontResourceArray[fontResourceArray.length - 1] = fontResource;
        this.nativeFallbacks = fontResourceArray;
        return n2;
    }

    @Override
    public int addSlotFont(FontResource fontResource) {
        if (fontResource == null) {
            return -1;
        }
        int n2 = this.getSlotForFont(fontResource.getFullName());
        if (n2 >= 0) {
            return n2;
        }
        return this.addNativeFallback(fontResource);
    }

    @Override
    public FontResource getSlotResource(int n2) {
        if (n2 == 0) {
            return this.getSlot0Resource();
        }
        this.getLinkedFonts();
        if (--n2 >= this.fallbacks.length) {
            if (this.nativeFallbacks == null || (n2 -= this.fallbacks.length) >= this.nativeFallbacks.length) {
                return null;
            }
            return this.nativeFallbacks[n2];
        }
        if (this.fallbacks[n2] == null) {
            String string = this.linkedFontFiles[n2];
            String string2 = this.linkedFontNames[n2];
            this.fallbacks[n2] = PrismFontFactory.getFontFactory().getFontResource(string2, string, false);
            if (this.fallbacks[n2] == null) {
                this.fallbacks[n2] = this.getSlot0Resource();
            }
        }
        return this.fallbacks[n2];
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getPSName() {
        return this.fullName;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getStyleName() {
        return this.styleName;
    }

    @Override
    public String getLocaleFullName() {
        return this.fullName;
    }

    @Override
    public String getLocaleFamilyName() {
        return this.familyName;
    }

    @Override
    public String getLocaleStyleName() {
        return this.styleName;
    }

    @Override
    public boolean isBold() {
        return this.getSlotResource(0).isBold();
    }

    @Override
    public boolean isItalic() {
        return this.getSlotResource(0).isItalic();
    }

    @Override
    public String getFileName() {
        return this.getSlotResource(0).getFileName();
    }

    @Override
    public int getFeatures() {
        return this.getSlotResource(0).getFeatures();
    }

    @Override
    public Object getPeer() {
        return null;
    }

    @Override
    public boolean isEmbeddedFont() {
        return this.getSlotResource(0).isEmbeddedFont();
    }

    @Override
    public void setPeer(Object object) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public float[] getGlyphBoundingBox(int n2, float f2, float[] fArray) {
        int n3 = n2 >>> 24;
        FontResource fontResource = this.getSlotResource(n3);
        return fontResource.getGlyphBoundingBox(n2 &= 0xFFFFFF, f2, fArray);
    }

    @Override
    public float getAdvance(int n2, float f2) {
        int n3 = n2 >>> 24;
        FontResource fontResource = this.getSlotResource(n3);
        return fontResource.getAdvance(n2 &= 0xFFFFFF, f2);
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    public Map<FontStrikeDesc, WeakReference<FontStrike>> getStrikeMap() {
        return this.strikeMap;
    }

    @Override
    public int getDefaultAAMode() {
        return this.getSlot0Resource().getDefaultAAMode();
    }

    @Override
    public FontStrike getStrike(float f2, BaseTransform baseTransform) {
        return this.getStrike(f2, baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float f2, BaseTransform baseTransform, int n2) {
        FontStrikeDesc fontStrikeDesc = new FontStrikeDesc(f2, baseTransform, n2);
        WeakReference<CompositeStrike> weakReference = this.strikeMap.get(fontStrikeDesc);
        CompositeStrike compositeStrike = null;
        if (weakReference != null) {
            compositeStrike = (CompositeStrike)weakReference.get();
        }
        if (compositeStrike == null) {
            compositeStrike = new CompositeStrike(this, f2, baseTransform, n2, fontStrikeDesc);
            if (compositeStrike.disposer != null) {
                CompositeStrike compositeStrike2 = compositeStrike;
                weakReference = Disposer.addRecord(compositeStrike2, compositeStrike2.disposer);
            } else {
                weakReference = new WeakReference<CompositeStrike>(compositeStrike);
            }
            this.strikeMap.put(fontStrikeDesc, weakReference);
        }
        return compositeStrike;
    }

    private static void buildFamily(String[] stringArray, String string) {
        stringArray[0] = string + " Regular";
        stringArray[1] = string + " Bold";
        stringArray[2] = string + " Italic";
        stringArray[3] = string + " Bold Italic";
    }

    private static void buildFamilies() {
        if (logFamilies == null) {
            String[][] stringArray = new String[4][4];
            LogicalFont.buildFamily(stringArray[0], SANS_SERIF);
            LogicalFont.buildFamily(stringArray[1], SERIF);
            LogicalFont.buildFamily(stringArray[2], MONOSPACED);
            LogicalFont.buildFamily(stringArray[3], SYSTEM);
            logFamilies = stringArray;
        }
    }

    static void addFamilies(ArrayList<String> arrayList) {
        arrayList.add(SANS_SERIF);
        arrayList.add(SERIF);
        arrayList.add(MONOSPACED);
        arrayList.add(SYSTEM);
    }

    static void addFullNames(ArrayList<String> arrayList) {
        LogicalFont.buildFamilies();
        for (int i2 = 0; i2 < logFamilies.length; ++i2) {
            for (int i3 = 0; i3 < logFamilies[i2].length; ++i3) {
                arrayList.add(logFamilies[i2][i3]);
            }
        }
    }

    static String[] getFontsInFamily(String string) {
        if ((string = LogicalFont.getCanonicalFamilyName(string)) == null) {
            return null;
        }
        LogicalFont.buildFamilies();
        if (string.equals(SANS_SERIF)) {
            return logFamilies[0];
        }
        if (string.equals(SERIF)) {
            return logFamilies[1];
        }
        if (string.equals(MONOSPACED)) {
            return logFamilies[2];
        }
        return logFamilies[3];
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof LogicalFont)) {
            return false;
        }
        object = (LogicalFont)object;
        return this.fullName.equals(((LogicalFont)object).fullName);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.fullName.hashCode();
        return this.hash;
    }
}

