/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontUtils;
import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.FontMetrics;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class PrismFontLoader
extends FontLoader {
    private static PrismFontLoader theInstance = new PrismFontLoader();
    private boolean embeddedFontsLoaded = false;
    FontFactory installedFontFactory = null;

    public static PrismFontLoader getInstance() {
        return theInstance;
    }

    Properties loadEmbeddedFontDefinitions() {
        Properties properties = new Properties();
        Object object = Thread.currentThread().getContextClassLoader();
        if (object == null) {
            return properties;
        }
        if ((object = ((ClassLoader)object).getResource("META-INF/fonts.mf")) == null) {
            return properties;
        }
        try {
            object = ((URL)object).openStream();
            try {
                properties.load((InputStream)object);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return properties;
    }

    private void loadEmbeddedFonts() {
        if (!this.embeddedFontsLoaded) {
            FontFactory fontFactory = this.getFontFactoryFromPipeline();
            if (!fontFactory.hasPermission()) {
                this.embeddedFontsLoaded = true;
                return;
            }
            Properties properties = this.loadEmbeddedFontDefinitions();
            Enumeration<Object> enumeration = properties.keys();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = properties.getProperty(string);
                if (!((String)object).startsWith("/")) continue;
                object = ((String)object).substring(1);
                try {
                    object = classLoader.getResourceAsStream((String)object);
                    try {
                        fontFactory.loadEmbeddedFont(string, (InputStream)object, 0.0f, true, false);
                    }
                    finally {
                        if (object == null) continue;
                        ((InputStream)object).close();
                    }
                }
                catch (Exception exception) {}
            }
            this.embeddedFontsLoaded = true;
        }
    }

    private Font[] createFonts(PGFont[] pGFontArray) {
        if (pGFontArray == null || pGFontArray.length == 0) {
            return null;
        }
        Font[] fontArray = new Font[pGFontArray.length];
        for (int i2 = 0; i2 < pGFontArray.length; ++i2) {
            fontArray[i2] = this.createFont(pGFontArray[i2]);
        }
        return fontArray;
    }

    @Override
    public Font[] loadFont(InputStream pGFontArray, double d2, boolean bl2) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        pGFontArray = fontFactory.loadEmbeddedFont(null, (InputStream)pGFontArray, (float)d2, true, bl2);
        return this.createFonts(pGFontArray);
    }

    @Override
    public Font[] loadFont(String pGFontArray, double d2, boolean bl2) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        pGFontArray = fontFactory.loadEmbeddedFont(null, (String)pGFontArray, (float)d2, true, bl2);
        return this.createFonts(pGFontArray);
    }

    private Font createFont(PGFont pGFont) {
        PGFont pGFont2 = pGFont;
        return FontHelper.nativeFont(pGFont2, pGFont2.getName(), pGFont.getFamilyName(), pGFont.getStyleName(), pGFont.getSize());
    }

    @Override
    public List<String> getFamilies() {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFamilyNames());
    }

    @Override
    public List<String> getFontNames() {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames());
    }

    @Override
    public List<String> getFontNames(String string) {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames(string));
    }

    @Override
    public Font font(String object, FontWeight fontWeight, FontPosture fontPosture, float f2) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        if (!this.embeddedFontsLoaded && !fontFactory.isPlatformFont((String)object)) {
            this.loadEmbeddedFonts();
        }
        boolean bl2 = fontWeight != null && fontWeight.ordinal() >= FontWeight.BOLD.ordinal();
        boolean bl3 = fontPosture == FontPosture.ITALIC;
        object = fontFactory.createFont((String)object, bl2, bl3, f2);
        object = FontHelper.nativeFont(object, object.getName(), object.getFamilyName(), object.getStyleName(), f2);
        return object;
    }

    @Override
    public void loadFont(Font font) {
        Object object = this.getFontFactoryFromPipeline();
        String string = font.getName();
        if (!this.embeddedFontsLoaded && !object.isPlatformFont(string)) {
            this.loadEmbeddedFonts();
        }
        object = object.createFont(string, (float)font.getSize());
        string = object.getName();
        String string2 = object.getFamilyName();
        String string3 = object.getStyleName();
        FontHelper.setNativeFont(font, object, string, string2, string3);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (font != null) {
            Object object = (PGFont)FontHelper.getNativeFont(font);
            object = PrismFontUtils.getFontMetrics((PGFont)object);
            float f2 = -object.getAscent();
            float f3 = -object.getAscent();
            float f4 = object.getXHeight();
            float f5 = object.getDescent();
            float f6 = object.getDescent();
            float f7 = object.getLineGap();
            return FontMetrics.createFontMetrics(f2, f3, f4, f5, f6, f7, font);
        }
        return null;
    }

    @Override
    public float getCharWidth(char c2, Font object) {
        object = (PGFont)FontHelper.getNativeFont((Font)object);
        return (float)PrismFontUtils.getCharWidth((PGFont)object, c2);
    }

    @Override
    public float getSystemFontSize() {
        return PrismFontFactory.getSystemFontSize();
    }

    private FontFactory getFontFactoryFromPipeline() {
        if (this.installedFontFactory != null) {
            return this.installedFontFactory;
        }
        try {
            Object object = Class.forName("com.sun.prism.GraphicsPipeline");
            Object object2 = ((Class)object).getMethod("getPipeline", null);
            object2 = ((Method)object2).invoke(null, new Object[0]);
            object = ((Class)object).getMethod("getFontFactory", null);
            object = ((Method)object).invoke(object2, new Object[0]);
            this.installedFontFactory = (FontFactory)object;
        }
        catch (Exception exception) {}
        return this.installedFontFactory;
    }
}

