/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.coretext;

import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FontFallbackInfo;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.MacFontFinder;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.coretext.CGAffineTransform;
import com.sun.javafx.font.coretext.CGRect;
import com.sun.javafx.font.coretext.CGSize;
import com.sun.javafx.font.coretext.CTFactory;
import com.sun.javafx.font.coretext.CTFontFile$SelfDisposerRecord;
import com.sun.javafx.font.coretext.CTFontStrike;
import com.sun.javafx.font.coretext.OS;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;

class CTFontFile
extends PrismFontFile {
    private long cgFontRef = 0L;
    private static final CGAffineTransform tx = new CGAffineTransform();
    private long ctFontRef = 0L;

    CTFontFile(String string, String string2, int n2, long l2) throws Exception {
        super(string, string2, n2, false, false, false, false);
        if (l2 == 0L) {
            throw new InternalError("Zero fontref");
        }
        this.ctFontRef = l2;
        Disposer.addRecord(this, new CTFontFile$SelfDisposerRecord(this.ctFontRef));
    }

    CTFontFile(String string, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws Exception {
        super(string, string2, n2, bl2, bl3, bl4, bl5);
        if (string != null && (string2 = this.getFamilyName()).equals("System Font")) {
            this.fullName = string;
        }
        if (bl3) {
            this.cgFontRef = this.createCGFontForEmbeddedFont();
            Disposer.addRecord(this, new CTFontFile$SelfDisposerRecord(this.cgFontRef));
            return;
        }
        this.cgFontRef = 0L;
    }

    @Override
    public boolean isBold() {
        return this.fullName.equals("System Font Bold") || super.isBold();
    }

    public static boolean registerFont(String string) {
        if (string == null) {
            return false;
        }
        long l2 = OS.kCFAllocatorDefault();
        boolean bl2 = false;
        long l3 = OS.CFStringCreate(string);
        if (l3 != 0L) {
            long l4 = OS.CFURLCreateWithFileSystemPath(l2, l3, 0L, false);
            if (l4 != 0L) {
                bl2 = OS.CTFontManagerRegisterFontsForURL(l4, 1, 0L);
                OS.CFRelease(l4);
            }
            OS.CFRelease(l3);
        }
        return bl2;
    }

    private long createCGFontForEmbeddedFont() {
        long l2 = 0L;
        long l3 = OS.CFStringCreate(this.getFileName());
        if (l3 != 0L) {
            long l4 = OS.CFURLCreateWithFileSystemPath(OS.kCFAllocatorDefault(), l3, 0L, false);
            if (l4 != 0L) {
                long l5 = OS.CGDataProviderCreateWithURL(l4);
                if (l5 != 0L) {
                    l2 = OS.CGFontCreateWithDataProvider(l5);
                    OS.CFRelease(l5);
                }
                OS.CFRelease(l4);
            }
            OS.CFRelease(l3);
        }
        return l2;
    }

    long getCGFontRef() {
        return this.cgFontRef;
    }

    CGRect getBBox(int n2, float f2) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f2, BaseTransform.IDENTITY_TRANSFORM);
        long l2 = cTFontStrike.getFontRef();
        if (l2 == 0L) {
            return null;
        }
        long l3 = OS.CTFontCreatePathForGlyph(l2, (short)n2, tx);
        if (l3 == 0L) {
            return null;
        }
        CGRect cGRect = OS.CGPathGetPathBoundingBox(l3);
        OS.CGPathRelease(l3);
        return cGRect;
    }

    Path2D getGlyphOutline(int n2, float f2) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f2, BaseTransform.IDENTITY_TRANSFORM);
        long l2 = cTFontStrike.getFontRef();
        if (l2 == 0L) {
            return null;
        }
        long l3 = OS.CTFontCreatePathForGlyph(l2, (short)n2, tx);
        if (l3 == 0L) {
            return null;
        }
        Path2D path2D = OS.CGPathApply(l3);
        OS.CGPathRelease(l3);
        return path2D;
    }

    @Override
    protected float getAdvanceFromPlatform(int n2, float f2) {
        Object object = (CTFontStrike)this.getStrike(f2, BaseTransform.IDENTITY_TRANSFORM);
        long l2 = ((CTFontStrike)object).getFontRef();
        object = new CGSize();
        return (float)OS.CTFontGetAdvancesForGlyphs(l2, 0, (short)n2, (CGSize)object);
    }

    @Override
    protected int[] createGlyphBoundingBox(int n2) {
        long l2;
        Object object = (CTFontStrike)this.getStrike(12.0f, BaseTransform.IDENTITY_TRANSFORM);
        long l3 = ((CTFontStrike)object).getFontRef();
        if (l3 == 0L) {
            return null;
        }
        object = new int[4];
        if (!this.isCFF()) {
            if (this.isColorGlyph(n2)) {
                CGRect cGRect = OS.CTFontGetBoundingRectForGlyphs(l3, (short)n2);
                float f2 = (float)this.getUnitsPerEm() / 12.0f;
                object[0] = (int)Math.round(cGRect.origin.x * (double)f2);
                object[1] = (int)Math.round(cGRect.origin.y * (double)f2);
                object[2] = (int)Math.round((cGRect.origin.x + cGRect.size.width) * (double)f2);
                object[3] = (int)Math.round((cGRect.origin.y + cGRect.size.height) * (double)f2);
                return object;
            }
            short s2 = this.getIndexToLocFormat();
            if (OS.CTFontGetBoundingRectForGlyphUsingTables(l3, (short)n2, s2, (int[])object)) {
                return object;
            }
        }
        if ((l2 = OS.CTFontCreatePathForGlyph(l3, (short)n2, null)) == 0L) {
            return null;
        }
        CGRect cGRect = OS.CGPathGetPathBoundingBox(l2);
        OS.CGPathRelease(l2);
        float f3 = (float)this.getUnitsPerEm() / 12.0f;
        object[0] = (int)Math.round(cGRect.origin.x * (double)f3);
        object[1] = (int)Math.round(cGRect.origin.y * (double)f3);
        object[2] = (int)Math.round((cGRect.origin.x + cGRect.size.width) * (double)f3);
        object[3] = (int)Math.round((cGRect.origin.y + cGRect.size.height) * (double)f3);
        return object;
    }

    @Override
    protected PrismFontStrike<CTFontFile> createStrike(float f2, BaseTransform baseTransform, int n2, FontStrikeDesc fontStrikeDesc) {
        return new CTFontStrike(this, f2, baseTransform, n2, fontStrikeDesc);
    }

    long getFontRef(float f2, CGAffineTransform cGAffineTransform) {
        long l2 = 0L;
        if (this.isEmbeddedFont()) {
            if (this.cgFontRef != 0L) {
                l2 = OS.CTFontCreateWithGraphicsFont(this.cgFontRef, f2, cGAffineTransform, 0L);
            }
        } else if (this.ctFontRef != 0L) {
            l2 = OS.CTFontCreateCopyWithAttributes(this.ctFontRef, f2, cGAffineTransform, 0L);
        } else {
            String string = this.getPSName();
            if (string.startsWith(".")) {
                boolean bl2 = this.getFullName().indexOf("Bold") > 0;
                l2 = OS.CTFontCreateUIFontForLanguage(f2, cGAffineTransform, bl2);
            } else {
                long l3 = OS.CFStringCreate(string);
                if (l3 != 0L) {
                    l2 = OS.CTFontCreateWithName(l3, f2, cGAffineTransform);
                    OS.CFRelease(l3);
                }
            }
        }
        return l2;
    }

    void getCascadingInfo(FontFallbackInfo fontFallbackInfo) {
        CTFactory cfr_ignored_0 = (CTFactory)PrismFontFactory.getFontFactory();
        long l2 = this.getFontRef(0.0f, null);
        String[] stringArray = MacFontFinder.getCascadeList(l2);
        if (PrismFontFactory.debugFonts) {
            System.err.println("Cascading list for " + this.getFullName());
        }
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            String string = stringArray[i2];
            String string2 = stringArray[i2 + 1];
            if (PrismFontFactory.debugFonts) {
                System.err.print("Entry : name=" + string + " file=" + string2);
            }
            if (string2 == null || string.startsWith(".")) {
                if (!PrismFontFactory.debugFonts) continue;
                System.err.println(" - *** not using this entry (.font and/or null file)");
                continue;
            }
            if (PrismFontFactory.debugFonts) {
                System.err.println();
            }
            fontFallbackInfo.add(string, string2, null);
        }
        if (PrismFontFactory.debugFonts) {
            System.err.println("End cascading list");
        }
    }

    static {
        new CGAffineTransform().a = 1.0;
        CTFontFile.tx.d = -1.0;
    }
}

