/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.freetype;

import com.sun.javafx.font.FontConfigManager;
import com.sun.javafx.font.FontConfigManager$FcCompFont;
import com.sun.javafx.font.FontFallbackInfo;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.freetype.FTFactory$StubGlyphLayout;
import com.sun.javafx.font.freetype.FTFontFile;
import com.sun.javafx.font.freetype.HBGlyphLayout;
import com.sun.javafx.font.freetype.OSFreetype;
import com.sun.javafx.font.freetype.OSPango;
import com.sun.javafx.font.freetype.PangoGlyphLayout;
import com.sun.javafx.text.GlyphLayout;
import java.util.ArrayList;

public class FTFactory
extends PrismFontFactory {
    static boolean LCD_SUPPORT;

    public static PrismFontFactory getFactory() {
        FTFactory fTFactory = null;
        Object object = new long[1];
        int n2 = OSFreetype.FT_Init_FreeType(object);
        long l2 = object[0];
        object = new int[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (n2 == 0) {
            fTFactory = new FTFactory();
            OSFreetype.FT_Library_Version(l2, (int[])object, nArray, nArray2);
            n2 = OSFreetype.FT_Library_SetLcdFilter(l2, 1);
            LCD_SUPPORT = n2 == 0;
            OSFreetype.FT_Done_FreeType(l2);
        }
        if (PrismFontFactory.debugFonts) {
            if (fTFactory != null) {
                object = (int)object[0] + "." + nArray[0] + "." + nArray2[0];
                System.err.println("Freetype2 Loaded (version " + (String)object + ")");
                object = LCD_SUPPORT ? "Enabled" : "Disabled";
                System.err.println("LCD support " + (String)object);
            } else {
                System.err.println("Freetype2 Failed (error " + n2 + ")");
            }
        }
        return fTFactory;
    }

    private FTFactory() {
    }

    @Override
    protected PrismFontFile createFontFile(String string, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws Exception {
        return new FTFontFile(string, string2, n2, bl2, bl3, bl4, bl5);
    }

    @Override
    public GlyphLayout createGlyphLayout() {
        if (OSFreetype.isPangoEnabled()) {
            return new PangoGlyphLayout();
        }
        if (OSFreetype.isHarfbuzzEnabled()) {
            return new HBGlyphLayout();
        }
        return new FTFactory$StubGlyphLayout();
    }

    @Override
    public boolean isLCDTextSupported() {
        return LCD_SUPPORT && super.isLCDTextSupported();
    }

    @Override
    protected boolean registerEmbeddedFont(String string) {
        long[] lArray = new long[1];
        int n2 = OSFreetype.FT_Init_FreeType(lArray);
        if (n2 != 0) {
            return false;
        }
        long l2 = lArray[0];
        byte[] byArray = (string + "\u0000").getBytes();
        int n3 = OSFreetype.FT_New_Face(l2, byArray, 0L, lArray);
        if (n3 != 0) {
            long l3 = lArray[0];
            OSFreetype.FT_Done_Face(l3);
        }
        OSFreetype.FT_Done_FreeType(l2);
        if (n3 != 0) {
            return false;
        }
        if (OSFreetype.isPangoEnabled()) {
            return OSPango.FcConfigAppFontAddFile(0L, string);
        }
        return true;
    }

    @Override
    public FontFallbackInfo getFallbacks(FontResource fontResource) {
        boolean bl2 = fontResource.isBold();
        boolean bl3 = fontResource.isItalic();
        Object object = FontConfigManager.getFontConfigFont("sans", bl2, bl3);
        ArrayList<String> arrayList = FontConfigManager.getFileNames((FontConfigManager$FcCompFont)object, false);
        object = FontConfigManager.getFontNames((FontConfigManager$FcCompFont)object, false);
        FontFallbackInfo fontFallbackInfo = new FontFallbackInfo();
        for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
            fontFallbackInfo.add((String)((ArrayList)object).get(i2), arrayList.get(i2), null);
        }
        return fontFallbackInfo;
    }
}

