/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.freetype;

import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.freetype.OSPango;
import com.sun.javafx.font.freetype.PangoGlyphString;
import com.sun.javafx.text.GlyphLayout;
import com.sun.javafx.text.TextRun;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

class PangoGlyphLayout
extends GlyphLayout {
    private static final long fontmap = OSPango.pango_ft2_font_map_new();
    private Map<TextRun, Long> runUtf8 = new LinkedHashMap<TextRun, Long>();

    PangoGlyphLayout() {
    }

    private int getSlot(PGFont object, PangoGlyphString object2) {
        CompositeFontResource compositeFontResource = (CompositeFontResource)object.getFontResource();
        long l2 = ((PangoGlyphString)object2).font;
        long l3 = OSPango.pango_font_describe(l2);
        object2 = OSPango.pango_font_description_get_family(l3);
        int n2 = OSPango.pango_font_description_get_style(l3);
        int bl2 = OSPango.pango_font_description_get_weight(l3);
        OSPango.pango_font_description_free(l3);
        boolean bl3 = bl2 == 700;
        n2 = n2 != 0 ? 1 : 0;
        PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
        object = prismFontFactory.createFont((String)object2, bl3, n2 != 0, object.getSize());
        object = object.getFullName();
        object2 = compositeFontResource.getSlotResource(0).getFullName();
        n2 = 0;
        if (!((String)object).equalsIgnoreCase((String)object2)) {
            n2 = compositeFontResource.getSlotForFont((String)object);
            if (PrismFontFactory.debugFonts) {
                System.err.println("\tFallback font= " + (String)object + " slot=" + (n2 >> 24));
            }
        }
        return n2;
    }

    private boolean check(long l2, String string, long l3, long l4, long l5) {
        if (l2 != 0L) {
            return false;
        }
        if (string != null && PrismFontFactory.debugFonts) {
            System.err.println(string);
        }
        if (l5 != 0L) {
            OSPango.pango_attr_list_unref(l5);
        }
        if (l4 != 0L) {
            OSPango.pango_font_description_free(l4);
        }
        if (l3 != 0L) {
            OSPango.g_object_unref(l3);
        }
        return true;
    }

    @Override
    public void layout(TextRun textRun, PGFont pGFont, FontStrike object, char[] cArray) {
        object = pGFont.getFontResource();
        boolean bl2 = object instanceof CompositeFontResource;
        if (bl2) {
            object = ((CompositeFontResource)object).getSlotResource(0);
        }
        if (this.check(fontmap, "Failed allocating PangoFontMap.", 0L, 0L, 0L)) {
            return;
        }
        long l2 = OSPango.pango_font_map_create_context(fontmap);
        if (this.check(l2, "Failed allocating PangoContext.", 0L, 0L, 0L)) {
            return;
        }
        boolean bl3 = (textRun.getLevel() & 1) != 0;
        if (bl3) {
            OSPango.pango_context_set_base_dir(l2, 1);
        }
        float f2 = pGFont.getSize();
        int n2 = object.isItalic() ? 2 : 0;
        int n3 = object.isBold() ? 700 : 400;
        long l3 = OSPango.pango_font_description_new();
        if (this.check(l3, "Failed allocating FontDescription.", l2, 0L, 0L)) {
            return;
        }
        OSPango.pango_font_description_set_family(l3, object.getFamilyName());
        OSPango.pango_font_description_set_absolute_size(l3, f2 * 1024.0f);
        OSPango.pango_font_description_set_stretch(l3, 4);
        OSPango.pango_font_description_set_style(l3, n2);
        OSPango.pango_font_description_set_weight(l3, n3);
        long l4 = OSPango.pango_attr_list_new();
        if (this.check(l4, "Failed allocating PangoAttributeList.", l2, l3, 0L)) {
            return;
        }
        long l5 = OSPango.pango_attr_font_desc_new(l3);
        if (this.check(l5, "Failed allocating PangoAttribute.", l2, l3, l4)) {
            return;
        }
        OSPango.pango_attr_list_insert(l4, l5);
        if (!bl2) {
            l5 = OSPango.pango_attr_fallback_new(false);
            OSPango.pango_attr_list_insert(l4, l5);
        }
        if ((object = this.runUtf8.get(textRun)) == null) {
            char[] cArray2 = Arrays.copyOfRange(cArray, textRun.getStart(), textRun.getEnd());
            object = OSPango.g_utf16_to_utf8(cArray2);
            if (this.check((Long)object, "Failed allocating UTF-8 buffer.", l2, l3, l4)) {
                return;
            }
            this.runUtf8.put(textRun, (Long)object);
        }
        long l6 = OSPango.g_utf8_strlen((Long)object, -1L);
        long l7 = OSPango.g_utf8_offset_to_pointer((Long)object, l6);
        long l8 = OSPango.pango_itemize(l2, (Long)object, 0, (int)(l7 - (Long)object), l4, 0L);
        if (l8 != 0L) {
            int n4 = OSPango.g_list_length(l8);
            PangoGlyphString[] pangoGlyphStringArray = new PangoGlyphString[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                long l9 = OSPango.g_list_nth_data(l8, n3);
                if (l9 == 0L) continue;
                pangoGlyphStringArray[n3] = OSPango.pango_shape((Long)object, l9);
                OSPango.pango_item_free(l9);
            }
            OSPango.g_list_free(l8);
            n3 = 0;
            Object[] objectArray = pangoGlyphStringArray;
            int n5 = pangoGlyphStringArray.length;
            for (int i2 = 0; i2 < n5; ++i2) {
                PangoGlyphString pangoGlyphString = objectArray[i2];
                if (pangoGlyphString == null) continue;
                n3 += pangoGlyphString.num_glyphs;
            }
            objectArray = new int[n3];
            float[] fArray = new float[(n3 << 1) + 2];
            int[] nArray = new int[n3];
            int n6 = 0;
            int n7 = bl3 ? textRun.getLength() : 0;
            int n8 = 0;
            for (PangoGlyphString pangoGlyphString : pangoGlyphStringArray) {
                int n9;
                if (pangoGlyphString == null) continue;
                int n10 = n9 = bl2 ? this.getSlot(pGFont, pangoGlyphString) : 0;
                if (bl3) {
                    n7 -= pangoGlyphString.num_chars;
                }
                for (int i3 = 0; i3 < pangoGlyphString.num_glyphs; ++i3) {
                    int n11;
                    int n12 = n6 + i3;
                    if (n9 != -1 && (n11 = pangoGlyphString.glyphs[i3]) >= 0 && n11 <= 0xFFFFFF) {
                        objectArray[n12] = (PangoGlyphString)(n9 << 24 | n11);
                    }
                    if (f2 != 0.0f) {
                        fArray[2 + (n12 << 1)] = (float)(n8 += pangoGlyphString.widths[i3]) / 1024.0f;
                    }
                    nArray[n12] = pangoGlyphString.log_clusters[i3] + n7;
                }
                if (!bl3) {
                    n7 += pangoGlyphString.num_chars;
                }
                n6 += pangoGlyphString.num_glyphs;
            }
            textRun.shape(n3, (int[])objectArray, fArray, nArray);
        }
        this.check(0L, null, l2, l3, l4);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Long l2 : this.runUtf8.values()) {
            OSPango.g_free(l2);
        }
        this.runUtf8.clear();
    }
}

