/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.CurveLink;

final class ChainEnd {
    CurveLink head;
    CurveLink tail;
    ChainEnd partner;
    int etag;

    public ChainEnd(CurveLink curveLink, ChainEnd chainEnd) {
        this.head = curveLink;
        this.tail = curveLink;
        this.partner = chainEnd;
        this.etag = curveLink.getEdgeTag();
    }

    public final CurveLink getChain() {
        return this.head;
    }

    public final void setOtherEnd(ChainEnd chainEnd) {
        this.partner = chainEnd;
    }

    public final ChainEnd getPartner() {
        return this.partner;
    }

    public final CurveLink linkTo(ChainEnd chainEnd) {
        ChainEnd chainEnd2;
        ChainEnd chainEnd3;
        if (this.etag == 0 || chainEnd.etag == 0) {
            throw new InternalError("ChainEnd linked more than once!");
        }
        if (this.etag == chainEnd.etag) {
            throw new InternalError("Linking chains of the same type!");
        }
        if (this.etag == 1) {
            chainEnd3 = this;
            chainEnd2 = chainEnd;
        } else {
            chainEnd3 = chainEnd;
            chainEnd2 = this;
        }
        this.etag = 0;
        chainEnd.etag = 0;
        chainEnd3.tail.setNext(chainEnd2.head);
        chainEnd3.tail = chainEnd2.tail;
        if (this.partner == chainEnd) {
            return chainEnd3.head;
        }
        chainEnd = chainEnd2.partner;
        chainEnd.partner = chainEnd2 = chainEnd3.partner;
        chainEnd2.partner = chainEnd;
        if (chainEnd3.head.getYTop() < chainEnd.head.getYTop()) {
            chainEnd3.tail.setNext(chainEnd.head);
            chainEnd.head = chainEnd3.head;
        } else {
            chainEnd2.tail.setNext(chainEnd3.head);
            chainEnd2.tail = chainEnd3.tail;
        }
        return null;
    }

    public final void addLink(CurveLink curveLink) {
        if (this.etag == 1) {
            this.tail.setNext(curveLink);
            this.tail = curveLink;
            return;
        }
        curveLink.setNext(this.head);
        this.head = curveLink;
    }

    public final double getX() {
        if (this.etag == 1) {
            return this.tail.getXBot();
        }
        return this.head.getXBot();
    }
}

