/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import java.util.Arrays;

public final class DirtyRegionContainer {
    public static final int DTR_OK = 1;
    public static final int DTR_CONTAINS_CLIP = 0;
    private RectBounds[] dirtyRegions;
    private int emptyIndex;
    private int[][] heap;
    private int heapSize;
    private long invalidMask;

    public DirtyRegionContainer(int n2) {
        this.initDirtyRegions(n2);
    }

    public final boolean equals(Object object) {
        if (object instanceof DirtyRegionContainer) {
            object = (DirtyRegionContainer)object;
            if (this.size() != ((DirtyRegionContainer)object).size()) {
                return false;
            }
            for (int i2 = 0; i2 < this.emptyIndex; ++i2) {
                if (this.getDirtyRegion(i2).equals(((DirtyRegionContainer)object).getDirtyRegion(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        int n2 = 485 + Arrays.deepHashCode(this.dirtyRegions);
        n2 = n2 * 97 + this.emptyIndex;
        return n2;
    }

    public final DirtyRegionContainer deriveWithNewRegion(RectBounds rectBounds) {
        if (rectBounds == null) {
            return this;
        }
        ((BaseBounds)this.dirtyRegions[0]).deriveWithNewBounds(rectBounds);
        this.emptyIndex = 1;
        return this;
    }

    public final DirtyRegionContainer deriveWithNewRegions(RectBounds[] rectBoundsArray) {
        if (rectBoundsArray == null || rectBoundsArray.length == 0) {
            return this;
        }
        if (rectBoundsArray.length > this.maxSpace()) {
            this.initDirtyRegions(rectBoundsArray.length);
        }
        this.regioncopy(rectBoundsArray, 0, this.dirtyRegions, 0, rectBoundsArray.length);
        this.emptyIndex = rectBoundsArray.length;
        return this;
    }

    public final DirtyRegionContainer deriveWithNewContainer(DirtyRegionContainer dirtyRegionContainer) {
        if (dirtyRegionContainer == null || dirtyRegionContainer.maxSpace() == 0) {
            return this;
        }
        if (dirtyRegionContainer.maxSpace() > this.maxSpace()) {
            this.initDirtyRegions(dirtyRegionContainer.maxSpace());
        }
        this.regioncopy(dirtyRegionContainer.dirtyRegions, 0, this.dirtyRegions, 0, dirtyRegionContainer.emptyIndex);
        this.emptyIndex = dirtyRegionContainer.emptyIndex;
        return this;
    }

    private void initDirtyRegions(int n2) {
        this.dirtyRegions = new RectBounds[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.dirtyRegions[i2] = new RectBounds();
        }
        this.emptyIndex = 0;
    }

    public final DirtyRegionContainer copy() {
        DirtyRegionContainer dirtyRegionContainer = new DirtyRegionContainer(this.maxSpace());
        DirtyRegionContainer dirtyRegionContainer2 = this;
        dirtyRegionContainer2.regioncopy(dirtyRegionContainer2.dirtyRegions, 0, dirtyRegionContainer.dirtyRegions, 0, this.emptyIndex);
        dirtyRegionContainer.emptyIndex = this.emptyIndex;
        return dirtyRegionContainer;
    }

    public final int maxSpace() {
        return this.dirtyRegions.length;
    }

    public final RectBounds getDirtyRegion(int n2) {
        return this.dirtyRegions[n2];
    }

    public final void setDirtyRegion(int n2, RectBounds rectBounds) {
        this.dirtyRegions[n2] = rectBounds;
    }

    public final void addDirtyRegion(RectBounds rectBounds) {
        RectBounds rectBounds2;
        if (((BaseBounds)rectBounds).isEmpty()) {
            return;
        }
        int n2 = 0;
        int n3 = this.emptyIndex;
        for (int i2 = 0; i2 < n3; ++i2) {
            rectBounds2 = this.dirtyRegions[n2];
            if (rectBounds.intersects(rectBounds2)) {
                rectBounds.unionWith(rectBounds2);
                rectBounds2 = this.dirtyRegions[n2];
                this.dirtyRegions[n2] = this.dirtyRegions[this.emptyIndex - 1];
                this.dirtyRegions[this.emptyIndex - 1] = rectBounds2;
                --this.emptyIndex;
                continue;
            }
            ++n2;
        }
        if (this.hasSpace()) {
            rectBounds2 = this.dirtyRegions[this.emptyIndex];
            ((BaseBounds)rectBounds2).deriveWithNewBounds(rectBounds);
            ++this.emptyIndex;
            return;
        }
        if (this.dirtyRegions.length == 1) {
            ((BaseBounds)this.dirtyRegions[0]).deriveWithUnion(rectBounds);
            return;
        }
        this.compress(rectBounds);
    }

    public final void merge(DirtyRegionContainer dirtyRegionContainer) {
        int n2 = dirtyRegionContainer.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addDirtyRegion(dirtyRegionContainer.getDirtyRegion(i2));
        }
    }

    public final int size() {
        return this.emptyIndex;
    }

    public final void reset() {
        this.emptyIndex = 0;
    }

    private RectBounds compress(RectBounds rectBounds) {
        this.compress_heap();
        this.addDirtyRegion(rectBounds);
        return rectBounds;
    }

    private boolean hasSpace() {
        return this.emptyIndex < this.dirtyRegions.length;
    }

    private void regioncopy(RectBounds[] rectBoundsArray, int n2, RectBounds[] rectBoundsArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            RectBounds rectBounds;
            if ((rectBounds = rectBoundsArray[n2++]) == null) {
                rectBoundsArray2[n3++].makeEmpty();
                continue;
            }
            ((BaseBounds)rectBoundsArray2[n3++]).deriveWithNewBounds(rectBounds);
        }
    }

    public final boolean checkAndClearRegion(int n2) {
        boolean bl2 = false;
        if (((BaseBounds)this.dirtyRegions[n2]).isEmpty()) {
            System.arraycopy(this.dirtyRegions, n2 + 1, this.dirtyRegions, n2, this.emptyIndex - n2 - 1);
            --this.emptyIndex;
            bl2 = true;
        }
        return bl2;
    }

    public final void grow(int n2, int n3) {
        if (n2 != 0 || n3 != 0) {
            for (int i2 = 0; i2 < this.emptyIndex; ++i2) {
                this.getDirtyRegion(i2).grow(n2, n3);
            }
        }
    }

    public final void roundOut() {
        for (int i2 = 0; i2 < this.emptyIndex; ++i2) {
            ((BaseBounds)this.dirtyRegions[i2]).roundOut();
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.emptyIndex; ++i2) {
            stringBuilder.append(this.dirtyRegions[i2]);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private void heapCompress() {
        int n2;
        this.invalidMask = 0L;
        int[] nArray = new int[this.dirtyRegions.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = n3++;
            nArray[n4] = n4;
        }
        for (int i2 = 0; i2 < this.dirtyRegions.length / 2; ++i2) {
            int[] nArray2 = this.takeMinWithMap(nArray);
            n2 = this.resolveMap(nArray, nArray2[1]);
            if (n2 == (n3 = this.resolveMap(nArray, nArray2[2]))) continue;
            ((BaseBounds)this.dirtyRegions[n2]).deriveWithUnion(this.dirtyRegions[n3]);
            nArray[n3] = n2;
            this.invalidMask |= (long)(1 << n2);
            this.invalidMask |= (long)(1 << n3);
        }
        for (n2 = 0; n2 < this.emptyIndex; ++n2) {
            if (nArray[n2] == n2) continue;
            while (nArray[this.emptyIndex - 1] != this.emptyIndex - 1) {
                --this.emptyIndex;
            }
            if (n2 >= this.emptyIndex - 1) continue;
            RectBounds rectBounds = this.dirtyRegions[this.emptyIndex - 1];
            this.dirtyRegions[this.emptyIndex - 1] = this.dirtyRegions[n2];
            this.dirtyRegions[n2] = rectBounds;
            int n5 = n2;
            nArray[n5] = n5;
            --this.emptyIndex;
        }
    }

    private void heapify() {
        for (int i2 = this.heapSize / 2; i2 >= 0; --i2) {
            this.siftDown(i2);
        }
    }

    private void siftDown(int n2) {
        int n3 = this.heapSize >> 1;
        while (n2 < n3) {
            int n4 = (n2 << 1) + 1;
            int[] nArray = this.heap[n4];
            if (n4 + 1 < this.heapSize && this.heap[n4 + 1][0] < nArray[0]) {
                ++n4;
            }
            if (this.heap[n4][0] >= this.heap[n2][0]) break;
            nArray = this.heap[n4];
            this.heap[n4] = this.heap[n2];
            this.heap[n2] = nArray;
            n2 = n4;
        }
    }

    private int[] takeMinWithMap(int[] nArray) {
        int[] nArray2 = this.heap[0];
        while (((long)(1 << nArray2[1] | 1 << nArray2[2]) & this.invalidMask) > 0L) {
            DirtyRegionContainer dirtyRegionContainer = this;
            nArray2[0] = dirtyRegionContainer.unifiedRegionArea(dirtyRegionContainer.resolveMap(nArray, nArray2[1]), this.resolveMap(nArray, nArray2[2]));
            this.siftDown(0);
            if (this.heap[0] == nArray2) break;
            nArray2 = this.heap[0];
        }
        this.heap[this.heapSize - 1] = nArray2;
        this.siftDown(0);
        --this.heapSize;
        return nArray2;
    }

    private int[] takeMin() {
        int[] nArray = this.heap[0];
        this.heap[0] = this.heap[this.heapSize - 1];
        this.heap[this.heapSize - 1] = nArray;
        this.siftDown(0);
        --this.heapSize;
        return nArray;
    }

    private int resolveMap(int[] nArray, int n2) {
        while (nArray[n2] != n2) {
            n2 = nArray[n2];
        }
        return n2;
    }

    private int unifiedRegionArea(int n2, int n3) {
        RectBounds rectBounds = this.dirtyRegions[n2];
        RectBounds rectBounds2 = this.dirtyRegions[n3];
        float f2 = ((BaseBounds)rectBounds).getMinX() < ((BaseBounds)rectBounds2).getMinX() ? ((BaseBounds)rectBounds).getMinX() : ((BaseBounds)rectBounds2).getMinX();
        float f3 = ((BaseBounds)rectBounds).getMinY() < ((BaseBounds)rectBounds2).getMinY() ? ((BaseBounds)rectBounds).getMinY() : ((BaseBounds)rectBounds2).getMinY();
        float f4 = ((BaseBounds)rectBounds).getMaxX() > ((BaseBounds)rectBounds2).getMaxX() ? ((BaseBounds)rectBounds).getMaxX() : ((BaseBounds)rectBounds2).getMaxX();
        float f5 = ((BaseBounds)rectBounds).getMaxY() > ((BaseBounds)rectBounds2).getMaxY() ? ((BaseBounds)rectBounds).getMaxY() : ((BaseBounds)rectBounds2).getMaxY();
        return (int)((f4 - f2) * (f5 - f3));
    }

    private void compress_heap() {
        int n2;
        assert (this.dirtyRegions.length == this.emptyIndex);
        if (this.heap == null) {
            int n3 = n2 = this.dirtyRegions.length;
            this.heap = new int[n3 * (n3 - 1) / 2][3];
        }
        this.heapSize = this.heap.length;
        n2 = 0;
        for (int i2 = 0; i2 < this.dirtyRegions.length - 1; ++i2) {
            int n4 = i2 + 1;
            while (n4 < this.dirtyRegions.length) {
                this.heap[n2][0] = this.unifiedRegionArea(i2, n4);
                this.heap[n2][1] = i2;
                this.heap[n2++][2] = n4++;
            }
        }
        this.heapify();
        this.heapCompress();
    }
}

