/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Curve;

public final class Edge {
    static final int INIT_PARTS = 4;
    static final int GROW_PARTS = 10;
    Curve curve;
    int ctag;
    int etag;
    double activey;
    int equivalence;
    private Edge lastEdge;
    private int lastResult;
    private double lastLimit;

    public Edge(Curve curve, int n2) {
        this(curve, n2, 0);
    }

    public Edge(Curve curve, int n2, int n3) {
        this.curve = curve;
        this.ctag = n2;
        this.etag = n3;
    }

    public final Curve getCurve() {
        return this.curve;
    }

    public final int getCurveTag() {
        return this.ctag;
    }

    public final int getEdgeTag() {
        return this.etag;
    }

    public final void setEdgeTag(int n2) {
        this.etag = n2;
    }

    public final int getEquivalence() {
        return this.equivalence;
    }

    public final void setEquivalence(int n2) {
        this.equivalence = n2;
    }

    public final int compareTo(Edge edge, double[] dArray) {
        if (edge == this.lastEdge && dArray[0] < this.lastLimit) {
            if (dArray[1] > this.lastLimit) {
                dArray[1] = this.lastLimit;
            }
            return this.lastResult;
        }
        if (this == edge.lastEdge && dArray[0] < edge.lastLimit) {
            if (dArray[1] > edge.lastLimit) {
                dArray[1] = edge.lastLimit;
            }
            return 0 - edge.lastResult;
        }
        int n2 = this.curve.compareTo(edge.curve, dArray);
        this.lastEdge = edge;
        this.lastLimit = dArray[1];
        this.lastResult = n2;
        return n2;
    }

    public final void record(double d2, int n2) {
        this.activey = d2;
        this.etag = n2;
    }

    public final boolean isActiveFor(double d2, int n2) {
        return this.etag == n2 && this.activey >= d2;
    }

    public final String toString() {
        return "Edge[" + String.valueOf(this.curve) + ", " + (this.ctag == 0 ? "L" : "R") + ", " + (this.etag == 1 ? "I" : (this.etag == -1 ? "O" : "N")) + "]";
    }
}

