/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Curve;
import com.sun.javafx.geom.RectBounds;
import java.util.Vector;

final class Order2
extends Curve {
    private double x0;
    private double y0;
    private double cx0;
    private double cy0;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;
    private double xcoeff0;
    private double xcoeff1;
    private double xcoeff2;
    private double ycoeff0;
    private double ycoeff1;
    private double ycoeff2;

    public static void insert(Vector vector, double[] dArray, double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        int n3 = Order2.getHorizontalParams(d3, d5, d7, dArray);
        if (n3 == 0) {
            Order2.addInstance(vector, d2, d3, d4, d5, d6, d7, n2);
            return;
        }
        double d8 = dArray[0];
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d4;
        dArray[3] = d5;
        dArray[4] = d6;
        dArray[5] = d7;
        Order2.split(dArray, 0, d8);
        int n4 = n2 == 1 ? 0 : 4;
        int n5 = 4 - n4;
        Order2.addInstance(vector, dArray[n4], dArray[n4 + 1], dArray[n4 + 2], dArray[n4 + 3], dArray[n4 + 4], dArray[n4 + 5], n2);
        Order2.addInstance(vector, dArray[n5], dArray[n5 + 1], dArray[n5 + 2], dArray[n5 + 3], dArray[n5 + 4], dArray[n5 + 5], n2);
    }

    public static void addInstance(Vector vector, double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        if (d3 > d7) {
            vector.add(new Order2(d6, d7, d4, d5, d2, d3, -n2));
            return;
        }
        if (d7 > d3) {
            vector.add(new Order2(d2, d3, d4, d5, d6, d7, n2));
        }
    }

    public static int getHorizontalParams(double d2, double d3, double d4, double[] dArray) {
        if (d2 <= d3 && d3 <= d4) {
            return 0;
        }
        double d5 = (d2 -= d3) + (d4 -= d3);
        if (d5 == 0.0) {
            return 0;
        }
        double d6 = d2 / d5;
        if (d6 <= 0.0 || d6 >= 1.0) {
            return 0;
        }
        dArray[0] = d6;
        return 1;
    }

    public static void split(double[] dArray, int n2, double d2) {
        double d3;
        double d4;
        dArray[n2 + 8] = d4 = dArray[n2 + 4];
        dArray[n2 + 9] = d3 = dArray[n2 + 5];
        double d5 = dArray[n2 + 2];
        double d6 = dArray[n2 + 3];
        d4 = d5 + (d4 - d5) * d2;
        d3 = d6 + (d3 - d6) * d2;
        double d7 = dArray[n2];
        double d8 = dArray[n2 + 1];
        d7 += (d5 - d7) * d2;
        d8 += (d6 - d8) * d2;
        d5 = d7 + (d4 - d7) * d2;
        d6 = d8 + (d3 - d8) * d2;
        dArray[n2 + 2] = d7;
        dArray[n2 + 3] = d8;
        dArray[n2 + 4] = d5;
        dArray[n2 + 5] = d6;
        dArray[n2 + 6] = d4;
        dArray[n2 + 7] = d3;
    }

    public Order2(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        super(n2);
        if (d5 < d3) {
            d5 = d3;
        } else if (d5 > d7) {
            d5 = d7;
        }
        this.x0 = d2;
        this.y0 = d3;
        this.cx0 = d4;
        this.cy0 = d5;
        this.x1 = d6;
        this.y1 = d7;
        this.xmin = Math.min(Math.min(d2, d6), d4);
        this.xmax = Math.max(Math.max(d2, d6), d4);
        this.xcoeff0 = d2;
        double d8 = d4;
        this.xcoeff1 = d8 + d8 - d2 - d2;
        this.xcoeff2 = d2 - d4 - d4 + d6;
        this.ycoeff0 = d3;
        double d9 = d5;
        this.ycoeff1 = d9 + d9 - d3 - d3;
        this.ycoeff2 = d3 - d5 - d5 + d7;
    }

    @Override
    public final int getOrder() {
        return 2;
    }

    @Override
    public final double getXTop() {
        return this.x0;
    }

    @Override
    public final double getYTop() {
        return this.y0;
    }

    @Override
    public final double getXBot() {
        return this.x1;
    }

    @Override
    public final double getYBot() {
        return this.y1;
    }

    @Override
    public final double getXMin() {
        return this.xmin;
    }

    @Override
    public final double getXMax() {
        return this.xmax;
    }

    @Override
    public final double getX0() {
        if (this.direction == 1) {
            return this.x0;
        }
        return this.x1;
    }

    @Override
    public final double getY0() {
        if (this.direction == 1) {
            return this.y0;
        }
        return this.y1;
    }

    public final double getCX0() {
        return this.cx0;
    }

    public final double getCY0() {
        return this.cy0;
    }

    @Override
    public final double getX1() {
        if (this.direction == -1) {
            return this.x0;
        }
        return this.x1;
    }

    @Override
    public final double getY1() {
        if (this.direction == -1) {
            return this.y0;
        }
        return this.y1;
    }

    @Override
    public final double XforY(double d2) {
        if (d2 <= this.y0) {
            return this.x0;
        }
        if (d2 >= this.y1) {
            return this.x1;
        }
        Order2 order2 = this;
        return ((Curve)order2).XforT(((Curve)order2).TforY(d2));
    }

    @Override
    public final double TforY(double d2) {
        if (d2 <= this.y0) {
            return 0.0;
        }
        if (d2 >= this.y1) {
            return 1.0;
        }
        return Order2.TforY(d2, this.ycoeff0, this.ycoeff1, this.ycoeff2);
    }

    public static double TforY(double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        d3 -= d2;
        if (d5 == 0.0) {
            double d8;
            d7 = -d3 / d4;
            if (d8 >= 0.0 && d7 <= 1.0) {
                return d7;
            }
        } else {
            double d9;
            double d10 = d4;
            d7 = d10 * d10 - d5 * 4.0 * d3;
            if (d9 >= 0.0) {
                double d11;
                d7 = Math.sqrt(d7);
                if (d4 < 0.0) {
                    d7 = -d7;
                }
                d6 = (d4 + d7) / -2.0;
                double d12 = d6 / d5;
                if (d11 >= 0.0 && d12 <= 1.0) {
                    return d12;
                }
                if (d6 != 0.0) {
                    double d13;
                    d12 = d3 / d6;
                    if (d13 >= 0.0 && d12 <= 1.0) {
                        return d12;
                    }
                }
            }
        }
        if (0.0 < ((d7 = d3) + (d6 = d3 + d4 + d5)) / 2.0) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public final double XforT(double d2) {
        return (this.xcoeff2 * d2 + this.xcoeff1) * d2 + this.xcoeff0;
    }

    @Override
    public final double YforT(double d2) {
        return (this.ycoeff2 * d2 + this.ycoeff1) * d2 + this.ycoeff0;
    }

    @Override
    public final double dXforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return (this.xcoeff2 * d2 + this.xcoeff1) * d2 + this.xcoeff0;
            }
            case 1: {
                return 2.0 * this.xcoeff2 * d2 + this.xcoeff1;
            }
            case 2: {
                return 2.0 * this.xcoeff2;
            }
        }
        return 0.0;
    }

    @Override
    public final double dYforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return (this.ycoeff2 * d2 + this.ycoeff1) * d2 + this.ycoeff0;
            }
            case 1: {
                return 2.0 * this.ycoeff2 * d2 + this.ycoeff1;
            }
            case 2: {
                return 2.0 * this.ycoeff2;
            }
        }
        return 0.0;
    }

    @Override
    public final double nextVertical(double d2, double d3) {
        double d4;
        double d5 = -this.xcoeff1 / (2.0 * this.xcoeff2);
        if (d4 > d2 && d5 < d3) {
            return d5;
        }
        return d3;
    }

    @Override
    public final void enlarge(RectBounds rectBounds) {
        double d2;
        rectBounds.add((float)this.x0, (float)this.y0);
        double d3 = -this.xcoeff1 / (2.0 * this.xcoeff2);
        if (d2 > 0.0 && d3 < 1.0) {
            rectBounds.add((float)((Curve)this).XforT(d3), (float)((Curve)this).YforT(d3));
        }
        rectBounds.add((float)this.x1, (float)this.y1);
    }

    @Override
    public final Curve getSubCurve(double d2, double d3, int n2) {
        int n3;
        double d4;
        if (d2 <= this.y0) {
            if (d3 >= this.y1) {
                return this.getWithDirection(n2);
            }
            d4 = 0.0;
        } else {
            d4 = Order2.TforY(d2, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        }
        double d5 = d3 >= this.y1 ? 1.0 : Order2.TforY(d3, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        double[] dArray = new double[10];
        double[] dArray2 = dArray;
        dArray[0] = this.x0;
        dArray2[1] = this.y0;
        dArray2[2] = this.cx0;
        dArray2[3] = this.cy0;
        dArray2[4] = this.x1;
        dArray2[5] = this.y1;
        if (d5 < 1.0) {
            Order2.split(dArray2, 0, d5);
        }
        if (d4 <= 0.0) {
            n3 = 0;
        } else {
            Order2.split(dArray2, 0, d4 / d5);
            n3 = 4;
        }
        return new Order2(dArray2[n3], d2, dArray2[n3 + 2], dArray2[n3 + 3], dArray2[n3 + 4], d3, n2);
    }

    @Override
    public final Curve getReversedCurve() {
        return new Order2(this.x0, this.y0, this.cx0, this.cy0, this.x1, this.y1, -this.direction);
    }

    @Override
    public final int getSegment(float[] fArray) {
        fArray[0] = (float)this.cx0;
        fArray[1] = (float)this.cy0;
        if (this.direction == 1) {
            fArray[2] = (float)this.x1;
            fArray[3] = (float)this.y1;
        } else {
            fArray[2] = (float)this.x0;
            fArray[3] = (float)this.y0;
        }
        return 2;
    }

    @Override
    public final String controlPointString() {
        return "(" + Order2.round(this.cx0) + ", " + Order2.round(this.cy0) + "), ";
    }
}

