/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Curve;
import com.sun.javafx.geom.Order2;
import com.sun.javafx.geom.RectBounds;
import java.util.Vector;

final class Order3
extends Curve {
    private double x0;
    private double y0;
    private double cx0;
    private double cy0;
    private double cx1;
    private double cy1;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;
    private double xcoeff0;
    private double xcoeff1;
    private double xcoeff2;
    private double xcoeff3;
    private double ycoeff0;
    private double ycoeff1;
    private double ycoeff2;
    private double ycoeff3;
    private double TforY1;
    private double YforT1;
    private double TforY2;
    private double YforT2;
    private double TforY3;
    private double YforT3;

    public static void insert(Vector vector, double[] dArray, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n2) {
        int n3 = Order3.getHorizontalParams(d3, d5, d7, d9, dArray);
        if (n3 == 0) {
            Order3.addInstance(vector, d2, d3, d4, d5, d6, d7, d8, d9, n2);
            return;
        }
        dArray[3] = d2;
        dArray[4] = d3;
        dArray[5] = d4;
        dArray[6] = d5;
        dArray[7] = d6;
        dArray[8] = d7;
        dArray[9] = d8;
        dArray[10] = d9;
        double d10 = dArray[0];
        if (n3 > 1 && d10 > dArray[1]) {
            dArray[0] = dArray[1];
            dArray[1] = d10;
            d10 = dArray[0];
        }
        Order3.split(dArray, 3, d10);
        if (n3 > 1) {
            d10 = (dArray[1] - d10) / (1.0 - d10);
            Order3.split(dArray, 9, d10);
        }
        int n4 = 3;
        if (n2 == -1) {
            n4 = 3 + n3 * 6;
        }
        while (n3 >= 0) {
            Order3.addInstance(vector, dArray[n4], dArray[n4 + 1], dArray[n4 + 2], dArray[n4 + 3], dArray[n4 + 4], dArray[n4 + 5], dArray[n4 + 6], dArray[n4 + 7], n2);
            --n3;
            if (n2 == 1) {
                n4 += 6;
                continue;
            }
            n4 -= 6;
        }
    }

    public static void addInstance(Vector vector, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n2) {
        if (d3 > d9) {
            vector.add(new Order3(d8, d9, d6, d7, d4, d5, d2, d3, -n2));
            return;
        }
        if (d9 > d3) {
            vector.add(new Order3(d2, d3, d4, d5, d6, d7, d8, d9, n2));
        }
    }

    public static int solveQuadratic(double[] dArray, double[] dArray2) {
        double d2 = dArray[2];
        double d3 = dArray[1];
        double d4 = dArray[0];
        int n2 = 0;
        if (d2 == 0.0) {
            if (d3 == 0.0) {
                return -1;
            }
            ++n2;
            dArray2[0] = -d4 / d3;
        } else {
            double d5;
            double d6 = d3;
            double d7 = d6 * d6 - d2 * 4.0 * d4;
            if (d5 < 0.0) {
                return 0;
            }
            d7 = Math.sqrt(d7);
            if (d3 < 0.0) {
                d7 = -d7;
            }
            double d8 = (d3 + d7) / -2.0;
            ++n2;
            dArray2[0] = d8 / d2;
            if (d8 != 0.0) {
                ++n2;
                dArray2[1] = d4 / d8;
            }
        }
        return n2;
    }

    public static int getHorizontalParams(double d2, double d3, double d4, double d5, double[] dArray) {
        if (d2 <= d3 && d3 <= d4 && d4 <= d5) {
            return 0;
        }
        d5 -= d4;
        d4 -= d3;
        dArray[0] = d3 -= d2;
        dArray[1] = (d4 - d3) * 2.0;
        dArray[2] = d5 - d4 - d4 + d3;
        int n2 = Order3.solveQuadratic(dArray, dArray);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d6;
            double d7 = dArray[i2];
            if (!(d6 > 0.0) || !(d7 < 1.0)) continue;
            if (n3 < i2) {
                dArray[n3] = d7;
            }
            ++n3;
        }
        return n3;
    }

    public static void split(double[] dArray, int n2, double d2) {
        double d3;
        double d4;
        dArray[n2 + 12] = d4 = dArray[n2 + 6];
        dArray[n2 + 13] = d3 = dArray[n2 + 7];
        double d5 = dArray[n2 + 4];
        double d6 = dArray[n2 + 5];
        d4 = d5 + (d4 - d5) * d2;
        d3 = d6 + (d3 - d6) * d2;
        double d7 = dArray[n2];
        double d8 = dArray[n2 + 1];
        double d9 = dArray[n2 + 2];
        double d10 = dArray[n2 + 3];
        d7 += (d9 - d7) * d2;
        d8 += (d10 - d8) * d2;
        d9 += (d5 - d9) * d2;
        d10 += (d6 - d10) * d2;
        d5 = d9 + (d4 - d9) * d2;
        d6 = d10 + (d3 - d10) * d2;
        d9 = d7 + (d9 - d7) * d2;
        d10 = d8 + (d10 - d8) * d2;
        dArray[n2 + 2] = d7;
        dArray[n2 + 3] = d8;
        dArray[n2 + 4] = d9;
        dArray[n2 + 5] = d10;
        dArray[n2 + 6] = d9 + (d5 - d9) * d2;
        dArray[n2 + 7] = d10 + (d6 - d10) * d2;
        dArray[n2 + 8] = d5;
        dArray[n2 + 9] = d6;
        dArray[n2 + 10] = d4;
        dArray[n2 + 11] = d3;
    }

    public Order3(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n2) {
        super(n2);
        if (d5 < d3) {
            d5 = d3;
        }
        if (d7 > d9) {
            d7 = d9;
        }
        this.x0 = d2;
        this.y0 = d3;
        this.cx0 = d4;
        this.cy0 = d5;
        this.cx1 = d6;
        this.cy1 = d7;
        this.x1 = d8;
        this.y1 = d9;
        this.xmin = Math.min(Math.min(d2, d8), Math.min(d4, d6));
        this.xmax = Math.max(Math.max(d2, d8), Math.max(d4, d6));
        this.xcoeff0 = d2;
        this.xcoeff1 = (d4 - d2) * 3.0;
        this.xcoeff2 = (d6 - d4 - d4 + d2) * 3.0;
        this.xcoeff3 = d8 - (d6 - d4) * 3.0 - d2;
        this.ycoeff0 = d3;
        this.ycoeff1 = (d5 - d3) * 3.0;
        this.ycoeff2 = (d7 - d5 - d5 + d3) * 3.0;
        this.ycoeff3 = d9 - (d7 - d5) * 3.0 - d3;
        Order3 order3 = this;
        order3.YforT2 = this.YforT3 = d3;
        order3.YforT1 = this.YforT3;
    }

    @Override
    public final int getOrder() {
        return 3;
    }

    @Override
    public final double getXTop() {
        return this.x0;
    }

    @Override
    public final double getYTop() {
        return this.y0;
    }

    @Override
    public final double getXBot() {
        return this.x1;
    }

    @Override
    public final double getYBot() {
        return this.y1;
    }

    @Override
    public final double getXMin() {
        return this.xmin;
    }

    @Override
    public final double getXMax() {
        return this.xmax;
    }

    @Override
    public final double getX0() {
        if (this.direction == 1) {
            return this.x0;
        }
        return this.x1;
    }

    @Override
    public final double getY0() {
        if (this.direction == 1) {
            return this.y0;
        }
        return this.y1;
    }

    public final double getCX0() {
        if (this.direction == 1) {
            return this.cx0;
        }
        return this.cx1;
    }

    public final double getCY0() {
        if (this.direction == 1) {
            return this.cy0;
        }
        return this.cy1;
    }

    public final double getCX1() {
        if (this.direction == -1) {
            return this.cx0;
        }
        return this.cx1;
    }

    public final double getCY1() {
        if (this.direction == -1) {
            return this.cy0;
        }
        return this.cy1;
    }

    @Override
    public final double getX1() {
        if (this.direction == -1) {
            return this.x0;
        }
        return this.x1;
    }

    @Override
    public final double getY1() {
        if (this.direction == -1) {
            return this.y0;
        }
        return this.y1;
    }

    @Override
    public final double TforY(double d2) {
        double d3;
        double d4;
        if (d2 <= this.y0) {
            return 0.0;
        }
        if (d2 >= this.y1) {
            return 1.0;
        }
        if (d2 == this.YforT1) {
            return this.TforY1;
        }
        if (d2 == this.YforT2) {
            return this.TforY2;
        }
        if (d2 == this.YforT3) {
            return this.TforY3;
        }
        if (this.ycoeff3 == 0.0) {
            return Order2.TforY(d2, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        }
        double d5 = this.ycoeff2 / this.ycoeff3;
        double d6 = this.ycoeff1 / this.ycoeff3;
        double d7 = (this.ycoeff0 - d2) / this.ycoeff3;
        double d8 = d5;
        double d9 = (d8 * d8 - d6 * 3.0) / 9.0;
        double d10 = (d5 * 2.0 * d5 * d5 - d5 * 9.0 * d6 + d7 * 27.0) / 54.0;
        double d11 = d10 * d10;
        double d12 = d9;
        double d13 = d12 * d12 * d9;
        double d14 = d5 / 3.0;
        if (d11 < d13) {
            double d15;
            d4 = Math.acos(d10 / Math.sqrt(d13));
            d9 = -2.0 * Math.sqrt(d9);
            d3 = this.refine(d5, d6, d7, d2, d9 * Math.cos(d4 / 3.0) - d14);
            if (d15 < 0.0) {
                d3 = this.refine(d5, d6, d7, d2, d9 * Math.cos((d4 + Math.PI * 2) / 3.0) - d14);
            }
            if (d3 < 0.0) {
                d3 = this.refine(d5, d6, d7, d2, d9 * Math.cos((d4 - Math.PI * 2) / 3.0) - d14);
            }
        } else {
            boolean bl2 = d10 < 0.0;
            double d16 = Math.sqrt(d11 - d13);
            if (bl2) {
                d10 = -d10;
            }
            double d17 = Math.pow(d10 + d16, 0.3333333333333333);
            if (!bl2) {
                d17 = -d17;
            }
            double d18 = d17 == 0.0 ? 0.0 : d9 / d17;
            d3 = this.refine(d5, d6, d7, d2, d17 + d18 - d14);
        }
        if (d3 < 0.0) {
            d4 = 0.0;
            double d19 = 1.0;
            while ((d3 = (d4 + d19) / 2.0) != d4 && d3 != d19) {
                double d20;
                double d21 = ((Curve)this).YforT(d3);
                if (d20 < d2) {
                    d4 = d3;
                    continue;
                }
                if (!(d21 > d2)) break;
                d19 = d3;
            }
        }
        if (d3 >= 0.0) {
            this.TforY3 = this.TforY2;
            this.YforT3 = this.YforT2;
            this.TforY2 = this.TforY1;
            this.YforT2 = this.YforT1;
            this.TforY1 = d3;
            this.YforT1 = d2;
        }
        return d3;
    }

    public final double refine(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        if (d6 < -0.1 || d6 > 1.1) {
            return -1.0;
        }
        double d10 = ((Curve)this).YforT(d6);
        if (d9 < d5) {
            d8 = d6;
            d7 = 1.0;
        } else {
            d8 = 0.0;
            d7 = d6;
        }
        boolean bl2 = true;
        while (d10 != d5) {
            double d11;
            if (!bl2) {
                var18_10 = (d8 + d7) / 2.0;
                if (var18_10 == d8 || var18_10 == d7) break;
                d6 = var18_10;
            } else {
                var18_10 = ((Curve)this).dYforT(d6, 1);
                if (var18_10 == 0.0) {
                    bl2 = false;
                    continue;
                }
                double d12 = d6 + (d5 - d10) / var18_10;
                if (d12 == d6 || d12 <= d8 || d12 >= d7) {
                    bl2 = false;
                    continue;
                }
                d6 = d12;
            }
            d10 = ((Curve)this).YforT(d6);
            if (d11 < d5) {
                d8 = d6;
                continue;
            }
            if (!(d10 > d5)) break;
            d7 = d6;
        }
        if (d6 > 1.0) {
            return -1.0;
        }
        return d6;
    }

    @Override
    public final double XforY(double d2) {
        if (d2 <= this.y0) {
            return this.x0;
        }
        if (d2 >= this.y1) {
            return this.x1;
        }
        Order3 order3 = this;
        return ((Curve)order3).XforT(((Curve)order3).TforY(d2));
    }

    @Override
    public final double XforT(double d2) {
        return ((this.xcoeff3 * d2 + this.xcoeff2) * d2 + this.xcoeff1) * d2 + this.xcoeff0;
    }

    @Override
    public final double YforT(double d2) {
        return ((this.ycoeff3 * d2 + this.ycoeff2) * d2 + this.ycoeff1) * d2 + this.ycoeff0;
    }

    @Override
    public final double dXforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return ((this.xcoeff3 * d2 + this.xcoeff2) * d2 + this.xcoeff1) * d2 + this.xcoeff0;
            }
            case 1: {
                return (3.0 * this.xcoeff3 * d2 + 2.0 * this.xcoeff2) * d2 + this.xcoeff1;
            }
            case 2: {
                return 6.0 * this.xcoeff3 * d2 + 2.0 * this.xcoeff2;
            }
            case 3: {
                return 6.0 * this.xcoeff3;
            }
        }
        return 0.0;
    }

    @Override
    public final double dYforT(double d2, int n2) {
        switch (n2) {
            case 0: {
                return ((this.ycoeff3 * d2 + this.ycoeff2) * d2 + this.ycoeff1) * d2 + this.ycoeff0;
            }
            case 1: {
                return (3.0 * this.ycoeff3 * d2 + 2.0 * this.ycoeff2) * d2 + this.ycoeff1;
            }
            case 2: {
                return 6.0 * this.ycoeff3 * d2 + 2.0 * this.ycoeff2;
            }
            case 3: {
                return 6.0 * this.ycoeff3;
            }
        }
        return 0.0;
    }

    @Override
    public final double nextVertical(double d2, double d3) {
        double[] dArray = new double[]{this.xcoeff1, 2.0 * this.xcoeff2, 3.0 * this.xcoeff3};
        int n2 = Order3.solveQuadratic(dArray, dArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(dArray[i2] > d2) || !(dArray[i2] < d3)) continue;
            d3 = dArray[i2];
        }
        return d3;
    }

    @Override
    public final void enlarge(RectBounds rectBounds) {
        rectBounds.add((float)this.x0, (float)this.y0);
        double[] dArray = new double[]{this.xcoeff1, 2.0 * this.xcoeff2, 3.0 * this.xcoeff3};
        int n2 = Order3.solveQuadratic(dArray, dArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            double d3 = dArray[i2];
            if (!(d2 > 0.0) || !(d3 < 1.0)) continue;
            rectBounds.add((float)((Curve)this).XforT(d3), (float)((Curve)this).YforT(d3));
        }
        rectBounds.add((float)this.x1, (float)this.y1);
    }

    @Override
    public final Curve getSubCurve(double d2, double d3, int n2) {
        int n3;
        if (d2 <= this.y0 && d3 >= this.y1) {
            return this.getWithDirection(n2);
        }
        double[] dArray = new double[14];
        double d4 = ((Curve)this).TforY(d2);
        double d5 = ((Curve)this).TforY(d3);
        dArray[0] = this.x0;
        dArray[1] = this.y0;
        dArray[2] = this.cx0;
        dArray[3] = this.cy0;
        dArray[4] = this.cx1;
        dArray[5] = this.cy1;
        dArray[6] = this.x1;
        dArray[7] = this.y1;
        if (d4 > d5) {
            double d6 = d4;
            d4 = d5;
            d5 = d6;
        }
        if (d5 < 1.0) {
            Order3.split(dArray, 0, d5);
        }
        if (d4 <= 0.0) {
            n3 = 0;
        } else {
            Order3.split(dArray, 0, d4 / d5);
            n3 = 6;
        }
        return new Order3(dArray[n3], d2, dArray[n3 + 2], dArray[n3 + 3], dArray[n3 + 4], dArray[n3 + 5], dArray[n3 + 6], d3, n2);
    }

    @Override
    public final Curve getReversedCurve() {
        return new Order3(this.x0, this.y0, this.cx0, this.cy0, this.cx1, this.cy1, this.x1, this.y1, -this.direction);
    }

    @Override
    public final int getSegment(float[] fArray) {
        if (this.direction == 1) {
            fArray[0] = (float)this.cx0;
            fArray[1] = (float)this.cy0;
            fArray[2] = (float)this.cx1;
            fArray[3] = (float)this.cy1;
            fArray[4] = (float)this.x1;
            fArray[5] = (float)this.y1;
        } else {
            fArray[0] = (float)this.cx1;
            fArray[1] = (float)this.cy1;
            fArray[2] = (float)this.cx0;
            fArray[3] = (float)this.cy0;
            fArray[4] = (float)this.x0;
            fArray[5] = (float)this.y0;
        }
        return 3;
    }

    @Override
    public final String controlPointString() {
        return "(" + Order3.round(this.getCX0()) + ", " + Order3.round(this.getCY0()) + "), (" + Order3.round(this.getCX1()) + ", " + Order3.round(this.getCY1()) + "), ";
    }
}

