/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.IllegalPathStateException;
import com.sun.javafx.geom.Path2D$CopyIterator;
import com.sun.javafx.geom.Path2D$CornerPrefix;
import com.sun.javafx.geom.Path2D$SVGParser;
import com.sun.javafx.geom.Path2D$TxIterator;
import com.sun.javafx.geom.PathConsumer2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.Arrays;

public class Path2D
extends Shape
implements PathConsumer2D {
    static final int[] curvecoords = new int[]{2, 2, 4, 6, 0};
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    byte[] pointTypes;
    int numTypes;
    int numCoords;
    int windingRule;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;
    static final int EXPAND_MAX_COORDS = 1000;
    float[] floatCoords;
    float moveX;
    float moveY;
    float prevX;
    float prevY;
    float currX;
    float currY;

    public Path2D() {
        this(1, 20);
    }

    public Path2D(int n2) {
        this(n2, 20);
    }

    public Path2D(int n2, int n3) {
        this.setWindingRule(n2);
        this.pointTypes = new byte[n3];
        this.floatCoords = new float[n3 << 1];
    }

    public Path2D(Shape shape) {
        this(shape, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Path2D(Shape object, BaseTransform baseTransform) {
        if (!(object instanceof Path2D)) {
            object = ((Shape)object).getPathIterator(baseTransform);
            this.setWindingRule(object.getWindingRule());
            this.pointTypes = new byte[20];
            this.floatCoords = new float[40];
            this.append((PathIterator)object, false);
            return;
        }
        object = (Path2D)object;
        this.setWindingRule(((Path2D)object).windingRule);
        this.numTypes = ((Path2D)object).numTypes;
        this.pointTypes = Arrays.copyOf(((Path2D)object).pointTypes, this.numTypes);
        this.numCoords = ((Path2D)object).numCoords;
        if (baseTransform != null && !baseTransform.isIdentity()) {
            this.floatCoords = new float[this.numCoords + 6];
            baseTransform.transform(((Path2D)object).floatCoords, 0, this.floatCoords, 0, this.numCoords / 2);
            this.floatCoords[this.numCoords] = this.moveX;
            this.floatCoords[this.numCoords + 1] = this.moveY;
            this.floatCoords[this.numCoords + 2] = this.prevX;
            this.floatCoords[this.numCoords + 3] = this.prevY;
            this.floatCoords[this.numCoords + 4] = this.currX;
            this.floatCoords[this.numCoords + 5] = this.currY;
            baseTransform.transform(this.floatCoords, this.numCoords, this.floatCoords, this.numCoords, 3);
            this.moveX = this.floatCoords[this.numCoords];
            this.moveY = this.floatCoords[this.numCoords + 1];
            this.prevX = this.floatCoords[this.numCoords + 2];
            this.prevY = this.floatCoords[this.numCoords + 3];
            this.currX = this.floatCoords[this.numCoords + 4];
            this.currY = this.floatCoords[this.numCoords + 5];
            return;
        }
        this.floatCoords = Arrays.copyOf(((Path2D)object).floatCoords, this.numCoords);
        this.moveX = ((Path2D)object).moveX;
        this.moveY = ((Path2D)object).moveY;
        this.prevX = ((Path2D)object).prevX;
        this.prevY = ((Path2D)object).prevY;
        this.currX = ((Path2D)object).currX;
        this.currY = ((Path2D)object).currY;
    }

    public Path2D(int n2, byte[] byArray, int n3, float[] fArray, int n4) {
        this.windingRule = n2;
        this.pointTypes = byArray;
        this.numTypes = n3;
        this.floatCoords = fArray;
        this.numCoords = n4;
    }

    Point2D getPoint(int n2) {
        return new Point2D(this.floatCoords[n2], this.floatCoords[n2 + 1]);
    }

    private boolean close(int n2, float f2, float f3) {
        return Math.abs((float)n2 - f2) <= f3;
    }

    public boolean checkAndGetIntRect(Rectangle rectangle, float f2) {
        if (this.numTypes == 5) {
            if (this.pointTypes[4] != 1 && this.pointTypes[4] != 4) {
                return false;
            }
        } else if (this.numTypes == 6) {
            if (this.pointTypes[4] != 1) {
                return false;
            }
            if (this.pointTypes[5] != 4) {
                return false;
            }
        } else if (this.numTypes != 4) {
            return false;
        }
        if (this.pointTypes[0] != 0) {
            return false;
        }
        if (this.pointTypes[1] != 1) {
            return false;
        }
        if (this.pointTypes[2] != 1) {
            return false;
        }
        if (this.pointTypes[3] != 1) {
            return false;
        }
        int n2 = (int)(this.floatCoords[0] + 0.5f);
        int n3 = (int)(this.floatCoords[1] + 0.5f);
        if (!this.close(n2, this.floatCoords[0], f2)) {
            return false;
        }
        if (!this.close(n3, this.floatCoords[1], f2)) {
            return false;
        }
        int n4 = (int)(this.floatCoords[2] + 0.5f);
        int n5 = (int)(this.floatCoords[3] + 0.5f);
        if (!this.close(n4, this.floatCoords[2], f2)) {
            return false;
        }
        if (!this.close(n5, this.floatCoords[3], f2)) {
            return false;
        }
        int n6 = (int)(this.floatCoords[4] + 0.5f);
        int n7 = (int)(this.floatCoords[5] + 0.5f);
        if (!this.close(n6, this.floatCoords[4], f2)) {
            return false;
        }
        if (!this.close(n7, this.floatCoords[5], f2)) {
            return false;
        }
        int n8 = (int)(this.floatCoords[6] + 0.5f);
        int n9 = (int)(this.floatCoords[7] + 0.5f);
        if (!this.close(n8, this.floatCoords[6], f2)) {
            return false;
        }
        if (!this.close(n9, this.floatCoords[7], f2)) {
            return false;
        }
        if (this.numTypes > 4 && this.pointTypes[4] == 1) {
            if (!this.close(n2, this.floatCoords[8], f2)) {
                return false;
            }
            if (!this.close(n3, this.floatCoords[9], f2)) {
                return false;
            }
        }
        if (n2 == n4 && n6 == n8 && n3 == n9 && n5 == n7 || n3 == n5 && n7 == n9 && n2 == n8 && n4 == n6) {
            int n10;
            if (n6 < n2) {
                n10 = n6;
                n4 = n2 - n6;
            } else {
                n10 = n2;
                n4 = n6 - n2;
            }
            if (n7 < n3) {
                n2 = n7;
                n3 -= n7;
            } else {
                n2 = n3;
                n3 = n7 - n3;
            }
            if (n4 < 0) {
                return false;
            }
            if (n3 < 0) {
                return false;
            }
            if (rectangle != null) {
                rectangle.setBounds(n10, n2, n4, n3);
            }
            return true;
        }
        return false;
    }

    void needRoom(boolean n2, int n3) {
        if (n2 != 0 && this.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        n2 = this.pointTypes.length;
        if (n2 == 0) {
            this.pointTypes = new byte[2];
        } else if (this.numTypes >= n2) {
            this.pointTypes = Path2D.expandPointTypes(this.pointTypes, 1);
        }
        int cfr_ignored_0 = this.floatCoords.length;
        if (this.numCoords > this.floatCoords.length - n3) {
            this.floatCoords = Path2D.expandCoords(this.floatCoords, n3);
        }
    }

    static byte[] expandPointTypes(byte[] byArray, int n2) {
        int n3 = byArray.length;
        if ((n2 = n3 + n2) < n3) {
            throw new ArrayIndexOutOfBoundsException("pointTypes exceeds maximum capacity !");
        }
        int n4 = n3;
        if (n4 > 500) {
            n4 = Math.max(500, n3 >> 3);
        } else if (n4 < 20) {
            n4 = 20;
        }
        assert (n4 > 0);
        if ((n3 += n4) < n2) {
            n3 = Integer.MAX_VALUE;
        }
        while (true) {
            try {
                return Arrays.copyOf(byArray, n3);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (n3 == n2) {
                    throw outOfMemoryError;
                }
                n3 = n2 + (n3 - n2) / 2;
                continue;
            }
            break;
        }
    }

    static float[] expandCoords(float[] fArray, int n2) {
        int n3 = fArray.length;
        int n4 = n3 + n2;
        if (n4 < n3) {
            throw new ArrayIndexOutOfBoundsException("coords exceeds maximum capacity !");
        }
        int n5 = n3;
        if (n5 > 1000) {
            n5 = Math.max(1000, n3 >> 3);
        } else if (n5 < 20) {
            n5 = 20;
        }
        assert (n5 > n2);
        n2 = n3 + n5;
        if (n2 < n4) {
            n2 = Integer.MAX_VALUE;
        }
        while (true) {
            try {
                return Arrays.copyOf(fArray, n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (n2 == n4) {
                    throw outOfMemoryError;
                }
                n2 = n4 + (n2 - n4) / 2;
                continue;
            }
            break;
        }
    }

    @Override
    public final void moveTo(float f2, float f3) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            Path2D path2D = this;
            path2D.prevX = this.currX = f2;
            path2D.moveX = this.currX;
            this.floatCoords[this.numCoords - 2] = this.currX;
            Path2D path2D2 = this;
            path2D2.prevY = this.currY = f3;
            path2D2.moveY = this.currY;
            this.floatCoords[this.numCoords - 1] = this.currY;
            return;
        }
        this.needRoom(false, 2);
        this.pointTypes[this.numTypes++] = 0;
        Path2D path2D = this;
        path2D.prevX = this.currX = f2;
        path2D.moveX = this.currX;
        this.floatCoords[this.numCoords++] = this.currX;
        Path2D path2D3 = this;
        path2D3.prevY = this.currY = f3;
        path2D3.moveY = this.currY;
        this.floatCoords[this.numCoords++] = this.currY;
    }

    public final void moveToRel(float f2, float f3) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            Path2D path2D = this;
            path2D.prevX = this.currX += f2;
            path2D.moveX = this.currX;
            this.floatCoords[this.numCoords - 2] = this.currX;
            Path2D path2D2 = this;
            path2D2.prevY = this.currY += f3;
            path2D2.moveY = this.currY;
            this.floatCoords[this.numCoords - 1] = this.currY;
            return;
        }
        this.needRoom(true, 2);
        this.pointTypes[this.numTypes++] = 0;
        Path2D path2D = this;
        path2D.prevX = this.currX += f2;
        path2D.moveX = this.currX;
        this.floatCoords[this.numCoords++] = this.currX;
        Path2D path2D3 = this;
        path2D3.prevY = this.currY += f3;
        path2D3.moveY = this.currY;
        this.floatCoords[this.numCoords++] = this.currY;
    }

    @Override
    public final void lineTo(float f2, float f3) {
        this.needRoom(true, 2);
        this.pointTypes[this.numTypes++] = 1;
        this.prevX = this.currX = f2;
        this.floatCoords[this.numCoords++] = this.currX;
        this.prevY = this.currY = f3;
        this.floatCoords[this.numCoords++] = this.currY;
    }

    public final void lineToRel(float f2, float f3) {
        this.needRoom(true, 2);
        this.pointTypes[this.numTypes++] = 1;
        this.prevX = this.currX += f2;
        this.floatCoords[this.numCoords++] = this.currX;
        this.prevY = this.currY += f3;
        this.floatCoords[this.numCoords++] = this.currY;
    }

    @Override
    public final void quadTo(float f2, float f3, float f4, float f5) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.floatCoords[this.numCoords++] = this.prevX = f2;
        this.floatCoords[this.numCoords++] = this.prevY = f3;
        this.floatCoords[this.numCoords++] = this.currX = f4;
        this.floatCoords[this.numCoords++] = this.currY = f5;
    }

    public final void quadToRel(float f2, float f3, float f4, float f5) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX + f2;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY + f3;
        this.floatCoords[this.numCoords++] = this.currX += f4;
        this.floatCoords[this.numCoords++] = this.currY += f5;
    }

    public final void quadToSmooth(float f2, float f3) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX * 2.0f - this.prevX;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY * 2.0f - this.prevY;
        this.floatCoords[this.numCoords++] = this.currX = f2;
        this.floatCoords[this.numCoords++] = this.currY = f3;
    }

    public final void quadToSmoothRel(float f2, float f3) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX * 2.0f - this.prevX;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY * 2.0f - this.prevY;
        this.floatCoords[this.numCoords++] = this.currX += f2;
        this.floatCoords[this.numCoords++] = this.currY += f3;
    }

    @Override
    public final void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.floatCoords[this.numCoords++] = f2;
        this.floatCoords[this.numCoords++] = f3;
        this.floatCoords[this.numCoords++] = this.prevX = f4;
        this.floatCoords[this.numCoords++] = this.prevY = f5;
        this.floatCoords[this.numCoords++] = this.currX = f6;
        this.floatCoords[this.numCoords++] = this.currY = f7;
    }

    public final void curveToRel(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.floatCoords[this.numCoords++] = this.currX + f2;
        this.floatCoords[this.numCoords++] = this.currY + f3;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX + f4;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY + f5;
        this.floatCoords[this.numCoords++] = this.currX += f6;
        this.floatCoords[this.numCoords++] = this.currY += f7;
    }

    public final void curveToSmooth(float f2, float f3, float f4, float f5) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.floatCoords[this.numCoords++] = this.currX * 2.0f - this.prevX;
        this.floatCoords[this.numCoords++] = this.currY * 2.0f - this.prevY;
        this.floatCoords[this.numCoords++] = this.prevX = f2;
        this.floatCoords[this.numCoords++] = this.prevY = f3;
        this.floatCoords[this.numCoords++] = this.currX = f4;
        this.floatCoords[this.numCoords++] = this.currY = f5;
    }

    public final void curveToSmoothRel(float f2, float f3, float f4, float f5) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.floatCoords[this.numCoords++] = this.currX * 2.0f - this.prevX;
        this.floatCoords[this.numCoords++] = this.currY * 2.0f - this.prevY;
        this.floatCoords[this.numCoords++] = this.prevX = this.currX + f2;
        this.floatCoords[this.numCoords++] = this.prevY = this.currY + f3;
        this.floatCoords[this.numCoords++] = this.currX += f4;
        this.floatCoords[this.numCoords++] = this.currY += f5;
    }

    public final void ovalQuadrantTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.numTypes <= 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        Path2D path2D = this;
        path2D.appendOvalQuadrant(path2D.currX, this.currY, f2, f3, f4, f5, f6, f7, Path2D$CornerPrefix.CORNER_ONLY);
    }

    public final void appendOvalQuadrant(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Path2D$CornerPrefix path2D$CornerPrefix) {
        if (!(f8 >= 0.0f && f8 <= f9 && f9 <= 1.0f)) {
            throw new IllegalArgumentException("0 <= tfrom <= tto <= 1 required");
        }
        float f10 = (float)((double)f2 + (double)(f4 - f2) * 0.5522847498307933);
        float f11 = (float)((double)f3 + (double)(f5 - f3) * 0.5522847498307933);
        f4 = (float)((double)f6 + (double)(f4 - f6) * 0.5522847498307933);
        f5 = (float)((double)f7 + (double)(f5 - f7) * 0.5522847498307933);
        if (f9 < 1.0f) {
            float f12 = 1.0f - f9;
            f6 += (f4 - f6) * f12;
            f7 += (f5 - f7) * f12;
            f4 += (f10 - f4) * f12;
            f5 += (f11 - f5) * f12;
            f10 += (f2 - f10) * f12;
            f11 += (f3 - f11) * f12;
            f6 += (f4 - f6) * f12;
            f7 += (f5 - f7) * f12;
            f4 += (f10 - f4) * f12;
            f5 += (f11 - f5) * f12;
            f6 += (f4 - f6) * f12;
            f7 += (f5 - f7) * f12;
        }
        if (f8 > 0.0f) {
            if (f9 < 1.0f) {
                f8 /= f9;
            }
            f2 += (f10 - f2) * f8;
            f3 += (f11 - f3) * f8;
            f10 += (f4 - f10) * f8;
            f11 += (f5 - f11) * f8;
            f4 += (f6 - f4) * f8;
            f5 += (f7 - f5) * f8;
            f2 += (f10 - f2) * f8;
            f3 += (f11 - f3) * f8;
            f10 += (f4 - f10) * f8;
            f11 += (f5 - f11) * f8;
            f2 += (f10 - f2) * f8;
            f3 += (f11 - f3) * f8;
        }
        if (path2D$CornerPrefix == Path2D$CornerPrefix.MOVE_THEN_CORNER) {
            this.moveTo(f2, f3);
        } else if (path2D$CornerPrefix == Path2D$CornerPrefix.LINE_THEN_CORNER && (this.numTypes == 1 || f2 != this.currX || f3 != this.currY)) {
            this.lineTo(f2, f3);
        }
        if (f8 == f9 || f2 == f10 && f10 == f4 && f4 == f6 && f3 == f11 && f11 == f5 && f5 == f7) {
            if (path2D$CornerPrefix != Path2D$CornerPrefix.LINE_THEN_CORNER) {
                this.lineTo(f6, f7);
                return;
            }
        } else {
            this.curveTo(f10, f11, f4, f5, f6, f7);
        }
    }

    public void arcTo(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
        double d2;
        double d3;
        double d4;
        if (this.numTypes <= 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        double d5 = Math.abs(f2);
        double d6 = Math.abs(f3);
        if (d5 == 0.0 || d6 == 0.0) {
            this.lineTo(f5, f6);
            return;
        }
        double d7 = this.currX;
        double d8 = this.currY;
        double d9 = f5;
        double d10 = f6;
        if (d7 == d9 && d8 == d10) {
            return;
        }
        if ((double)f4 == 0.0) {
            d4 = 1.0;
            d3 = 0.0;
        } else {
            d4 = Math.cos(f4);
            d3 = Math.sin(f4);
        }
        double d11 = (d7 + d9) / 2.0;
        double d12 = (d8 + d10) / 2.0;
        double d13 = d7 - d11;
        double d14 = d8 - d12;
        double d15 = (d4 * d13 + d3 * d14) / d5;
        double d16 = (d4 * d14 - d3 * d13) / d6;
        double d17 = d15;
        double d18 = d16;
        double d19 = d17 * d17 + d18 * d18;
        if (d2 >= 1.0) {
            double d20 = d16 * d5;
            double d21 = d15 * d6;
            if (bl3) {
                d20 = -d20;
            } else {
                d21 = -d21;
            }
            double d22 = d4 * d20 - d3 * d21;
            double d23 = d4 * d21 + d3 * d20;
            double d24 = d11 + d22;
            double d25 = d12 + d23;
            double d26 = d7 + d22;
            double d27 = d8 + d23;
            this.appendOvalQuadrant((float)d7, (float)d8, (float)d26, (float)d27, (float)d24, (float)d25, 0.0f, 1.0f, Path2D$CornerPrefix.CORNER_ONLY);
            d26 = d9 + d22;
            d27 = d10 + d23;
            this.appendOvalQuadrant((float)d24, (float)d25, (float)d26, (float)d27, (float)d9, (float)d10, 0.0f, 1.0f, Path2D$CornerPrefix.CORNER_ONLY);
            return;
        }
        double d28 = Math.sqrt((1.0 - d19) / d19);
        double d29 = d28 * d16;
        double d30 = d28 * d15;
        if (bl2 == bl3) {
            d29 = -d29;
        } else {
            d30 = -d30;
        }
        d11 += d4 * d29 * d5 - d3 * d30 * d6;
        d12 += d4 * d30 * d6 + d3 * d29 * d5;
        double d31 = d15 - d29;
        double d32 = d16 - d30;
        double d33 = -(d15 + d29);
        double d34 = -(d16 + d30);
        boolean bl4 = false;
        float f7 = 1.0f;
        boolean bl5 = false;
        do {
            double d35;
            double d36 = d32;
            double d37 = d31;
            if (bl3) {
                d36 = -d36;
            } else {
                d37 = -d37;
            }
            if (d36 * d33 + d37 * d34 > 0.0) {
                double d38;
                d35 = d31 * d33 + d32 * d34;
                if (d38 >= 0.0) {
                    f7 = (float)(Math.acos(d35) / 1.5707963267948966);
                    bl4 = true;
                }
                bl5 = true;
            } else if (bl5) break;
            d35 = d4 * d36 * d5 - d3 * d37 * d6;
            double d39 = d4 * d37 * d6 + d3 * d36 * d5;
            double d40 = d11 + d35;
            double d41 = d12 + d39;
            double d42 = d7 + d35;
            double d43 = d8 + d39;
            this.appendOvalQuadrant((float)d7, (float)d8, (float)d42, (float)d43, (float)d40, (float)d41, 0.0f, f7, Path2D$CornerPrefix.CORNER_ONLY);
            d7 = d40;
            d8 = d41;
            d31 = d36;
            d32 = d37;
        } while (!bl4);
    }

    public void arcToRel(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
        this.arcTo(f2, f3, f4, bl2, bl3, this.currX + f5, this.currY + f6);
    }

    int pointCrossings(float f2, float f3) {
        float f4;
        float f5;
        float[] fArray = this.floatCoords;
        float f6 = f5 = this.floatCoords[0];
        float f7 = f4 = fArray[1];
        int n2 = 0;
        int n3 = 2;
        block7: for (int i2 = 1; i2 < this.numTypes; ++i2) {
            switch (this.pointTypes[i2]) {
                case 0: {
                    if (f7 != f4) {
                        n2 += Shape.pointCrossingsForLine(f2, f3, f6, f7, f5, f4);
                    }
                    f5 = f6 = fArray[n3++];
                    f4 = f7 = fArray[n3++];
                    continue block7;
                }
                case 1: {
                    float f8 = f6;
                    float f9 = f7;
                    f6 = fArray[n3++];
                    f7 = fArray[n3++];
                    n2 += Shape.pointCrossingsForLine(f2, f3, f8, f9, f6, f7);
                    continue block7;
                }
                case 2: {
                    float f10 = f6;
                    float f11 = f7;
                    int n4 = n3++;
                    int n5 = n3++;
                    f6 = fArray[n3++];
                    f7 = fArray[n3++];
                    n2 += Shape.pointCrossingsForQuad(f2, f3, f10, f11, fArray[n4], fArray[n5], f6, f7, 0);
                    continue block7;
                }
                case 3: {
                    float f12 = f6;
                    float f13 = f7;
                    int n6 = n3++;
                    int n7 = n3++;
                    int n8 = n3++;
                    int n9 = n3++;
                    f6 = fArray[n3++];
                    f7 = fArray[n3++];
                    n2 += Shape.pointCrossingsForCubic(f2, f3, f12, f13, fArray[n6], fArray[n7], fArray[n8], fArray[n9], f6, f7, 0);
                    continue block7;
                }
                case 4: {
                    if (f7 != f4) {
                        n2 += Shape.pointCrossingsForLine(f2, f3, f6, f7, f5, f4);
                    }
                    f6 = f5;
                    f7 = f4;
                }
            }
        }
        if (f7 != f4) {
            n2 += Shape.pointCrossingsForLine(f2, f3, f6, f7, f5, f4);
        }
        return n2;
    }

    int rectCrossings(float f2, float f3, float f4, float f5) {
        float f6;
        float f7;
        float[] fArray = this.floatCoords;
        float f8 = f7 = this.floatCoords[0];
        float f9 = f6 = fArray[1];
        int n2 = 0;
        int n3 = 2;
        block7: for (int i2 = 1; n2 != Integer.MIN_VALUE && i2 < this.numTypes; ++i2) {
            switch (this.pointTypes[i2]) {
                case 0: {
                    if (f8 != f7 || f9 != f6) {
                        n2 = Shape.rectCrossingsForLine(n2, f2, f3, f4, f5, f8, f9, f7, f6);
                    }
                    f7 = f8 = fArray[n3++];
                    f6 = f9 = fArray[n3++];
                    continue block7;
                }
                case 1: {
                    float f10 = f8;
                    float f11 = f9;
                    f8 = fArray[n3++];
                    f9 = fArray[n3++];
                    n2 = Shape.rectCrossingsForLine(n2, f2, f3, f4, f5, f10, f11, f8, f9);
                    continue block7;
                }
                case 2: {
                    float f12 = f8;
                    float f13 = f9;
                    int n4 = n3++;
                    int n5 = n3++;
                    f8 = fArray[n3++];
                    f9 = fArray[n3++];
                    n2 = Shape.rectCrossingsForQuad(n2, f2, f3, f4, f5, f12, f13, fArray[n4], fArray[n5], f8, f9, 0);
                    continue block7;
                }
                case 3: {
                    float f14 = f8;
                    float f15 = f9;
                    int n6 = n3++;
                    int n7 = n3++;
                    int n8 = n3++;
                    int n9 = n3++;
                    f8 = fArray[n3++];
                    f9 = fArray[n3++];
                    n2 = Shape.rectCrossingsForCubic(n2, f2, f3, f4, f5, f14, f15, fArray[n6], fArray[n7], fArray[n8], fArray[n9], f8, f9, 0);
                    continue block7;
                }
                case 4: {
                    if (f8 != f7 || f9 != f6) {
                        n2 = Shape.rectCrossingsForLine(n2, f2, f3, f4, f5, f8, f9, f7, f6);
                    }
                    f8 = f7;
                    f9 = f6;
                }
            }
        }
        if (n2 != Integer.MIN_VALUE && (f8 != f7 || f9 != f6)) {
            n2 = Shape.rectCrossingsForLine(n2, f2, f3, f4, f5, f8, f9, f7, f6);
        }
        return n2;
    }

    public final void append(PathIterator pathIterator, boolean bl2) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (!bl2 || this.numTypes <= 0 || this.numCoords <= 0) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    if (this.pointTypes[this.numTypes - 1] != 4 && this.floatCoords[this.numCoords - 2] == fArray[0] && this.floatCoords[this.numCoords - 1] == fArray[1]) break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pathIterator.next();
            bl2 = false;
        }
    }

    public final void transform(BaseTransform baseTransform) {
        if (this.numCoords == 0) {
            return;
        }
        this.needRoom(false, 6);
        this.floatCoords[this.numCoords] = this.moveX;
        this.floatCoords[this.numCoords + 1] = this.moveY;
        this.floatCoords[this.numCoords + 2] = this.prevX;
        this.floatCoords[this.numCoords + 3] = this.prevY;
        this.floatCoords[this.numCoords + 4] = this.currX;
        this.floatCoords[this.numCoords + 5] = this.currY;
        baseTransform.transform(this.floatCoords, 0, this.floatCoords, 0, this.numCoords / 2 + 3);
        this.moveX = this.floatCoords[this.numCoords];
        this.moveY = this.floatCoords[this.numCoords + 1];
        this.prevX = this.floatCoords[this.numCoords + 2];
        this.prevY = this.floatCoords[this.numCoords + 3];
        this.currX = this.floatCoords[this.numCoords + 4];
        this.currY = this.floatCoords[this.numCoords + 5];
    }

    @Override
    public final RectBounds getBounds() {
        float f2;
        float f3;
        float f4;
        float f5;
        int n2 = this.numCoords;
        if (n2 > 0) {
            f4 = f5 = this.floatCoords[--n2];
            f2 = f3 = this.floatCoords[--n2];
            while (n2 > 0) {
                float f6;
                float f7 = this.floatCoords[--n2];
                float f8 = this.floatCoords[--n2];
                if (f6 < f2) {
                    f2 = f8;
                }
                if (f7 < f4) {
                    f4 = f7;
                }
                if (f8 > f3) {
                    f3 = f8;
                }
                if (!(f7 > f5)) continue;
                f5 = f7;
            }
        } else {
            f5 = 0.0f;
            f3 = 0.0f;
            f4 = 0.0f;
            f2 = 0.0f;
        }
        return new RectBounds(f2, f4, f3, f5);
    }

    public final int getNumCommands() {
        return this.numTypes;
    }

    public final byte[] getCommandsNoClone() {
        return this.pointTypes;
    }

    public final float[] getFloatCoordsNoClone() {
        return this.floatCoords;
    }

    @Override
    public PathIterator getPathIterator(BaseTransform baseTransform) {
        if (baseTransform == null) {
            return new Path2D$CopyIterator(this);
        }
        return new Path2D$TxIterator(this, baseTransform);
    }

    @Override
    public final void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(true, 0);
            this.pointTypes[this.numTypes++] = 4;
            Path2D path2D = this;
            path2D.prevX = path2D.currX = this.moveX;
            Path2D path2D2 = this;
            path2D2.prevY = path2D2.currY = this.moveY;
        }
    }

    @Override
    public void pathDone() {
    }

    public final void append(Shape shape, boolean bl2) {
        this.append(shape.getPathIterator(null), bl2);
    }

    public final void appendSVGPath(String object) {
        object = new Path2D$SVGParser((String)object);
        v0.allowcomma = false;
        while (!((Path2D$SVGParser)object).isDone()) {
            ((Path2D$SVGParser)object).allowcomma = false;
            char c2 = ((Path2D$SVGParser)object).getChar();
            switch (c2) {
                case 'M': {
                    this.moveTo(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    while (((Path2D$SVGParser)object).nextIsNumber()) {
                        this.lineTo(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    }
                    break;
                }
                case 'm': {
                    if (this.numTypes > 0) {
                        this.moveToRel(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } else {
                        this.moveTo(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    }
                    while (((Path2D$SVGParser)object).nextIsNumber()) {
                        this.lineToRel(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    }
                    break;
                }
                case 'L': {
                    do {
                        this.lineTo(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'l': {
                    do {
                        this.lineToRel(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'H': {
                    do {
                        this.lineTo(((Path2D$SVGParser)object).f(), this.currY);
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'h': {
                    do {
                        this.lineToRel(((Path2D$SVGParser)object).f(), 0.0f);
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'V': {
                    do {
                        Path2D path2D = this;
                        path2D.lineTo(path2D.currX, ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'v': {
                    do {
                        this.lineToRel(0.0f, ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'Q': {
                    do {
                        this.quadTo(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'q': {
                    do {
                        this.quadToRel(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'T': {
                    do {
                        this.quadToSmooth(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 't': {
                    do {
                        this.quadToSmoothRel(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'C': {
                    do {
                        this.curveTo(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'c': {
                    do {
                        this.curveToRel(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'S': {
                    do {
                        this.curveToSmooth(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 's': {
                    do {
                        this.curveToSmoothRel(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'A': {
                    do {
                        this.arcTo(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).a(), ((Path2D$SVGParser)object).b(), ((Path2D$SVGParser)object).b(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'a': {
                    do {
                        this.arcToRel(((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).a(), ((Path2D$SVGParser)object).b(), ((Path2D$SVGParser)object).b(), ((Path2D$SVGParser)object).f(), ((Path2D$SVGParser)object).f());
                    } while (((Path2D$SVGParser)object).nextIsNumber());
                    break;
                }
                case 'Z': 
                case 'z': {
                    this.closePath();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid command (" + c2 + ") in SVG path at pos=" + ((Path2D$SVGParser)object).pos);
                }
            }
            ((Path2D$SVGParser)object).allowcomma = false;
        }
    }

    public final int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = n2;
    }

    public final Point2D getCurrentPoint() {
        if (this.numTypes <= 0) {
            return null;
        }
        return new Point2D(this.currX, this.currY);
    }

    public final float getCurrentX() {
        if (this.numTypes <= 0) {
            throw new IllegalPathStateException("no current point in empty path");
        }
        return this.currX;
    }

    public final float getCurrentY() {
        if (this.numTypes <= 0) {
            throw new IllegalPathStateException("no current point in empty path");
        }
        return this.currY;
    }

    public final void reset() {
        Path2D path2D = this;
        path2D.numCoords = 0;
        path2D.numTypes = 0;
        Path2D path2D2 = this;
        Path2D path2D3 = this;
        Path2D path2D4 = this;
        path2D4.currY = 0.0f;
        path2D4.currX = 0.0f;
        path2D3.prevY = 0.0f;
        path2D3.prevX = 0.0f;
        path2D2.moveY = 0.0f;
        path2D2.moveX = 0.0f;
    }

    public final Shape createTransformedShape(BaseTransform baseTransform) {
        return new Path2D(this, baseTransform);
    }

    @Override
    public Path2D copy() {
        return new Path2D(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Path2D) {
            object = (Path2D)object;
            if (((Path2D)object).numTypes == this.numTypes && ((Path2D)object).numCoords == this.numCoords && ((Path2D)object).windingRule == this.windingRule) {
                int n2;
                for (n2 = 0; n2 < this.numTypes; ++n2) {
                    if (((Path2D)object).pointTypes[n2] == this.pointTypes[n2]) continue;
                    return false;
                }
                for (n2 = 0; n2 < this.numCoords; ++n2) {
                    if (((Path2D)object).floatCoords[n2] == this.floatCoords[n2]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n2;
        int n3 = 77 + this.numTypes;
        n3 = n3 * 11 + this.numCoords;
        n3 = n3 * 11 + this.windingRule;
        for (n2 = 0; n2 < this.numTypes; ++n2) {
            n3 = n3 * 11 + this.pointTypes[n2];
        }
        for (n2 = 0; n2 < this.numCoords; ++n2) {
            n3 = n3 * 11 + Float.floatToIntBits(this.floatCoords[n2]);
        }
        return n3;
    }

    public static boolean contains(PathIterator pathIterator, float f2, float f3) {
        if (f2 * 0.0f + f3 * 0.0f == 0.0f) {
            int n2 = pathIterator.getWindingRule() == 1 ? -1 : 1;
            int n3 = Shape.pointCrossingsForPath(pathIterator, f2, f3);
            return (n3 & n2) != 0;
        }
        return false;
    }

    public static boolean contains(PathIterator pathIterator, Point2D point2D) {
        return Path2D.contains(pathIterator, point2D.x, point2D.y);
    }

    @Override
    public final boolean contains(float f2, float f3) {
        if (f2 * 0.0f + f3 * 0.0f == 0.0f) {
            int n2;
            if (this.numTypes < 2) {
                return false;
            }
            int n3 = n2 = this.windingRule == 1 ? -1 : 1;
            return (this.pointCrossings(f2, f3) & n2) != 0;
        }
        return false;
    }

    @Override
    public final boolean contains(Point2D point2D) {
        return ((Shape)this).contains(point2D.x, point2D.y);
    }

    public static boolean contains(PathIterator pathIterator, float f2, float f3, float f4, float f5) {
        if (Float.isNaN(f2 + f4) || Float.isNaN(f3 + f5)) {
            return false;
        }
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return false;
        }
        int n2 = pathIterator.getWindingRule() == 1 ? -1 : 2;
        int n3 = Shape.rectCrossingsForPath(pathIterator, f2, f3, f2 + f4, f3 + f5);
        return n3 != Integer.MIN_VALUE && (n3 & n2) != 0;
    }

    @Override
    public final boolean contains(float f2, float f3, float f4, float f5) {
        if (Float.isNaN(f2 + f4) || Float.isNaN(f3 + f5)) {
            return false;
        }
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return false;
        }
        int n2 = this.windingRule == 1 ? -1 : 2;
        int n3 = this.rectCrossings(f2, f3, f2 + f4, f3 + f5);
        return n3 != Integer.MIN_VALUE && (n3 & n2) != 0;
    }

    public static boolean intersects(PathIterator pathIterator, float f2, float f3, float f4, float f5) {
        if (Float.isNaN(f2 + f4) || Float.isNaN(f3 + f5)) {
            return false;
        }
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return false;
        }
        int n2 = pathIterator.getWindingRule() == 1 ? -1 : 2;
        int n3 = Shape.rectCrossingsForPath(pathIterator, f2, f3, f2 + f4, f3 + f5);
        return n3 == Integer.MIN_VALUE || (n3 & n2) != 0;
    }

    @Override
    public final boolean intersects(float f2, float f3, float f4, float f5) {
        if (Float.isNaN(f2 + f4) || Float.isNaN(f3 + f5)) {
            return false;
        }
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return false;
        }
        int n2 = this.windingRule == 1 ? -1 : 2;
        int n3 = this.rectCrossings(f2, f3, f2 + f4, f3 + f5);
        return n3 == Integer.MIN_VALUE || (n3 & n2) != 0;
    }

    @Override
    public PathIterator getPathIterator(BaseTransform baseTransform, float f2) {
        return new FlatteningPathIterator(((Shape)this).getPathIterator(baseTransform), f2);
    }

    public void setTo(Path2D path2D) {
        this.numTypes = path2D.numTypes;
        this.numCoords = path2D.numCoords;
        if (this.numTypes > this.pointTypes.length) {
            this.pointTypes = new byte[this.numTypes];
        }
        System.arraycopy(path2D.pointTypes, 0, this.pointTypes, 0, this.numTypes);
        if (this.numCoords > this.floatCoords.length) {
            this.floatCoords = new float[this.numCoords];
        }
        System.arraycopy(path2D.floatCoords, 0, this.floatCoords, 0, this.numCoords);
        this.windingRule = path2D.windingRule;
        this.moveX = path2D.moveX;
        this.moveY = path2D.moveY;
        this.prevX = path2D.prevX;
        this.prevY = path2D.prevY;
        this.currX = path2D.currX;
        this.currY = path2D.currY;
    }
}

