/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.bmp;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage$ImageType;
import com.sun.javafx.iio.bmp.BMPDescriptor;
import com.sun.javafx.iio.bmp.BMPImageLoader$BitConverter;
import com.sun.javafx.iio.bmp.BitmapInfoHeader;
import com.sun.javafx.iio.bmp.LEInputStream;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class BMPImageLoader
extends ImageLoaderImpl {
    static final short BM = 19778;
    static final int BFH_SIZE = 14;
    final LEInputStream data;
    int bfSize;
    int bfOffBits;
    byte[] bgra_palette;
    BitmapInfoHeader bih;
    int[] bitMasks;
    int[] bitOffsets;

    BMPImageLoader(InputStream inputStream) throws IOException {
        super(BMPDescriptor.theInstance);
        this.data = new LEInputStream(inputStream);
        if (this.data.readShort() != 19778) {
            throw new IOException("Invalid BMP file signature");
        }
        this.readHeader();
    }

    private void readHeader() throws IOException {
        this.bfSize = this.data.readInt();
        this.data.skipBytes(4);
        this.bfOffBits = this.data.readInt();
        this.bih = new BitmapInfoHeader(this.data);
        if (this.bfOffBits < this.bih.biSize + 14) {
            throw new IOException("Invalid bitmap bits offset");
        }
        if (this.bih.biSize + 14 != this.bfOffBits) {
            int n2 = this.bfOffBits - this.bih.biSize - 14;
            int n3 = n2 / 4;
            this.bgra_palette = new byte[n3 << 2];
            n3 = this.data.in.read(this.bgra_palette);
            if (n3 < n2) {
                this.data.skipBytes(n2 - n3);
            }
        }
        if (this.bih.biCompression == 3) {
            this.parseBitfields();
            return;
        }
        if (this.bih.biCompression == 0 && this.bih.biBitCount == 16) {
            this.bitMasks = new int[]{31744, 992, 31};
            this.bitOffsets = new int[]{10, 5, 0};
        }
    }

    private void parseBitfields() throws IOException {
        if (this.bgra_palette.length != 12) {
            throw new IOException("Invalid bit masks");
        }
        this.bitMasks = new int[3];
        this.bitOffsets = new int[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            int n2;
            this.bitMasks[i2] = n2 = BMPImageLoader.getDWord(this.bgra_palette, i2 << 2);
            int n3 = 0;
            if (n2 != 0) {
                while ((n2 & 1) == 0) {
                    ++n3;
                    n2 >>>= 1;
                }
                if (!BMPImageLoader.isPow2Minus1(n2)) {
                    throw new IOException("Bit mask is not contiguous");
                }
            }
            this.bitOffsets[i2] = n3;
        }
        if (!BMPImageLoader.checkDisjointMasks(this.bitMasks[0], this.bitMasks[1], this.bitMasks[2])) {
            throw new IOException("Bit masks overlap");
        }
    }

    static boolean checkDisjointMasks(int n2, int n3, int n4) {
        return (n2 & n3 | n2 & n4 | n3 & n4) == 0;
    }

    static boolean isPow2Minus1(int n2) {
        int n3 = n2;
        return (n3 & n3 + 1) == 0;
    }

    @Override
    public final void dispose() {
    }

    private void readRLE(byte[] byArray, int n2, int n3, boolean bl2) throws IOException {
        int n4 = this.bih.biSizeImage;
        if (n4 == 0) {
            n4 = this.bfSize - this.bfOffBits;
        }
        byte[] byArray2 = new byte[n4];
        ImageTools.readFully(this.data.in, byArray2);
        boolean bl3 = this.bih.biHeight > 0;
        n3 = bl3 ? n3 - 1 : 0;
        int n5 = 0;
        int n6 = n3 * n2;
        block5: while (n5 < n4) {
            int n7;
            int n8;
            int n9 = BMPImageLoader.getByte(byArray2, n5++);
            int n10 = BMPImageLoader.getByte(byArray2, n5++);
            if (n9 == 0) {
                switch (n10) {
                    case 0: {
                        n6 = (n3 += bl3 ? -1 : 1) * n2;
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        n8 = BMPImageLoader.getByte(byArray2, n5++);
                        n10 = BMPImageLoader.getByte(byArray2, n5++);
                        n3 += n10;
                        n6 += n10 * n2;
                        n6 += n8 * 3;
                        continue block5;
                    }
                }
                n7 = 0;
                for (n8 = 0; n8 < n10; ++n8) {
                    if (bl2) {
                        if ((n8 & 1) == 0) {
                            n7 = BMPImageLoader.getByte(byArray2, n5++);
                            n9 = (n7 & 0xF0) >> 4;
                        } else {
                            n9 = n7 & 0xF;
                        }
                    } else {
                        n9 = BMPImageLoader.getByte(byArray2, n5++);
                    }
                    n6 = this.setRGBFromPalette(byArray, n6, n9);
                }
                if (bl2) {
                    if ((n10 & 3) != 1 && (n10 & 3) != 2) continue;
                    ++n5;
                    continue;
                }
                if ((n10 & 1) != 1) continue;
                ++n5;
                continue;
            }
            if (bl2) {
                n8 = (n10 & 0xF0) >> 4;
                n10 &= 0xF;
                for (n7 = 0; n7 < n9; ++n7) {
                    n6 = this.setRGBFromPalette(byArray, n6, (n7 & 1) == 0 ? n8 : n10);
                }
                continue;
            }
            for (n8 = 0; n8 < n9; ++n8) {
                n6 = this.setRGBFromPalette(byArray, n6, n10);
            }
        }
    }

    private int setRGBFromPalette(byte[] byArray, int n2, int n3) {
        byArray[n2++] = this.bgra_palette[(n3 <<= 2) + 2];
        byArray[n2++] = this.bgra_palette[n3 + 1];
        byArray[n2++] = this.bgra_palette[n3];
        return n2;
    }

    private void readPackedBits(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 8 / this.bih.biBitCount;
        n4 = (this.bih.biWidth + n4 - 1) / n4;
        n4 = n4 + 3 & 0xFFFFFFFC;
        int n5 = (1 << this.bih.biBitCount) - 1;
        byte[] byArray2 = new byte[n4];
        for (int i2 = 0; i2 != n3; ++i2) {
            ImageTools.readFully(this.data.in, byArray2);
            int n6 = this.bih.biHeight < 0 ? i2 : n3 - i2 - 1;
            n6 = n6 * n2;
            for (int i3 = 0; i3 != this.bih.biWidth; ++i3) {
                int n7 = i3 * this.bih.biBitCount;
                byte by2 = byArray2[n7 / 8];
                n7 = 8 - (n7 & 7) - this.bih.biBitCount;
                n7 = by2 >> n7 & n5;
                n6 = this.setRGBFromPalette(byArray, n6, n7);
            }
        }
    }

    private static int getDWord(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    private static int getWord(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    private static int getByte(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    private static byte convertFrom5To8Bit(int n2, int n3, int n4) {
        n2 = (n2 & n3) >>> n4;
        return (byte)(n2 << 3 | n2 >> 2);
    }

    private static byte convertFromXTo8Bit(int n2, int n3, int n4) {
        n2 = (n2 & n3) >>> n4;
        return (byte)((double)n2 * 255.0 / (double)(n3 >>> n4));
    }

    private void read16Bit(byte[] byArray, int n2, int n3, BMPImageLoader$BitConverter bMPImageLoader$BitConverter) throws IOException {
        int n4 = this.bih.biWidth << 1;
        n4 = n4 + 3 & 0xFFFFFFFC;
        byte[] byArray2 = new byte[n4];
        for (int i2 = 0; i2 != n3; ++i2) {
            ImageTools.readFully(this.data.in, byArray2);
            int n5 = this.bih.biHeight < 0 ? i2 : n3 - i2 - 1;
            n5 = n5 * n2;
            for (int i3 = 0; i3 != this.bih.biWidth; ++i3) {
                int n6 = BMPImageLoader.getWord(byArray2, i3 << 1);
                for (int i4 = 0; i4 < 3; ++i4) {
                    byArray[n5++] = bMPImageLoader$BitConverter.convert(n6, this.bitMasks[i4], this.bitOffsets[i4]);
                }
            }
        }
    }

    private void read32BitRGB(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.bih.biWidth << 2;
        byte[] byArray2 = new byte[n4];
        for (int i2 = 0; i2 != n3; ++i2) {
            ImageTools.readFully(this.data.in, byArray2);
            int n5 = this.bih.biHeight < 0 ? i2 : n3 - i2 - 1;
            n5 = n5 * n2;
            for (int i3 = 0; i3 != this.bih.biWidth; ++i3) {
                int n6 = i3 << 2;
                byArray[n5++] = byArray2[n6 + 2];
                byArray[n5++] = byArray2[n6 + 1];
                byArray[n5++] = byArray2[n6];
            }
        }
    }

    private void read32BitBF(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.bih.biWidth << 2;
        byte[] byArray2 = new byte[n4];
        for (int i2 = 0; i2 != n3; ++i2) {
            ImageTools.readFully(this.data.in, byArray2);
            int n5 = this.bih.biHeight < 0 ? i2 : n3 - i2 - 1;
            n5 = n5 * n2;
            for (int i3 = 0; i3 != this.bih.biWidth; ++i3) {
                int n6 = i3 << 2;
                n6 = BMPImageLoader.getDWord(byArray2, n6);
                for (int i4 = 0; i4 < 3; ++i4) {
                    byArray[n5++] = BMPImageLoader.convertFromXTo8Bit(n6, this.bitMasks[i4], this.bitOffsets[i4]);
                }
            }
        }
    }

    private void read24Bit(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2 + 3 & 0xFFFFFFFC;
        n4 -= n2;
        for (int i2 = 0; i2 != n3; ++i2) {
            int n5 = this.bih.biHeight < 0 ? i2 : n3 - i2 - 1;
            n5 = n5 * n2;
            ImageTools.readFully(this.data.in, byArray, n5, n2);
            this.data.skipBytes(n4);
            BMPImageLoader.BGRtoRGB(byArray, n5, n2);
        }
    }

    static void BGRtoRGB(byte[] byArray, int n2, int n3) {
        n3 /= 3;
        while (n3 != 0) {
            byte by2 = byArray[n2];
            byte by3 = byArray[n2 + 2];
            byArray[n2 + 2] = by2;
            byArray[n2] = by3;
            n2 += 3;
            --n3;
        }
    }

    @Override
    public final ImageFrame load(int n2, int n3, int n4, boolean bl2, boolean bl3) throws IOException {
        int n5;
        if (n2 != 0) {
            return null;
        }
        n2 = Math.abs(this.bih.biHeight);
        int[] nArray = ImageTools.computeDimensions(this.bih.biWidth, n2, n3, n4, bl2);
        n3 = nArray[0];
        if (n3 >= Integer.MAX_VALUE / (n5 = nArray[1]) / 3) {
            throw new IOException("Bad BMP image size!");
        }
        ImageMetadata imageMetadata = new ImageMetadata(null, Boolean.TRUE, null, null, null, null, null, n3, n5, null, null, null);
        this.updateImageMetadata(imageMetadata);
        int n6 = this.bih.biWidth * 3;
        byte[] byArray = new byte[n6 * n2];
        switch (this.bih.biBitCount) {
            case 1: {
                this.readPackedBits(byArray, n6, n2);
                break;
            }
            case 4: {
                if (this.bih.biCompression == 2) {
                    this.readRLE(byArray, n6, n2, true);
                    break;
                }
                this.readPackedBits(byArray, n6, n2);
                break;
            }
            case 8: {
                if (this.bih.biCompression == 1) {
                    this.readRLE(byArray, n6, n2, false);
                    break;
                }
                this.readPackedBits(byArray, n6, n2);
                break;
            }
            case 16: {
                if (this.bih.biCompression == 3) {
                    this.read16Bit(byArray, n6, n2, BMPImageLoader::convertFromXTo8Bit);
                    break;
                }
                this.read16Bit(byArray, n6, n2, BMPImageLoader::convertFrom5To8Bit);
                break;
            }
            case 32: {
                if (this.bih.biCompression == 3) {
                    this.read32BitBF(byArray, n6, n2);
                    break;
                }
                this.read32BitRGB(byArray, n6, n2);
                break;
            }
            case 24: {
                this.read24Bit(byArray, n6, n2);
                break;
            }
            default: {
                throw new IOException("Unknown BMP bit depth");
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (this.bih.biWidth != n3 || n2 != n5) {
            byteBuffer = ImageTools.scaleImage(byteBuffer, this.bih.biWidth, n2, 3, n3, n5, bl3);
        }
        return new ImageFrame(ImageStorage$ImageType.RGB, byteBuffer, n3, n5, n3 * 3, null, imageMetadata);
    }
}

