/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.gif;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage$ImageType;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFDescriptor;
import com.sun.javafx.iio.gif.GIFImageLoader2$LZWDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class GIFImageLoader2
extends ImageLoaderImpl {
    static final byte[] FILE_SIG87 = new byte[]{71, 73, 70, 56, 55, 97};
    static final byte[] FILE_SIG89 = new byte[]{71, 73, 70, 56, 57, 97};
    static final byte[] NETSCAPE_SIG = new byte[]{78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48};
    static final int DEFAULT_FPS = 25;
    InputStream stream = null;
    int screenW;
    int screenH;
    int bgColor;
    byte[][] globalPalette;
    byte[] image;
    int loopCount = 1;

    public GIFImageLoader2(InputStream inputStream) throws IOException {
        super(GIFDescriptor.getInstance());
        this.stream = inputStream;
        this.readGlobalHeader();
    }

    private void readGlobalHeader() throws IOException {
        byte[] byArray = this.readBytes(new byte[6]);
        if (!Arrays.equals(FILE_SIG87, byArray) && !Arrays.equals(FILE_SIG89, byArray)) {
            throw new IOException("Bad GIF signature!");
        }
        this.screenW = this.readShort();
        this.screenH = this.readShort();
        int n2 = this.readByte();
        this.bgColor = this.readByte();
        this.readByte();
        if ((n2 & 0x80) != 0) {
            this.globalPalette = this.readPalete(2 << (n2 & 7), -1);
        }
        this.image = new byte[this.screenW * this.screenH << 2];
    }

    private byte[][] readPalete(int n2, int n3) throws IOException {
        byte[][] byArray = new byte[4][n2];
        byte[] byArray2 = this.readBytes(new byte[n2 * 3]);
        int n4 = 0;
        for (int i2 = 0; i2 != n2; ++i2) {
            for (int i3 = 0; i3 != 3; ++i3) {
                byArray[i3][i2] = byArray2[n4++];
            }
            int n5 = i2;
            byArray[3][n5] = n5 == n3 ? 0 : -1;
        }
        return byArray;
    }

    private void consumeAnExtension() throws IOException {
        int n2 = this.readByte();
        while (n2 != 0) {
            this.skipBytes(n2);
            n2 = this.readByte();
        }
    }

    private void readAppExtension() throws IOException {
        int n2 = this.readByte();
        byte[] byArray = this.readBytes(new byte[n2]);
        if (Arrays.equals(NETSCAPE_SIG, byArray)) {
            int n3 = this.readByte();
            while (n3 != 0) {
                byte[] byArray2 = this.readBytes(new byte[n3]);
                byte by2 = byArray2[0];
                if (n3 == 3 && by2 == 1) {
                    this.loopCount = byArray2[1] & 0xFF | (byArray2[2] & 0xFF) << 8;
                }
                n3 = this.readByte();
            }
            return;
        }
        this.consumeAnExtension();
    }

    private int readControlCode() throws IOException {
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readShort();
        int n5 = this.readByte();
        if (n2 != 4 || this.readByte() != 0) {
            throw new IOException("Bad GIF GraphicControlExtension");
        }
        return ((n3 & 0x1F) << 24) + (n5 << 16) + n4;
    }

    private int waitForImageFrame() throws IOException {
        int n2;
        int n3 = 0;
        block9: while (true) {
            n2 = this.stream.read();
            switch (n2) {
                case 44: {
                    return n3;
                }
                case 33: {
                    switch (this.readByte()) {
                        case 249: {
                            n3 = this.readControlCode();
                            continue block9;
                        }
                        case 255: {
                            this.readAppExtension();
                            continue block9;
                        }
                    }
                    this.consumeAnExtension();
                    continue block9;
                }
                case -1: 
                case 59: {
                    return -1;
                }
            }
            break;
        }
        throw new IOException("Unexpected GIF control characher 0x" + String.format("%02X", n2));
    }

    private void decodeImage(byte[] byArray, int n2, int n3, int[] nArray) throws IOException {
        GIFImageLoader2$LZWDecoder gIFImageLoader2$LZWDecoder = new GIFImageLoader2$LZWDecoder(this);
        byte[] byArray2 = gIFImageLoader2$LZWDecoder.getString();
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        block0: while (true) {
            int n7;
            if ((n7 = gIFImageLoader2$LZWDecoder.readString()) == -1) {
                gIFImageLoader2$LZWDecoder.waitForTerminator();
                return;
            }
            int n8 = 0;
            while (true) {
                if (n8 == n7) continue block0;
                int n9 = n6 < n7 - n8 ? n6 : n7 - n8;
                System.arraycopy(byArray2, n8, byArray, n5, n9);
                n5 += n9;
                n8 += n9;
                if ((n6 -= n9) != 0) continue;
                if (++n4 == n3) {
                    gIFImageLoader2$LZWDecoder.waitForTerminator();
                    return;
                }
                n5 = nArray == null ? n4 : nArray[n4];
                n5 = n5 * n2;
                n6 = n2;
            }
            break;
        }
    }

    private int[] computeInterlaceReIndex(int n2) {
        int n3;
        int[] nArray = new int[n2];
        int n4 = 0;
        for (n3 = 0; n3 < n2; n3 += 8) {
            nArray[n4++] = n3;
        }
        for (n3 = 4; n3 < n2; n3 += 8) {
            nArray[n4++] = n3;
        }
        for (n3 = 2; n3 < n2; n3 += 4) {
            nArray[n4++] = n3;
        }
        for (n3 = 1; n3 < n2; n3 += 2) {
            nArray[n4++] = n3;
        }
        return nArray;
    }

    @Override
    public ImageFrame load(int n2, int n3, int n4, boolean bl2, boolean bl3) throws IOException {
        n2 = this.waitForImageFrame();
        if (n2 < 0) {
            return null;
        }
        int n5 = this.readShort();
        int n6 = this.readShort();
        int n7 = this.readShort();
        int n8 = this.readShort();
        if (n5 + n7 > this.screenW || n6 + n8 > this.screenH) {
            throw new IOException("Wrong GIF image frame size");
        }
        int n9 = this.readByte();
        int n10 = (n2 >>> 24 & 1) == 1 ? 1 : 0;
        n10 = n10 != 0 ? n2 >>> 16 & 0xFF : -1;
        boolean bl4 = (n9 & 0x80) != 0;
        boolean bl5 = (n9 & 0x40) != 0;
        byte[][] byArray = bl4 ? this.readPalete(2 << (n9 & 7), n10) : this.globalPalette;
        int[] nArray = ImageTools.computeDimensions(this.screenW, this.screenH, n3, n4, bl2);
        n3 = nArray[0];
        int n11 = nArray[1];
        ImageMetadata imageMetadata = this.updateMetadata(n3, n11, n2 & 0xFFFF);
        n2 = n2 >>> 26 & 7;
        byte[] byArray2 = new byte[n7 * n8];
        this.decodeImage(byArray2, n7, n8, bl5 ? this.computeInterlaceReIndex(n8) : null);
        ByteBuffer byteBuffer = this.decodePalette(byArray2, byArray, n10, n5, n6, n7, n8, n2);
        if (this.screenW != n3 || this.screenH != n11) {
            byteBuffer = ImageTools.scaleImage(byteBuffer, this.screenW, this.screenH, 4, n3, n11, bl3);
        }
        return new ImageFrame(ImageStorage$ImageType.RGBA, byteBuffer, n3, n11, n3 << 2, null, imageMetadata);
    }

    private int readByte() throws IOException {
        int n2 = this.stream.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    private int readShort() throws IOException {
        int n2 = this.readByte();
        int n3 = this.readByte();
        return n2 + (n3 << 8);
    }

    private byte[] readBytes(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    private byte[] readBytes(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = this.stream.read(byArray, n2, n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n2 += n4;
            n3 -= n4;
        }
        return byArray;
    }

    private void skipBytes(int n2) throws IOException {
        ImageTools.skipFully(this.stream, n2);
    }

    @Override
    public void dispose() {
    }

    private void restoreToBackground(byte[] byArray, int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 != n5; ++i2) {
            int n6 = (n3 + i2) * this.screenW + n2 << 2;
            for (int i3 = 0; i3 != n4; ++i3) {
                byArray[n6 + 3] = 0;
                n6 += 4;
            }
        }
    }

    private ByteBuffer decodePalette(byte[] byArray, byte[][] byArray2, int n2, int n3, int n4, int n5, int n6, int n7) {
        byte[] byArray3 = n7 == 3 ? (byte[])this.image.clone() : this.image;
        for (int i2 = 0; i2 != n6; ++i2) {
            int n8;
            int n9;
            int n10 = (n4 + i2) * this.screenW + n3 << 2;
            int n11 = i2 * n5;
            if (n2 < 0) {
                for (n9 = 0; n9 != n5; ++n9) {
                    n8 = 0xFF & byArray[n11 + n9];
                    byArray3[n10] = byArray2[0][n8];
                    byArray3[n10 + 1] = byArray2[1][n8];
                    byArray3[n10 + 2] = byArray2[2][n8];
                    byArray3[n10 + 3] = byArray2[3][n8];
                    n10 += 4;
                }
                continue;
            }
            for (n9 = 0; n9 != n5; ++n9) {
                n8 = 0xFF & byArray[n11 + n9];
                if (n8 != n2) {
                    byArray3[n10] = byArray2[0][n8];
                    byArray3[n10 + 1] = byArray2[1][n8];
                    byArray3[n10 + 2] = byArray2[2][n8];
                    byArray3[n10 + 3] = byArray2[3][n8];
                }
                n10 += 4;
            }
        }
        if (n7 != 3) {
            byArray3 = (byte[])byArray3.clone();
        }
        if (n7 == 2) {
            GIFImageLoader2 gIFImageLoader2 = this;
            gIFImageLoader2.restoreToBackground(gIFImageLoader2.image, n3, n4, n5, n6);
        }
        return ByteBuffer.wrap(byArray3);
    }

    private ImageMetadata updateMetadata(int n2, int n3, int n4) {
        ImageMetadata imageMetadata = new ImageMetadata(null, Boolean.TRUE, null, null, null, n4 != 0 ? n4 * 10 : 40, this.loopCount, n2, n3, null, null, null);
        this.updateImageMetadata(imageMetadata);
        return imageMetadata;
    }
}

