/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.png;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage$ImageType;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.png.PNGDescriptor;
import com.sun.javafx.iio.png.PNGIDATChunkInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class PNGImageLoader2
extends ImageLoaderImpl {
    static final byte[] FILE_SIG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static final int IHDR_TYPE = 1229472850;
    static final int PLTE_TYPE = 1347179589;
    static final int IDAT_TYPE = 1229209940;
    static final int IEND_TYPE = 1229278788;
    static final int tRNS_TYPE = 1951551059;
    static final int PNG_COLOR_GRAY = 0;
    static final int PNG_COLOR_RGB = 2;
    static final int PNG_COLOR_PALETTE = 3;
    static final int PNG_COLOR_GRAY_ALPHA = 4;
    static final int PNG_COLOR_RGB_ALPHA = 6;
    static final int[] numBandsPerColorType = new int[]{1, -1, 3, 1, 2, -1, 4};
    static final int PNG_FILTER_NONE = 0;
    static final int PNG_FILTER_SUB = 1;
    static final int PNG_FILTER_UP = 2;
    static final int PNG_FILTER_AVERAGE = 3;
    static final int PNG_FILTER_PAETH = 4;
    private final DataInputStream stream;
    private int width;
    private int height;
    private int bitDepth;
    private int colorType;
    private boolean isInterlaced;
    private boolean tRNS_present = false;
    private boolean tRNS_GRAY_RGB = false;
    private int trnsR;
    private int trnsG;
    private int trnsB;
    private byte[][] palette;
    private static final int[] starting_y = new int[]{0, 0, 4, 0, 2, 0, 1, 0};
    private static final int[] starting_x = new int[]{0, 4, 0, 2, 0, 1, 0, 0};
    private static final int[] increment_y = new int[]{8, 8, 8, 4, 4, 2, 2, 1};
    private static final int[] increment_x = new int[]{8, 8, 4, 4, 2, 2, 1, 1};

    public PNGImageLoader2(InputStream object) throws IOException {
        super(PNGDescriptor.getInstance());
        this.stream = new DataInputStream((InputStream)object);
        object = this.readBytes(new byte[8]);
        if (!Arrays.equals(FILE_SIG, (byte[])object)) {
            throw new IOException("Bad PNG signature!");
        }
        this.readHeader();
    }

    private void readHeader() throws IOException {
        int[] nArray = this.readChunk();
        if (nArray[1] != 1229472850 && nArray[0] != 13) {
            throw new IOException("Bad PNG header!");
        }
        this.width = this.stream.readInt();
        this.height = this.stream.readInt();
        if (this.width <= 0) {
            throw new IOException("Bad PNG image width, must be > 0!");
        }
        if (this.height <= 0) {
            throw new IOException("Bad PNG image height, must be > 0!");
        }
        if (this.width >= Integer.MAX_VALUE / this.height) {
            throw new IOException("Bad PNG image size!");
        }
        this.bitDepth = this.stream.readByte();
        if (this.bitDepth != 1 && this.bitDepth != 2 && this.bitDepth != 4 && this.bitDepth != 8 && this.bitDepth != 16) {
            throw new IOException("Bad PNG bit depth");
        }
        this.colorType = this.stream.readByte();
        if (this.colorType > 6 || this.colorType == 1 || this.colorType == 5) {
            throw new IOException("Bad PNG color type");
        }
        if (this.colorType != 3 && this.colorType != 0 && this.bitDepth < 8 || this.colorType == 3 && this.bitDepth == 16) {
            throw new IOException("Bad color type/bit depth combination!");
        }
        byte by2 = this.stream.readByte();
        if (by2 != 0) {
            throw new IOException("Bad PNG comression!");
        }
        by2 = this.stream.readByte();
        if (by2 != 0) {
            throw new IOException("Bad PNG filter method!");
        }
        by2 = this.stream.readByte();
        if (by2 != 0 && by2 != 1) {
            throw new IOException("Unknown interlace method (not 0 or 1)!");
        }
        this.stream.readInt();
        this.isInterlaced = by2 == 1;
    }

    private int[] readChunk() throws IOException {
        return new int[]{this.stream.readInt(), this.stream.readInt()};
    }

    private byte[] readBytes(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    private byte[] readBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.stream.readFully(byArray, n2, n3);
        return byArray;
    }

    private void skip(int n2) throws IOException {
        if (n2 != this.stream.skipBytes(n2)) {
            throw new EOFException();
        }
    }

    private void readPaletteChunk(int n2) throws IOException {
        int n3 = n2 / 3;
        int n4 = 1 << this.bitDepth;
        if (n3 > n4) {
            this.emitWarning("PLTE chunk contains too many entries for bit depth, ignoring extras.");
            n3 = n4;
        }
        this.palette = new byte[3][n4];
        byte[] byArray = this.readBytes(new byte[n2]);
        int n5 = 0;
        for (n4 = 0; n4 != n3; ++n4) {
            for (int i2 = 0; i2 != 3; ++i2) {
                this.palette[i2][n4] = byArray[n5++];
            }
        }
    }

    private void parsePaletteChunk(int n2) throws IOException {
        if (this.palette != null) {
            this.emitWarning("A PNG image may not contain more than one PLTE chunk.\nThe chunk wil be ignored.");
            this.skip(n2);
            return;
        }
        switch (this.colorType) {
            case 3: {
                this.readPaletteChunk(n2);
                return;
            }
            case 0: 
            case 4: {
                this.emitWarning("A PNG gray or gray alpha image cannot have a PLTE chunk.\nThe chunk wil be ignored.");
            }
        }
        this.skip(n2);
    }

    private boolean readPaletteTransparency(int n2) throws IOException {
        if (this.palette == null) {
            this.emitWarning("tRNS chunk without prior PLTE chunk, ignoring it.");
            this.skip(n2);
            return false;
        }
        byte[][] byArrayArray = new byte[4][];
        System.arraycopy(this.palette, 0, byArrayArray, 0, 3);
        int n3 = this.palette[0].length;
        byArrayArray[3] = new byte[n3];
        int n4 = n2 < n3 ? n2 : n3;
        this.readBytes(byArrayArray[3], 0, n4);
        for (int i2 = n4; i2 < n3; ++i2) {
            byArrayArray[3][i2] = -1;
        }
        if (n4 < n2) {
            this.skip(n2 - n4);
        }
        this.palette = byArrayArray;
        return true;
    }

    private boolean readGrayTransparency(int n2) throws IOException {
        if (n2 == 2) {
            this.trnsG = this.stream.readShort();
            return true;
        }
        return false;
    }

    private boolean readRgbTransparency(int n2) throws IOException {
        if (n2 == 6) {
            this.trnsR = this.stream.readShort();
            this.trnsG = this.stream.readShort();
            this.trnsB = this.stream.readShort();
            return true;
        }
        return false;
    }

    private void parseTransparencyChunk(int n2) throws IOException {
        switch (this.colorType) {
            case 3: {
                this.tRNS_present = this.readPaletteTransparency(n2);
                return;
            }
            case 0: {
                PNGImageLoader2 pNGImageLoader2 = this;
                pNGImageLoader2.tRNS_GRAY_RGB = pNGImageLoader2.tRNS_present = this.readGrayTransparency(n2);
                return;
            }
            case 2: {
                PNGImageLoader2 pNGImageLoader2 = this;
                pNGImageLoader2.tRNS_GRAY_RGB = pNGImageLoader2.tRNS_present = this.readRgbTransparency(n2);
                return;
            }
        }
        this.emitWarning("TransparencyChunk may not present when alpha explicitly defined");
        this.skip(n2);
    }

    private int parsePngMeta() throws IOException {
        while (true) {
            int[] nArray;
            if ((nArray = this.readChunk())[0] < 0) {
                throw new IOException("Invalid chunk length");
            }
            switch (nArray[1]) {
                case 1229209940: {
                    return nArray[0];
                }
                case 1229278788: {
                    return 0;
                }
                case 1347179589: {
                    this.parsePaletteChunk(nArray[0]);
                    break;
                }
                case 1951551059: {
                    this.parseTransparencyChunk(nArray[0]);
                    break;
                }
                default: {
                    this.skip(nArray[0]);
                }
            }
            this.stream.readInt();
        }
    }

    @Override
    public final void dispose() {
    }

    private ImageStorage$ImageType getType() {
        switch (this.colorType) {
            case 0: {
                if (this.tRNS_present) {
                    return ImageStorage$ImageType.GRAY_ALPHA;
                }
                return ImageStorage$ImageType.GRAY;
            }
            case 2: {
                if (this.tRNS_present) {
                    return ImageStorage$ImageType.RGBA;
                }
                return ImageStorage$ImageType.RGB;
            }
            case 3: {
                return ImageStorage$ImageType.PALETTE;
            }
            case 4: {
                return ImageStorage$ImageType.GRAY_ALPHA;
            }
            case 6: {
                return ImageStorage$ImageType.RGBA;
            }
        }
        throw new RuntimeException();
    }

    private void doSubFilter(byte[] byArray, int n2) {
        int n3 = byArray.length;
        for (int i2 = n2; i2 != n3; ++i2) {
            byArray[i2] = (byte)(byArray[i2] + byArray[i2 - n2]);
        }
    }

    private void doUpFilter(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        for (int i2 = 0; i2 != n2; ++i2) {
            byArray[i2] = (byte)(byArray[i2] + byArray2[i2]);
        }
    }

    private void doAvrgFilter(byte[] byArray, byte[] byArray2, int n2) {
        int n3;
        int n4 = byArray.length;
        for (n3 = 0; n3 != n2; ++n3) {
            byArray[n3] = (byte)(byArray[n3] + (byArray2[n3] & 0xFF) / 2);
        }
        for (n3 = n2; n3 != n4; ++n3) {
            byArray[n3] = (byte)(byArray[n3] + ((byArray[n3 - n2] & 0xFF) + (byArray2[n3] & 0xFF)) / 2);
        }
    }

    private static int paethPr(int n2, int n3, int n4) {
        int n5 = Math.abs(n3 - n4);
        int n6 = Math.abs(n2 - n4);
        int n7 = Math.abs(n3 - n4 + n2 - n4);
        if (n5 <= n6 && n5 <= n7) {
            return n2;
        }
        if (n6 <= n7) {
            return n3;
        }
        return n4;
    }

    private void doPaethFilter(byte[] byArray, byte[] byArray2, int n2) {
        int n3;
        int n4 = byArray.length;
        for (n3 = 0; n3 != n2; ++n3) {
            byArray[n3] = (byte)(byArray[n3] + byArray2[n3]);
        }
        for (n3 = n2; n3 != n4; ++n3) {
            byArray[n3] = (byte)(byArray[n3] + PNGImageLoader2.paethPr(byArray[n3 - n2] & 0xFF, byArray2[n3] & 0xFF, byArray2[n3 - n2] & 0xFF));
        }
    }

    private void doFilter(byte[] byArray, byte[] byArray2, int n2, int n3) {
        switch (n2) {
            case 1: {
                this.doSubFilter(byArray, n3);
                return;
            }
            case 2: {
                this.doUpFilter(byArray, byArray2);
                return;
            }
            case 3: {
                this.doAvrgFilter(byArray, byArray2, n3);
                return;
            }
            case 4: {
                this.doPaethFilter(byArray, byArray2, n3);
            }
        }
    }

    private void downsample16to8trns_gray(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = byArray.length / 2;
        for (int i2 = 0; i2 < n4; ++i2) {
            short s2 = (short)(((byArray[i2 << 1] & 0xFF) << 8) + (byArray[(i2 << 1) + 1] & 0xFF));
            byArray2[n2] = byArray[i2 << 1];
            byArray2[n2 + 1] = s2 == this.trnsG ? 0 : -1;
            n2 += n3 << 1;
        }
    }

    private void downsample16to8trns_rgb(byte[] byArray, byte[] byArray2, int n2, int n3) {
        int n4 = byArray.length / 2 / 3;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 * 6;
            short s2 = (short)(((byArray[n5] & 0xFF) << 8) + (byArray[n5 + 1] & 0xFF));
            short s3 = (short)(((byArray[n5 + 2] & 0xFF) << 8) + (byArray[n5 + 3] & 0xFF));
            short s4 = (short)(((byArray[n5 + 4] & 0xFF) << 8) + (byArray[n5 + 5] & 0xFF));
            byArray2[n2] = byArray[n5];
            byArray2[n2 + 1] = byArray[n5 + 2];
            byArray2[n2 + 2] = byArray[n5 + 4];
            byArray2[n2 + 3] = s2 == this.trnsR && s3 == this.trnsG && s4 == this.trnsB ? 0 : -1;
            n2 += n3 << 2;
        }
    }

    private void downsample16to8_plain(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = byArray.length / 2 / n4 * n4;
        n3 *= n4;
        for (int i2 = 0; i2 != n5; i2 += n4) {
            for (int i3 = 0; i3 != n4; ++i3) {
                byArray2[n2 + i3] = byArray[i2 + i3 << 1];
            }
            n2 += n3;
        }
    }

    private void downsample16to8(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        if (!this.tRNS_GRAY_RGB) {
            this.downsample16to8_plain(byArray, byArray2, n2, n3, n4);
            return;
        }
        if (this.colorType == 0) {
            this.downsample16to8trns_gray(byArray, byArray2, n2, n3);
            return;
        }
        if (this.colorType == 2) {
            this.downsample16to8trns_rgb(byArray, byArray2, n2, n3);
        }
    }

    private void copyTrns_gray(byte[] byArray, byte[] byArray2, int n2, int n3) {
        byte by2 = (byte)this.trnsG;
        int n4 = byArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by3;
            byArray2[n2] = by3 = byArray[i2];
            byArray2[n2 + 1] = by3 == by2 ? 0 : -1;
            n2 += 2 * n3;
        }
    }

    private void copyTrns_rgb(byte[] byArray, byte[] byArray2, int n2, int n3) {
        byte by2 = (byte)this.trnsR;
        byte by3 = (byte)this.trnsG;
        byte by4 = (byte)this.trnsB;
        int n4 = byArray.length / 3;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by5 = byArray[i2 * 3];
            byte by6 = byArray[i2 * 3 + 1];
            byte by7 = byArray[i2 * 3 + 2];
            byArray2[n2] = by5;
            byArray2[n2 + 1] = by6;
            byArray2[n2 + 2] = by7;
            byArray2[n2 + 3] = by5 == by2 && by6 == by3 && by7 == by4 ? 0 : -1;
            n2 += n3 << 2;
        }
    }

    private void copy_plain(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = byArray.length;
        n3 *= n4;
        for (int i2 = 0; i2 != n5; i2 += n4) {
            for (int i3 = 0; i3 != n4; ++i3) {
                byArray2[n2 + i3] = byArray[i2 + i3];
            }
            n2 += n3;
        }
    }

    private void copy(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        if (!this.tRNS_GRAY_RGB) {
            if (n3 == 1) {
                System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
                return;
            }
            this.copy_plain(byArray, byArray2, n2, n3, n4);
            return;
        }
        if (this.colorType == 0) {
            this.copyTrns_gray(byArray, byArray2, n2, n3);
            return;
        }
        if (this.colorType == 2) {
            this.copyTrns_rgb(byArray, byArray2, n2, n3);
        }
    }

    private void upsampleTo8Palette(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = 8 / this.bitDepth;
        int n6 = (1 << this.bitDepth) - 1;
        int n7 = 0;
        for (int i2 = 0; i2 < n3; i2 += n5) {
            int n8 = n3 - i2 < n5 ? n3 - i2 : n5;
            int n9 = byArray[n7] >> (n5 - n8) * this.bitDepth;
            --n8;
            while (n8 >= 0) {
                byArray2[n2 + (i2 + n8) * n4] = (byte)(n9 & n6);
                n9 >>= this.bitDepth;
                --n8;
            }
            ++n7;
        }
    }

    private void upsampleTo8Gray(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = 8 / this.bitDepth;
        int n6 = (1 << this.bitDepth) - 1;
        int n7 = n6 / 2;
        int n8 = 0;
        for (int i2 = 0; i2 < n3; i2 += n5) {
            int n9 = n3 - i2 < n5 ? n3 - i2 : n5;
            int n10 = byArray[n8] >> (n5 - n9) * this.bitDepth;
            --n9;
            while (n9 >= 0) {
                byArray2[n2 + (i2 + n9) * n4] = (byte)(((n10 & n6) * 255 + n7) / n6);
                n10 >>= this.bitDepth;
                --n9;
            }
            ++n8;
        }
    }

    private void upsampleTo8GrayTrns(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = 8 / this.bitDepth;
        int n6 = (1 << this.bitDepth) - 1;
        int n7 = n6 / 2;
        int n8 = 0;
        for (int i2 = 0; i2 < n3; i2 += n5) {
            int n9 = n3 - i2 < n5 ? n3 - i2 : n5;
            int n10 = byArray[n8] >> (n5 - n9) * this.bitDepth;
            --n9;
            while (n9 >= 0) {
                int n11 = n2 + ((i2 + n9) * n4 << 1);
                int n12 = n10 & n6;
                byArray2[n11] = (byte)((n12 * 255 + n7) / n6);
                byArray2[n11 + 1] = n12 == this.trnsG ? 0 : -1;
                n10 >>= this.bitDepth;
                --n9;
            }
            ++n8;
        }
    }

    private void upsampleTo8(byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5) {
        if (this.colorType == 3) {
            this.upsampleTo8Palette(byArray, byArray2, n2, n3, n4);
            return;
        }
        if (n5 == 1) {
            this.upsampleTo8Gray(byArray, byArray2, n2, n3, n4);
            return;
        }
        if (this.tRNS_GRAY_RGB && n5 == 2) {
            this.upsampleTo8GrayTrns(byArray, byArray2, n2, n3, n4);
        }
    }

    private static int mipSize(int n2, int n3, int[] nArray, int[] nArray2) {
        return (n2 - nArray[n3] + nArray2[n3] - 1) / nArray2[n3];
    }

    private static int mipPos(int n2, int n3, int[] nArray, int[] nArray2) {
        return nArray[n3] + n2 * nArray2[n3];
    }

    private void loadMip(byte[] byArray, InputStream inputStream, int n2) throws IOException {
        int n3 = PNGImageLoader2.mipSize(this.width, n2, starting_x, increment_x);
        int n4 = PNGImageLoader2.mipSize(this.height, n2, starting_y, increment_y);
        int n5 = (n3 * this.bitDepth * numBandsPerColorType[this.colorType] + 7) / 8;
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        int n6 = this.bpp();
        int n7 = numBandsPerColorType[this.colorType] * this.bytesPerColor();
        for (int i2 = 0; i2 != n4; ++i2) {
            int n8 = inputStream.read();
            if (n8 == -1) {
                throw new EOFException();
            }
            if (inputStream.read(byArray2) != n5) {
                throw new EOFException();
            }
            this.doFilter(byArray2, byArray3, n8, n7);
            n8 = (PNGImageLoader2.mipPos(i2, n2, starting_y, increment_y) * this.width + starting_x[n2]) * n6;
            int n9 = increment_x[n2];
            if (this.bitDepth == 16) {
                this.downsample16to8(byArray2, byArray, n8, n9, n6);
            } else if (this.bitDepth < 8) {
                this.upsampleTo8(byArray2, byArray, n8, n3, n9, n6);
            } else {
                this.copy(byArray2, byArray, n8, n9, n6);
            }
            byte[] byArray4 = byArray2;
            byArray2 = byArray3;
            byArray3 = byArray4;
        }
    }

    private void load(byte[] byArray, InputStream inputStream) throws IOException {
        if (this.isInterlaced) {
            for (int i2 = 0; i2 != 7; ++i2) {
                if (this.width <= starting_x[i2] || this.height <= starting_y[i2]) continue;
                this.loadMip(byArray, inputStream, i2);
            }
            return;
        }
        this.loadMip(byArray, inputStream, 7);
    }

    private ImageFrame decodePalette(byte[] byArray, ImageMetadata imageMetadata) throws IOException {
        int n2;
        int n3 = n2 = this.tRNS_present ? 4 : 3;
        if (this.width >= Integer.MAX_VALUE / this.height / n2) {
            throw new IOException("Bad PNG image size!");
        }
        byte[] byArray2 = new byte[this.width * this.height * n2];
        int n4 = this.width * this.height;
        if (this.tRNS_present) {
            int n5 = 0;
            for (var6_6 = 0; var6_6 != n4; ++var6_6) {
                int n6 = 0xFF & byArray[var6_6];
                byArray2[n5] = this.palette[0][n6];
                byArray2[n5 + 1] = this.palette[1][n6];
                byArray2[n5 + 2] = this.palette[2][n6];
                byArray2[n5 + 3] = this.palette[3][n6];
                n5 += 4;
            }
        } else {
            int n7 = 0;
            for (var6_6 = 0; var6_6 != n4; ++var6_6) {
                int n8 = 0xFF & byArray[var6_6];
                byArray2[n7] = this.palette[0][n8];
                byArray2[n7 + 1] = this.palette[1][n8];
                byArray2[n7 + 2] = this.palette[2][n8];
                n7 += 3;
            }
        }
        ImageStorage$ImageType imageStorage$ImageType = this.tRNS_present ? ImageStorage$ImageType.RGBA : ImageStorage$ImageType.RGB;
        return new ImageFrame(imageStorage$ImageType, ByteBuffer.wrap(byArray2), this.width, this.height, this.width * n2, null, imageMetadata);
    }

    private int bpp() {
        return numBandsPerColorType[this.colorType] + (this.tRNS_GRAY_RGB ? 1 : 0);
    }

    private int bytesPerColor() {
        if (this.bitDepth == 16) {
            return 2;
        }
        return 1;
    }

    @Override
    public final ImageFrame load(int n2, int n3, int n4, boolean bl2, boolean bl3) throws IOException {
        if (n2 != 0) {
            return null;
        }
        n2 = this.parsePngMeta();
        if (n2 == 0) {
            this.emitWarning("No image data in PNG");
            return null;
        }
        int n5 = this.bpp();
        if (this.width >= Integer.MAX_VALUE / this.height / n5) {
            throw new IOException("Bad PNG image size!");
        }
        int[] nArray = ImageTools.computeDimensions(this.width, this.height, n3, n4, bl2);
        n3 = nArray[0];
        int n6 = nArray[1];
        ImageMetadata imageMetadata = new ImageMetadata(null, Boolean.TRUE, null, null, null, null, null, n3, n6, null, null, null);
        this.updateImageMetadata(imageMetadata);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n5 * this.width * this.height);
        Object object = new PNGIDATChunkInputStream(this.stream, n2);
        Inflater inflater = new Inflater();
        object = new BufferedInputStream(new InflaterInputStream((InputStream)object, inflater));
        try {
            this.load(byteBuffer.array(), (InputStream)object);
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
        finally {
            inflater.end();
        }
        Object object2 = object = this.colorType == 3 ? this.decodePalette(byteBuffer.array(), imageMetadata) : new ImageFrame(this.getType(), byteBuffer, this.width, this.height, n5 * this.width, this.palette, imageMetadata);
        if (this.width != n3 || this.height != n6) {
            object = ImageTools.scaleImageFrame((ImageFrame)object, n3, n6, bl3);
        }
        return object;
    }
}

